/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.NoopMonitorRegistry;
import com.netflix.servo.SpectatorContext;
import com.netflix.servo.jmx.JmxMonitorRegistry;
import com.netflix.servo.jmx.ObjectNameMapper;
import com.netflix.servo.monitor.Monitor;
import java.util.Collection;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultMonitorRegistry
implements MonitorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMonitorRegistry.class);
    private static final String CLASS_NAME = DefaultMonitorRegistry.class.getCanonicalName();
    private static final String REGISTRY_CLASS_PROP = CLASS_NAME + ".registryClass";
    private static final String REGISTRY_NAME_PROP = CLASS_NAME + ".registryName";
    private static final String REGISTRY_JMX_NAME_PROP = CLASS_NAME + ".jmxMapperClass";
    private static final MonitorRegistry INSTANCE = new DefaultMonitorRegistry();
    private static final String DEFAULT_REGISTRY_NAME = "com.netflix.servo";
    private final MonitorRegistry registry;

    public static MonitorRegistry getInstance() {
        return INSTANCE;
    }

    DefaultMonitorRegistry() {
        this(DefaultMonitorRegistry.loadProps());
    }

    DefaultMonitorRegistry(Properties props) {
        String className = props.getProperty(REGISTRY_CLASS_PROP);
        if (className != null) {
            MonitorRegistry r;
            if (className.equals(JmxMonitorRegistry.class.getName())) {
                String registryName = props.getProperty(REGISTRY_NAME_PROP, DEFAULT_REGISTRY_NAME);
                r = new JmxMonitorRegistry(registryName, DefaultMonitorRegistry.getObjectNameMapper(props));
            } else {
                try {
                    Class<?> c = Class.forName(className);
                    r = (MonitorRegistry)c.newInstance();
                }
                catch (Throwable t) {
                    LOG.error("failed to create instance of class " + className + ", using default class " + NoopMonitorRegistry.class.getName(), t);
                    r = new NoopMonitorRegistry();
                }
            }
            this.registry = r;
        } else {
            this.registry = new NoopMonitorRegistry();
        }
    }

    private static ObjectNameMapper getObjectNameMapper(Properties props) {
        ObjectNameMapper mapper = ObjectNameMapper.DEFAULT;
        String jmxNameMapperClass = props.getProperty(REGISTRY_JMX_NAME_PROP);
        if (jmxNameMapperClass != null) {
            try {
                Class<?> mapperClazz = Class.forName(jmxNameMapperClass);
                mapper = (ObjectNameMapper)mapperClazz.newInstance();
            }
            catch (Throwable t) {
                LOG.error("failed to create the JMX ObjectNameMapper instance of class " + jmxNameMapperClass + ", using the default naming scheme", t);
            }
        }
        return mapper;
    }

    private static Properties loadProps() {
        String registryClassProp = System.getProperty(REGISTRY_CLASS_PROP);
        String registryNameProp = System.getProperty(REGISTRY_NAME_PROP);
        String registryJmxNameProp = System.getProperty(REGISTRY_JMX_NAME_PROP);
        Properties props = new Properties();
        if (registryClassProp != null) {
            props.setProperty(REGISTRY_CLASS_PROP, registryClassProp);
        }
        if (registryNameProp != null) {
            props.setProperty(REGISTRY_NAME_PROP, registryNameProp);
        }
        if (registryJmxNameProp != null) {
            props.setProperty(REGISTRY_JMX_NAME_PROP, registryJmxNameProp);
        }
        return props;
    }

    @Override
    public Collection<Monitor<?>> getRegisteredMonitors() {
        return this.registry.getRegisteredMonitors();
    }

    @Override
    public void register(Monitor<?> monitor) {
        SpectatorContext.register(monitor);
        this.registry.register(monitor);
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        SpectatorContext.unregister(monitor);
        this.registry.unregister(monitor);
    }

    MonitorRegistry getInnerRegistry() {
        return this.registry;
    }

    @Override
    public boolean isRegistered(Monitor<?> monitor) {
        return this.registry.isRegistered(monitor);
    }
}

