/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.ViewRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.LogicalViewResponse;
import org.apache.kylin.rest.service.SparkDDLService;
import org.apache.spark.sql.LogicalViewLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/spark_source"}, produces={"application/vnd.apache.kylin-v4-public+json", "application/vnd.apache.kylin-v4+json"})
public class SparkDDLController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparkDDLController.class);
    @Autowired
    private SparkDDLService sparkDDLService;

    @ApiOperation(value="ddl")
    @PostMapping(value={"/ddl"})
    @ResponseBody
    public EnvelopeResponse<String> executeSQL(@RequestBody ViewRequest request) {
        String project = this.checkProjectName(request.getDdlProject());
        request.setDdlProject(project);
        String result = this.sparkDDLService.executeSQL(request);
        return new EnvelopeResponse("000", (Object)result, "");
    }

    @ApiOperation(value="ddl_description")
    @GetMapping(value={"/ddl/description"})
    @ResponseBody
    public EnvelopeResponse<List<List<String>>> description(@RequestParam(value="project") String project, @RequestParam(value="page_type") String pageType) {
        project = this.checkProjectName(project);
        return new EnvelopeResponse("000", (Object)this.sparkDDLService.pluginsDescription(project, pageType), "");
    }

    @ApiOperation(value="ddl_sync")
    @GetMapping(value={"/ddl/sync"})
    @ResponseBody
    public EnvelopeResponse<String> sync() {
        LogicalViewLoader.syncViewFromDB();
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="ddl_desc")
    @GetMapping(value={"/ddl/view_list"})
    @ResponseBody
    public EnvelopeResponse<List<LogicalViewResponse>> list(@RequestParam(value="project") String project, @RequestParam(value="table", required=false, defaultValue="") String tableName) {
        project = this.checkProjectName(project);
        List logicalViews = this.sparkDDLService.listAll(project, tableName);
        return new EnvelopeResponse("000", (Object)logicalViews, "");
    }
}

