/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NUserController;
import org.apache.kylin.rest.request.CachedUserUpdateRequest;
import org.apache.kylin.rest.request.PasswordChangeRequest;
import org.apache.kylin.rest.request.UserRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.UserInfoResponse;
import org.apache.kylin.rest.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/user"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenUserController
extends NBasicController {
    @Autowired
    private NUserController userController;
    @Autowired
    private UserService userService;

    @ApiOperation(value="listAllUsers", tags={"MID"})
    @GetMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<DataResult<List<UserInfoResponse>>> listAllUsers(@RequestParam(value="name", required=false) String name, @RequestParam(value="is_case_sensitive", required=false) boolean isCaseSensitive, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize) throws IOException {
        List usersByFuzzyMatching = this.userService.getManagedUsersByFuzzMatching(name, isCaseSensitive);
        for (ManagedUser u : usersByFuzzyMatching) {
            this.userService.completeUserInfo(u);
        }
        List userInfoResponses = usersByFuzzyMatching.stream().map(UserInfoResponse::new).collect(Collectors.toList());
        return new EnvelopeResponse("000", (Object)DataResult.get(userInfoResponses, (int)pageOffset, (int)pageSize), "");
    }

    @ApiOperation(value="createUser", tags={"MID"})
    @PostMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> createUser(@RequestBody UserRequest user) throws IOException {
        return this.userController.createUser(user);
    }

    @ApiOperation(value="updateUser", tags={"MID"})
    @PutMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> updateUser(@RequestBody UserRequest user) throws IOException {
        return this.userController.updateUser(user);
    }

    @ApiOperation(value="delete", tags={"MID"})
    @DeleteMapping(value={"/{username:.+}"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> delete(@PathVariable(value="username") String username) {
        return this.userController.delete(username);
    }

    @ApiOperation(value="updateUserPassword", tags={"MID"})
    @PutMapping(value={"/password"})
    @ResponseBody
    public EnvelopeResponse<String> updateUserPassword(@RequestBody PasswordChangeRequest user) {
        return this.userController.updateUserPassword(user);
    }

    @ApiOperation(value="deleteUser", tags={"MID"})
    @DeleteMapping(value={""})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> deleteUser(@RequestBody ManagedUser request) {
        return this.userController.delete(request.getUsername());
    }

    @ApiOperation(value="deleteUser", tags={"MID"})
    @DeleteMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchDelete(@RequestBody List<String> usernames) throws IOException {
        return this.userController.batchDelete(usernames);
    }

    @ApiOperation(value="createUser", tags={"MID"}, notes="Update Body: default_password, locked_time, wrong_time, first_login_failed_time")
    @PostMapping(value={"/batch"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<String> batchCreate(@RequestBody List<UserRequest> users) throws IOException {
        return this.userController.batchCreate(users);
    }

    @ApiOperation(value="refreshUser", tags={"MID"})
    @PutMapping(value={"/refresh"})
    @ResponseBody
    public EnvelopeResponse<String> refreshUser(@RequestBody CachedUserUpdateRequest request) {
        this.userService.refresh(request);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

