/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/models"})
public class NModelControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;

    @ApiOperation(value="getModels", tags={"AI"})
    @GetMapping(value={""}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getModels(@RequestParam(value="modelName", required=false) String modelAlias, @RequestParam(value="exactMatch", required=false, defaultValue="true") boolean exactMatch, @RequestParam(value="projectName") String project, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer offset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer limit, @RequestParam(value="sortBy", required=false, defaultValue="last_modify") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") Boolean reverse) {
        this.checkProjectName(project);
        List models = new ArrayList(this.modelService.getModels(modelAlias, project, exactMatch, null, (List)Lists.newArrayList(), sortBy, reverse.booleanValue()));
        models = this.modelService.addOldParams(project, models);
        Map modelResponse = this.getDataResponse("models", models, offset, limit);
        return new EnvelopeResponse("000", (Object)modelResponse, "");
    }

    @ApiOperation(value="getModelDesc", tags={"AI"})
    @GetMapping(value={"/{projectName}/{modelName}"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<Map<String, Object>> getModelDesc(@PathVariable(value="projectName") String project, @PathVariable(value="modelName") String modelAlias) {
        this.checkProjectName(project);
        List models = new ArrayList(this.modelService.getModels(modelAlias, project, true, null, (List)Lists.newArrayList(), "last_modify", true));
        if (models.size() == 0) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_ID_NOT_EXIST, new Object[]{modelAlias});
        }
        models = this.modelService.addOldParams(project, models);
        HashMap<String, HashMap> modelResponse = new HashMap<String, HashMap>();
        modelResponse.put("model", models.size() == 0 ? Maps.newHashMap() : models.get(0));
        return new EnvelopeResponse("000", modelResponse, "");
    }
}

