/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.OlapAggregateRel;
import org.apache.kylin.query.relnode.OlapFilterRel;
import org.apache.kylin.query.relnode.OlapJoinRel;
import org.apache.kylin.query.relnode.OlapProjectRel;
import org.apache.kylin.query.util.RuleUtils;

public class OlapAggProjectMergeRule
extends RelOptRule {
    public static final OlapAggProjectMergeRule AGG_PROJECT_JOIN = new OlapAggProjectMergeRule(OlapAggProjectMergeRule.operand(OlapAggregateRel.class, (RelOptRuleOperand)OlapAggProjectMergeRule.operand(OlapProjectRel.class, (RelOptRuleOperand)OlapAggProjectMergeRule.operand(OlapJoinRel.class, (RelOptRuleOperandChildren)OlapAggProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "OlapAggProjectMergeRule:agg-project-join");
    public static final OlapAggProjectMergeRule AGG_PROJECT_FILTER_JOIN = new OlapAggProjectMergeRule(OlapAggProjectMergeRule.operand(OlapAggregateRel.class, (RelOptRuleOperand)OlapAggProjectMergeRule.operand(OlapProjectRel.class, (RelOptRuleOperand)OlapAggProjectMergeRule.operand(OlapFilterRel.class, (RelOptRuleOperand)OlapAggProjectMergeRule.operand(OlapJoinRel.class, (RelOptRuleOperandChildren)OlapAggProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "OlapAggProjectMergeRule:agg-project-filter-join");

    public OlapAggProjectMergeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public OlapAggProjectMergeRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    public OlapAggProjectMergeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall call) {
        OlapJoinRel joinRel;
        OlapJoinRel olapJoinRel = joinRel = call.rel(2) instanceof OlapFilterRel ? (OlapJoinRel)call.rel(3) : (OlapJoinRel)call.rel(2);
        if (!RuleUtils.isJoinOnlyOneAggChild(joinRel)) {
            return false;
        }
        OlapAggregateRel aggregate = (OlapAggregateRel)call.rel(0);
        OlapProjectRel project = (OlapProjectRel)call.rel(1);
        ImmutableBitSet.Builder immutableBitSetBuilder = ImmutableBitSet.builder();
        immutableBitSetBuilder.addAll(aggregate.getGroupSet());
        aggregate.getAggCallList().forEach(aggregateCall -> {
            ImmutableBitSet args = ImmutableBitSet.of((Iterable)aggregateCall.getArgList());
            immutableBitSetBuilder.addAll(args);
        });
        ImmutableBitSet hasUseInAgg = immutableBitSetBuilder.build();
        for (int i = 0; i < project.getProjects().size(); ++i) {
            RexNode rexNode = (RexNode)project.getProjects().get(i);
            if (rexNode instanceof RexInputRef || !hasUseInAgg.get(i)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        OlapProjectRel project;
        OlapAggregateRel aggregate = (OlapAggregateRel)call.rel(0);
        RelNode x = OlapAggProjectMergeRule.apply(call, (Aggregate)aggregate, (Project)(project = (OlapProjectRel)call.rel(1)));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(RelOptRuleCall call, Aggregate aggregate, Project project) {
        ArrayList newKeys = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            RexNode rex = (RexNode)project.getProjects().get(key);
            if (!(rex instanceof RexInputRef)) continue;
            int newKey = ((RexInputRef)rex).getIndex();
            newKeys.add(newKey);
            map.put(key, newKey);
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList newGroupingSets = null;
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable)aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            ImmutableList.Builder newArgs = ImmutableList.builder();
            Iterator iterator2 = aggregateCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int arg = (Integer)iterator2.next();
                RexNode rex = (RexNode)project.getProjects().get(arg);
                if (!(rex instanceof RexInputRef)) {
                    return null;
                }
                newArgs.add((Object)((RexInputRef)rex).getIndex());
            }
            int newFilterArg = -1;
            if (aggregateCall.filterArg >= 0 && project.getProjects().get(aggregateCall.filterArg) instanceof RexInputRef) {
                newFilterArg = ((RexInputRef)project.getProjects().get(aggregateCall.filterArg)).getIndex();
            }
            aggCalls.add((Object)aggregateCall.copy((List)newArgs.build(), newFilterArg));
        }
        RelTraitSet relTraitSet = aggregate.getTraitSet();
        RelNode relNode = project.getInput();
        aggregate.getClass();
        Aggregate newAggregate = aggregate.copy(relTraitSet, relNode, false, newGroupSet, (List)newGroupingSets, (List)aggCalls.build());
        RelBuilder relBuilder = call.builder();
        relBuilder.push((RelNode)newAggregate);
        OlapAggProjectMergeRule.processNewKeyNotExists(relBuilder, newKeys, newGroupSet, aggregate, newAggregate);
        return relBuilder.build();
    }

    private static void processNewKeyNotExists(RelBuilder relBuilder, List<Integer> newKeys, ImmutableBitSet newGroupSet, Aggregate aggregate, Aggregate newAggregate) {
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList posList = Lists.newArrayList();
            for (int newKey : newKeys) {
                posList.add(newGroupSet.indexOf(newKey));
            }
            aggregate.getClass();
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            relBuilder.project((Iterable)relBuilder.fields((List)posList));
        }
    }
}

