/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class OlapProjectMergeRule
extends RelOptRule {
    public static final OlapProjectMergeRule INSTANCE = new OlapProjectMergeRule(true, RelFactories.LOGICAL_BUILDER);
    private static final Set<String> NON_MERGEABLE_FUNCTION = Sets.newHashSet((Object[])new String[]{"EXPLODE"});
    private final boolean force;

    public OlapProjectMergeRule(boolean force, RelBuilderFactory relBuilderFactory) {
        super(OlapProjectMergeRule.operand(Project.class, (RelOptRuleOperand)OlapProjectMergeRule.operand(Project.class, (RelOptRuleOperandChildren)OlapProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "OlapProjectMergeRule" + (force ? ":force_mode" : ""));
        this.force = force;
    }

    @Deprecated
    public OlapProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        this(force, RelBuilder.proto((Object[])new Object[]{projectFactory}));
    }

    public boolean matches(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        return topProject.getConvention() == bottomProject.getConvention();
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RelBuilder relBuilder = call.builder();
        if (this.containsNonMergeableExprs(bottomProject) || this.containsNonMergeableExprs(topProject)) {
            return;
        }
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                relBuilder.push(bottomProject.getInput());
                relBuilder.project((Iterable)relBuilder.fields((Mappings.TargetMapping)product), (Iterable)topProject.getRowType().getFieldNames());
                call.transformTo(relBuilder.build());
                return;
            }
        }
        if (!this.force && RexUtil.isIdentity((List)topProject.getProjects(), (RelDataType)topProject.getInput().getRowType())) {
            return;
        }
        List<RexNode> newProjects = RelOptUtil.pushPastProjectUnlessBloat((List)topProject.getProjects(), (Project)bottomProject, (int)KylinConfig.getInstanceFromEnv().getProjectBloatThreshold());
        if (newProjects == null) {
            return;
        }
        if (RexUtil.isIdentity(newProjects = OlapProjectMergeRule.simplifyCast(newProjects, topProject.getCluster().getRexBuilder()), (RelDataType)(input = bottomProject.getInput()).getRowType()) && (this.force || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        relBuilder.push(bottomProject.getInput());
        relBuilder.project(newProjects, (Iterable)topProject.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    public static List<RexNode> simplifyCast(List<RexNode> projects, RexBuilder rexBuilder) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        for (RexNode rex : projects) {
            if (rex.getKind() == SqlKind.CAST) {
                RexNode inner = (RexNode)((RexCall)rex).getOperands().get(0);
                RexNode simplified = OlapProjectMergeRule.simplify(inner);
                if (simplified.getType() == rex.getType()) {
                    list.add(simplified);
                    continue;
                }
                List<RexNode> newNodes = Collections.singletonList(simplified);
                RexNode rexNode = rexBuilder.makeCall(rex.getType(), ((RexCall)rex).getOperator(), newNodes);
                list.add(rexNode);
                continue;
            }
            list.add(rex);
        }
        return list;
    }

    private static RexNode simplify(RexNode node) {
        RexNode operand;
        RexNode current = node;
        if (current.isA(SqlKind.CAST) && (operand = (RexNode)((RexCall)current).getOperands().get(0)).getType().equals(current.getType())) {
            current = OlapProjectMergeRule.simplify(operand);
        }
        return current;
    }

    private boolean containsNonMergeableExprs(Project project) {
        for (RexNode expr : project.getProjects()) {
            if (!this.containsNonMergeableExprs(expr)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNonMergeableExprs(RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            if (NON_MERGEABLE_FUNCTION.contains(((RexCall)rexNode).getOperator().getName())) {
                return true;
            }
            for (RexNode operand : ((RexCall)rexNode).getOperands()) {
                if (!this.containsNonMergeableExprs(operand)) continue;
                return true;
            }
        }
        return false;
    }
}

