/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.PropertiesDelegate;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.annotation.ThirdPartyDependencies;
import org.apache.kylin.common.constant.NonCustomProjectLevelConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.extension.KylinInfoExtension;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ByteUnit;
import org.apache.kylin.common.util.ClassLoaderUtils;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.common.util.CompositeMapView;
import org.apache.kylin.common.util.EncryptUtil;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.SizeConvertUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public abstract class KylinConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfigBase.class);
    protected static final String WORKING_DIR_PROP = "kylin.env.hdfs-working-dir";
    protected static final String DATA_WORKING_DIR_PROP = "kylin.env.hdfs-data-working-dir";
    protected static final String KYLIN_ROOT = "/kylin";
    public static final String WRITING_CLUSTER_WORKING_DIR = "kylin.env.hdfs-write-working-dir";
    public static final long REJECT_SIMILARITY_THRESHOLD = 100000000L;
    public static final double SIMILARITY_THRESHOLD = 0.9;
    public static final long MINUTE = 60L;
    private static final String ONE_HUNDRED_THOUSAND = "100000";
    public static final String DEFAULT = "default";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String QUERY_NODE = "query";
    public static final String PATH_DELIMITER = "/";
    public static final String DIAG_ID_PREFIX = "front_";
    public static final String POWER_BI_CONVERTER = "org.apache.kylin.query.util.PowerBIConverter";
    public static final String KYLIN_STREAMING_STATS_URL = "kylin.streaming.stats.url";
    public static final String KYLIN_QUERY_HISTORY_URL = "kylin.query.queryhistory.url";
    public static final String KYLIN_QUERY_HISTORY_JDBC_URL = "kylin.query.queryhistory.jdbc.url";
    public static final String KYLIN_JDBC_SHARE_STATE_URL = "kylin.jdbc.share.state.url";
    public static final String KYLIN_METADATA_DISTRIBUTED_LOCK_JDBC_URL = "kylin.metadata.distributed-lock.jdbc.url";
    public static final String LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED = "kylin.storage.columnar.spark-conf.spark.sql.legacy.allowNegativeScaleOfDecimal";
    private static final String METRICS = "_metrics/";
    public static final String SERVER_NAME_STRING = "spring.application.name";
    protected static final Map<String, String> STATIC_SYSTEM_ENV = new ConcurrentHashMap<String, String>(System.getenv());
    public static final int BYTES_PER_CHAR = 2;
    static BackwardCompatibilityConfig BCC = new BackwardCompatibilityConfig();
    final PropertiesDelegate properties;
    final transient StrSubstitutor substitutor;
    protected String cachedHdfsWorkingDirectory;
    private static final String JOB_JAR_NAME_PATTERN = "newten-job(.?)\\.jar";
    private static final String JAR_NAME_PATTERN = "(.*)\\.jar";

    public static String getKylinHome() {
        String kylinHome = KylinConfigBase.getKylinHomeWithoutWarn();
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            logger.warn("KYLIN_HOME was not set");
        }
        return kylinHome;
    }

    public static String getKylinHomeWithoutWarn() {
        String kylinHome = System.getenv("KYLIN_HOME");
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            kylinHome = SystemPropertiesCache.getProperty("KYLIN_HOME");
        }
        return kylinHome;
    }

    public static String getKylinConfHome() {
        String confHome = System.getenv("KYLIN_CONF");
        if (StringUtils.isEmpty((CharSequence)confHome)) {
            confHome = SystemPropertiesCache.getProperty("KYLIN_CONF");
        }
        return confHome;
    }

    public static String getSparkHome() {
        String sparkHome = System.getenv("SPARK_HOME");
        if (StringUtils.isNotEmpty((CharSequence)sparkHome)) {
            return sparkHome;
        }
        return KylinConfigBase.getKylinHome() + File.separator + "spark";
    }

    public Map<String, String> getReadonlyProperties() {
        StrSubstitutor subStitutorTmp = this.getSubstitutor();
        HashMap config = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            config.put((String)entry.getKey(), subStitutorTmp.replace((String)entry.getValue()));
        }
        return config;
    }

    protected KylinConfigBase(IExternalConfigLoader configLoader) {
        this(new Properties(), configLoader);
    }

    protected KylinConfigBase(Properties props, IExternalConfigLoader configLoader) {
        this(props, false, configLoader);
    }

    protected KylinConfigBase(Properties props, boolean force, IExternalConfigLoader configLoader) {
        this.properties = props instanceof PropertiesDelegate ? (PropertiesDelegate)props : (force ? new PropertiesDelegate(props, configLoader) : new PropertiesDelegate(BCC.check(props), configLoader));
        this.substitutor = new StrSubstitutor(new CompositeMapView(this.properties, STATIC_SYSTEM_ENV));
    }

    protected final String getOptional(String prop) {
        return this.getOptional(prop, null);
    }

    protected String getOptional(String prop, String dft) {
        String property = SystemPropertiesCache.getProperty(prop);
        return property != null ? this.getSubstitutor().replace(property) : this.getSubstitutor().replace(this.properties.getProperty(prop, dft));
    }

    protected Properties getAllProperties() {
        return this.getProperties(null);
    }

    protected Properties getProperties(Collection<String> propertyKeys) {
        StrSubstitutor subStitutorTmp = this.getSubstitutor();
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (propertyKeys != null && !propertyKeys.contains(entry.getKey())) continue;
            result.put(entry.getKey(), subStitutorTmp.replace((String)entry.getValue()));
        }
        return result;
    }

    protected StrSubstitutor getSubstitutor() {
        return this.substitutor;
    }

    protected Properties getRawAllProperties() {
        return this.properties;
    }

    protected final Map<String, String> getPropertiesByPrefix(String prefix) {
        String key;
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : this.getAllProperties().entrySet()) {
            key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : SystemPropertiesCache.getProperties().entrySet()) {
            key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    protected final String[] getOptionalStringArray(String prop, String[] dft) {
        String property = this.getOptional(prop);
        if (!StringUtils.isBlank((CharSequence)property)) {
            return (String[])Arrays.stream(property.split(",")).map(String::trim).toArray(String[]::new);
        }
        return dft;
    }

    protected final String[] getSystemStringArray(String prop, String[] dft) {
        String property = SystemPropertiesCache.getProperty(prop);
        if (!StringUtils.isBlank((CharSequence)property)) {
            return (String[])Arrays.stream(property.split(",")).map(String::trim).toArray(String[]::new);
        }
        return dft;
    }

    protected final int[] getOptionalIntArray(String prop, String[] dft) {
        String[] strArray = this.getOptionalStringArray(prop, dft);
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    protected final String getRequired(String prop) {
        String r = this.getOptional(prop);
        if (StringUtils.isEmpty((CharSequence)r)) {
            throw new IllegalArgumentException("missing '" + prop + "' in conf/kylin.properties");
        }
        return r;
    }

    public final void setProperty(String key, String value) {
        logger.trace("KylinConfig was updated with {}={}", (Object)key, (Object)value);
        this.properties.setProperty(BCC.check(key), value);
    }

    protected final void reloadKylinConfig(Properties properties) {
        this.properties.reloadProperties(BCC.check(properties));
        this.setProperty("kylin.metadata.url.identifier", this.getMetadataUrlPrefix());
        this.setProperty("kylin.metadata.url.unique-id", this.getMetadataUrlUniqueId());
        this.setProperty("kylin.log.spark-executor-properties-file", this.getLogSparkExecutorPropertiesFile());
        this.setProperty("kylin.log.spark-driver-properties-file", this.getLogSparkDriverPropertiesFile());
        this.setProperty("kylin.log.spark-appmaster-properties-file", this.getLogSparkAppMasterPropertiesFile());
        this.properties.put(WORKING_DIR_PROP, this.makeQualified(new Path(this.getOptional(WORKING_DIR_PROP, KYLIN_ROOT))).toString());
        if (this.properties.getProperty(DATA_WORKING_DIR_PROP) != null) {
            this.properties.put(DATA_WORKING_DIR_PROP, this.makeQualified(new Path(this.properties.getProperty(DATA_WORKING_DIR_PROP))).toString());
        }
        if (this.properties.getProperty(WRITING_CLUSTER_WORKING_DIR) != null) {
            this.properties.put(WRITING_CLUSTER_WORKING_DIR, this.makeQualified(new Path(this.properties.getProperty(WRITING_CLUSTER_WORKING_DIR))).toString());
        }
    }

    private Map<Integer, String> convertKeyToInteger(Map<String, String> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Integer.parseInt(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public boolean isDevOrUT() {
        return this.isUTEnv() || this.isDevEnv();
    }

    public boolean isUTEnv() {
        return "UT".equals(this.getDeployEnv());
    }

    @Deprecated
    public boolean isDevEnv() {
        return "DEV".equals(this.getDeployEnv());
    }

    public String getDeployEnv() {
        return this.getOptional("kylin.env", "PROD");
    }

    public String getHdfsWorkingDirectoryWithoutScheme() {
        return HadoopUtil.getPathWithoutScheme(this.getHdfsWorkingDirectory());
    }

    protected Path makeQualified(Path path) {
        try {
            FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
            return fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new KylinRuntimeException(e);
        }
    }

    public String getHdfsWorkingDirectory() {
        Path path;
        if (this.cachedHdfsWorkingDirectory != null) {
            return this.cachedHdfsWorkingDirectory;
        }
        String root = this.getOptional(DATA_WORKING_DIR_PROP, null);
        boolean compriseMetaId = false;
        if (root == null) {
            root = this.getOptional(WORKING_DIR_PROP, KYLIN_ROOT);
            compriseMetaId = true;
        }
        if (!(path = new Path(root)).isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        path = this.makeQualified(path);
        if (compriseMetaId) {
            String metaId = this.getMetadataUrlPrefix().replace(':', '-').replace('/', '-');
            path = new Path(path, metaId);
        }
        if (!(root = path.toString()).endsWith(PATH_DELIMITER)) {
            root = root + PATH_DELIMITER;
        }
        this.cachedHdfsWorkingDirectory = root;
        if (this.cachedHdfsWorkingDirectory.startsWith("file:")) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace("file:", "file://");
        } else if (this.cachedHdfsWorkingDirectory.startsWith("maprfs:")) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace("maprfs:", "maprfs://");
        }
        logger.info("Hdfs data working dir is setting to {}", (Object)this.cachedHdfsWorkingDirectory);
        return this.cachedHdfsWorkingDirectory;
    }

    public String getKylinMetricsPrefix() {
        return this.getOptional("kylin.metrics.prefix", "KYLIN").toUpperCase(Locale.ROOT);
    }

    public String getFirstDayOfWeek() {
        return this.getOptional("kylin.metadata.first-day-of-week", "monday");
    }

    public String getKylinMetricsActiveReservoirDefaultClass() {
        return this.getOptional("kylin.metrics.active-reservoir-default-class", "org.apache.kylin.metrics.lib.impl.StubReservoir");
    }

    public String getKylinSystemCubeSinkDefaultClass() {
        return this.getOptional("kylin.metrics.system-cube-sink-default-class", "org.apache.kylin.metrics.lib.impl.hive.HiveSink");
    }

    public String getEngineSparkHome() {
        return this.getOptional("kylin.engine.spark-home", null);
    }

    public boolean isKylinMetricsMonitorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.monitor-enabled", FALSE));
    }

    public String getZookeeperBasePath() {
        return this.getOptional("kylin.env.zookeeper-base-path", KYLIN_ROOT);
    }

    public String getClusterName() {
        return this.getOptional("kylin.server.cluster-name", this.getMetadataUrlUniqueId());
    }

    public int getZKBaseSleepTimeMs() {
        long sleepTimeMs = TimeUtil.timeStringAs(this.getOptional("kylin.env.zookeeper-base-sleep-time", "3s"), TimeUnit.MILLISECONDS);
        return Math.toIntExact(sleepTimeMs);
    }

    public int getZKMaxRetries() {
        return Integer.parseInt(this.getOptional("kylin.env.zookeeper-max-retries", "3"));
    }

    public String getZookeeperConnectString() {
        String str = this.getOptional("kylin.env.zookeeper-connect-string");
        if (!StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        throw new KylinRuntimeException("Please set 'kylin.env.zookeeper-connect-string' in kylin.properties");
    }

    public long geZookeeperClientSessionTimeoutThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.env.zookeeper-session-client-timeout-threshold", "120000ms"), TimeUnit.MILLISECONDS);
    }

    public long geZookeeperClientConnectionTimeoutThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.env.zookeeper-connection-client-timeout-threshold", "15000ms"), TimeUnit.MILLISECONDS);
    }

    public boolean isZookeeperAclEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.zookeeper-acl-enabled", FALSE));
    }

    public String getZKAuths() {
        return EncryptUtil.getDecryptedValue(this.getOptional("kylin.env.zookeeper.zk-auth", ""));
    }

    public String getZKAcls() {
        return this.getOptional("kylin.env.zookeeper.zk-acl", "world:anyone:rwcda");
    }

    public String getYarnStatusCheckUrl() {
        return this.getOptional("kylin.job.yarn-app-rest-check-status-url", null);
    }

    public boolean isInternalTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.internal-table-enabled", FALSE));
    }

    public boolean isInternalTablePreloadCacheEnabled() {
        boolean preloadCacheEnabled = Boolean.parseBoolean(this.getOptional("kylin.internal-table.preloaded-cache.enabled", TRUE));
        return preloadCacheEnabled && this.isInternalTableEnabled() && this.queryUseGlutenEnabled();
    }

    public boolean isInternalTableSortByPartitionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.internal-table.sort-by-partition.enabled", TRUE));
    }

    public int getQueryConcurrentRunningThresholdForProject() {
        return Integer.parseInt(this.getOptional("kylin.query.project-concurrent-running-threshold", "0"));
    }

    public int getAsyncQueryMaxConcurrentJobs() {
        return Integer.parseInt(this.getOptional("kylin.query.async-query.max-concurrent-jobs", "0"));
    }

    public boolean isAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-admin", TRUE));
    }

    public boolean isNoneAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-other", TRUE));
    }

    public StorageURL getMetadataUrl() {
        return StorageURL.valueOf(this.getOptional("kylin.metadata.url", "kylin_metadata@jdbc"));
    }

    public void setCoreMetadataDBUrl() {
        this.setProperty("kylin.core.metadata.url", this.getMetadataUrl().toString());
    }

    public StorageURL getCoreMetadataDBUrl() {
        return StorageURL.valueOf(this.getOptional("kylin.core.metadata.url", this.getMetadataUrl().toString()));
    }

    public boolean isMetadataCompressEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.compress.enabled", TRUE));
    }

    public int getMetadataCacheMaxNum() {
        return Integer.parseInt(this.getOptional("kylin.metadata.cache.max-num", String.valueOf(Integer.MAX_VALUE)));
    }

    public int getMetadataCacheMaxDuration() {
        return Integer.parseInt(this.getOptional("kylin.metadata.cache.max-duration", String.valueOf(Integer.MAX_VALUE)));
    }

    public boolean skipRecordJobExecutionTime() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.skip-record-execution-time", FALSE));
    }

    public boolean isAuditLogJsonPatchEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.audit-log-json-patch-enabled", TRUE));
    }

    public boolean isAuditLogOnlyOriginalEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.audit-log-compatible-only-original-format-enabled", FALSE));
    }

    public long getMetadataAuditLogMaxSize() {
        return Long.parseLong(this.getOptional("kylin.metadata.audit-log.max-size", "500000"));
    }

    public boolean isConcurrencyProcessMetadataEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.concurrency-process-metadata-size-enabled", TRUE));
    }

    public int getConcurrencyProcessMetadataThreadNumber() {
        return Integer.parseInt(this.getOptional("kylin.metadata.concurrency-process-metadata-thread-number", "8"));
    }

    public void setMetadataUrl(String metadataUrl) {
        this.setProperty("kylin.metadata.url", metadataUrl);
    }

    public String getMetadataUrlPrefix() {
        return this.getMetadataUrl().getIdentifier();
    }

    public String getMetadataUrlUniqueId() {
        if ("cloud".equalsIgnoreCase(this.getChannel())) {
            return this.getMetadataUrlPrefix();
        }
        StorageURL url = this.getMetadataUrl();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(url.getIdentifier());
        Optional.ofNullable(url.getParameter("url")).map(value -> value.split("\\?")[0]).map(value -> "_" + value).ifPresent(stringBuilder::append);
        String instanceId = stringBuilder.toString().replaceAll("\\W", "_");
        return instanceId;
    }

    public Map<String, String> getMetadataStoreImpls() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put("", "org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore");
        r.put("file", "org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore");
        r.put("hdfs", "org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore");
        r.put("jdbc", "org.apache.kylin.common.persistence.metadata.JdbcMetadataStore");
        r.putAll(this.getPropertiesByPrefix("kylin.metadata.resource-store-provider."));
        return r;
    }

    public static File getDiagFileName() {
        String uuid = RandomUtil.randomUUIDStr().toUpperCase(Locale.ROOT).substring(0, 6);
        String packageName = DIAG_ID_PREFIX + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.getDefault(Locale.Category.FORMAT)).format(new Date()) + "_" + uuid;
        String workDir = KylinConfigBase.getKylinHomeWithoutWarn();
        String diagPath = "diag_dump/" + packageName;
        File file = StringUtils.isNotEmpty((CharSequence)workDir) ? new File(workDir, diagPath) : new File(diagPath);
        return file;
    }

    public String getSecurityProfile() {
        return this.getOptional("kylin.security.profile", "testing");
    }

    public String[] getHdfsMetaStoreFileSystemSchemas() {
        return this.getOptionalStringArray("kylin.metadata.hdfs-compatible-schemas", new String[]{"hdfs", "maprfs", "s3", "s3a", "wasb", "wasbs", "adl", "adls", "abfs", "abfss", "gs", "oss"});
    }

    public String getMultiPartitionKeyMappingProvider() {
        return this.getOptional("kylin.model.multi-partition-key-mapping-provider-class", "org.apache.kylin.metadata.model.DefaultMultiPartitionKeyMappingProvider");
    }

    public boolean isMultiPartitionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.multi-partition-enabled", FALSE));
    }

    public String[] getCubeDimensionCustomEncodingFactories() {
        return this.getOptionalStringArray("kylin.metadata.custom-dimension-encodings", new String[0]);
    }

    public Map<String, String> getCubeCustomMeasureTypes() {
        return this.getPropertiesByPrefix("kylin.metadata.custom-measure-types.");
    }

    public DistributedLockFactory getDistributedLockFactory() {
        return (DistributedLockFactory)ClassUtil.newInstance(this.getDistributedLockFactoryFullClassName());
    }

    public String getDistributedLockFactoryFullClassName() {
        return this.getOptional("kylin.metadata.distributed-lock-impl", "org.apache.kylin.common.lock.curator.CuratorDistributedLockFactory");
    }

    public StorageURL getJDBCDistributedLockURL() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional(KYLIN_METADATA_DISTRIBUTED_LOCK_JDBC_URL))) {
            return this.getMetadataUrl();
        }
        return StorageURL.valueOf(this.getOptional(KYLIN_METADATA_DISTRIBUTED_LOCK_JDBC_URL));
    }

    public void setJDBCDistributedLockURL(String url) {
        this.setProperty(KYLIN_METADATA_DISTRIBUTED_LOCK_JDBC_URL, url);
    }

    public boolean isCheckCopyOnWrite() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.check-copy-on-write", FALSE));
    }

    public boolean isCheckHostname() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.hostname-check-enabled", TRUE));
    }

    public String getServerIpAddress() {
        return this.getOptional("kylin.env.ip-address");
    }

    public String getTransactionLockManager() {
        return this.getOptional("kylin.env.transaction-lock-manager", "org.apache.kylin.common.persistence.transaction.TransactionOptimisticLockManager");
    }

    public String getLockManager() {
        return this.getOptional("kylin.env.lock-manager", "org.apache.kylin.common.persistence.lock.MemoryLockManager");
    }

    public long getLockTimeoutSeconds() {
        return Long.parseLong(this.getOptional("kylin.env.lock-timeout", "60"));
    }

    public long getLockCheckIntervalSeconds() {
        return Long.parseLong(this.getOptional("kylin.env.dead-lock-check-interval", "3"));
    }

    public long getMaxSecondsForDeadLockRetry() {
        return Long.parseLong(this.getOptional("kylin.env.max-seconds-for-dead-lock-retry", "600"));
    }

    public int getLockRemoveMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.env.lock-remove-max-size", "200"));
    }

    public String getServerAddress() {
        String serverAddress = this.getOptional("kylin.server.address", this.getDefaultServerAddress());
        AddressUtil.validateHost(serverAddress);
        return serverAddress;
    }

    private String getDefaultServerAddress() {
        String hostAddress = AddressUtil.getLocalHostExactAddress();
        String serverPort = this.getServerPort();
        return String.format(Locale.ROOT, "%s:%s", hostAddress, serverPort);
    }

    public String getServerPort() {
        return this.getOptional("server.port", "7070");
    }

    public String getChannel() {
        return this.getOptional("kylin.env.channel", "on-premises");
    }

    public boolean isServerHttpsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.https.enable", FALSE));
    }

    public boolean isQueryNodeRequestForwardEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.request-forward-enabled", TRUE));
    }

    public int getServerHttpsPort() {
        return Integer.parseInt(this.getOptional("kylin.server.https.port", "7443"));
    }

    public String getServerHttpsKeyType() {
        return this.getOptional("kylin.server.https.keystore-type", "JKS");
    }

    public String getServerHttpsKeystore() {
        return this.getOptional("kylin.server.https.keystore-file", KylinConfigBase.getKylinHome() + "/server/.keystore");
    }

    public String getServerHttpsKeyPassword() {
        return this.getOptional("kylin.server.https.keystore-password", "changeit");
    }

    public String getServerHttpsKeyAlias() {
        return this.getOptional("kylin.server.https.key-alias", null);
    }

    public boolean isSemiAutoMode() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.semi-automatic-mode", FALSE));
    }

    public boolean isTableExclusionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.table-exclusion-enabled", FALSE));
    }

    public boolean isSnapshotPreferred() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.snapshot-preferred-for-table-exclusion", TRUE));
    }

    public boolean onlyReuseUserDefinedCC() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.only-reuse-user-defined-computed-column", FALSE));
    }

    public boolean isConvertExpressionToCcEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.implicit-computed-column-convert", TRUE));
    }

    public int getConvertCcMaxIterations() {
        return Integer.parseInt(this.getOptional("kylin.query.computed-column-max-recursion-times", "10"));
    }

    public boolean exposeComputedColumn() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.metadata.expose-computed-column", FALSE));
    }

    public boolean validateComputedColumn() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.validate-computed-column", TRUE));
    }

    public String getCalciteQuoting() {
        return this.getOptional("kylin.query.calcite.extras-props.quoting", "DOUBLE_QUOTE");
    }

    public String getModelExportHost() {
        return this.getOptional("kylin.model.export.host");
    }

    public int getModelExportPort() {
        return Integer.parseInt(this.getOptional("kylin.model.export.port", "-1"));
    }

    public boolean isSnapshotParallelBuildEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.parallel-build-enabled", TRUE));
    }

    public int snapshotParallelBuildTimeoutSeconds() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.parallel-build-timeout-seconds", "3600"));
    }

    public int snapshotPartitionBuildMaxThread() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.partition-build-max-thread", "10"));
    }

    public int getSnapshotMaxVersions() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.max-versions", "3"));
    }

    public long getSnapshotVersionTTL() {
        return Long.parseLong(this.getOptional("kylin.snapshot.version-ttl", "259200000"));
    }

    public int getSnapshotShardSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.shard-size-mb", "128"));
    }

    public boolean isSnapshotManualManagementEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.manual-management-enabled", FALSE));
    }

    public boolean isSnapshotAutoRefreshEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.auto-refresh-enabled", FALSE));
    }

    public String getSnapshotAutoRefreshCron() {
        return this.getOptional("kylin.snapshot.auto-refresh-cron", "0 0 0 */1 * ?");
    }

    public int getSnapshotAutoRefreshFetchFilesCount() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.auto-refresh-fetch-files-count", "1"));
    }

    public int getSnapshotAutoRefreshFetchPartitionsCount() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.auto-refresh-fetch-partitions-count", "1"));
    }

    public int getSnapshotAutoRefreshMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.auto-refresh-max-concurrent-jobs", "20"));
    }

    public long getSnapshotAutoRefreshTaskTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.snapshot.auto-refresh-task-timeout", "30min"), TimeUnit.MILLISECONDS);
    }

    public String getSnapshotAutoRefreshDir(String project) {
        return this.getHdfsWorkingDirectory(project) + "snapshot_auto_refresh" + PATH_DELIMITER;
    }

    public boolean isSnapshotFirstAutoRefreshEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.first-auto-refresh-enabled", FALSE));
    }

    public boolean isSnapshotNullLocationAutoRefreshEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.null-location-auto-refresh-enabled", FALSE));
    }

    public int getGlobalDictV2MinHashPartitions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-min-hash-partitions", "1"));
    }

    public int getGlobalDictV2ThresholdBucketSize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-threshold-bucket-size", "500000"));
    }

    public double getGlobalDictV2InitLoadFactor() {
        return Double.parseDouble(this.getOptional("kylin.dictionary.globalV2-init-load-factor", "0.5"));
    }

    public double getGlobalDictV2BucketOverheadFactor() {
        return Double.parseDouble(this.getOptional("kylin.dictionary.globalV2-bucket-overhead-factor", "1.5"));
    }

    public int getGlobalDictV2MaxVersions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-max-versions", "3"));
    }

    public long getGlobalDictV2VersionTTL() {
        return Long.parseLong(this.getOptional("kylin.dictionary.globalV2-version-ttl", "259200000"));
    }

    public long getNullEncodingOptimizeThreshold() {
        return Long.parseLong(this.getOptional("kylin.dictionary.null-encoding-opt-threshold", "40000000"));
    }

    public String getSegmentAdvisor() {
        return this.getOptional("kylin.cube.segment-advisor", "org.apache.kylin.cube.CubeSegmentAdvisor");
    }

    public long getCubeAggrGroupMaxCombination() {
        return Long.parseLong(this.getOptional("kylin.cube.aggrgroup.max-combination", "4096"));
    }

    public boolean getCubeAggrGroupIsMandatoryOnlyValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.is-mandatory-only-valid", TRUE));
    }

    public boolean isBaseCuboidAlwaysValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.is-base-cuboid-always-valid", TRUE));
    }

    public boolean isBaseIndexAutoUpdate() {
        return Boolean.parseBoolean(this.getOptional("kylin.index.base-index-auto-update", TRUE));
    }

    public double getMergeSegmentStorageThreshold() {
        double thresholdValue = Double.parseDouble(this.getOptional("kylin.cube.merge-segment-storage-threshold", "0"));
        if (thresholdValue < 0.0 || thresholdValue > 1.0) {
            logger.warn("The configuration file is incorrect. The value of[kylin.cube.merge-segment-storage-threshold] cannot be less than 0 or greater than 1.");
            thresholdValue = 0.0;
        }
        return thresholdValue;
    }

    public StorageURL getJobMetadataUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional("kylin.job.metadata.url"))) {
            return this.getMetadataUrl();
        }
        return StorageURL.valueOf(this.getOptional("kylin.job.metadata.url"));
    }

    public void setJobMetadataUrl(String jobMetadataUrl) {
        this.setProperty("kylin.job.metadata.url", jobMetadataUrl);
    }

    public String getStreamingJobTmpDir(String project) {
        return this.getHdfsWorkingDirectoryWithoutScheme() + "streaming/jobs/" + project + PATH_DELIMITER;
    }

    public String getStreamingJobTmpOutputStorePath(String project, String jobId) {
        return this.getStreamingJobTmpDir(project) + jobId + PATH_DELIMITER;
    }

    public String getJobTmpDir(String project, boolean withScheme) {
        if (!withScheme) {
            return this.getHdfsWorkingDirectoryWithoutScheme() + project + "/job_tmp/";
        }
        return this.getHdfsWorkingDirectory(project) + "job_tmp/";
    }

    public String getJobTmpDir(String project) {
        return this.getHdfsWorkingDirectoryWithoutScheme() + project + "/job_tmp/";
    }

    public String getSnapshotCheckPointDir(String project, String jobId) {
        return this.getHdfsWorkingDirectory(project) + "job_tmp/" + jobId + "/__step_checkpoint_snapshot/";
    }

    public StorageURL getJobTmpMetaStoreUrl(String project, String jobId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", this.getJobTmpDir(project) + this.getNestedPath(jobId) + "meta");
        return new StorageURL(this.getMetadataUrlPrefix(), "hdfs", params);
    }

    public String getJobTmpOutputStorePath(String project, String jobId) {
        return this.getJobTmpDir(project) + this.getNestedPath(jobId) + "/execute_output.json";
    }

    public String getJobTmpArgsDir(String project, String jobId) {
        return this.getJobTmpDir(project) + this.getNestedPath(jobId) + "/spark_args.json";
    }

    public String getJobTmpTransactionalTableDir(String project, String jobId) {
        return this.getJobTmpDir(project) + jobId + "/transactional/";
    }

    public Path getJobTmpShareDir(String project, String jobId) {
        String path = this.getJobTmpDir(project) + jobId + "/share/";
        return new Path(path);
    }

    public boolean isBuildFilesSeparationEnabled() {
        return !this.getBuildConf().isEmpty() && !this.getWritingClusterWorkingDir().isEmpty();
    }

    public String getWriteClusterWorkingDir() {
        return this.getOptional("kylin.env.write-hdfs-working-dir", "");
    }

    public String getWritingClusterWorkingDir() {
        return this.getOptional(WRITING_CLUSTER_WORKING_DIR, "");
    }

    public String getWritingClusterWorkingDir(String withSuffix) {
        Path writingClusterPath = new Path(this.getWritingClusterWorkingDir());
        if (!writingClusterPath.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-write-working-dir must be absolute, but got " + writingClusterPath);
        }
        writingClusterPath = this.makeQualified(writingClusterPath);
        String metaId = this.getMetadataUrlPrefix().replace(':', '-').replace('/', '-');
        return writingClusterPath + PATH_DELIMITER + metaId + PATH_DELIMITER + withSuffix;
    }

    public Path getFlatTableDir(String project, String dataFlowId, String segmentId) {
        String flatTableDirSuffix = project + "/flat_table/" + dataFlowId + PATH_DELIMITER + segmentId;
        String writingClusterWorkingDir = this.getWritingClusterWorkingDir();
        if (writingClusterWorkingDir.isEmpty()) {
            return new Path(this.getHdfsWorkingDirectory() + flatTableDirSuffix);
        }
        return new Path(this.getWritingClusterWorkingDir(flatTableDirSuffix));
    }

    public Path getFactTableViewDir(String project, String dataflowId, String segmentId) {
        String path = this.getHdfsWorkingDirectory() + project + "/fact_table_view/" + dataflowId + PATH_DELIMITER + segmentId;
        return new Path(path);
    }

    public Path getJobTmpFlatTableDir(String project, String jobId) {
        String path = this.getJobTmpDir(project) + jobId + "/flat_table/";
        return new Path(path);
    }

    public Path getJobTmpFactTableViewDir(String project, String jobId) {
        String path = this.getJobTmpDir(project) + jobId + "/fact_table_view/";
        return new Path(path);
    }

    private String getNestedPath(String id) {
        String[] ids = id.split("_");
        StringBuilder builder = new StringBuilder();
        for (String subId : ids) {
            builder.append(subId).append(PATH_DELIMITER);
        }
        return builder.toString();
    }

    public CliCommandExecutor getCliCommandExecutor() {
        CliCommandExecutor exec = new CliCommandExecutor();
        if (this.getRunAsRemoteCommand()) {
            exec.setRunAtRemote(this.getRemoteHadoopCliHostname(), this.getRemoteHadoopCliPort(), this.getRemoteHadoopCliUsername(), this.getRemoteHadoopCliPassword());
        }
        return exec;
    }

    public boolean getRunAsRemoteCommand() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-remote-cli"));
    }

    public int getRemoteHadoopCliPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote-cli-port", "22"));
    }

    public String getRemoteHadoopCliHostname() {
        return this.getOptional("kylin.job.remote-cli-hostname");
    }

    public String getRemoteHadoopCliUsername() {
        return this.getOptional("kylin.job.remote-cli-username");
    }

    public String getRemoteHadoopCliPassword() {
        return this.getOptional("kylin.job.remote-cli-password");
    }

    public int getRemoteSSHPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote-ssh-port", "22"));
    }

    public String getRemoteSSHUsername() {
        return this.getOptional("kylin.job.ssh-username");
    }

    public String getRemoteSSHPassword() {
        return EncryptUtil.getDecryptedValue(this.getOptional("kylin.job.ssh-password"));
    }

    public String getCliWorkingDir() {
        return this.getOptional("kylin.job.remote-cli-working-dir");
    }

    public int getMaxTransactionRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.max-transaction-retry", "3"));
    }

    public int getMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.max-concurrent-jobs", "20"));
    }

    public int getMaxConcurrentFillIndexJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.index-planner.max-job-count", "5"));
    }

    public int getNodeMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.node-max-concurrent-jobs", "30"));
    }

    public int getMaxStreamingConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.streaming.job.max-concurrent-jobs", "10"));
    }

    public int getNodeMaxStreamingConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.streaming.job.node-max-concurrent-jobs", "30"));
    }

    public boolean getAutoSetConcurrentJob() {
        if (this.isDevOrUT()) {
            return Boolean.parseBoolean(this.getOptional("kylin.job.auto-set-concurrent-jobs", FALSE));
        }
        return Boolean.parseBoolean(this.getOptional("kylin.job.auto-set-concurrent-jobs", TRUE));
    }

    public double getMaxLocalConsumptionRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.max-local-consumption-ratio", "0.5"));
    }

    public boolean isCtlJobPriorCrossProj() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.control-job-priority-cross-project", TRUE));
    }

    public String[] getOverCapacityMailingList() {
        return this.getOptionalStringArray("kylin.capacity.notification-emails", new String[0]);
    }

    public boolean isOverCapacityNotificationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.capacity.notification-enabled", FALSE));
    }

    public String getQueryExtensionFactory() {
        String defaultValue = "org.apache.kylin.query.QueryExtension$Factory";
        return this.getOptional("kylin.extension.query.factory", defaultValue);
    }

    public String getMetadataExtensionFactory() {
        String defaultValue = "org.apache.kylin.metadata.MetadataExtension$Factory";
        return this.getOptional("kylin.extension.metadata.factory", defaultValue);
    }

    public String getTestMetadataDirectory() {
        return this.getOptional("kylin.test.metadata.dir", "../examples/test_case_data/localmeta");
    }

    public String getTestDataDirectory() {
        return this.getOptional("kylin.test.data.dir", "../examples/test_data/");
    }

    public double getOverCapacityThreshold() {
        return Double.parseDouble(this.getOptional("kylin.capacity.over-capacity-threshold", "80")) / 100.0;
    }

    public boolean isMailEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-enabled", FALSE));
    }

    public boolean isStarttlsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-mail-enable-starttls", FALSE));
    }

    public String getSmtpPort() {
        return this.getOptional("kylin.job.notification-mail-port", "25");
    }

    public String getMailHost() {
        return this.getOptional("kylin.job.notification-mail-host", "");
    }

    public String getMailUsername() {
        return this.getOptional("kylin.job.notification-mail-username", "");
    }

    public String getMailPassword() {
        return this.getOptional("kylin.job.notification-mail-password", "");
    }

    public String getMailSender() {
        return this.getOptional("kylin.job.notification-mail-sender", "");
    }

    public String[] getAdminDls() {
        return this.getOptionalStringArray("kylin.job.notification-admin-emails", new String[0]);
    }

    public String[] getJobNotificationStates() {
        return this.getOptionalStringArray("kylin.job.notification-enable-states", null);
    }

    public int getJobRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.retry", "0"));
    }

    public int getJobRetryInterval() {
        return Integer.parseInt(this.getOptional("kylin.job.retry-interval", "30000"));
    }

    public String[] getJobRetryExceptions() {
        return this.getOptionalStringArray("kylin.job.retry-exception-classes", new String[0]);
    }

    public String getJobControllerLock() {
        return this.getOptional("kylin.job.lock", "org.apache.kylin.storage.hbase.util.ZookeeperJobLock");
    }

    public Integer getSchedulerPollIntervalSecond() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.poll-interval-second", "10"));
    }

    public boolean isFlatTableJoinWithoutLookup() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.flat-table-join-without-lookup", FALSE));
    }

    public String getJobTrackingURLPattern() {
        return this.getOptional("kylin.job.tracking-url-pattern", "");
    }

    public boolean isJobLogPrintEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.log-print-enabled", TRUE));
    }

    public boolean isDeleteJobTmpWhenRetry() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.delete-job-tmp-when-retry", FALSE));
    }

    public boolean isSetYarnQueueInTaskEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine-yarn.queue.in.task.enabled", FALSE));
    }

    public List<String> getYarnQueueInTaskAvailable() {
        return Lists.newArrayList((Object[])this.getOptional("kylin.engine-yarn.queue.in.task.available", DEFAULT).split(","));
    }

    public boolean isConcurrencyFetchDataSourceSize() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.concurrency-fetch-datasource-size-enabled", TRUE));
    }

    public int getConcurrencyFetchDataSourceSizeThreadNumber() {
        return Integer.parseInt(this.getOptional("kylin.job.concurrency-fetch-datasource-size-thread_number", "10"));
    }

    public boolean isUseBigIntAsTimestampForPartitionColumn() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-bigint-as-timestamp-for-partition-column", FALSE));
    }

    public int getDefaultSource() {
        return Integer.parseInt(this.getOptional("kylin.source.default", "9"));
    }

    public Map<Integer, String> getSourceEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(1, "org.apache.kylin.source.kafka.NSparkKafkaSource");
        r.put(8, "org.apache.kylin.source.jdbc.JdbcSource");
        r.put(9, "org.apache.kylin.engine.spark.source.NSparkDataSource");
        r.put(13, "org.apache.kylin.source.file.FileSource");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.provider.")));
        return r;
    }

    public List<Integer> getSourceProviderFamily(int sourceType) {
        String family = this.getOptional("kylin.source.provider-family." + sourceType, "");
        if (StringUtils.isBlank((CharSequence)family)) {
            return Collections.emptyList();
        }
        return Arrays.stream(family.split(",")).map(Integer::parseInt).collect(Collectors.toList());
    }

    public Map<Integer, List<Integer>> getSourceProviderFamilyMapping() {
        Map<Integer, String> originalMapping = this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.provider-family."));
        HashMap ret = Maps.newHashMap();
        for (Map.Entry<Integer, String> entry : originalMapping.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            ret.put(entry.getKey(), Arrays.stream(entry.getValue().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
        }
        return ret;
    }

    @Deprecated
    public String getHiveUrl() {
        return this.getOptional("kylin.source.hive.connection-url", "");
    }

    @Deprecated
    public String getHiveUser() {
        return this.getOptional("kylin.source.hive.connection-user", "");
    }

    @Deprecated
    public String getHivePassword() {
        return this.getOptional("kylin.source.hive.connection-password", "");
    }

    public String getHiveDatabaseForIntermediateTable() {
        return this.getOptional("kylin.source.hive.database-for-flat-table", DEFAULT);
    }

    public String getHiveClientMode() {
        return this.getOptional("kylin.source.hive.client", "cli");
    }

    public String getHiveBeelineParams() {
        return this.getOptional("kylin.source.hive.beeline-params", "");
    }

    public boolean getSourceNameCaseSensitiveEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.name-case-sensitive-enabled", FALSE));
    }

    public boolean getPushdownSelectStarCaseSensitiveEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.pushdown.select-star-case-sensitive-enabled", TRUE));
    }

    public boolean getPushdownSelectStarLowercaseEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.pushdown.select-star-lowercase-enabled", FALSE));
    }

    public int getDefaultVarcharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-varchar-precision", "4096"));
        if (v < 1) {
            return 4096;
        }
        if (v > 65355) {
            return 65535;
        }
        return v;
    }

    public int getDefaultCharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-char-precision", "255"));
        if (v < 1) {
            return 255;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public int getDefaultDecimalPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-precision", "19"));
        if (v < 1) {
            return 19;
        }
        return v;
    }

    public int getDefaultDecimalScale() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-scale", "4"));
        if (v < 1) {
            return 4;
        }
        return v;
    }

    public String getKafkaMaxOffsetsPerTrigger() {
        return this.getOptional("kylin.streaming.kafka-conf.maxOffsetsPerTrigger", "0");
    }

    public String getJdbcConnectionUrl() {
        return this.getOptional("kylin.source.jdbc.connection-url");
    }

    public String getJdbcDriver() {
        return this.getOptional("kylin.source.jdbc.driver");
    }

    public String getJdbcDialect() {
        return this.getOptional("kylin.source.jdbc.dialect");
    }

    public String getJdbcUser() {
        return this.getOptional("kylin.source.jdbc.user");
    }

    public String getJdbcPass() {
        return EncryptUtil.getDecryptedValue(this.getOptional("kylin.source.jdbc.pass"));
    }

    public boolean getJdbcEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.jdbc.source.enable", FALSE));
    }

    public long getKafkaPollMessageTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.source.kafka.poll-message-timeout-ms", "3000ms"), TimeUnit.MILLISECONDS);
    }

    public String getJdbcAdaptorClass() {
        return this.getOptional("kylin.source.jdbc.adaptor", this.getJdbcSourceConnector());
    }

    public int getJdbcConnectRetryTimes() {
        return Integer.parseInt(this.getOptional("kylin.source.jdbc.connect-retry-times", "1"));
    }

    public long getJdbcSleepIntervalBetweenRetry() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.source.jdbc.connect-retry-sleep-interval", "100ms"), TimeUnit.MILLISECONDS);
    }

    public String getJdbcSourceConnector() {
        return this.getOptional("kylin.source.jdbc.connector-class-name", "org.apache.kylin.source.jdbc.DefaultSourceConnector");
    }

    public String getJdbcConvertToLowerCase() {
        return this.getOptional("kylin.source.jdbc.convert-to-lowercase", FALSE);
    }

    public Map<Integer, String> getStorageEngines() {
        LinkedHashMap r = Maps.newLinkedHashMap();
        r.put(20, "org.apache.kylin.storage.ParquetDataStorage");
        r.put(3, "org.apache.kylin.storage.DeltaDataStorage");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.storage.provider.")));
        return r;
    }

    public int getDefaultStorageEngine() {
        return Integer.parseInt(this.getOptional("kylin.storage.default", "20"));
    }

    public int getDefaultStorageType() {
        return Integer.parseInt(this.getOptional("kylin.storage.default-storage-type", "0"));
    }

    public String getExtraJarsPath() {
        return this.getOptional("kylin.engine.extra-jars-path", "");
    }

    public String getKylinJobJarPath() {
        String jobJar = this.getOptional("kylin.engine.spark.job-jar");
        if (StringUtils.isNotEmpty((CharSequence)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            return "";
        }
        File jar = FileUtils.findFile(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
        if (jar == null) {
            return "";
        }
        return jar.getAbsolutePath();
    }

    public String getStreamingJobJarPath() {
        String jobJar = this.getOptional("kylin.streaming.spark.job-jar");
        if (StringUtils.isNotEmpty((CharSequence)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            return "";
        }
        File jar = FileUtils.findFile(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
        if (jar == null) {
            return "";
        }
        return jar.getAbsolutePath();
    }

    public String getHdfsCustomJarPath(String project, String jarType) {
        return this.getHdfsWorkingDirectory() + "custom/jars/" + project + PATH_DELIMITER + jarType + PATH_DELIMITER;
    }

    public int getStreamingCustomParserLimit() {
        int parserLimit = Integer.parseInt(this.getOptional("kylin.streaming.custom-parser-limit", "50"));
        return parserLimit < 1 ? 50 : parserLimit;
    }

    public long getStreamingCustomJarSizeMB() {
        return SizeConvertUtil.byteStringAs(this.getOptional("kylin.streaming.custom-jar-size", "20mb"), ByteUnit.BYTE);
    }

    public String getKylinExtJarsPath(Boolean withGluten) {
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((CharSequence)kylinHome)) {
            return "";
        }
        List<File> files = FileUtils.findFiles(kylinHome + File.separator + "lib/ext", JAR_NAME_PATTERN);
        if (CollectionUtils.isEmpty(files)) {
            return "";
        }
        StringBuilder extJar = new StringBuilder();
        for (File file : files) {
            if (!withGluten.booleanValue() && StringUtils.containsIgnoreCase((CharSequence)file.getName(), (CharSequence)"gluten")) continue;
            extJar.append(",");
            extJar.append(file.getAbsolutePath());
        }
        return extJar.toString();
    }

    public String getSnapshotBuildClassName() {
        return this.getOptional("kylin.engine.spark.snapshot-build-class-name", "org.apache.kylin.engine.spark.job.SnapshotBuildJob");
    }

    public String getInternalTableBuildClassName() {
        return this.getOptional("kylin.engine.spark.internal-table-build-class-name", "org.apache.kylin.engine.spark.job.InternalTableLoadJob");
    }

    public String getSparkMaster() {
        return this.getOptional("kylin.engine.spark-conf.spark.master", "yarn").toLowerCase(Locale.ROOT);
    }

    public String getKubernetesNameSpace() {
        return this.getOptional("kylin.engine.spark-conf.spark.kubernetes.namespace", DEFAULT).toLowerCase(Locale.ROOT);
    }

    public String getDeployMode() {
        return this.getOptional("kylin.engine.spark-conf.spark.submit.deployMode", "client").toLowerCase(Locale.ROOT);
    }

    public String getSparkSqlHiveMetastoreJarsPath() {
        return this.getOptional("kylin.engine.spark-conf.spark.sql.hive.metastore.jars.path", "");
    }

    public boolean getHiveClientJarUploadEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.hive-client-jar-upload.enable", FALSE));
    }

    public String getSparkBuildClassName() {
        return this.getOptional("kylin.engine.spark.build-class-name", "org.apache.kylin.engine.spark.job.SegmentBuildJob");
    }

    public List<String> getSparkBuildConfExtraRules() {
        String rules = this.getOptional("kylin.engine.spark.build-conf-extra-rules");
        if (StringUtils.isEmpty((CharSequence)rules)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])rules.split(","));
    }

    public String getSparkTableSamplingClassName() {
        return this.getOptional("kylin.engine.spark.sampling-class-name", "org.apache.kylin.engine.spark.job.TableAnalyzeJob");
    }

    public String getSparkIndexPlanOptClassName() {
        return this.getOptional("kylin.engine.spark.index-plan-opt-class-name", "org.apache.kylin.engine.spark.job.IndexPlanOptimizeJob");
    }

    public String getSparkMergeClassName() {
        return this.getOptional("kylin.engine.spark.merge-class-name", "org.apache.kylin.engine.spark.job.SegmentMergeJob");
    }

    public boolean isCompactionAfterDataUpdateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.compaction-after-date-update-enabled", TRUE));
    }

    public boolean isAutoOptimizeAfterBuildEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.optimize-after-build-enabled", FALSE));
    }

    public int getKylinDeltaStorageWriteRetyTimes() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.delta-storage-write-retry-times", "10"));
    }

    public String getSparkOptimizeClassName() {
        return this.getOptional("kylin.engin.spark.optimize-class-name", "org.apache.kylin.engine.spark.job.LayoutDataOptimizeJob");
    }

    public String getClusterManagerClassName() {
        return this.getOptional("kylin.engine.spark.cluster-manager-class-name", "org.apache.kylin.cluster.YarnClusterManager");
    }

    public long getClusterManagerTimeoutThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.engine.cluster-manager-timeout-threshold", "150s"), TimeUnit.SECONDS);
    }

    public void overrideSparkJobJarPath(String path) {
        Unsafe.setProperty("kylin.engine.spark.job-jar", path);
    }

    public int getBuildingCacheThreshold() {
        int threshold = Integer.parseInt(this.getOptional("kylin.engine.spark.cache-threshold", "100"));
        if (threshold <= 0) {
            threshold = Integer.MAX_VALUE;
        }
        return threshold;
    }

    public Map<String, String> getSparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.spark-conf.");
    }

    public String getGlutenStoragePolicy() {
        String prefix = "kylin.engine.spark-conf.spark.gluten.sql.columnar.backend.ch.runtime_config.storage_configuration.policies.";
        Map<String, String> policies = this.getPropertiesByPrefix(prefix);
        if (policies.isEmpty()) {
            return DEFAULT;
        }
        String propKey = policies.keySet().iterator().next();
        return propKey.split("\\.")[0];
    }

    public boolean isSnapshotSpecifiedSparkConf() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.snapshot.specified-spark-conf-enabled", FALSE));
    }

    public Map<String, String> getSnapshotBuildingConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.snapshot.spark-conf.");
    }

    public Map<String, String> getIndexPlannerBuildingConfigOverride() {
        return this.getPropertiesByPrefix("kylin.index-planner.spark-conf.");
    }

    public Map<String, String> getAsyncQuerySparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.query.async-query.spark-conf.");
    }

    public boolean isCleanSparkUIZombieJob() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.engine.clean-spark-ui-zombie-job-enabled", FALSE));
    }

    public int getSparkUIZombieJobCleanSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.engine.spark-ui-zombie-job-clean-seconds", "180"));
    }

    public boolean isSparkUIAclEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.engine.spark-ui-acl.enabled", FALSE));
    }

    public int getSparkEngineMaxRetryTime() {
        return Integer.parseInt(this.getOptional("kylin.engine.max-retry-time", "3"));
    }

    public double getSparkEngineRetryMemoryGradient() {
        return Double.parseDouble(this.getOptional("kylin.engine.retry-memory-gradient", "1.5"));
    }

    public double getSparkEngineRetryOverheadMemoryGradient() {
        return Double.parseDouble(this.getOptional("kylin.engine.retry-overheadMemory-gradient", "0.2"));
    }

    public boolean isAutoSetSparkConf() {
        return Boolean.parseBoolean(this.getOptional("kylin.spark-conf.auto-prior", TRUE));
    }

    public Double getMaxAllocationResourceProportion() {
        return Double.parseDouble(this.getOptional("kylin.engine.max-allocation-proportion", "0.9"));
    }

    public int getSparkEngineDriverMemoryTableSampling() {
        return (int)SizeConvertUtil.byteStringAsMb(this.getOptional("kylin.engine.driver-memory-table-sampling", "1024"));
    }

    public int getSparkEngineDriverMemorySnapshotBuilding() {
        return (int)SizeConvertUtil.byteStringAsMb(this.getOptional("kylin.engine.snapshot.spark-conf.spark.driver.memory", "1024"));
    }

    public int getSparkEngineDriverMemoryInternalTableLoading() {
        return (int)SizeConvertUtil.byteStringAsMb(this.getOptional("kylin.engine.internal.spark-conf.spark.driver.memory", "1024"));
    }

    public int getSparkEngineDriverMemoryBase() {
        return Integer.parseInt(this.getOptional("kylin.engine.driver-memory-base", "1024"));
    }

    public boolean useDynamicResourcePlan() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.dynamic-resource-plan-enabled", FALSE));
    }

    public boolean useQueueElasticResource() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.queue-elastic-resource-enabled", FALSE));
    }

    public boolean isSanityCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.sanity-check-enabled", TRUE));
    }

    public boolean isGlobalDictCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.global-dict-check-enabled", FALSE));
    }

    public boolean isGlobalDictAQEEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.global-dict-aqe-enabled", FALSE));
    }

    public String getJdbcSourceName() {
        return this.getOptional("kylin.source.jdbc.source.name");
    }

    public int getSparkEngineDriverMemoryMaximum() {
        return Integer.parseInt(this.getOptional("kylin.engine.driver-memory-maximum", "4096"));
    }

    public int getSparkEngineTaskCoreFactor() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.task-core-factor", "3"));
    }

    public String getSparkEngineSampleSplitThreshold() {
        return this.getOptional("kylin.engine.spark.sample-split-threshold", "256m");
    }

    public boolean isSparkEngineTaskImpactInstanceEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.task-impact-instance-enabled", TRUE));
    }

    public int getSparkEngineBaseExuctorInstances() {
        return Integer.parseInt(this.getOptional("kylin.engine.base-executor-instance", "5"));
    }

    public String getSparkEngineExuctorInstanceStrategy() {
        return this.getOptional("kylin.engine.executor-instance-strategy", "100,2,500,3,1000,4");
    }

    public Double getSparkEngineResourceRequestOverLimitProportion() {
        return Double.parseDouble(this.getOptional("kylin.engine.resource-request-over-limit-proportion", "1.0"));
    }

    public boolean isStreamingConfigEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.streaming.enabled", FALSE));
    }

    public int getMaxCommandLineOutputLength() {
        return Integer.parseInt(this.getOptional("kylin.command.max-output-bytes", String.valueOf(0xA00000))) / 2;
    }

    public boolean isStreamingEnabled() {
        return this.isStreamingConfigEnabled() && KylinInfoExtension.getFactory().checkKylinInfo();
    }

    public Map<String, String> getStreamingSparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.streaming.spark-conf.");
    }

    public Map<String, String> getStreamingKafkaConfigOverride() {
        return this.getPropertiesByPrefix("kylin.streaming.kafka-conf.");
    }

    public String getStreamingTableRefreshInterval() {
        return this.getOptional("kylin.streaming.table-refresh-interval");
    }

    public String getStreamingJobStatusWatchEnabled() {
        return this.getOptional("kylin.streaming.job-status-watch-enabled", TRUE);
    }

    public String getStreamingJobRetryEnabled() {
        return this.getOptional("kylin.streaming.job-retry-enabled", FALSE);
    }

    public int getStreamingJobRetryInterval() {
        return (int)TimeUtil.timeStringAs(this.getOptional("kylin.streaming.job-retry-interval", "5m"), TimeUnit.MINUTES);
    }

    public int getStreamingJobMaxRetryInterval() {
        return (int)TimeUtil.timeStringAs(this.getOptional("kylin.streaming.job-retry-max-interval", "30m"), TimeUnit.MINUTES);
    }

    public String getStreamingJobWatermark() {
        return this.getOptional("kylin.streaming.watermark", "");
    }

    public long getStreamingJobExecutionIdCheckInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.streaming.job-execution-id-check-interval", "1m"), TimeUnit.MINUTES);
    }

    public long getStreamingJobMetaRetainedTime() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.streaming.job-meta-retained-time", "2h"), TimeUnit.MILLISECONDS);
    }

    public String getSparkEngineBuildStepsToSkip() {
        return this.getOptional("kylin.engine.steps.skip", "");
    }

    public String getHadoopConfDir() {
        return this.getOptional("kylin.env.hadoop-conf-dir", "");
    }

    public boolean isRouteToMetadataEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.using-metadata-answer-minmax-of-dimension", FALSE));
    }

    public boolean partialMatchNonEquiJoins() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.match-partial-non-equi-join-model", FALSE));
    }

    public boolean asyncProfilingEnabled() {
        return !Boolean.parseBoolean(SystemPropertiesCache.getProperty("spark.local", FALSE)) && Boolean.parseBoolean(this.getOptional("kylin.query.async-profiler-enabled", TRUE));
    }

    public long asyncProfilingResultTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.async-profiler-result-timeout", "60s"), TimeUnit.MILLISECONDS);
    }

    public long asyncProfilingProfileTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.async-profiler-profile-timeout", "5m"), TimeUnit.MILLISECONDS);
    }

    public boolean readSourceWithDefaultParallelism() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.read-source-with-default-parallelism", FALSE));
    }

    public boolean isHeterogeneousSegmentEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.heterogeneous-segment-enabled", TRUE));
    }

    public boolean isUseTableIndexAnswerNonRawQuery() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.use-tableindex-answer-non-raw-query", FALSE));
    }

    public boolean isPreferAggIndex() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.layout.prefer-aggindex", TRUE));
    }

    public boolean isTransactionEnabledInQuery() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.transaction-enable", FALSE));
    }

    public boolean isConvertCreateTableToWith() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.convert-create-table-to-with", FALSE));
    }

    public boolean isConvertSumExpressionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.convert-sum-expression-enabled", FALSE));
    }

    public boolean isEnhancedAggPushDownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enhanced-agg-pushdown-enabled", FALSE));
    }

    public boolean isOptimizedSumCastDoubleRuleEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.optimized-sum-cast-double-rule-enabled", TRUE));
    }

    public boolean isQueryFilterReductionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.filter-reduction-enabled", TRUE));
    }

    public boolean isConvertCountDistinctExpressionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.convert-count-distinct-expression-enabled", FALSE));
    }

    public long getQueryMemoryLimitDuringCollect() {
        return Long.parseLong(this.getOptional("kylin.query.memory-limit-during-collect-mb", "5400"));
    }

    public List<String> getCalciteAddRule() {
        String rules = this.getOptional("kylin.query.calcite.add-rule");
        if (StringUtils.isEmpty((CharSequence)rules)) {
            return Lists.newArrayList((Object[])new String[]{"org.apache.kylin.query.optrule.ExtensionOlapJoinRule#INSTANCE"});
        }
        return Lists.newArrayList((Object[])rules.split(","));
    }

    public List<String> getCalciteRemoveRule() {
        String rules = this.getOptional("kylin.query.calcite.remove-rule");
        if (StringUtils.isEmpty((CharSequence)rules)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])rules.split(","));
    }

    public boolean isReplaceColCountWithCountStar() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.replace-count-column-with-count-star", FALSE));
    }

    public int getForceLimit() {
        return Integer.parseInt(this.getOptional("kylin.query.force-limit", "-1"));
    }

    public boolean getEmptyResultForSelectStar() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.return-empty-result-on-select-star", FALSE));
    }

    public long getLargeQueryThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.large-query-threshold", String.valueOf(1000000)));
    }

    public int[] getSparkEngineDriverMemoryStrategy() {
        String[] dft = new String[]{"2", "20", "100"};
        return this.getOptionalIntArray("kylin.engine.driver-memory-strategy", dft);
    }

    public int getLoadCounterCapacity() {
        return Integer.parseInt(this.getOptional("kylin.query.load-counter-capacity", "50"));
    }

    public long getLoadCounterPeriodSeconds() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.load-counter-period-seconds", "3s"), TimeUnit.SECONDS);
    }

    public int getCartesianPartitionNumThresholdFactor() {
        return Integer.parseInt(this.getOptional("kylin.query.cartesian-partition-num-threshold-factor", String.valueOf(100)));
    }

    public String[] getQueryInterceptors() {
        return this.getOptionalStringArray("kylin.query.interceptors", new String[0]);
    }

    public long getQueryDurationCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-duration", String.valueOf(2000)));
    }

    public long getQueryScanCountCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-count", String.valueOf(10240)));
    }

    public long getQueryScanBytesCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-bytes", String.valueOf(0x100000)));
    }

    public boolean isQueryDryRunEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.dryrun-enabled", FALSE));
    }

    public boolean isQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-enabled", TRUE));
    }

    public boolean isSchemaCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.schema-cache-enabled", FALSE));
    }

    public boolean isMppOnTheFlyLayoutsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.mpp-on-the-fly-layouts-enabled", FALSE));
    }

    public String getMppOnTheFlyLayoutsProvider() {
        return this.getOptional("kylin.query.mpp-on-the-fly-layouts-provider", "org.apache.kylin.engine.spark.job.MppOnTheFlyImpl");
    }

    public boolean enableReplaceDynamicParams() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.replace-dynamic-params-enabled", FALSE));
    }

    public String getPercentileApproxAlgorithm() {
        return this.getOptional("kylin.query.percentile-approx-algorithm", "");
    }

    public boolean isCollectUnionInOrder() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.collect-union-in-order", TRUE));
    }

    public int getConcurrentRunningThresholdForGlutenCache() {
        return Integer.parseInt(this.getOptional("kylin.cache.gluten-cache-concurrent-running-threshold", "20"));
    }

    public int getGlutenCacheRequestTimeout() {
        return Math.toIntExact(TimeUtil.timeStringAs(this.getOptional("kylin.cache.gluten-cache-request-timeout", "1d"), TimeUnit.MILLISECONDS));
    }

    public boolean isRedisEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cache.redis.enabled", FALSE));
    }

    public boolean isRedisClusterEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cache.redis.cluster-enabled", FALSE));
    }

    public boolean isRedisSentinelEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cache.redis.sentinel-enabled", FALSE));
    }

    public String getRedisSentinelMasterId() {
        return this.getOptional("kylin.cache.redis.sentinel-master", null);
    }

    public String getRedisHosts() {
        return this.getOptional("kylin.cache.redis.hosts", "localhost:6379");
    }

    public String getRedisPassword() {
        return this.getOptional("kylin.cache.redis.password", "");
    }

    public String getRedisExpireTimeUnit() {
        String expireTimeUnit = this.getOptional("kylin.cache.redis.expire-time-unit", "EX");
        if (!expireTimeUnit.equals("EX") && !expireTimeUnit.equals("PX")) {
            expireTimeUnit = "EX";
        }
        return expireTimeUnit;
    }

    public long getRedisExpireTime() {
        return Long.parseLong(this.getOptional("kylin.cache.redis.expire-time", "86400"));
    }

    public long getRedisExpireTimeForException() {
        return Long.parseLong(this.getOptional("kylin.cache.redis.exception-expire-time", "600"));
    }

    public int getRedisConnectionTimeout() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.connection-timeout", "2000"));
    }

    public int getRedisSoTimeout() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.so-timeout", "2000"));
    }

    public int getRedisMaxAttempts() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.max-attempts", "20"));
    }

    public int getRedisMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.max-total", "8"));
    }

    public int getRedisMaxIdle() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.max-idle", "8"));
    }

    public int getRedisMinIdle() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.min-idle", "0"));
    }

    public int getRedisScanKeysBatchCount() {
        return Integer.parseInt(this.getOptional("kylin.cache.redis.batch-count", ONE_HUNDRED_THOUSAND));
    }

    public boolean isMemcachedEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cache.memcached.enabled", FALSE));
    }

    public String getMemcachedHosts() {
        return this.getOptional("kylin.cache.memcached.hosts", "localhost:11211");
    }

    public long getMemcachedOpTimeout() {
        return Long.parseLong(this.getOptional("kylin.cache.memcached.option.timeout", "500"));
    }

    public int getMaxChunkSize() {
        return Integer.parseInt(this.getOptional("kylin.cache.memcached.max-chunk-size", "1024"));
    }

    public int getMaxObjectSize() {
        return Integer.parseInt(this.getOptional("kylin.cache.memcached.max-object-size", "1048576"));
    }

    public boolean isEnableCompression() {
        return Boolean.parseBoolean(this.getOptional("kylin.cache.memcached.is-enable-compression", TRUE));
    }

    public long getMaxWaitMillis() {
        return Long.parseLong(this.getOptional("kylin.cache.redis.max-wait", "300000"));
    }

    public String getEhCacheConfigPath() {
        return this.getOptional("kylin.cache.config", "classpath:ehcache.xml");
    }

    public boolean isQueryIgnoreUnknownFunction() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.ignore-unknown-function", FALSE));
    }

    public boolean isQueryMatchPartialInnerJoinModel() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.match-partial-inner-join-model", FALSE));
    }

    public boolean isQueryNonEquiJoinModelEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.non-equi-join-model-enabled", FALSE));
    }

    public boolean isNonEquiJoinRecommendationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.non-equi-join-recommendation-enabled", FALSE));
    }

    public String getQueryAccessController() {
        return this.getOptional("kylin.query.access-controller", null);
    }

    public int getDimCountDistinctMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.query.max-dimension-count-distinct", "5000000"));
    }

    public boolean getAutoModelViewEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.auto-model-view-enabled", FALSE));
    }

    public String getColOrderForSelectStarInModelView() {
        String colOrder;
        switch (colOrder = this.getOptional("kylin.query.select-star-col-order-in-model-view", DEFAULT).toLowerCase(Locale.ROOT)) {
            case "1": 
            case "order-by-model": {
                return "orderByModel";
            }
            case "2": 
            case "order-by-table": {
                return "orderByTable";
            }
        }
        return DEFAULT;
    }

    public Map<String, String> getUDFs() {
        LinkedHashMap udfMap = Maps.newLinkedHashMap();
        udfMap.put("bitmap_function", "org.apache.kylin.query.udf.KylinBitmapUDF");
        udfMap.put("kylin_udf_function", "org.apache.kylin.query.udf.KylinOtherUDF");
        udfMap.put("spark_leaf_function", "org.apache.kylin.query.udf.SparkLeafUDF");
        udfMap.put("spark_string_function", "org.apache.kylin.query.udf.SparkStringUDF");
        udfMap.put("spark_misc_function", "org.apache.kylin.query.udf.SparkMiscUDF");
        udfMap.put("spark_time_function", "org.apache.kylin.query.udf.SparkTimeUDF");
        udfMap.put("spark_math_function", "org.apache.kylin.query.udf.SparkMathUDF");
        udfMap.put("spark_other_function", "org.apache.kylin.query.udf.SparkCollectionUDF");
        Map<String, String> overrideUdfMap = this.getPropertiesByPrefix("kylin.query.udf.");
        udfMap.putAll(overrideUdfMap);
        return udfMap;
    }

    public int getSlowQueryDefaultDetectIntervalSeconds() {
        int intervalSec = Integer.parseInt(this.getOptional("kylin.query.slowquery-detect-interval", "3"));
        if (intervalSec < 1) {
            logger.warn("Slow query detect interval less than 1 sec, set to 1 sec.");
            intervalSec = 1;
        }
        return intervalSec;
    }

    public int getQueryTimeoutSeconds() {
        int time = Integer.parseInt(this.getOptional("kylin.query.timeout-seconds", "300"));
        if (time < 5) {
            logger.warn("Query timeout seconds less than 5 sec, set to 5 sec.");
            time = 5;
        }
        return time;
    }

    public String getQueryVIPRole() {
        return String.valueOf(this.getOptional("kylin.query.vip-role", ""));
    }

    public boolean isPushDownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown-enabled", TRUE));
    }

    public String getPushDownRunnerClassName() {
        return this.getOptional("kylin.query.pushdown.runner-class-name", "");
    }

    public String getPushDownRunnerClassNameWithDefaultValue() {
        String pushdownRunner = this.getPushDownRunnerClassName();
        if (StringUtils.isEmpty((CharSequence)pushdownRunner)) {
            pushdownRunner = "org.apache.kylin.query.pushdown.PushDownRunnerSparkImpl";
        }
        return pushdownRunner;
    }

    public String[] getTableDetectorTransformers() {
        String[] stringArray;
        String value = this.getOptional("kylin.query.table-detect-transformers");
        if (value == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = POWER_BI_CONVERTER;
            stringArray2[1] = "org.apache.kylin.query.util.DefaultQueryTransformer";
            stringArray = stringArray2;
            stringArray2[2] = "org.apache.kylin.query.util.EscapeTransformer";
        } else {
            stringArray = this.getOptionalStringArray("kylin.query.table-detect-transformers", new String[0]);
        }
        return stringArray;
    }

    public String[] getQueryTransformers() {
        String[] stringArray;
        String value = this.getOptional("kylin.query.transformers");
        if (value == null) {
            String[] stringArray2 = new String[6];
            stringArray2[0] = POWER_BI_CONVERTER;
            stringArray2[1] = "org.apache.kylin.query.util.DefaultQueryTransformer";
            stringArray2[2] = "org.apache.kylin.query.util.EscapeTransformer";
            stringArray2[3] = "org.apache.kylin.query.util.ConvertToComputedColumn";
            stringArray2[4] = "org.apache.kylin.query.util.KeywordDefaultDirtyHack";
            stringArray = stringArray2;
            stringArray2[5] = "org.apache.kylin.query.security.RowFilter";
        } else {
            stringArray = this.getOptionalStringArray("kylin.query.transformers", new String[0]);
        }
        return stringArray;
    }

    public String getPartitionCheckRunnerClassName() {
        return this.getOptional("kylin.query.pushdown.partition-check.runner-class-name", "");
    }

    public String getDefaultPartitionCheckerClassName() {
        String partitionCheckRunner = this.getPartitionCheckRunnerClassName();
        if (StringUtils.isEmpty((CharSequence)partitionCheckRunner)) {
            partitionCheckRunner = "org.apache.kylin.query.pushdown.PushDownRunnerSparkImpl";
        }
        return partitionCheckRunner;
    }

    public boolean isPushdownQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.cache-enabled", FALSE));
    }

    public boolean isAutoSetPushDownPartitions() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.auto-set-shuffle-partitions-enabled", TRUE));
    }

    public int autoSetPushDownPartitionsForced() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.auto-set-shuffle-partitions-forced", "0"));
    }

    public int getBaseShufflePartitionSize() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.base-shuffle-partition-size", "48"));
    }

    public String getHiveMetastoreExtraClassPath() {
        return this.getOptional("kylin.query.pushdown.hive-extra-class-path", "");
    }

    public String getJdbcUrl() {
        return this.getOptional("kylin.query.pushdown.jdbc.url", "");
    }

    public String getJdbcDriverClass() {
        return this.getOptional("kylin.query.pushdown.jdbc.driver", "");
    }

    public String getJdbcUsername() {
        return this.getOptional("kylin.query.pushdown.jdbc.username", "");
    }

    public String getJdbcPassword() {
        return this.getOptional("kylin.query.pushdown.jdbc.password", "");
    }

    public int getPoolMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-total", "8"));
    }

    public int getPoolMaxIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-idle", "8"));
    }

    public int getPoolMinIdle() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-min-idle", "0"));
    }

    public boolean isAclTCREnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security.acl-tcr-enabled", TRUE));
    }

    public boolean inferFiltersEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.infer-filters-enabled", FALSE));
    }

    public boolean isEscapeDefaultKeywordEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.escape-default-keyword", FALSE));
    }

    public String getQueryRealizationFilter() {
        return this.getOptional("kylin.query.realization-filter", null);
    }

    public int getQueryRealizationChooserThreadMaxNum() {
        return Integer.parseInt(this.getOptional("kylin.query.realization.chooser.thread-max-num", "50"));
    }

    public int getQueryRealizationChooserThreadCoreNum() {
        return Integer.parseInt(this.getOptional("kylin.query.realization.chooser.thread-core-num", "5"));
    }

    public boolean isRealizationChooserUsingMultiThread() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.realization-chooser-using-multi-threads", TRUE));
    }

    public Map<String, String> getCalciteExtrasProperties() {
        return this.getPropertiesByPrefix("kylin.query.calcite.extras-props.");
    }

    public String getCalciteConformance() {
        return this.getOptional("kylin.query.calcite.extras-props.conformance", DEFAULT);
    }

    public boolean isExecuteAsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.query-with-execute-as", FALSE));
    }

    public boolean isJoinMatchOptimizationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.join-match-optimization-enabled", FALSE));
    }

    private boolean isMicroService() {
        return Boolean.parseBoolean(this.getOptional("kylin.micro.service", FALSE));
    }

    public String getServerMode() {
        return this.getOptional("kylin.server.mode", "all");
    }

    public String getMicroServiceMode() {
        ClusterConstant.ServerModeEnum[] allModes;
        if (!this.isMicroService()) {
            return null;
        }
        String serverName = this.getApplicationConfig(SERVER_NAME_STRING);
        for (ClusterConstant.ServerModeEnum mode : allModes = ClusterConstant.ServerModeEnum.values()) {
            if (!mode.getName().equals(serverName)) continue;
            return mode.getName();
        }
        return null;
    }

    public String getApplicationConfig(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            return value;
        }
        try {
            String[] keys = key.split("\\.");
            URL ymlFile = ClassLoaderUtils.getOriginClassLoader().getResource("application.yaml");
            if (ymlFile == null) {
                return null;
            }
            Iterable applicationConfigs = new Yaml().loadAll(ymlFile.openStream());
            for (Object config : applicationConfigs) {
                Map tmpConf = (Map)config;
                for (int index = 0; index < keys.length - 1 && (tmpConf = (Map)tmpConf.get(keys[index])) != null; ++index) {
                }
                if (tmpConf == null || (value = (String)tmpConf.get(keys[keys.length - 1])) == null) continue;
                this.properties.setProperty(key, value);
                break;
            }
        }
        catch (IOException e) {
            logger.error("Parse application.yaml failed.", (Throwable)e);
        }
        return value;
    }

    public String getMetadataStoreType() {
        if (!this.isJobNode()) {
            return this.getOptional("kylin.server.store-type", "jdbc");
        }
        return "jdbc";
    }

    public boolean isJobNode() {
        return !StringUtils.equals((CharSequence)ClusterConstant.ServerModeEnum.QUERY.getName(), (CharSequence)this.getServerMode()) && this.getMicroServiceMode() == null;
    }

    public boolean isQueryNode() {
        return !StringUtils.equals((CharSequence)ClusterConstant.ServerModeEnum.JOB.getName(), (CharSequence)this.getServerMode()) && this.getMicroServiceMode() == null || ClusterConstant.QUERY.equals(this.getMicroServiceMode());
    }

    public boolean isJobNodeOnly() {
        return StringUtils.equals((CharSequence)ClusterConstant.ServerModeEnum.JOB.getName(), (CharSequence)this.getServerMode()) && this.getMicroServiceMode() == null;
    }

    public boolean isQueryNodeOnly() {
        return StringUtils.equals((CharSequence)ClusterConstant.ServerModeEnum.QUERY.getName(), (CharSequence)this.getServerMode()) && this.getMicroServiceMode() == null || ClusterConstant.QUERY.equals(this.getMicroServiceMode());
    }

    public boolean isSmartNode() {
        return ClusterConstant.SMART.equals(this.getMicroServiceMode());
    }

    public boolean isOpsNode() {
        return ClusterConstant.OPS.equals(this.getMicroServiceMode());
    }

    public boolean isDataLoadingNode() {
        return ClusterConstant.DATA_LOADING.equals(this.getMicroServiceMode());
    }

    public boolean isMetadataNode() {
        return ClusterConstant.COMMON.equals(this.getMicroServiceMode());
    }

    public boolean isResource() {
        return ClusterConstant.RESOURCE.equals(this.getMicroServiceMode());
    }

    public boolean isAllNode() {
        return ClusterConstant.ALL.equals(this.getServerMode()) && this.getMicroServiceMode() == null;
    }

    public boolean isCommonOnlyMode() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.common-only", FALSE));
    }

    public String[] getAllModeServers() {
        return this.getSystemStringArray("kylin.server.cluster-mode-all", new String[0]);
    }

    public String[] getQueryModeServers() {
        return this.getSystemStringArray("kylin.server.cluster-mode-query", new String[0]);
    }

    public String[] getJobModeServers() {
        return this.getSystemStringArray("kylin.server.cluster-mode-job", new String[0]);
    }

    public List<String> getAllServers() {
        ArrayList allServers = Lists.newArrayList();
        allServers.addAll(Arrays.asList(this.getAllModeServers()));
        allServers.addAll(Arrays.asList(this.getQueryModeServers()));
        allServers.addAll(Arrays.asList(this.getJobModeServers()));
        return allServers;
    }

    public boolean getStreamingChangeMeta() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.streaming-change-meta", FALSE));
    }

    public String[] getPushDownConverterClassNames() {
        return this.getOptionalStringArray("kylin.query.pushdown.converter-class-names", new String[]{"org.apache.kylin.source.adhocquery.DoubleQuotePushDownConverter", POWER_BI_CONVERTER, "org.apache.kylin.query.util.KeywordDefaultDirtyHack", "org.apache.kylin.query.util.RestoreFromComputedColumn", "org.apache.kylin.query.security.RowFilter", "org.apache.kylin.query.security.HackSelectStarWithColumnACL", "org.apache.kylin.query.util.SchemaConverter", "org.apache.kylin.query.util.SparkSQLFunctionConverter"});
    }

    public String getQueryIndexMatchRules() {
        return this.getOptional("kylin.query.index-match-rules", "");
    }

    public boolean useTableIndexAnswerSelectStarEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.use-tableindex-answer-select-star.enabled", FALSE));
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider", "StaticUserGroupService", "StaticUserService"})})
    public int getServerUserCacheExpireSeconds() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.expire-seconds", "300"));
    }

    public String getExternalAclProvider() {
        return this.getOptional("kylin.server.external-acl-provider", "");
    }

    public String getLDAPUserSearchBase() {
        return this.getOptional("kylin.security.ldap.user-search-base", "");
    }

    public String getLDAPGroupSearchBase() {
        return this.getOptional("kylin.security.ldap.user-group-search-base", "");
    }

    public String getLDAPAdminRole() {
        return this.getOptional("kylin.security.acl.admin-role", "");
    }

    public int getRowFilterLimit() {
        return Integer.parseInt(this.getOptional("kylin.security.acl.row-filter-limit-threshold", "100"));
    }

    public String getSuperAdminUsername() {
        return this.getOptional("kylin.security.acl.super-admin-username", "admin");
    }

    public boolean isDataPermissionDefaultEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.security.acl.data-permission-default-enabled", TRUE));
    }

    public String getTimeZone() {
        String timeZone = this.getOptional("kylin.web.timezone", "");
        if (StringUtils.isEmpty((CharSequence)timeZone)) {
            return TimeZone.getDefault().getID();
        }
        return timeZone;
    }

    public boolean isAllowNonAsciiCharInUrl() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.allow-non-ascii-char-in-url", FALSE));
    }

    public int getRestClientDefaultMaxPerRoute() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.default-max-per-route", "20"));
    }

    public int getRestClientMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.max-total", "200"));
    }

    public int getFavoriteQueryAccelerateThreshold() {
        return Integer.parseInt(this.getOptional("kylin.favorite.query-accelerate-threshold", "20"));
    }

    public boolean getFavoriteQueryAccelerateTipsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.favorite.query-accelerate-tips-enable", TRUE));
    }

    public int getAutoMarkFavoriteInterval() {
        return Integer.parseInt(this.getOptional("kylin.favorite.auto-mark-detection-interval-minutes", "60")) * 60;
    }

    public int getFavoriteStatisticsCollectionInterval() {
        return Integer.parseInt(this.getOptional("kylin.favorite.statistics-collection-interval-minutes", "60")) * 60;
    }

    public int getFavoriteAccelerateBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.favorite.batch-accelerate-size", "500"));
    }

    public int getFavoriteImportSqlMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.favorite.import-sql-max-size", "1000"));
    }

    public long getQueryHistoryScanPeriod() {
        return Long.parseLong(this.getOptional("kylin.favorite.query-history-scan-period-minutes", "60")) * 60L * 1000L;
    }

    public long getQueryHistoryMaxScanInterval() {
        return (long)(Integer.parseInt(this.getOptional("kylin.favorite.query-history-max-scan-interval", "1")) * 30 * 24 * 60 * 60) * 1000L;
    }

    public int getAutoCheckAccStatusBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.favorite.auto-check-accelerate-batch-size", "100"));
    }

    public String getCodahaleMetricsReportClassesNames() {
        return this.getOptional("kylin.metrics.reporter-classes", "JsonFileMetricsReporter,JmxMetricsReporter");
    }

    public String getMetricsFileLocation() {
        return this.getOptional("kylin.metrics.file-location", "/tmp/report.json");
    }

    public Long getMetricsReporterFrequency() {
        return Long.parseLong(this.getOptional("kylin.metrics.file-frequency", "5000"));
    }

    public String getHdfsWorkingDirectory(String project) {
        if (project != null) {
            return new Path(this.getHdfsWorkingDirectory(), project).toString() + PATH_DELIMITER;
        }
        return this.getHdfsWorkingDirectory();
    }

    public String getWorkingDirectoryWithConfiguredFs(String project) {
        String engineWriteFs = this.getEngineWriteFs();
        if (StringUtils.isEmpty((CharSequence)engineWriteFs)) {
            return this.getHdfsWorkingDirectory(project);
        }
        engineWriteFs = new Path(engineWriteFs, this.getHdfsWorkingDirectoryWithoutScheme()).toString();
        if (project != null) {
            engineWriteFs = new Path(engineWriteFs, project).toString() + PATH_DELIMITER;
        }
        return engineWriteFs;
    }

    private String getReadHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty((CharSequence)this.getParquetReadFileSystem())) {
            Path workingDir = new Path(this.getHdfsWorkingDirectory());
            return new Path(this.getParquetReadFileSystem(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + PATH_DELIMITER;
        }
        return this.getHdfsWorkingDirectory();
    }

    public String getReadHdfsWorkingDirectory(String project) {
        if (StringUtils.isNotEmpty((CharSequence)this.getParquetReadFileSystem())) {
            Path workingDir = new Path(this.getHdfsWorkingDirectory(project));
            return new Path(this.getParquetReadFileSystem(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + PATH_DELIMITER;
        }
        return this.getHdfsWorkingDirectory(project);
    }

    public String getJdbcHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty((CharSequence)this.getJdbcFileSystem())) {
            Path workingDir = new Path(this.getReadHdfsWorkingDirectory());
            return new Path(this.getJdbcFileSystem(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + PATH_DELIMITER;
        }
        return this.getReadHdfsWorkingDirectory();
    }

    public String getBuildConf() {
        return this.getOptional("kylin.engine.submit-hadoop-conf-dir", "");
    }

    public String getParquetReadFileSystem() {
        return this.getOptional("kylin.storage.columnar.file-system", "");
    }

    public String getJdbcFileSystem() {
        return this.getOptional("kylin.storage.columnar.jdbc-file-system", "");
    }

    public String getPropertiesWhiteList() {
        return this.getOptional("kylin.web.properties.whitelist", "kylin.web.timezone,kylin.env,kylin.security.profile,kylin.source.default,metadata.semi-automatic-mode,kylin.cube.aggrgroup.is-base-cuboid-always-valid,kylin.htrace.show-gui-trace-toggle,kylin.web.export-allow-admin,kylin.web.export-allow-other");
    }

    public Boolean isCalciteInClauseEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite-in-clause-enabled", TRUE));
    }

    public int convertInSubQueryThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.convert-in-to-or-threshold", "20"));
    }

    public boolean isEnumerableRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.enumerable-rules-enabled", FALSE));
    }

    public boolean isReduceExpressionsRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.reduce-rules-enabled", TRUE));
    }

    public boolean isAggregatePushdownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.aggregate-pushdown-enabled", TRUE));
    }

    public boolean isScalarSubqueryJoinEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.scalar-subquery-join-enabled", FALSE));
    }

    public int getCalciteBindableCacheSize() {
        return Integer.parseInt(this.getOptional("kylin.query.calcite.bindable.cache.maxSize", "10"));
    }

    public int getCalciteBindableCacheConcurrencyLevel() {
        return Integer.parseInt(this.getOptional("kylin.query.calcite.bindable.cache.concurrencyLevel", "5"));
    }

    public boolean isCalciteCompatibleWithMsSqlPlusEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.compatible-with-mssql-plus-enabled", FALSE));
    }

    public int getEventPollIntervalSecond() {
        return Integer.parseInt(this.getOptional("kylin.job.event.poll-interval-second", "60"));
    }

    public int getIndexOptimizationLevel() {
        return Integer.parseInt(this.getOptional("kylin.index.optimization-level", "2"));
    }

    public double getLayoutSimilarityThreshold() {
        return this.safeParseDouble(this.getOptional("kylin.index.similarity-ratio-threshold"), 0.9);
    }

    public long getSimilarityStrategyRejectThreshold() {
        return this.safeParseLong(this.getOptional("kylin.index.beyond-similarity-bias-threshold"), 100000000L);
    }

    public boolean isIncludedStrategyConsiderTableIndex() {
        return Boolean.parseBoolean(this.getOptional("kylin.index.include-strategy.consider-table-index", TRUE));
    }

    public boolean isLowFreqStrategyConsiderTableIndex() {
        return Boolean.parseBoolean(this.getOptional("kylin.index.frequency-strategy.consider-table-index", TRUE));
    }

    public long getExecutableSurvivalTimeThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.garbage.storage.executable-survival-time-threshold", "30d"), TimeUnit.MILLISECONDS);
    }

    public long getSourceUsageSurvivalTimeThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.garbage.storage.sourceusage-survival-time-threshold", "90d"), TimeUnit.MILLISECONDS);
    }

    public long getStorageQuotaSize() {
        return Double.valueOf(Double.parseDouble(this.getOptional("kylin.storage.quota-in-giga-bytes", "10240")) * 1024.0 * 1024.0 * 1024.0).longValue();
    }

    public long getStorageCleanTaskTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.storage.clean-timeout", "4h"), TimeUnit.MILLISECONDS);
    }

    public int getStorageCleanTaskConcurrency() {
        return Integer.parseInt(this.getOptional("kylin.storage.clean-tasks-concurrency", "5"));
    }

    public long getSourceUsageQuota() {
        Double d = Double.parseDouble(this.getOptional("kylin.storage.source-quota-in-giga-bytes", "-1"));
        return d >= 0.0 ? Double.valueOf(d * 1024.0 * 1024.0 * 1024.0).longValue() : -1L;
    }

    public long getCuboidLayoutSurvivalTimeThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.garbage.storage.cuboid-layout-survival-time-threshold", "7d"), TimeUnit.MILLISECONDS);
    }

    public boolean getJobDataLoadEmptyNotificationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-on-empty-data-load", FALSE));
    }

    public boolean getJobErrorNotificationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-on-job-error", FALSE));
    }

    public Long getStorageResourceSurvivalTimeThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.storage.resource-survival-time-threshold", "7d"), TimeUnit.MILLISECONDS);
    }

    public int getMetadataBackupCountThreshold() {
        return Integer.parseInt(this.getOptional("kylin.metadata.backup-count-threshold", "7"));
    }

    public boolean getMetadataBackupFromSystem() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.backup-from-sys", TRUE));
    }

    public int getSchedulerLimitPerMinute() {
        return Integer.parseInt(this.getOptional("kylin.scheduler.schedule-limit-per-minute", "10"));
    }

    public Integer getSchedulerJobTimeOutMinute() {
        return Integer.parseInt(this.getOptional("kylin.scheduler.schedule-job-timeout-minute", "0"));
    }

    public Long getRateLimitPermitsPerMinute() {
        return Long.parseLong(this.getOptional("kylin.ratelimit.permits-per-minutes", "10"));
    }

    public boolean getSmartModeBrokenModelDeleteEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.broken-model-deleted-on-smart-mode", FALSE));
    }

    public boolean isNeedCollectLookupTableInfo() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.need-collect-lookup-table-info", TRUE));
    }

    public long getCountLookupTableMaxTime() {
        return Long.parseLong(this.getOptional("kylin.engine.count.lookup-table-max-time", "600000"));
    }

    public long getLookupTableCountDefaultValue() {
        return Long.parseLong(this.getOptional("kylin.engine.lookup-table-default-count-value", "1000000000"));
    }

    public int getPersistFlatTableThreshold() {
        return Integer.parseInt(this.getOptional("kylin.engine.persist-flattable-threshold", "1"));
    }

    public boolean isPersistFlatTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.persist-flattable-enabled", TRUE));
    }

    public boolean isFlatTableRedistributionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.redistribution-flattable-enabled", FALSE));
    }

    public boolean isPersistFlatViewEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.persist-flatview", FALSE));
    }

    public boolean isPersistFlatUseSnapshotEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.persist-flat-use-snapshot-enabled", TRUE));
    }

    public boolean isBuildExcludedTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.build-excluded-table", FALSE));
    }

    public boolean isBuildCheckPartitionColEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.check-partition-col-enabled", TRUE));
    }

    public boolean isShardingJoinOptEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.expose-sharding-trait", TRUE));
    }

    public int getQueryPartitionSplitSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.storage.columnar.partition-split-size-mb", "64"));
    }

    public String getStorageProvider() {
        return this.getOptional("kylin.storage.provider", "org.apache.kylin.common.storage.DefaultStorageProvider");
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public int getServerUserCacheMaxEntries() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.max-entries", "100"));
    }

    public String getStreamingBaseJobsLocation() {
        return this.getOptional("kylin.engine.streaming-jobs-location", this.getHdfsWorkingDirectory() + "/streaming/jobs");
    }

    public boolean getStreamingMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.streaming-metrics-enabled", FALSE));
    }

    public long getStreamingSegmentMergeInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.engine.streaming-segment-merge-interval", "60s"), TimeUnit.SECONDS);
    }

    public long getStreamingSegmentCleanInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.engine.streaming-segment-clean-interval", "2h"), TimeUnit.HOURS);
    }

    public double getStreamingSegmentMergeRatio() {
        return Double.parseDouble(this.getOptional("kylin.engine.streaming-segment-merge-ratio", "1.5"));
    }

    public long getStreamingJobStatsSurvivalThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.streaming.jobstats.survival-time-threshold", "7d"), TimeUnit.DAYS);
    }

    public boolean getTriggerOnce() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.streaming-trigger-once", FALSE));
    }

    public String getLogSparkDriverPropertiesFile() {
        return this.getLogPropertyFile("spark-driver-log4j.xml");
    }

    public String getLogSparkExecutorPropertiesFile() {
        return this.getLogPropertyFile("spark-executor-log4j.xml");
    }

    public String getLogSparkStreamingDriverPropertiesFile() {
        return this.getLogPropertyFile("spark-streaming-driver-log4j.xml");
    }

    public String getLogSparkStreamingExecutorPropertiesFile() {
        return this.getLogPropertyFile("spark-streaming-executor-log4j.xml");
    }

    public String getLogSparkAppMasterPropertiesFile() {
        return this.getLogPropertyFile("spark-appmaster-log4j.xml");
    }

    public String getAsyncProfilerFiles() throws IOException {
        String kylinHome = KylinConfigBase.getKylinHomeWithoutWarn();
        File libX64 = new File(kylinHome + "/lib/" + "libasyncProfiler-linux-x64.so");
        File libArm64 = new File(kylinHome + "/lib/" + "libasyncProfiler-linux-arm64.so");
        return libX64.getCanonicalPath() + "," + libArm64.getCanonicalPath();
    }

    private String getLogPropertyFile(String filename) {
        String parentFolder = this.isDevEnv() ? Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "build", "conf").toString() : (Files.exists(Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "conf", filename), new LinkOption[0]) ? Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "conf").toString() : Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "server", "conf").toString());
        return parentFolder + File.separator + filename;
    }

    public long getLoadHiveTablenameIntervals() {
        return Long.parseLong(this.getOptional("kylin.source.load-hive-tablename-interval-seconds", "3600"));
    }

    public boolean getLoadHiveTablenameEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.load-hive-tablename-enabled", TRUE));
    }

    public boolean getKerberosProjectLevelEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.kerberos.project-level-enabled", FALSE));
    }

    public boolean getTableAccessFilterEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.table-access-filter-enabled", FALSE));
    }

    public boolean getTableAccessCacheEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.table-access-cache-enabled", TRUE));
    }

    public long getTableAccessCacheSize() {
        return Long.parseLong(this.getOptional("kylin.source.hive.table-access-cache-size", ONE_HUNDRED_THOUSAND));
    }

    public long getTableAccessCacheTTL() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.source.hive.table-access-cache-ttl", "7d"), TimeUnit.MINUTES);
    }

    public String[] getHiveDatabases() {
        return this.getOptionalStringArray("kylin.source.hive.databases", new String[0]);
    }

    private double safeParseDouble(String value, double defaultValue) {
        double result = defaultValue;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return result;
        }
        try {
            result = Double.parseDouble(value.trim());
        }
        catch (Exception e) {
            logger.error("Detect a malformed double value, set to a default value {}", (Object)defaultValue);
        }
        return result;
    }

    private long safeParseLong(String value, long defaultValue) {
        long result = defaultValue;
        if (StringUtils.isEmpty((CharSequence)value)) {
            return result;
        }
        try {
            result = Long.parseLong(value.trim());
        }
        catch (Exception e) {
            logger.error("Detect a malformed long value, set to a default value {}", (Object)defaultValue);
        }
        return result;
    }

    public boolean isSmartModelEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.smart-mode-enabled", FALSE));
    }

    public Integer getProposingThreadNum() {
        return Integer.parseInt(this.getOptional("kylin.env.smart-thread-num", "10"));
    }

    public boolean getSkipCorrReduceRule() {
        return Boolean.parseBoolean(this.getOptional("kylin.smart.conf.skip-corr-reduce-rule", FALSE));
    }

    public int getOptimizeTransformerMaxIterations() {
        return Integer.parseInt(this.getOptional("kylin.smart.conf.optimize-transformer-max-iterations", "2"));
    }

    public int getOptimizeTransformerConditionCountThreshold() {
        return Integer.parseInt(this.getOptional("kylin.smart.conf.optimize-transformer-condition-count-threshold", "200"));
    }

    public String getEngineWriteFs() {
        String engineWriteFs = this.getOptional("kylin.env.engine-write-fs", "");
        return StringHelper.dropSuffix(engineWriteFs, File.separator);
    }

    public boolean isAllowedProjectAdminGrantAcl() {
        String option = this.getOptional("kylin.security.allow-project-admin-grant-acl", TRUE);
        return !FALSE.equals(option);
    }

    public boolean isAllowedNonAdminGenerateQueryDiagPackage() {
        return Boolean.parseBoolean(this.getOptional("kylin.security.allow-non-admin-generate-query-diag-package", TRUE));
    }

    public String getStreamingBaseCheckpointLocation() {
        return this.getOptional("kylin.engine.streaming-checkpoint-location", this.getHdfsWorkingDirectory() + "/streaming/checkpoint");
    }

    public boolean isTrackingUrlIpAddressEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.tracking-url-ip-address-enabled", TRUE));
    }

    public long getDiscoveryClientTimeoutThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.server.discovery-client-timeout-threshold", "3s"), TimeUnit.SECONDS);
    }

    public boolean isUploadGCLogToWorkingDirEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.task.upload-gc-log-enabled", FALSE));
    }

    public long getGCLogUploadTaskPeriod() {
        return Long.parseLong(this.getOptional("kylin.task.gc-log-upload-interval-minutes", "10"));
    }

    public boolean isUploadJstackDumpToWorkingDirEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.task.upload-jstack-dump-enabled", FALSE));
    }

    public boolean getJStackDumpTaskEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.task.jstack-dump-enabled", TRUE));
    }

    public long getJStackDumpTaskPeriod() {
        return Long.parseLong(this.getOptional("kylin.task.jstack-dump-interval-minutes", "10"));
    }

    public long getJStackDumpTaskLogsMaxNum() {
        return Math.max(1L, Long.parseLong(this.getOptional("kylin.task.jstack-dump-log-files-max-count", "20")));
    }

    public StorageURL getStreamingStatsUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional(KYLIN_STREAMING_STATS_URL))) {
            return this.getMetadataUrl();
        }
        return StorageURL.valueOf(this.getOptional(KYLIN_STREAMING_STATS_URL));
    }

    public void setStreamingStatsUrl(String streamingStatsUrl) {
        this.setProperty(KYLIN_STREAMING_STATS_URL, streamingStatsUrl);
    }

    public StorageURL getQueryHistoryUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional(KYLIN_QUERY_HISTORY_URL))) {
            return this.getMetadataUrl();
        }
        return StorageURL.valueOf(this.getOptional(KYLIN_QUERY_HISTORY_URL));
    }

    public void setQueryHistoryUrl(String queryHistoryUrl) {
        this.setProperty(KYLIN_QUERY_HISTORY_URL, queryHistoryUrl);
    }

    public StorageURL getJDBCQueryHistoryURL() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional(KYLIN_QUERY_HISTORY_JDBC_URL))) {
            return this.getQueryHistoryUrl();
        }
        return StorageURL.valueOf(this.getOptional(KYLIN_QUERY_HISTORY_JDBC_URL));
    }

    public void setJDBCQueryHistoryURL(String url) {
        this.setProperty(KYLIN_QUERY_HISTORY_JDBC_URL, url);
    }

    public int getQueryHistoryMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.queryhistory.max-size", "10000000"));
    }

    public int getQueryHistoryProjectMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.queryhistory.project-max-size", "1000000"));
    }

    public int getQueryHistorySingleDeletionSize() {
        return Integer.parseInt(this.getOptional("kylin.query.queryhistory.single-deletion-size", "2000"));
    }

    public long getQueryHistorySurvivalThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.queryhistory.survival-time-threshold", "30d"), TimeUnit.MILLISECONDS);
    }

    public int getQueryHistoryBufferSize() {
        return Integer.parseInt(this.getOptional("kylin.query.queryhistory.buffer-size", "500"));
    }

    public long getQueryHistorySchedulerInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.queryhistory.scheduler-interval", "3s"), TimeUnit.SECONDS);
    }

    public int getQueryHistoryAccelerateBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.favorite.query-history-accelerate-batch-size", "1000"));
    }

    public int getQueryHistoryStatMetaUpdateBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.query.query-history-stat-batch-size", "1000"));
    }

    public int getQueryHistoryAccelerateMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.favorite.query-history-accelerate-max-size", ONE_HUNDRED_THOUSAND));
    }

    public int getQueryHistoryStatMetaUpdateMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.query-history-stat-update-max-size", ONE_HUNDRED_THOUSAND));
    }

    public long getQueryHistoryAccelerateInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.favorite.query-history-accelerate-interval", "60m"), TimeUnit.MINUTES);
    }

    public long getQueryHistoryStatMetaUpdateInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.query-history-stat-interval", "30m"), TimeUnit.MINUTES);
    }

    public int getQueryHistoryDownloadMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.query.query-history-download-max-size", ONE_HUNDRED_THOUSAND));
    }

    public int getQueryHistoryDownloadBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.query.query-history-download-batch-size", "20000"));
    }

    public long getQueryHistoryDownloadTimeoutSeconds() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.query-history-download-timeout-seconds", "300s"), TimeUnit.SECONDS);
    }

    public long getAsyncQueryResultRetainDays() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.async.result-retain-days", "7d"), TimeUnit.DAYS);
    }

    public boolean isUniqueAsyncQueryYarnQueue() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.unique-async-query-yarn-queue-enabled", FALSE));
    }

    public String getAsyncQuerySparkYarnQueue() {
        return this.getOptional("kylin.query.async-query.spark-conf.spark.yarn.queue", DEFAULT);
    }

    public String getAsyncQueryHadoopConfDir() {
        return this.getOptional("kylin.query.async-query.submit-hadoop-conf-dir", "");
    }

    public String getExternalCatalogClass() {
        return this.getOptional("kylin.use.external.catalog", "");
    }

    public String getExternalSharedStateClass() {
        return this.getOptional("kylin.use.external.sharedState", "org.apache.spark.sql.kylin.external.KylinSharedState");
    }

    public String getExternalSessionStateBuilderClass() {
        return this.getOptional("kylin.use.external.sessionStateBuilder", "org.apache.spark.sql.kylin.external.KylinSessionStateBuilder");
    }

    public boolean isSparderAsync() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.init-sparder-async", TRUE));
    }

    public boolean getRandomAdminPasswordEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.random-admin-password.enabled", TRUE));
    }

    public long getCatchUpInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.metadata.audit-log.catchup-interval", "5s"), TimeUnit.SECONDS);
    }

    public long getUpdateJobInfoTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.job.update-job-info-timeout", "30s"), TimeUnit.MILLISECONDS);
    }

    public long getCatchUpTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.metadata.audit-log.catchup-timeout", "2s"), TimeUnit.SECONDS);
    }

    public long getCatchUpMaxTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.metadata.audit-log.catchup-max-timeout", "60s"), TimeUnit.SECONDS);
    }

    public boolean isQueryEscapedLiteral() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.parser.escaped-string-literals", FALSE));
    }

    public boolean isSessionSecureRandomCreateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.session.secure-random-create-enabled", FALSE));
    }

    public boolean isSessionJdbcEncodeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.session.jdbc-encode-enabled", FALSE));
    }

    public int getDataBinderAutoGrowCollectionLimit() {
        String defaultValue = "256";
        String value = this.getOptional("kylin.web.data-binder.auto-grow-collection-limit", defaultValue);
        if (!NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(defaultValue);
        }
        int intValue = Integer.parseInt(value);
        if (intValue <= 0) {
            return Integer.parseInt(defaultValue);
        }
        return intValue;
    }

    public String getSpringStoreType() {
        return this.getOptional("spring.session.store-type", "");
    }

    public int getJdbcSessionMaxInactiveInterval() {
        return Integer.parseInt(this.getOptional("spring.session.timeout", "3600"));
    }

    public int getCapacitySampleRows() {
        return Integer.parseInt(this.getOptional("kylin.capacity.sample-rows", "1000"));
    }

    public String getUserPasswordEncoder() {
        return this.getOptional("kylin.security.user-password-encoder", "org.apache.kylin.rest.security.CachedBCryptPasswordEncoder");
    }

    public int getRecommendationPageSize() {
        return Integer.parseInt(this.getOptional("kylin.model.recommendation-page-size", "500"));
    }

    public boolean isGuardianEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.guardian.enabled", FALSE));
    }

    private long getConfigItemSeconds(String configItem, long defaultLongValue, long rangeStart, long rangeEnd) {
        long resultValue = defaultLongValue;
        try {
            resultValue = TimeUtil.timeStringAs(this.getOptional(configItem, String.format(Locale.ROOT, "%dS", defaultLongValue)), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return resultValue;
        }
        return rangeStart <= resultValue && resultValue <= rangeEnd ? resultValue : defaultLongValue;
    }

    private int getConfigItemIntValue(String configItem, int defaultIntValue, int rangeStart, int rangeEnd) {
        int resultValue = defaultIntValue;
        try {
            resultValue = Integer.parseInt(this.getOptional(configItem, String.valueOf(defaultIntValue)));
        }
        catch (Exception e) {
            return resultValue;
        }
        return rangeStart <= resultValue && resultValue <= rangeEnd ? resultValue : defaultIntValue;
    }

    private double getConfigItemDoubleValue(String configItem, double defaultDoubleValue, double rangeStart, double rangeEnd) {
        double resultValue = defaultDoubleValue;
        try {
            resultValue = Integer.parseInt(this.getOptional(configItem, String.valueOf(defaultDoubleValue)));
        }
        catch (Exception e) {
            return resultValue;
        }
        return rangeStart <= resultValue && resultValue <= rangeEnd ? resultValue : defaultDoubleValue;
    }

    public long getGuardianCheckInterval() {
        return this.getConfigItemSeconds("kylin.guardian.check-interval", 60L, 60L, 3600L);
    }

    public long getGuardianCheckInitDelay() {
        return this.getConfigItemSeconds("kylin.guardian.check-init-delay", 300L, 60L, 3600L);
    }

    public boolean isGuardianHAEnabled() {
        return !FALSE.equalsIgnoreCase(this.getOptional("kylin.guardian.ha-enabled", TRUE));
    }

    public long getGuardianHACheckInterval() {
        return this.getConfigItemSeconds("kylin.guardian.ha-check-interval", 60L, 60L, 3600L);
    }

    public long getGuardianHACheckInitDelay() {
        return this.getConfigItemSeconds("kylin.guardian.ha-check-init-delay", 300L, 60L, 3600L);
    }

    public String getGuardianHealthCheckers() {
        return this.getOptional("kylin.guardian.checkers", "org.apache.kylin.tool.daemon.checker.KEProcessChecker,org.apache.kylin.tool.daemon.checker.FullGCDurationChecker,org.apache.kylin.tool.daemon.checker.KEStatusChecker");
    }

    public int getGuardianFullGCCheckFactor() {
        return this.getConfigItemIntValue("kylin.guardian.full-gc-check-factor", 5, 1, 60);
    }

    public boolean isFullGCRatioBeyondRestartEnabled() {
        return !FALSE.equalsIgnoreCase(this.getOptional("kylin.guardian.full-gc-duration-ratio-restart-enabled", TRUE));
    }

    public double getGuardianFullGCRatioThreshold() {
        return this.getConfigItemDoubleValue("kylin.guardian.full-gc-duration-ratio-threshold", 75.0, 0.0, 100.0);
    }

    public boolean isDowngradeOnFullGCBusyEnable() {
        return !FALSE.equalsIgnoreCase(this.getOptional("kylin.guardian.downgrade-on-full-gc-busy-enabled", TRUE));
    }

    public double getGuardianFullGCHighWatermark() {
        return this.getConfigItemDoubleValue("kylin.guardian.full-gc-busy-high-watermark", 40.0, 0.0, 100.0);
    }

    public double getGuardianFullGCLowWatermark() {
        return this.getConfigItemDoubleValue("kylin.guardian.full-gc-busy-low-watermark", 20.0, 0.0, 100.0);
    }

    public int getGuardianApiFailThreshold() {
        return this.getConfigItemIntValue("kylin.guardian.api-fail-threshold", 5, 1, 100);
    }

    public boolean isSparkFailRestartKeEnabled() {
        return !FALSE.equalsIgnoreCase(this.getOptional("kylin.guardian.restart-spark-fail-restart-enabled", TRUE));
    }

    public int getGuardianSparkFailThreshold() {
        return this.getConfigItemIntValue("kylin.guardian.restart-spark-fail-threshold", 3, 1, 100);
    }

    public int getDowngradeParallelQueryThreshold() {
        return this.getConfigItemIntValue("kylin.guardian.downgrade-mode-parallel-query-threshold", 10, 0, 100);
    }

    public boolean isSlowQueryKillFailedRestartKeEnabled() {
        return !FALSE.equalsIgnoreCase(this.getOptional("kylin.guardian.kill-slow-query-fail-restart-enabled", TRUE));
    }

    public Integer getGuardianSlowQueryKillFailedThreshold() {
        return this.getConfigItemIntValue("kylin.guardian.kill-slow-query-fail-threshold", 3, 1, 100);
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"AuthenticationClient"})})
    public Long getLightningClusterId() {
        return Long.parseLong(this.getOptional("kylin.lightning.cluster-id", "0"));
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"AuthenticationClient"})})
    public Long getLightningWorkspaceId() {
        return Long.parseLong(this.getOptional("kylin.lightning.workspace-id", "0"));
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"AuthenticationClient"})})
    public String getLightningServerZkNode() {
        return this.getOptional("kylin.lightning.server.zookeeper-node", "/kylin/management");
    }

    public String getSparkLogExtractor() {
        return this.getOptional("kylin.tool.spark-log-extractor", "org.apache.kylin.tool.YarnSparkLogExtractor");
    }

    public String getLicenseExtractor() {
        return this.getOptional("kylin.tool.license-extractor", "org.apache.kylin.rest.service.DefaultLicenseExtractor");
    }

    public String getMountSparkLogDir() {
        return this.getOptional("kylin.tool.mount-spark-log-dir", "");
    }

    public boolean cleanDiagTmpFile() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.clean-diag-tmp-file", FALSE));
    }

    public long getInstanceLogRetentionTime() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.log.gc-and-jstack.retention-time", "7d"), TimeUnit.MILLISECONDS);
    }

    public int getTurnMaintainModeRetryTimes() {
        return Integer.parseInt(this.getOptional("kylin.tool.turn-on-maintainmodel-retry-times", "3"));
    }

    public int getSuggestModelSqlLimit() {
        return Integer.parseInt(this.getOptional("kylin.model.suggest-model-sql-limit", "200"));
    }

    public int getSuggestModelSqlInterval() {
        return Integer.parseInt(this.getOptional("kylin.model.suggest-model-sql-interval", "10"));
    }

    public String getIntersectFilterOrSeparator() {
        return this.getOptional("kylin.query.intersect.separator", "|");
    }

    public int getBitmapValuesUpperBound() {
        return Integer.parseInt(this.getOptional("kylin.query.bitmap-values-upper-bound", "10000000"));
    }

    public String getUIProxyLocation() {
        return this.getOptional("kylin.query.ui.proxy-location", KYLIN_ROOT);
    }

    public boolean isHistoryServerEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.history-server.enable", FALSE));
    }

    public String getJobFinishedNotifierUrl() {
        return this.getOptional("kylin.job.finished-notifier-url", null);
    }

    public String getJobFinishedNotifierUsername() {
        return this.getOptional("kylin.job.finished-notifier-username");
    }

    public String getJobFinishedNotifierPassword() {
        return EncryptUtil.getDecryptedValue(this.getOptional("kylin.job.finished-notifier-password"));
    }

    public int getMaxModelDimensionMeasureNameLength() {
        return Integer.parseInt(this.getOptional("kylin.model.dimension-measure-name.max-length", "300"));
    }

    public int getAuditLogBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.metadata.audit-log.batch-size", "5000"));
    }

    public int getAuditLogDeleteBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.metadata.audit-log.delete-batch-size", "2000"));
    }

    public int getAuditLogBatchTimeout() {
        return (int)TimeUtil.timeStringAs(this.getOptional("kylin.metadata.audit-log.batch-timeout", "30s"), TimeUnit.SECONDS);
    }

    public long getDiagTaskTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.diag.task-timeout", "180s"), TimeUnit.SECONDS);
    }

    public ImmutableSet<String> getDiagTaskTimeoutBlackList() {
        String lists = this.getOptional("kylin.diag.task-timeout-black-list", "METADATA,LOG").toUpperCase(Locale.ROOT);
        return ImmutableSet.copyOf((Object[])lists.split(","));
    }

    public boolean isMetadataOnlyForRead() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.metadata.only-for-read", FALSE));
    }

    public String getGlobalDictV2StoreImpl() {
        return this.getOptional("kylin.dictionary.globalV2-store-class-name", "org.apache.spark.dict.NGlobalDictHDFSStore");
    }

    public boolean isV2DictEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.is-v2dict-enable", TRUE));
    }

    public boolean isV3DictEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.is-v3dict-enable", FALSE));
    }

    public boolean isConvertV3DictEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.is-convert-v3dict-enable", FALSE));
    }

    public long getV3DictFileNumLimit() {
        return Long.parseLong(this.getOptional("kylin.build.v3dict-file-num-limit", "10"));
    }

    public long getV3DictFileRetentionHours() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.build.v3dict-file-retention", "3d"), TimeUnit.HOURS);
    }

    public String getV3DictDBName() {
        return this.getOptional("kylin.build.v3dict-db-name", DEFAULT);
    }

    public String getLogLocalWorkingDirectory() {
        return this.getOptional("kylin.engine.log.local-working-directory", "");
    }

    public String getLokiServer() {
        return this.getOptional("kylin.diag.loki-api-server", "");
    }

    public String[] getJobResourceLackIgnoreExceptionClasses() {
        return this.getOptionalStringArray("kylin.job.resource-lack-ignore-exception-classes", new String[]{"com.amazonaws.services.s3.model.AmazonS3Exception"});
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public String getAADUsernameClaim() {
        return this.getOptional("kylin.server.aad-username-claim", "upn");
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public String getAADClientId() {
        return this.getOptional("kylin.server.aad-client-id", "");
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public String getAADTenantId() {
        return this.getOptional("kylin.server.aad-tenant-id", "");
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public int getAADTokenClockSkewSeconds() {
        return Integer.parseInt(this.getOptional("kylin.server.aad-token-clock-skew-seconds", "0"));
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public String getOktaOauth2Issuer() {
        return this.getOptional("kylin.server.okta-oauth2-issuer", "");
    }

    @ThirdPartyDependencies(value={@ThirdPartyDependencies.ThirdPartyDependent(repository="static-user-manager", classes={"StaticAuthenticationProvider"})})
    public String getOktaClientId() {
        return this.getOptional("kylin.server.okta-client-id", "");
    }

    public long buildResourceStateCheckInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.build.resource.state-check-interval-seconds", "1s"), TimeUnit.SECONDS);
    }

    public int buildResourceConsecutiveIdleStateNum() {
        return Integer.parseInt(this.getOptional("kylin.build.resource.consecutive-idle-state-num", "3"));
    }

    public double buildResourceLoadRateThreshold() {
        return Double.parseDouble(this.getOptional("kylin.build.resource.load-rate-threshold", "10"));
    }

    public boolean skipFreshAlluxio() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.skip-fresh-alluxio", FALSE));
    }

    public Set<String> getUserDefinedNonCustomProjectConfigs() {
        String configs = this.getOptional("kylin.server.non-custom-project-configs");
        if (StringUtils.isEmpty((CharSequence)configs)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])configs.split(","));
    }

    public Set<String> getNonCustomProjectConfigs() {
        Set<String> allConfigNameSet = this.getUserDefinedNonCustomProjectConfigs();
        allConfigNameSet.addAll(NonCustomProjectLevelConfig.listAllConfigNames());
        return allConfigNameSet;
    }

    public String getDiagObfLevel() {
        return this.getOptional("kylin.diag.obf.level", "OBF").toUpperCase(Locale.ROOT);
    }

    public boolean isDiagIpObfEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.diag.ip-obf-enabled", FALSE));
    }

    public boolean isDimensionRangeFilterEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.dimension-range-filter-enabled", TRUE));
    }

    public boolean isQueryDimensionRangeFilterEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.dimension-range-filter-enabled", FALSE));
    }

    public int getSegmentExecMaxThreads() {
        return Integer.parseInt(this.getOptional("kylin.engine.segment-exec-max-threads", "200"));
    }

    public boolean isSegmentParallelBuildEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.segment-exec-parallel-enabled", FALSE));
    }

    public boolean isEmbeddedEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.file-system.journal.embedded-enable", FALSE));
    }

    public String getSystemProfileExtractor() {
        return this.getOptional("kylin.tool.system-profile-extractor", "org.apache.kylin.tool.LightningSystemProfileExtractor");
    }

    public boolean isCharDisplaySizeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.char-display-size-enabled", TRUE));
    }

    public boolean isPrometheusMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.prometheus-enabled", TRUE));
    }

    public boolean getWaitResourceEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.wait-resource.enabled", TRUE));
    }

    public boolean getCheckResourceEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.resource.check-enabled", FALSE));
    }

    public long getCheckResourceTimeLimit() {
        return Long.parseLong(this.getOptional("kylin.build.resource.check-retry-limit-minutes", "30"));
    }

    public boolean isBatchGetRowAclEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.batch-get-row-acl-enabled", FALSE));
    }

    public boolean isAdaptiveSpanningTreeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.adaptive-spanning-tree-enabled", FALSE));
    }

    public double getAdaptiveSpanningTreeThreshold() {
        return Double.parseDouble(this.getOptional("kylin.engine.adaptive-spanning-tree-threshold", "0.5d"));
    }

    public int getAdaptiveSpanningTreeBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.engine.adaptive-spanning-tree-batch-size", "10"));
    }

    public boolean isIndexColumnFlatTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.index-column-flattable-enabled", FALSE));
    }

    public boolean isInferiorFlatTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.inferior-flattable-enabled", FALSE));
    }

    public String getInferiorFlatTableStorageLevel() {
        return this.getOptional("kylin.engine.inferior-flattable-storage-level", "MEMORY_AND_DISK");
    }

    public int getInferiorFlatTableGroupFactor() {
        return Integer.parseInt(this.getOptional("kylin.engine.inferior-flattable-group-factor", "20"));
    }

    public int getInferiorFlatTableDimensionFactor() {
        return Integer.parseInt(this.getOptional("kylin.engine.inferior-flattable-dimension-factor", "10"));
    }

    public int getFlatTableCoalescePartitionNum() {
        return Integer.parseInt(this.getOptional("kylin.engine.flattable-coalesce-partition-num", "-1"));
    }

    public boolean isNeedReplayConsecutiveLog() {
        return Boolean.parseBoolean(this.getOptional("kylin.auditlog.replay-need-consecutive-log", TRUE));
    }

    public int getReplayWaitMaxRetryTimes() {
        return Integer.parseInt(this.getOptional("kylin.auditlog.replay-wait-max-retry-times", "3"));
    }

    public long getReplayWaitMaxTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.auditlog.replay-wait-max-timeout", "100ms"), TimeUnit.MILLISECONDS);
    }

    public long getEventualReplayDelayItemTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.auditlog.replay-eventual-delay-item-timeout", "5m"), TimeUnit.MILLISECONDS);
    }

    public int getEventualReplayDelayItemBatch() {
        return Integer.parseInt(this.getOptional("kylin.auditlog.replay-eventual-delay-item-batch", "1000"));
    }

    public boolean skipCheckFlatTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.skip-check-flattable", FALSE));
    }

    public boolean isQueryExceptionCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.exception-cache-enabled", FALSE));
    }

    public int getQueryExceptionCacheThresholdTimes() {
        return Integer.parseInt(this.getOptional("kylin.query.exception-cache-threshold-times", "2"));
    }

    public int getQueryExceptionCacheThresholdDuration() {
        return Integer.parseInt(this.getOptional("kylin.query.exception-cache-threshold-duration", "2000"));
    }

    public boolean isQueryBlacklistEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.blacklist-enabled", FALSE));
    }

    public boolean isSkipEmptySegments() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.skip-empty-segments", TRUE));
    }

    public long getEhcacheTimeToIdleSecondsForException() {
        return Long.parseLong(this.getOptional("kylin.cache.ehcache.exception-time-to-idle-seconds", "600"));
    }

    public boolean isSkipBasicAuthorization() {
        return Boolean.parseBoolean(this.getOptional("kap.authorization.skip-basic-authorization", FALSE));
    }

    public boolean isReadTransactionalTableEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.resource.read-transactional-table-enabled", TRUE));
    }

    public String getFlatTableStorageFormat() {
        return this.getOptional("kylin.source.hive.flat-table-storage-format", "SEQUENCEFILE");
    }

    public String getFlatTableFieldDelimiter() {
        return this.getOptional("kylin.source.hive.flat-table-field-delimiter", "\u001f");
    }

    public long[] getMetricsQuerySlaSeconds() {
        return this.getOptionalLongArray("kylin.metrics.query.sla.seconds", new String[]{"3", "15", "60"});
    }

    public long[] getMetricsJobSlaMinutes() {
        return this.getOptionalLongArray("kylin.metrics.job.sla.minutes", new String[]{"30", "60", "300"});
    }

    public boolean decimalOperationsAllowPrecisionLoss() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.spark-conf.spark.sql.decimalOperations.allowPrecisionLoss", TRUE));
    }

    public boolean allowNegativeScaleOfDecimalEnabled() {
        return Boolean.parseBoolean(this.getOptional(LEGACY_ALLOW_NEGATIVE_SCALE_OF_DECIMAL_ENABLED, FALSE));
    }

    public boolean isSpark3ExecutorPrometheusEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.spark-conf.spark.ui.prometheus.enabled", FALSE));
    }

    public String getSpark3DriverPrometheusServletClass() {
        return this.getOptional("kylin.storage.columnar.spark-conf.spark.metrics.conf.*.sink.prometheusServlet.class", "");
    }

    public String getSpark3DriverPrometheusServletPath() {
        return this.getOptional("kylin.storage.columnar.spark-conf.spark.metrics.conf.*.sink.prometheusServlet.path", "");
    }

    protected final long[] getOptionalLongArray(String prop, String[] dft) {
        long[] longArray;
        String[] strArray = this.getOptionalStringArray(prop, dft);
        try {
            longArray = Arrays.stream(strArray).mapToLong(Long::parseLong).toArray();
        }
        catch (NumberFormatException ex) {
            logger.warn("NumberFormatException, prop={}", (Object)prop, (Object)ex);
            longArray = Arrays.stream(dft).mapToLong(Long::parseLong).toArray();
        }
        return longArray;
    }

    public String getUpdateTopNTime() {
        return this.getOptional("kylin.smart.update-topn-time", "23:00");
    }

    public boolean getUsingUpdateFrequencyRule() {
        return Boolean.parseBoolean(this.getOptional("kylin.smart.frequency-rule-enable", TRUE));
    }

    public long getUpdateTopNTimeGap() {
        return Long.parseLong(this.getOptional("kylin.smart.update-topn-time-gap", "3600000"));
    }

    public long getCheckProjectTimeGap() {
        return Long.parseLong(this.getOptional("kylin.smart.check-project-time-gap-minute", "60"));
    }

    public String getRecommendationCostMethod() {
        return this.getOptional("kylin.smart.update-cost-method", "HIT_COUNT");
    }

    public int getEventBusHandleThreadCount() {
        return Integer.parseInt(this.getOptional("kylin.env.eventbus-handle-count", "100"));
    }

    public long getMetadataCheckDuration() {
        return Long.parseLong(this.getOptional("kylin.env.health-check-interval", "3000"));
    }

    public boolean isMeasureNameCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.measure-name-check-enabled", TRUE));
    }

    public boolean checkModelDependencyHealthy() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.check-model-dependency-health", FALSE));
    }

    public boolean isTableFastReload() {
        return Boolean.parseBoolean(this.getOptional("kylin.table.fast-reload-enabled", TRUE));
    }

    public boolean isUnitOfWorkSimulationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.unitofwork-simulation-enabled", FALSE));
    }

    public long getClusterManagerHealthCheckMaxTimes() {
        return Long.parseLong(this.getOptional("kylin.engine.cluster-manager-health-check-max-times", "10"));
    }

    public long getClusterManagerHealCheckIntervalSecond() {
        return Long.parseLong(this.getOptional("kylin.engine.cluster-manager-heal-check-interval-second", "120"));
    }

    public boolean isRemoveLdapCustomSecurityLimitEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.security.remove-ldap-custom-security-limit-enabled", FALSE));
    }

    public String getSparkBuildJobHandlerClassName() {
        return this.getOptional("kylin.engine.spark.build-job-handler-class-name", "org.apache.kylin.engine.spark.job.DefaultSparkBuildJobHandler");
    }

    public String getBuildJobProgressReporter() {
        return this.getOptional("kylin.engine.spark.build-job-progress-reporter", "org.apache.kylin.engine.spark.job.RestfulJobProgressReport");
    }

    public String getBuildJobEnviromentAdaptor() {
        return this.getOptional("kylin.engine.spark.build-job-enviroment-adaptor", "org.apache.kylin.engine.spark.job.DefaultEnviromentAdaptor");
    }

    public boolean useDynamicRoleCredentialInTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.use-dynamic-role-credential-in-table", FALSE)) || Boolean.parseBoolean(this.getOptional("kylin.env.use-dynamic-S3-role-credential-in-table", FALSE));
    }

    public String getJobCallbackLanguage() {
        return this.getOptional("kylin.job.callback-language", "en");
    }

    public Integer getMaxResultRows() {
        return Integer.parseInt(this.getOptional("kylin.query.max-result-rows", "0"));
    }

    public boolean isBigQueryPushDown() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.big-query-pushdown", FALSE));
    }

    public Integer getLoadHiveTableWaitSparderSeconds() {
        return Integer.parseInt(this.getOptional("kylin.source.load-hive-table-wait-sparder-seconds", "900"));
    }

    public Integer getLoadHiveTableWaitSparderIntervals() {
        return Integer.parseInt(this.getOptional("kylin.source.load-hive-table-wait-sparder-interval-seconds", "10"));
    }

    public double getJobSchedulerMasterRenewalRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.master-lock-renew-ratio", "0.85"));
    }

    public long getJobSchedulerMasterRenewalSec() {
        return Long.parseLong(this.getOptional("kylin.job.master-lock-renew-sec", "60"));
    }

    public long getJobSchedulerMasterPollIntervalSec() {
        return Long.parseLong(this.getOptional("kylin.job.master-poll-interval-second", "10"));
    }

    public int getJobSchedulerMasterPollBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.job.master-pull-batch-size", "30"));
    }

    public long getJobSchedulerJobRenewalSec() {
        return Long.parseLong(this.getOptional("kylin.job.slave-lock-renew-sec", "120"));
    }

    public double getJobSchedulerJobRenewalRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.slave-lock-renew-ratio", "0.75"));
    }

    public int getJobSchedulerSlavePollBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.job.slave-pull-batch-size", "20"));
    }

    public int getJobLockClientRenewalMaxThreads() {
        return Integer.parseInt(this.getOptional("kylin.job.lock-client-renewal-threads", "3"));
    }

    public String getQueueKey() {
        if (this.getSparkMaster().startsWith("k8s")) {
            return "kylin.engine.spark-conf.spark.kubernetes.scheduler.volcano.podGroup.spec.queue";
        }
        return "kylin.engine.spark-conf.spark.yarn.queue";
    }

    public String getIndexPlannerQueueKey() {
        if (this.getSparkMaster().startsWith("k8s")) {
            return "kylin.index-planner.spark-conf.spark.kubernetes.scheduler.volcano.podGroup.spec.queue";
        }
        return "kylin.index-planner.spark-conf.spark.yarn.queue";
    }

    public boolean isProxyJobSparkUIEnabled() {
        String defaultValue = FALSE;
        if (this.getSparkMaster().startsWith("k8s")) {
            defaultValue = TRUE;
        }
        return Boolean.parseBoolean(this.getOptional("kylin.job.proxy-spark-ui-enabled", defaultValue));
    }

    public boolean isContainerSchedulerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.container-scheduler-enabled", TRUE));
    }

    public int getShuffleTrackingTimeout() {
        return Integer.parseInt(this.getOptional("kylin.resource.shuffle-tracking-timeout", "30"));
    }

    public int getExecutorIdleTimeout() {
        return Integer.parseInt(this.getOptional("kylin.resource.executor-idle-timeout", "10"));
    }

    public long getContainerMinMB() {
        return Long.parseLong(this.getOptional("kylin.container.minimum-allocation-mb", "1024"));
    }

    public int getContainerMinCore() {
        return Integer.parseInt(this.getOptional("kylin.container.minimum-allocation-vcores", "1"));
    }

    public int getJobTagMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.job.tag-max-size", "1024"));
    }

    public long getRoutineOpsTaskTimeOut() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.metadata.ops-cron-timeout", "4h"), TimeUnit.MILLISECONDS);
    }

    public boolean buildJobProfilingEnabled() {
        return !Boolean.parseBoolean(System.getProperty("spark.local", FALSE)) && Boolean.parseBoolean(this.getOptional("kylin.engine.async-profiler-enabled", TRUE));
    }

    public long buildJobProfilingResultTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.engine.async-profiler-result-timeout", "60s"), TimeUnit.MILLISECONDS);
    }

    public long buildJobProfilingProfileTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.engine.async-profiler-profile-timeout", "5m"), TimeUnit.MILLISECONDS);
    }

    public String getJobTmpProfilerFlagsDir(String project, String jobId) {
        return this.getJobTmpDir(project) + this.getNestedPath(jobId) + "profiler_flags";
    }

    public boolean exposeAllModelRelatedColumns() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.tds-expose-all-model-related-columns", TRUE));
    }

    public boolean exposeModelJoinKey() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.tds-expose-model-join-key", TRUE));
    }

    public boolean skipCheckTds() {
        return Boolean.parseBoolean(this.getOptional("kylin.model.skip-check-tds", TRUE));
    }

    public boolean isHdfsMetricsPeriodicCalculationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.hdfs-periodic-calculation-enabled", TRUE));
    }

    public long getHdfsMetricsPeriodicCalculationInterval() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.metrics.hdfs-periodic-calculation-interval", "5m"), TimeUnit.MILLISECONDS);
    }

    public String getKubernetesUploadPath() {
        return this.getOptional(this.getKubernetesUploadPathKey());
    }

    public String getKubernetesUploadPathKey() {
        return "kylin.engine.spark-conf.spark.kubernetes.file.upload.path";
    }

    public String getHdfsMetricsDir(String metricFile) {
        return this.getHdfsWorkingDirectory() + METRICS + metricFile;
    }

    public boolean isSkipResourceCheck() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.resource.skip-resource-check", FALSE));
    }

    public boolean isBuildSegmentOverlapEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.segment-overlap-enabled", FALSE));
    }

    public boolean isJobTmpDirALLPermissionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.job-tmp-dir-all-permission-enabled", FALSE));
    }

    public int getProjectBloatThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.project-merge-bloat-threshold", "100"));
    }

    public boolean isStorageQuotaEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.check-quota-enabled", FALSE));
    }

    public boolean skipShardPruningForInExpr() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.skip-shard-pruning-for-in", FALSE));
    }

    public boolean isDDLEnabled() {
        return this.isDDLLogicalViewEnabled() || this.isDDLHiveEnabled();
    }

    public boolean isDDLLogicalViewEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.ddl.logical-view.enabled", FALSE));
    }

    public String getDDLCheckToSkip() {
        return this.getOptional("kylin.source.ddl.check-skip", "");
    }

    public boolean isDDLHiveEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.ddl.hive.enabled", FALSE));
    }

    public String getDDLLogicalViewDB() {
        return this.getOptional("kylin.source.ddl.logical-view.database", "KYLIN_LOGICAL_VIEW");
    }

    public int getDDLLogicalViewCatchupInterval() {
        return Integer.parseInt(this.getOptional("kylin.source.ddl.logical-view-catchup-interval", "60"));
    }

    public boolean isDataCountCheckEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.data-count-check-enabled", FALSE));
    }

    public boolean isNonStrictCountCheckAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.allow-non-strict-count-check", FALSE));
    }

    public long queryDiagnoseCollectionTimeout() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.diagnose-collection-timeout", "30s"), TimeUnit.MILLISECONDS);
    }

    public boolean queryDiagnoseEnable() {
        return !Boolean.parseBoolean(System.getProperty("spark.local", FALSE)) && Boolean.parseBoolean(this.getOptional("kylin.query.diagnose-enabled", TRUE));
    }

    public long getMaxMeasureSegmentPrunerBeforeDays() {
        return Long.parseLong(this.getOptional("kylin.query.max-measure-segment-pruner-before-days", "-1"));
    }

    public int getQueryConcurrentRunningThresholdForPushDown() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown-concurrent-running-threshold", "10"));
    }

    public boolean enableCostBasedIndexPlanner() {
        return Boolean.parseBoolean(this.getOptional("kylin.index.costbased.enabled", FALSE));
    }

    public int getCostBasedPlannerGreedyAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.index.costbased.algorithm-threshold-greedy", "8"));
    }

    public int getCostBasedPlannerGeneticAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.index.costbased.algorithm-threshold-genetic", "23"));
    }

    public double getCostBasedPlannerExpansionRateThreshold() {
        return Double.parseDouble(this.getOptional("kylin.index.costbased.expansion-threshold", "15.0"));
    }

    public double getCostBasedPlannerBPUSMinBenefitRatio() {
        return Double.parseDouble(this.getOptional("kylin.index.costbased.bpus-min-benefit-ratio", "0.01"));
    }

    public int getStatsHLLPrecision() {
        return Integer.parseInt(this.getOptional("kylin.index.costbased.sampling-hll-precision", "14"));
    }

    public double getJobCuboidSizeRatio() {
        return Double.parseDouble(this.getOptional("kylin.index.costbased.model-size-estimate-ratio", "0.25"));
    }

    public double getJobCuboidSizeCountDistinctRatio() {
        return Double.parseDouble(this.getOptional("kylin.index.costbased.model-size-estimate-countdistinct-ratio", "0.5"));
    }

    public double getJobCuboidSizeTopNRatio() {
        return Double.parseDouble(this.getOptional("kylin.index.costbased.model-size-estimate-topn-ratio", "0.5"));
    }

    public int getJobPerReducerHLLCuboidNumber() {
        return Integer.parseInt(this.getOptional("kylin.index.costbased.per-reducer-hll-cuboid-number", "100"));
    }

    public int getJobHLLMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.index.costbased.hll-max-reducer-number", "1"));
    }

    public boolean isTableLoadThresholdEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.table.load-threshold-enabled", TRUE));
    }

    public boolean isIndexEnableOperatorDesign() {
        return Boolean.parseBoolean(this.getOptional("kylin.index.enable-operator-design", FALSE));
    }

    public int getAutoShufflePartitionMultiple() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.auto-set-shuffle-partitions-multiple", "3"));
    }

    public int getAutoShufflePartitionTimeOut() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.auto-set-shuffle-partitions-timeout", "30"));
    }

    public boolean isKylinMultiTenantEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.multi-tenant.enabled", FALSE));
    }

    public long getKylinMultiTenantRouteTaskTimeOut() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.multi-tenant.route-task-timeout", "30min"), TimeUnit.MILLISECONDS);
    }

    public StorageURL getJdbcShareStateUrl() {
        if (StringUtils.isEmpty((CharSequence)this.getOptional(KYLIN_JDBC_SHARE_STATE_URL))) {
            return this.getMetadataUrl();
        }
        return StorageURL.valueOf(this.getOptional(KYLIN_JDBC_SHARE_STATE_URL));
    }

    public void setJdbcShareStateUrl(String jdbcShareStateUrl) {
        this.setProperty(KYLIN_JDBC_SHARE_STATE_URL, jdbcShareStateUrl);
    }

    public String getKylinInfoExtensionFactory() {
        String defaultValue = "org.apache.kylin.common.extension.KylinInfoExtension$Factory";
        return this.getOptional("kylin.extension.info.factory", defaultValue);
    }

    public boolean isIndexPreloadCacheEnabled() {
        boolean preloadCacheEnabled = Boolean.parseBoolean(this.getOptional("kylin.index.preloaded-cache.enabled", TRUE));
        return preloadCacheEnabled && this.queryUseGlutenEnabled();
    }

    public String[] getProjectsAggressiveOptimizationIndex() {
        return this.getOptionalStringArray("kylin.index.projects-optimized-aggressively", new String[0]);
    }

    public int getExpectedIndexSizeOptimized() {
        return Integer.parseInt(this.getOptional("kylin.index.expected-size-after-optimization", "0"));
    }

    public int getQueryFilterCollectInterval() {
        return Integer.parseInt(this.getOptional("kylin.query.filter.collect-interval", "1800"));
    }

    public boolean isBloomCollectFilterEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.bloom.collect-filter.enabled", TRUE));
    }

    public boolean isCollectQueryMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.collect-metrics.enabled", TRUE));
    }

    public boolean isBloomBuildEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.bloom.build.enabled", FALSE));
    }

    public int getBloomBuildColumnMaxNum() {
        return Integer.parseInt(this.getOptional("kylin.bloom.build.column.max-size", "3"));
    }

    public String getBloomBuildColumn() {
        return this.getOptional("kylin.bloom.build.column", "");
    }

    public String getBloomBuildColumnIds() {
        return this.getOptional("kylin.bloom.build.column-ids", "");
    }

    public int getBloomBuildColumnNvd() {
        return Integer.parseInt(this.getOptional("kylin.bloom.build.column.nvd", "200000"));
    }

    public boolean isRoundDecimalZero() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.round-decimal-zero", FALSE));
    }

    public boolean isKylinLocalCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.spark-conf.spark.kylin.local-cache.enabled", FALSE));
    }

    public boolean isKylinFileStatusCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.spark-conf.spark.hadoop.spark.kylin.file-status-cache.enabled", FALSE));
    }

    public boolean isSupportPushdownHiveCsvEnhancement() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.hive.csv.enhancement", FALSE));
    }

    public String getFileSegmentSuccessFile() {
        return this.getOptional("kylin.fileseg.success-file", null);
    }

    public boolean isPrintQueryPlanEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.print-logical-plan", FALSE));
    }

    public boolean isQueryUseIterableCollectApi() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.use-iterable-collect", FALSE));
    }

    public String getBuildResourceTemporaryWritableDB() {
        return this.getOptional("kylin.build.resource.temporary-writable-db", null);
    }

    public String getQueryEnginePeriodicGCCrontab() {
        return this.getOptional("kylin.query.engine.periodicGC.crontab", "-");
    }

    public boolean useOnlyModelsInPriorities() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.use-only-in-priorities", FALSE));
    }

    public String sparkPeriodicGCEnabled() {
        String queryEnginePeriodicGCCrontab = this.getQueryEnginePeriodicGCCrontab();
        boolean notUseCrontabPeriodicGC = StringUtils.isBlank((CharSequence)queryEnginePeriodicGCCrontab) || StringUtils.equals((CharSequence)"-", (CharSequence)queryEnginePeriodicGCCrontab);
        return String.valueOf(notUseCrontabPeriodicGC);
    }

    public int getMaxFilterConditionCnt() {
        return Integer.parseInt(this.getOptional("kylin.query.filter-condition-count", "300"));
    }

    public boolean runQueryLocallyWhenRouteToMetadata() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.using-metadata-answer-minmax-of-dimension-locally", FALSE));
    }

    public String getSourceJDBCExtend() {
        return this.getOptional("kylin.source.jdbc.extend", "");
    }

    public boolean useV3StorageEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.use-v3-storage", FALSE));
    }

    public boolean queryIndexUseGluten() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.index-use-gulten", TRUE));
    }

    public boolean buildUseGlutenEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.gluten.enabled", FALSE));
    }

    public boolean uniqueAsyncQueryUseGlutenEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.unique-async-query.gluten.enabled", FALSE));
    }

    public boolean queryUseGlutenEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.columnar.spark-conf.spark.gluten.enabled", FALSE)) && this.getOptional("kylin.storage.columnar.spark-conf.spark.plugins", "").contains("GlutenPlugin");
    }

    public String getFragmentType() {
        return this.getOptional("kylin.fragment.metadata.type", "delta");
    }

    public boolean isV3SkipVacuumOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.optimize.v3.skip-vacuum-optimize", FALSE));
    }

    public boolean isV3SkipRepartitionOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.optimize.v3.skip-repartition-optimize", FALSE));
    }

    public boolean isV3SkipZorderOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.optimize.v3.skip-zorder-optimize", FALSE));
    }

    public boolean isV3SkipCompactionOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.optimize.v3.skip-compaction-optimize", FALSE));
    }

    public boolean isPushdownSqlHintsErasingEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.sql-hints-erasing.enabled", TRUE));
    }

    public boolean isGlobalStackInterceptionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.stack-interception-enabled", FALSE));
    }

    public int getLoadTableBatchSize() {
        return Integer.parseInt(this.getOptional("kylin.table.load-batch-size", "200"));
    }

    public int getMaxRetryTimesOfContextCut() {
        return Integer.parseInt(this.getOptional("kylin.query.context-cutting-max-times", "10"));
    }

    public long getV3FilePruningNumLimit() {
        return Long.parseLong(this.getOptional("kylin.query.v3.file-pruning-file-num-limit", "50"));
    }

    public long getV3FilePruningSizeLimit() {
        return Long.parseLong(this.getOptional("kylin.query.v3.file-pruning-file-size-limit", "10485760"));
    }

    public boolean isV3ScanDynamicSplitEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.v3.scan-dynamic-split", TRUE));
    }

    public int getV3ScanMinPartitionNum() {
        return Integer.parseInt(this.getOptional("kylin.query.v3.scan-min-partition-num", "5"));
    }

    public long getV3ScanSplitRecordNum() {
        return Long.parseLong(this.getOptional("kylin.query.v3.scan-split-record-num", "2000000"));
    }

    public long getV3ScanSplitFileNum() {
        return Long.parseLong(this.getOptional("kylin.query.v3.scan-split-file-num", "5"));
    }

    public long getV3ScanSplitSizeMB() {
        return Long.parseLong(this.getOptional("kylin.query.v3.scan-split-size-mb", "64"));
    }

    public long getV3DeltaLogCacheExpireThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.query.v3.delta-log-cache-expire-threshold", "43200s"), TimeUnit.SECONDS);
    }

    public boolean isSourceJdbcWhiteListEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.jdbc.white-list.enabled", FALSE));
    }

    public Set<String> getSourceJdbcWhiteListSchemes() {
        String config = StringUtils.deleteWhitespace((String)this.getOptional("kylin.source.jdbc.white-list.schemes", ""));
        if (StringUtils.isBlank((CharSequence)config)) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])config.split(","));
    }

    public String getSourceJdbcWhiteListValidatorClassByScheme(String scheme) {
        Set<String> whiteListSchemes = this.getSourceJdbcWhiteListSchemes();
        if (!whiteListSchemes.contains(scheme)) {
            return null;
        }
        return this.getOptional(String.format(Locale.ROOT, "kylin.source.jdbc.white-list.%s.validator-class", scheme), "org.apache.kylin.rest.source.CommonJdbcSourceConnectionValidator");
    }

    public Set<String> getSourceJdbcWhiteListUrlParamKeysByScheme(String scheme) {
        Set<String> whiteListSchemes = this.getSourceJdbcWhiteListSchemes();
        if (!whiteListSchemes.contains(scheme)) {
            return Collections.emptySet();
        }
        String config = StringUtils.deleteWhitespace((String)this.getOptional(String.format(Locale.ROOT, "kylin.source.jdbc.white-list.%s.url-param-keys", scheme), ""));
        if (StringUtils.isBlank((CharSequence)config)) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])config.split(","));
    }

    public boolean isForcedToPushDown() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown-force", FALSE));
    }

    public boolean isMultiPartitionFilterEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.build.multi-partition-filter-enabled", FALSE));
    }

    public boolean isImprovedSumDecimalPrecisionEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.improved-sum-decimal-precision.enabled", FALSE));
    }

    public String getServerNodeRegistryJdbcRenewCron() {
        return this.getOptional("kylin.server.node-registry.jdbc.renew-cron", "0/30 * * * * *");
    }

    public String getServerNodeRegistryJdbcCheckCron() {
        return this.getOptional("kylin.server.node-registry.jdbc.check-cron", "0 */2 * * * *");
    }

    public long getNodeRegistryJdbcExpireThreshold() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.server.node-registry.jdbc.expire-threshold", "90s"), TimeUnit.MILLISECONDS);
    }

    public long getServerNodeRegistryJdbcCheckIdleTime() {
        return TimeUtil.timeStringAs(this.getOptional("kylin.server.node-registry.jdbc.check-idle-time", "8s"), TimeUnit.MILLISECONDS);
    }
}

