/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public abstract class RootPersistentEntity
implements AclEntity,
Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RootPersistentEntity.class);
    private static final long serialVersionUID = 0L;
    @JsonProperty(value="uuid")
    protected String uuid = RandomUtil.randomUUIDStr();
    @JsonProperty(value="last_modified")
    protected long lastModified;
    @JsonProperty(value="create_time")
    protected long createTime = System.currentTimeMillis();
    protected boolean isCachedAndShared = false;
    @JsonProperty(value="version")
    protected String version = KylinVersion.getCurrentVersion().toString();
    @JsonProperty(value="mvcc")
    @JsonView(value={JsonUtil.PublicView.class})
    private long mvcc = -1L;
    private boolean isBroken = false;
    private List<RootPersistentEntity> dependencies;
    @JsonProperty(value="project")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String project;

    public List<RootPersistentEntity> calcDependencies() {
        return Lists.newArrayList();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.checkIsNotCachedAndShared();
        this.version = version;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.checkIsNotCachedAndShared();
        this.uuid = uuid;
    }

    @Override
    public String getId() {
        return this.uuid;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void updateRandomUuid() {
        this.setUuid(RandomUtil.randomUUIDStr());
    }

    public boolean isCachedAndShared() {
        return this.isCachedAndShared;
    }

    public void setCachedAndShared(boolean isCachedAndShared) {
        if (this.isCachedAndShared && !isCachedAndShared) {
            throw new IllegalStateException();
        }
        this.isCachedAndShared = isCachedAndShared;
    }

    public void checkIsNotCachedAndShared() {
        if (this.isCachedAndShared) {
            throw new IllegalStateException();
        }
    }

    public void setMvcc(long mvcc) {
        if (this.isCachedAndShared) {
            log.warn("[UNEXPECTED_THINGS_HAPPENED]update mvcc for isCachedAndShared object " + this.getClass() + ", from " + this.mvcc + " to " + mvcc, (Throwable)new IllegalStateException());
        }
        this.mvcc = mvcc;
    }

    public <T extends RootPersistentEntity> void copyPropertiesTo(T copy) {
        BeanUtils.copyProperties((Object)this, copy, (String[])new String[]{"cachedAndShared"});
    }

    public String resourceName() {
        return this.uuid;
    }

    public void setResourceName(String resourceName) {
    }

    public MetadataType resourceType() {
        throw new IllegalStateException("Please override this method in " + this.getClass());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RootPersistentEntity other = (RootPersistentEntity)obj;
        if (this.lastModified != other.lastModified || this.version != null && !this.version.equals(other.getVersion())) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public String getResourcePath() {
        return MetadataType.mergeKeyWithType(this.resourceName(), this.resourceType());
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.uuid;
    }

    @Generated
    public long getCreateTime() {
        return this.createTime;
    }

    @Generated
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    @Generated
    public long getMvcc() {
        return this.mvcc;
    }

    @Generated
    public boolean isBroken() {
        return this.isBroken;
    }

    @Generated
    public void setBroken(boolean isBroken) {
        this.isBroken = isBroken;
    }

    @Generated
    public List<RootPersistentEntity> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setDependencies(List<RootPersistentEntity> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }
}

