/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.scheduler;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.transaction.BroadcastEventReadyNotifier;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.eventbus.AsyncEventBus;
import org.apache.kylin.guava30.shaded.common.eventbus.EventBus;
import org.apache.kylin.guava30.shaded.common.eventbus.SyncThrowExceptionEventBus;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventBusFactory.class);
    private final KylinConfig kylinConfig;
    private EventBus asyncEventBus;
    private EventBus syncEventBus;
    private EventBus broadcastEventBus;
    private EventBus serviceEventBus;
    private ThreadPoolExecutor eventExecutor;
    private ExecutorService broadcastExecutor;
    private final Map<String, RateLimiter> rateLimiters = Maps.newConcurrentMap();

    public static EventBusFactory getInstance() {
        return Singletons.getInstance(EventBusFactory.class);
    }

    private EventBusFactory() {
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.init();
    }

    private void init() {
        this.eventExecutor = new ThreadPoolExecutor(this.kylinConfig.getEventBusHandleThreadCount(), this.kylinConfig.getEventBusHandleThreadCount(), 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("SchedulerEventBus"));
        this.broadcastExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("BroadcastEventBus"));
        this.eventExecutor.allowCoreThreadTimeOut(true);
        this.asyncEventBus = new AsyncEventBus((Executor)this.eventExecutor);
        this.syncEventBus = new SyncThrowExceptionEventBus();
        this.broadcastEventBus = new AsyncEventBus((Executor)this.broadcastExecutor);
        this.serviceEventBus = new SyncThrowExceptionEventBus();
    }

    public void registerBroadcast(Object broadcastListener) {
        this.broadcastEventBus.register(broadcastListener);
    }

    public void register(Object listener, boolean isSync) {
        if (isSync) {
            this.syncEventBus.register(listener);
        } else {
            this.asyncEventBus.register(listener);
        }
    }

    public void registerService(Object listener) {
        this.serviceEventBus.register(listener);
    }

    public void unregister(Object listener) {
        try {
            this.asyncEventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.syncEventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.broadcastEventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void unregisterService(Object listener) {
        try {
            this.serviceEventBus.unregister(listener);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void postWithLimit(SchedulerEventNotifier event) {
        this.rateLimiters.putIfAbsent(event.toString(), RateLimiter.create((double)((double)this.kylinConfig.getSchedulerLimitPerMinute() / 60.0)));
        RateLimiter rateLimiter = this.rateLimiters.get(event.toString());
        if (rateLimiter.tryAcquire()) {
            this.postAsync(event);
        }
    }

    public void postAsync(SchedulerEventNotifier event) {
        try (SetLogCategory ignored = new SetLogCategory("schedule");){
            log.debug("Post event {} async", (Object)event);
        }
        if (event instanceof BroadcastEventReadyNotifier) {
            this.broadcastEventBus.post((Object)event);
        } else {
            this.asyncEventBus.post((Object)event);
        }
    }

    public void postSync(Object event) {
        try (SetLogCategory ignored = new SetLogCategory("schedule");){
            log.debug("Post event {} sync", event);
        }
        this.syncEventBus.post(event);
    }

    public void callService(Object event) {
        try (SetLogCategory ignored = new SetLogCategory("schedule");){
            log.debug("Post Service event {} sync", event);
        }
        this.serviceEventBus.post(event);
    }

    @VisibleForTesting
    public void restart() {
        this.stopThreadPool(this.eventExecutor);
        this.stopThreadPool(this.broadcastExecutor);
        this.init();
    }

    private void stopThreadPool(ExecutorService executor) {
        executor.shutdown();
        try (SetLogCategory ignored = new SetLogCategory("schedule");){
            if (!executor.awaitTermination(6000L, TimeUnit.SECONDS)) {
                ExecutorServiceUtil.forceShutdown(executor);
            }
        }
        catch (InterruptedException ex) {
            ExecutorServiceUtil.forceShutdown(executor);
            Thread.currentThread().interrupt();
        }
    }
}

