/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kylin.common.util.BitSets;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;

public class ImmutableBitSet
implements Iterable<Integer>,
Serializable {
    private static final long serialVersionUID = 2670748367234738640L;
    public static final ImmutableBitSet EMPTY = new ImmutableBitSet(new BitSet());
    private final BitSet set;
    private final int[] arr;
    public static final BytesSerializer<ImmutableBitSet> serializer = new BytesSerializer<ImmutableBitSet>(){

        @Override
        public void serialize(ImmutableBitSet value, ByteBuffer out) {
            BytesUtil.writeByteArray(value.set.toByteArray(), out);
        }

        @Override
        public ImmutableBitSet deserialize(ByteBuffer in) {
            BitSet bitSet = BitSet.valueOf(BytesUtil.readByteArray(in));
            return new ImmutableBitSet(bitSet);
        }
    };

    public static ImmutableBitSet valueOf(int ... values) {
        return new ImmutableBitSet(BitSets.valueOf(values), false);
    }

    public static ImmutableBitSet valueOf(List<Integer> values) {
        return new ImmutableBitSet(BitSets.valueOf(values), false);
    }

    public ImmutableBitSet(int index) {
        this(ImmutableBitSet.newBitSet(index));
    }

    private ImmutableBitSet(BitSet set, boolean needClone) {
        this.set = needClone ? (BitSet)set.clone() : set;
        this.arr = new int[set.cardinality()];
        int j = 0;
        int i = set.nextSetBit(0);
        while (i >= 0) {
            this.arr[j++] = i;
            i = set.nextSetBit(i + 1);
        }
    }

    public ImmutableBitSet(BitSet set) {
        this(set, true);
    }

    private static BitSet newBitSet(int index) {
        BitSet set = new BitSet(index);
        set.set(index);
        return set;
    }

    public ImmutableBitSet(int indexFrom, int indexTo) {
        this(ImmutableBitSet.newBitSet(indexFrom, indexTo));
    }

    private static BitSet newBitSet(int indexFrom, int indexTo) {
        BitSet set = new BitSet(indexTo);
        set.set(indexFrom, indexTo);
        return set;
    }

    public int trueBitCount() {
        return this.arr.length;
    }

    public int trueBitAt(int i) {
        return this.arr[i];
    }

    public int trueBitIndexOf(int bitIndex) {
        for (int i = 0; i < this.arr.length; ++i) {
            if (this.arr[i] != bitIndex) continue;
            return i;
        }
        return -1;
    }

    public BitSet mutable() {
        return (BitSet)this.set.clone();
    }

    public ImmutableBitSet set(int bitIndex) {
        return this.set(bitIndex, true);
    }

    public ImmutableBitSet set(int bitIndex, boolean value) {
        if (this.set.get(bitIndex) == value) {
            return this;
        }
        BitSet mutable = this.mutable();
        mutable.set(bitIndex, value);
        return new ImmutableBitSet(mutable);
    }

    public ImmutableBitSet or(ImmutableBitSet another) {
        BitSet mutable = this.mutable();
        mutable.or(another.set);
        return new ImmutableBitSet(mutable);
    }

    public ImmutableBitSet andNot(ImmutableBitSet another) {
        BitSet mutable = this.mutable();
        mutable.andNot(another.set);
        return new ImmutableBitSet(mutable);
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableBitSet other = (ImmutableBitSet)obj;
        return this.set.equals(other.set);
    }

    public String toString() {
        return this.set.toString();
    }

    public boolean get(int bitIndex) {
        return this.set.get(bitIndex);
    }

    public int cardinality() {
        return this.set.cardinality();
    }

    public boolean intersects(ImmutableBitSet another) {
        return this.set.intersects(another.set);
    }

    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ImmutableBitSet.this.arr.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImmutableBitSet.this.arr[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int size() {
        return this.set.size();
    }
}

