/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotationUtils;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;
import springfox.documentation.spi.service.contexts.ParameterContext;

public class Validators {
    public static final int BEAN_VALIDATOR_PLUGIN_ORDER = -2147483148;

    private Validators() {
        throw new UnsupportedOperationException();
    }

    public static <T extends Annotation> Optional<T> extractAnnotation(ModelPropertyContext context, Class<T> annotationType) {
        return Validators.annotationFromBean(context, annotationType).map(Optional::of).orElse(Validators.annotationFromField(context, annotationType));
    }

    public static <T extends Annotation> Optional<T> annotationFromBean(ModelPropertyContext context, Class<T> annotationType) {
        Optional<BeanPropertyDefinition> propertyDefinition = context.getBeanPropertyDefinition();
        if (propertyDefinition.isPresent()) {
            Optional<Annotation> fromGetter = Validators.extractGetterFromPropertyDefinition(propertyDefinition.get()).map(m -> AnnotationUtils.findAnnotation((Method)m, (Class)annotationType));
            if (fromGetter.isPresent()) {
                return fromGetter;
            }
            return Validators.extractFieldFromPropertyDefinition(propertyDefinition.get()).map(f -> AnnotationUtils.findAnnotation((AnnotatedElement)f, (Class)annotationType));
        }
        return Optional.empty();
    }

    public static <T extends Annotation> Optional<T> annotationFromField(ModelPropertyContext context, Class<T> annotationType) {
        return Validators.findAnnotation(context.getAnnotatedElement(), annotationType);
    }

    public static <T extends Annotation> Optional<T> annotationFromParameter(ParameterContext context, Class<T> annotationType) {
        ResolvedMethodParameter methodParam = context.resolvedMethodParameter();
        return methodParam.findAnnotation(annotationType);
    }

    private static Optional<Field> extractFieldFromPropertyDefinition(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.getField() != null) {
            return Optional.ofNullable(propertyDefinition.getField().getAnnotated());
        }
        return Optional.empty();
    }

    private static Optional<Method> extractGetterFromPropertyDefinition(BeanPropertyDefinition propertyDefinition) {
        if (propertyDefinition.getGetter() != null) {
            return Optional.ofNullable(propertyDefinition.getGetter().getMember());
        }
        return Optional.empty();
    }

    private static <T extends Annotation> Optional<T> findAnnotation(Optional<? extends AnnotatedElement> annotatedElement, Class<T> annotationType) {
        return annotatedElement.map(annotated -> AnnotationUtils.findAnnotation((AnnotatedElement)annotated, (Class)annotationType));
    }
}

