/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.mappers;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.XML;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Named;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.oas.mappers.CollectionSpecificationToSchemaConverter;
import springfox.documentation.oas.mappers.CompoundSpecificationToSchemaConverter;
import springfox.documentation.oas.mappers.MapSchema;
import springfox.documentation.oas.mappers.MapSpecificationToSchemaConverter;
import springfox.documentation.oas.mappers.ModelSpecificationInheritanceDeterminer;
import springfox.documentation.oas.mappers.ReferenceModelSpecificationToSchemaConverter;
import springfox.documentation.oas.mappers.ScalarModelToSchemaConverter;
import springfox.documentation.oas.mappers.VendorExtensionsMapper;
import springfox.documentation.schema.CollectionElementFacet;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ElementFacetSource;
import springfox.documentation.schema.EnumerationFacet;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.schema.StringElementFacet;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ModelNamesRegistry;

@Mapper(componentModel="spring")
public abstract class SchemaMapper {
    @Named(value="ModelsMapping")
    public Map<String, Schema> modelsFromApiListings(Map<String, List<ApiListing>> apiListings) {
        TreeMap<String, Schema> modelMap = new TreeMap<String, Schema>();
        apiListings.values().forEach(listings -> listings.forEach(each -> modelMap.putAll(this.mapModels(each.getModelSpecifications(), each.getModelNamesRegistry()))));
        return modelMap;
    }

    protected Map<String, Schema> mapModels(Map<String, ModelSpecification> specifications, ModelNamesRegistry modelNamesRegistry) {
        if (specifications == null) {
            return null;
        }
        HashMap<String, Schema> map = new HashMap<String, Schema>(Math.max((int)((float)specifications.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, ModelSpecification> entry : specifications.entrySet()) {
            String key = entry.getKey();
            Schema value = this.mapModel(entry.getValue(), modelNamesRegistry);
            map.put(key, value);
        }
        return map;
    }

    @Named(value="ModelsMapping")
    public Schema mapModel(ModelSpecification source, @Context ModelNamesRegistry namesRegistry) {
        if (source == null) {
            return null;
        }
        ModelSpecificationInheritanceDeterminer determiner = new ModelSpecificationInheritanceDeterminer(namesRegistry);
        return determiner.parent(source).map(rm -> this.mapComposedModel((Schema)rm, source, namesRegistry)).orElse(this.model(source, namesRegistry));
    }

    private Schema model(ModelSpecification source, @Context ModelNamesRegistry namesRegistry) {
        Optional<ModelFacets> facets = source.getFacets();
        Schema model = this.mapFrom(source, namesRegistry).description(facets.map(ModelFacets::getDescription).orElse(null)).example(facets.map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null)).name(source.getName()).xml(facets.map(ModelFacets::getXml).map(this::mapXml).orElse(null));
        source.getCompound().ifPresent(c -> {
            TreeMap<String, Schema> modelProperties = new TreeMap<String, Schema>(Comparator.naturalOrder());
            Map<String, PropertySpecification> properties = c.getProperties().stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()));
            modelProperties.putAll(this.mapProperties(properties, namesRegistry));
            model.setProperties(modelProperties);
            List<String> requiredFields = properties.values().stream().filter(PropertySpecification::nullSafeIsRequired).map(PropertySpecification::getName).filter(Objects::nonNull).collect(Collectors.toList());
            model.setRequired(requiredFields);
            model.setType("object");
            model.setTitle(facets.map(ModelFacets::getTitle).orElse(null));
        });
        source.getScalar().ifPresent(s -> {
            model.setType(s.getType().getType());
            model.setFormat(s.getType().getFormat());
            facets.flatMap(mf -> mf.elementFacet(EnumerationFacet.class)).ifPresent(ef -> model.setEnum(ef.getAllowedValues()));
            facets.flatMap(mf -> mf.elementFacet(StringElementFacet.class)).ifPresent(sf -> {
                model.setPattern(sf.getPattern());
                model.setMinLength(sf.getMinLength());
                model.setMaxLength(sf.getMaxLength());
            });
            facets.flatMap(mf -> mf.elementFacet(NumericElementFacet.class)).ifPresent(nf -> {
                model.maximum(nf.getMaximum());
                model.minimum(nf.getMinimum());
                model.setExclusiveMaximum(nf.getExclusiveMaximum());
                model.setExclusiveMinimum(nf.getExclusiveMinimum());
            });
        });
        source.getReference().ifPresent(r -> {
            if (BuilderDefaults.emptyToNull(r.getKey().getQualifiedModelName().getName()) != null) {
                ObjectSchema refModel = new ObjectSchema();
                refModel.type(null);
                refModel.set$ref(namesRegistry.nameByKey(r.getKey()).orElse("ERROR - " + r.getKey().getQualifiedModelName()));
            }
        });
        source.getCollection().ifPresent(c -> {
            ModelSpecification itemSpec = c.getModel();
            ArraySchema arrayModel = new ArraySchema();
            arrayModel.description(facets.map(ModelFacets::getDescription).orElse(null));
            arrayModel.setExample(facets.map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null));
            if (itemSpec.getScalar().isPresent()) {
                arrayModel.items(new ScalarModelToSchemaConverter().convert(itemSpec.getScalar().get()));
            } else if (itemSpec.getCompound().isPresent()) {
                arrayModel.items(new CompoundSpecificationToSchemaConverter(namesRegistry).convert(itemSpec.getCompound().get()));
            } else if (itemSpec.getCollection().isPresent()) {
                arrayModel.items(new CollectionSpecificationToSchemaConverter(namesRegistry).convert(itemSpec.getCollection().get()));
            } else if (itemSpec.getReference().isPresent()) {
                arrayModel.items(new ReferenceModelSpecificationToSchemaConverter(namesRegistry).convert(itemSpec.getReference().get()));
            }
            facets.flatMap(mf -> mf.elementFacet(CollectionElementFacet.class)).ifPresent(cf -> {
                arrayModel.setMaxItems(cf.getMaxItems());
                arrayModel.setMinItems(cf.getMinItems());
                arrayModel.setUniqueItems(cf.getUniqueItems());
            });
        });
        source.getMap().ifPresent(map -> {
            ModelSpecification valueSpec = map.getValue();
            if (valueSpec.getScalar().isPresent()) {
                model.additionalProperties(new ScalarModelToSchemaConverter().convert(valueSpec.getScalar().get()));
            } else if (valueSpec.getCompound().isPresent()) {
                model.additionalProperties(new CompoundSpecificationToSchemaConverter(namesRegistry).convert(valueSpec.getCompound().get()));
            } else if (valueSpec.getCollection().isPresent()) {
                model.additionalProperties(new CollectionSpecificationToSchemaConverter(namesRegistry).convert(valueSpec.getCollection().get()));
            } else if (valueSpec.getReference().isPresent()) {
                model.additionalProperties(new ReferenceModelSpecificationToSchemaConverter(namesRegistry).convert(valueSpec.getReference().get()));
            } else {
                model.additionalProperties(new ObjectSchema());
            }
        });
        return model;
    }

    private Schema mapComposedModel(Schema parent, ModelSpecification source, ModelNamesRegistry namesRegistry) {
        ComposedSchema model = new ComposedSchema().addAllOfItem(parent).addAllOfItem(this.model(source, namesRegistry));
        model.setDescription(source.getFacets().map(ModelFacets::getDescription).orElse(null));
        model.setExample(source.getFacets().map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST).stream().findFirst().orElse(null));
        model.setTitle(source.getName());
        Map properties = source.getCompound().map(c -> c.getProperties().stream().collect(Collectors.toMap(PropertySpecification::getName, Function.identity()))).orElse(new HashMap());
        TreeMap<String, Schema> modelProperties = new TreeMap<String, Schema>(Comparator.naturalOrder());
        modelProperties.putAll(this.mapProperties(properties, namesRegistry));
        model.setProperties(modelProperties);
        return model;
    }

    protected Map<String, Schema> mapProperties(Map<String, PropertySpecification> properties, ModelNamesRegistry modelNamesRegistry) {
        return properties.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparing(PropertySpecification::getPosition).thenComparing(PropertySpecification::getName))).collect(Collectors.toMap(Map.Entry::getKey, e -> this.fromProperty((PropertySpecification)e.getValue(), modelNamesRegistry), (p1, p2) -> p1, TreeMap::new));
    }

    private Schema fromProperty(PropertySpecification source, ModelNamesRegistry modelNamesRegistry) {
        Schema property = this.model(source.getType(), modelNamesRegistry);
        ModelFacets facets = source.getType().getFacets().orElse(null);
        SchemaMapper.maybeAddFacets(property, facets);
        SchemaMapper.maybeAddFacets(property, source);
        if (property instanceof ArraySchema) {
            ArraySchema arrayProperty = (ArraySchema)property;
            SchemaMapper.maybeAddFacets(arrayProperty.getItems(), source.getType().getCollection().flatMap(c -> c.getModel().getFacets()).orElse(null));
        }
        if (property instanceof MapSchema) {
            MapSchema mapProperty = (MapSchema)property;
            SchemaMapper.maybeAddFacets((Schema)mapProperty.getAdditionalProperties(), source.getType().getMap().flatMap(c -> c.getValue().getFacets()).orElse(null));
        }
        if (property instanceof StringSchema) {
            StringSchema stringProperty = (StringSchema)property;
            stringProperty.setDefault(source.getDefaultValue() != null ? String.valueOf(source.getDefaultValue()) : null);
        }
        Map<String, Object> extensions = new VendorExtensionsMapper().mapExtensions(source.getVendorExtensions());
        if (property != null) {
            property.setDescription(source.getDescription());
            property.setName(source.getName());
            property.setReadOnly(source.getReadOnly());
            property.setExample(source.getExample());
            property.setExtensions(extensions);
            property.setXml(this.mapXml(source.getXml()));
        }
        return property;
    }

    private XML mapXml(Xml xml) {
        if (xml == null) {
            return null;
        }
        return new XML().name(xml.getName()).attribute(xml.getAttribute()).namespace(xml.getNamespace()).prefix(xml.getPrefix()).wrapped(xml.getWrapped());
    }

    public Schema mapFrom(ModelSpecification modelSpecification, @Context ModelNamesRegistry modelNamesRegistry) {
        Schema schema = modelSpecification.getScalar().map(sm -> new ScalarModelToSchemaConverter().convert((ScalarModelSpecification)sm)).orElse(null);
        if (schema == null) {
            schema = modelSpecification.getCompound().map(cm -> new CompoundSpecificationToSchemaConverter(modelNamesRegistry).convert((CompoundModelSpecification)cm)).orElse(null);
        }
        if (schema == null) {
            schema = modelSpecification.getMap().map(mm -> new MapSpecificationToSchemaConverter(modelNamesRegistry).convert((MapSpecification)mm)).orElse(null);
        }
        if (schema == null) {
            schema = modelSpecification.getCollection().map(cm -> new CollectionSpecificationToSchemaConverter(modelNamesRegistry).convert((CollectionSpecification)cm)).orElse(null);
        }
        if (schema == null) {
            schema = modelSpecification.getReference().filter(r -> BuilderDefaults.emptyToNull(r.getKey().getQualifiedModelName().getName()) != null).map(cm -> new ReferenceModelSpecificationToSchemaConverter(modelNamesRegistry).convert((ReferenceModelSpecification)cm)).orElse(null);
        }
        if (schema != null) {
            schema.setName(modelSpecification.getName());
        }
        return schema;
    }

    static Schema maybeAddFacets(Schema property, ElementFacetSource facets) {
        if (facets == null) {
            return property;
        }
        facets.elementFacet(EnumerationFacet.class).ifPresent(f -> {
            if (property instanceof StringSchema) {
                StringSchema stringProperty = (StringSchema)property;
                stringProperty.setEnum(f.getAllowedValues());
            } else if (property instanceof IntegerSchema) {
                IntegerSchema integerProperty = (IntegerSchema)property;
                List<BigDecimal> convert = SchemaMapper.convert(f.getAllowedValues(), BigDecimal.class);
                integerProperty.setEnum(convert);
            } else if (property instanceof NumberSchema) {
                NumberSchema longProperty = (NumberSchema)property;
                longProperty.setEnum(SchemaMapper.convert(f.getAllowedValues(), BigDecimal.class));
            }
        });
        if (property instanceof NumberSchema) {
            facets.elementFacet(NumericElementFacet.class).ifPresent(f -> {
                NumberSchema numeric = (NumberSchema)property;
                numeric.setMaximum(f.getMaximum());
                numeric.exclusiveMaximum(f.getExclusiveMaximum());
                numeric.setMinimum(f.getMinimum());
                numeric.exclusiveMinimum(f.getExclusiveMinimum());
            });
        }
        if (property instanceof ArraySchema) {
            facets.elementFacet(CollectionElementFacet.class).ifPresent(f -> {
                ArraySchema arrayProperty = (ArraySchema)property;
                arrayProperty.setMinItems(f.getMinItems());
                arrayProperty.setMaxItems(f.getMaxItems());
            });
        }
        if (property instanceof StringSchema) {
            StringSchema stringProperty = (StringSchema)property;
            facets.elementFacet(StringElementFacet.class).ifPresent(f -> {
                stringProperty.maxLength(f.getMaxLength());
                stringProperty.minLength(f.getMinLength());
                if (f.getPattern() != null) {
                    stringProperty.pattern(f.getPattern());
                }
            });
        }
        return property;
    }

    private static <T extends Number> List<T> convert(List<String> values, Class<T> toType) {
        return values.stream().map(SchemaMapper.converterOfType(toType)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static <T extends Number> Function<? super String, Optional<T>> converterOfType(Class<T> toType) {
        return input -> {
            try {
                if (Integer.class.equals((Object)toType)) {
                    return Optional.of(Integer.valueOf(input));
                }
                if (Long.class.equals((Object)toType)) {
                    return Optional.of(Long.valueOf(input));
                }
                if (Double.class.equals((Object)toType)) {
                    return Optional.of(Double.valueOf(input));
                }
                if (Float.class.equals((Object)toType)) {
                    return Optional.of(Float.valueOf(input));
                }
                if (BigDecimal.class.equals((Object)toType)) {
                    return Optional.of(new BigDecimal((String)input));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Optional.empty();
        };
    }
}

