/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.web;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;
import springfox.documentation.oas.web.ForwardedHeaderExtractingRequest;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.SpecGeneration;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.spi.DocumentationType;

@Order(value=-2147483648)
public class WebMvcBasePathAndHostnameTransformationFilter
implements WebMvcOpenApiTransformationFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebMvcBasePathAndHostnameTransformationFilter.class);
    private final String requestPrefix;

    public WebMvcBasePathAndHostnameTransformationFilter(@Value(value="${springfox.documentation.open-api.v3.path:/v3/api-docs}") String oasPath) {
        this.requestPrefix = StringUtils.trimTrailingCharacter((String)oasPath, (char)'/');
    }

    @Override
    public OpenAPI transform(OpenApiTransformationContext<HttpServletRequest> context) {
        OpenAPI openApi = context.getSpecification();
        context.request().ifPresent(servletRequest -> {
            ForwardedHeaderExtractingRequest filter = new ForwardedHeaderExtractingRequest((HttpServletRequest)servletRequest, new UrlPathHelper());
            openApi.servers(Collections.singletonList(SpecGeneration.inferredServer(this.requestPrefix, filter.adjustedRequestURL())));
        });
        return openApi;
    }

    @Override
    public boolean supports(DocumentationType delimiter) {
        return delimiter == DocumentationType.OAS_30;
    }
}

