/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.PropertySpecificationBuilder;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.service.Encoding;
import springfox.documentation.service.ParameterType;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.spring.web.readers.operation.ParameterAggregator;

@Component
public class ContentParameterAggregator
implements ParameterAggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentParameterAggregator.class);

    @Override
    public Collection<RequestParameter> aggregate(Collection<RequestParameter> parameters) {
        if (parameters.size() == 0) {
            return new ArrayList<RequestParameter>();
        }
        LOGGER.debug("Aggregating content parameters from parameters: {}", (Object)parameters.stream().map(RequestParameter::getName).collect(Collectors.joining(", ")));
        MediaType contentMediaType = MediaType.MULTIPART_FORM_DATA;
        ParameterType in = ParameterType.FORMDATA;
        if (parameters.stream().noneMatch(p -> p.getIn() == ParameterType.FORMDATA)) {
            contentMediaType = MediaType.APPLICATION_FORM_URLENCODED;
            in = ParameterType.FORM;
        }
        MediaType aggregateMediaType = contentMediaType;
        ParameterType aggregateIn = in;
        RequestParameterBuilder builder = new RequestParameterBuilder();
        parameters.stream().filter(p -> p.getIn() == ParameterType.FORM).forEach(each -> builder.name("body").in(aggregateIn).content(q -> q.requestBody(true).representation(aggregateMediaType).apply(r -> r.model(m -> m.compoundModel(cm -> cm.modelKey(mk -> mk.qualifiedModelName(qn -> qn.namespace("io.springfox").name(each.getName() + "Aggregate")).viewDiscriminator(null).validationGroupDiscriminators(new ArrayList<ResolvedType>()).isResponse(false).build()).properties(this.properties((RequestParameter)each)))).encoding(each.getName()).apply(e -> e.copyOf(this.encoding((RequestParameter)each, MediaType.TEXT_PLAIN))).build())));
        parameters.stream().filter(p -> p.getIn() == ParameterType.FORMDATA && p.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().anyMatch(m -> m.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA) || m.getMediaType().equals((Object)MediaType.MULTIPART_MIXED) || m.getMediaType().equals((Object)MediaType.APPLICATION_OCTET_STREAM) || m.getMediaType().equals((Object)MediaType.ALL))).orElse(false) != false).forEach(each -> builder.name("body").in(aggregateIn).content(c -> c.requestBody(true).representation(aggregateMediaType).apply(r -> r.model(m -> m.compoundModel(cm -> cm.modelKey(mk -> mk.qualifiedModelName(q -> q.namespace("io.springfox").name(each.getName() + "Aggregate")).viewDiscriminator(null).validationGroupDiscriminators(new ArrayList<ResolvedType>()).isResponse(false).build()).properties(this.properties((RequestParameter)each)))).encoding(each.getName()).apply(e -> e.copyOf(this.encoding((RequestParameter)each, aggregateMediaType))))).build());
        RequestParameter content = builder.build();
        ArrayList requestParameters = parameters.stream().filter(p -> p.getIn() != ParameterType.FORMDATA && p.getIn() != ParameterType.FORM).collect(Collectors.toCollection(ArrayList::new));
        if (content != null && content.getIn() != null) {
            requestParameters.add(content);
        }
        LOGGER.debug("Post content aggregation parameters: {}", (Object)requestParameters.stream().map(RequestParameter::getName).collect(Collectors.joining(", ")));
        return requestParameters;
    }

    private List<PropertySpecification> properties(RequestParameter parameter) {
        return parameter.getParameterSpecification().getContent().map(c -> c.getRepresentations().stream().map(m -> new PropertySpecificationBuilder(parameter.getName()).type(m.getModel()).required(parameter.getRequired()).description(parameter.getDescription()).build()).collect(Collectors.toList())).orElse(new ArrayList());
    }

    private Encoding encoding(RequestParameter parameter, MediaType mediaType) {
        return parameter.getParameterSpecification().getContent().flatMap(c -> c.representationFor(mediaType).flatMap(r -> r.getEncodings().stream().filter(e -> parameter.getName().equals(e.getPropertyRef())).findFirst())).orElse(null);
    }
}

