/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.backendsapi.clickhouse;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.gluten.backendsapi.ListenerApi;
import org.apache.gluten.backendsapi.clickhouse.CHConf$;
import org.apache.gluten.backendsapi.clickhouse.RuntimeSettings$;
import org.apache.gluten.columnarbatch.CHBatch$;
import org.apache.gluten.config.GlutenConfig$;
import org.apache.gluten.execution.CHBroadcastBuildSideCache$;
import org.apache.gluten.execution.datasource.GlutenFormatFactory$;
import org.apache.gluten.execution.datasource.GlutenFormatWriterInjects;
import org.apache.gluten.execution.datasource.GlutenRowSplitter;
import org.apache.gluten.expression.UDFMappings$;
import org.apache.gluten.extension.ExpressionExtensionTrait;
import org.apache.gluten.extension.ExpressionExtensionTrait$;
import org.apache.gluten.jni.JniLibLoader;
import org.apache.gluten.kerberos.KerberosTicketRefreshAssist;
import org.apache.gluten.vectorized.CHNativeExpressionEvaluator;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.listener.CHGlutenSQLAppStatusListener$;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.package$;
import org.apache.spark.rpc.GlutenDriverEndpoint;
import org.apache.spark.rpc.GlutenDriverEndpoint$;
import org.apache.spark.rpc.GlutenExecutorEndpoint;
import org.apache.spark.rpc.GlutenExecutorEndpoint$;
import org.apache.spark.sql.execution.datasources.GlutenWriterColumnarRules;
import org.apache.spark.sql.execution.datasources.v1.CHMergeTreeWriterInjects;
import org.apache.spark.sql.execution.datasources.v1.CHOrcWriterInjects;
import org.apache.spark.sql.execution.datasources.v1.CHParquetWriterInjects;
import org.apache.spark.sql.execution.datasources.v1.CHRowSplitter;
import org.apache.spark.sql.utils.ExpressionUtil$;
import org.apache.spark.util.SparkDirectoryUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001M3A\u0001C\u0005\u0001)!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C!Y!)\u0001\t\u0001C!\u0003\")!\t\u0001C!\u0007\")Q\t\u0001C!\u0003\")a\t\u0001C\u0005\u000f\")!\u000b\u0001C\u0005\u0003\ni1\t\u0013'jgR,g.\u001a:Ba&T!AC\u0006\u0002\u0015\rd\u0017nY6i_V\u001cXM\u0003\u0002\r\u001b\u0005Y!-Y2lK:$7/\u00199j\u0015\tqq\"\u0001\u0004hYV$XM\u001c\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)2d\b\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qiR\"A\u0006\n\u0005yY!a\u0003'jgR,g.\u001a:Ba&\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0011%tG/\u001a:oC2T!\u0001J\b\u0002\u000bM\u0004\u0018M]6\n\u0005\u0019\n#a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003%\u0002\"A\u000b\u0001\u000e\u0003%\tQb\u001c8Ee&4XM]*uCJ$HcA\u00171mA\u0011aCL\u0005\u0003_]\u0011A!\u00168ji\")\u0011G\u0001a\u0001e\u0005\u00111o\u0019\t\u0003gQj\u0011aI\u0005\u0003k\r\u0012Ab\u00159be.\u001cuN\u001c;fqRDQa\u000e\u0002A\u0002a\n!\u0001]2\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014A\u00029mk\u001eLgN\u0003\u0002>G\u0005\u0019\u0011\r]5\n\u0005}R$!\u0004)mk\u001eLgnQ8oi\u0016DH/\u0001\tp]\u0012\u0013\u0018N^3s'\",H\u000fZ8x]R\tQ&A\bp]\u0016CXmY;u_J\u001cF/\u0019:u)\tiC\tC\u00038\t\u0001\u0007\u0001(\u0001\np]\u0016CXmY;u_J\u001c\u0006.\u001e;e_^t\u0017AC5oSRL\u0017\r\\5{KR\u0019Q\u0006S'\t\u000b%3\u0001\u0019\u0001&\u0002\t\r|gN\u001a\t\u0003g-K!\u0001T\u0012\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"\u0002(\u0007\u0001\u0004y\u0015\u0001C5t\tJLg/\u001a:\u0011\u0005Y\u0001\u0016BA)\u0018\u0005\u001d\u0011un\u001c7fC:\f\u0001b\u001d5vi\u0012|wO\u001c")
public class CHListenerApi
implements ListenerApi,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void onDriverStart(SparkContext sc, PluginContext pc) {
        block0: {
            GlutenDriverEndpoint$.MODULE$.glutenDriverEndpointRef_$eq(new GlutenDriverEndpoint().self());
            CHGlutenSQLAppStatusListener$.MODULE$.registerListener(sc);
            this.initialize(pc.conf(), true);
            ExpressionExtensionTrait expressionExtensionTransformer = ExpressionUtil$.MODULE$.extendedExpressionTransformer(pc.conf().get(GlutenConfig$.MODULE$.GLUTEN_EXTENDED_EXPRESSION_TRAN_CONF(), ""));
            if (expressionExtensionTransformer == null) break block0;
            ExpressionExtensionTrait$.MODULE$.expressionExtensionTransformer_$eq(expressionExtensionTransformer);
        }
    }

    public void onDriverShutdown() {
        this.shutdown();
    }

    public void onExecutorStart(PluginContext pc) {
        KerberosTicketRefreshAssist.initKerberosIfNeeded(pc.conf());
        GlutenExecutorEndpoint$.MODULE$.executorEndpoint_$eq(new GlutenExecutorEndpoint(pc.executorID(), pc.conf()));
        if (pc.conf().get("spark.master").startsWith("local")) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping duplicate initializing clickhouse backend on spark local mode");
        } else {
            this.initialize(pc.conf(), false);
        }
    }

    public void onExecutorShutdown() {
        this.shutdown();
    }

    private void initialize(SparkConf conf, boolean isDriver) {
        BoxedUnit boxedUnit;
        CHBatch$.MODULE$.ensureRegistered();
        SparkDirectoryUtil$.MODULE$.init(conf);
        String libPath = conf.get(GlutenConfig$.MODULE$.GLUTEN_LIB_PATH(), "");
        if (StringUtils.isBlank((CharSequence)libPath)) {
            throw new IllegalArgumentException("Please set spark.gluten.sql.columnar.libpath to enable clickhouse backend");
        }
        if (isDriver) {
            JniLibLoader.loadFromPath((String)libPath, (boolean)true);
        } else {
            String executorLibPath = conf.get(GlutenConfig$.MODULE$.GLUTEN_EXECUTOR_LIB_PATH(), libPath);
            JniLibLoader.loadFromPath((String)executorLibPath, (boolean)true);
        }
        CHConf$.MODULE$.GlutenCHConf(conf).setCHConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"timezone"), (Object)conf.get("spark.sql.session.timeZone", TimeZone.getDefault().getID())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"local_engine.settings.log_processors_profiles"), (Object)"true")}));
        CHConf$.MODULE$.GlutenCHConf(conf).setCHSettings("spark_version", package$.MODULE$.SPARK_VERSION());
        if (conf.getLong(RuntimeSettings$.MODULE$.MAX_BYTES_BEFORE_EXTERNAL_SORT().key(), -1L) < 0L) {
            if (conf.getBoolean("spark.memory.offHeap.enabled", false)) {
                long memSize = JavaUtils.byteStringAsBytes((String)conf.get("spark.memory.offHeap.size"));
                if (memSize > 0L) {
                    long cores = conf.getInt("spark.executor.cores", 1);
                    long sortMemLimit = (long)((double)(memSize / cores) * 0.8);
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("max memory for sorting: ").append(sortMemLimit).toString());
                    boxedUnit = conf.set(RuntimeSettings$.MODULE$.MAX_BYTES_BEFORE_EXTERNAL_SORT().key(), Long.toString(sortMemLimit));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        UDFMappings$.MODULE$.loadFromSparkConf(conf);
        CHNativeExpressionEvaluator.initNative((Map<String, String>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).toMap(Predef$.MODULE$.$conforms()));
        GlutenFormatFactory$.MODULE$.register((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GlutenFormatWriterInjects[]{new CHParquetWriterInjects(), new CHOrcWriterInjects(), new CHMergeTreeWriterInjects()}));
        GlutenFormatFactory$.MODULE$.injectPostRuleFactory((Function1 & Serializable & scala.Serializable)session -> new GlutenWriterColumnarRules.NativeWritePostRule(session));
        GlutenFormatFactory$.MODULE$.register((GlutenRowSplitter)new CHRowSplitter());
    }

    private void shutdown() {
        KerberosTicketRefreshAssist.shutdownIfNeeded();
        CHBroadcastBuildSideCache$.MODULE$.cleanAll();
        CHNativeExpressionEvaluator.finalizeNative();
    }

    public CHListenerApi() {
        ListenerApi.$init$((ListenerApi)this);
        Logging.$init$((Logging)this);
    }
}

