/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.ShuffleInputStream;

public class LowCopyNettyShuffleInputStream
implements ShuffleInputStream {
    private final InputStream in;
    private final boolean isCompressed;
    private final ByteBuf byteBuf;
    private int readBytesCount = 0;

    public LowCopyNettyShuffleInputStream(InputStream in, ByteBuf byteBuf, boolean isCompressed) {
        this.in = in;
        this.byteBuf = byteBuf;
        this.isCompressed = isCompressed;
    }

    @Override
    public long read(long destAddress, long maxReadSize) {
        long bytesToRead = Math.min(maxReadSize, (long)this.byteBuf.readableBytes());
        int bytesToRead32 = Math.toIntExact(bytesToRead);
        if (bytesToRead32 == 0) {
            return 0L;
        }
        ByteBuffer direct = PlatformDependent.directBuffer((long)destAddress, (int)bytesToRead32);
        this.byteBuf.readBytes(direct);
        this.readBytesCount += direct.position();
        return direct.position();
    }

    @Override
    public long pos() {
        return this.readBytesCount;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (Exception e) {
            throw new GlutenException((Throwable)e);
        }
    }
}

