/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.vectorized;

import io.netty.util.internal.PlatformDependent;
import java.io.InputStream;
import org.apache.gluten.exception.GlutenException;
import org.apache.gluten.vectorized.ShuffleInputStream;

public class OnHeapCopyShuffleInputStream
implements ShuffleInputStream {
    private InputStream in;
    private final boolean isCompressed;
    private long bytesRead = 0L;
    private byte[] buffer;

    public OnHeapCopyShuffleInputStream(InputStream in, boolean isCompressed) {
        this.in = in;
        this.isCompressed = isCompressed;
    }

    @Override
    public long read(long destAddress, long maxReadSize) {
        try {
            int read;
            int maxReadSize32 = Math.toIntExact(maxReadSize);
            if (this.buffer == null || maxReadSize32 > this.buffer.length) {
                this.buffer = new byte[maxReadSize32];
            }
            if ((read = this.in.read(this.buffer, 0, maxReadSize32)) == -1 || read == 0) {
                return 0L;
            }
            PlatformDependent.copyMemory((byte[])this.buffer, (int)0, (long)destAddress, (long)read);
            this.bytesRead += (long)read;
            return read;
        }
        catch (Exception e) {
            throw new GlutenException((Throwable)e);
        }
    }

    @Override
    public long pos() {
        return this.bytesRead;
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }

    @Override
    public void close() {
        try {
            this.in.close();
            this.in = null;
        }
        catch (Exception e) {
            throw new GlutenException((Throwable)e);
        }
    }
}

