/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.aspect;

import java.util.HashSet;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.insensitive.InsensitiveRequest;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InsensitiveNameAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InsensitiveNameAspect.class);

    public static String getCaseInsentiveType(String type) {
        HashSet originTypes = Sets.newHashSet((Object[])new String[]{"user", "group", "NDataModel", "ProjectInstance"});
        return originTypes.stream().filter(originType -> originType.equalsIgnoreCase(type)).findFirst().orElse(type);
    }

    @Around(value="@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController)")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        try {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            String[] parameterNames = signature.getParameterNames();
            Class[] parameterTypes = signature.getParameterTypes();
            for (int i = 0; i < parameterNames.length; ++i) {
                if (args[i] == null) continue;
                this.updateInsensitiveField(args, parameterNames, parameterTypes, i);
            }
        }
        catch (Exception e) {
            log.warn("update insensitive field failed ", (Throwable)e);
        }
        return pjp.proceed(args);
    }

    private void updateInsensitiveField(Object[] args, String[] parameterNames, Class[] parameterTypes, int i) {
        Object arg = args[i];
        if (parameterTypes[i] == String.class) {
            if (StringUtils.isEmpty((CharSequence)((String)args[i]))) {
                return;
            }
            switch (parameterNames[i]) {
                case "project": {
                    NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                    ProjectInstance projectInstance = projectManager.getProject((String)args[i]);
                    if (projectInstance == null) break;
                    args[i] = projectInstance.getName();
                    break;
                }
                case "username": {
                    NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
                    ManagedUser user = userManager.get((String)args[i]);
                    if (user == null) break;
                    args[i] = user.getUsername();
                    break;
                }
                case "modelAlias": {
                    args[i] = this.getDataModelAlias(args, parameterNames, parameterTypes, (String)arg);
                    break;
                }
                case "type": 
                case "sidType": 
                case "entityType": {
                    args[i] = InsensitiveNameAspect.getCaseInsentiveType((String)arg);
                    break;
                }
            }
        } else if (arg instanceof InsensitiveRequest) {
            InsensitiveRequest insensitiveRequest = (InsensitiveRequest)arg;
            insensitiveRequest.updateField();
        }
    }

    private String getDataModelAlias(Object[] args, String[] parameterNames, Class[] parameterTypes, String modelAlias) {
        String projectName = null;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (parameterTypes[i] != String.class || !Objects.equals("project", parameterNames[i]) || StringUtils.isBlank((CharSequence)(projectName = (String)args[i]))) continue;
            NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            ProjectInstance projectInstance = projectManager.getProject(projectName);
            if (projectInstance == null) break;
            projectName = projectInstance.getName();
            break;
        }
        if (StringUtils.isEmpty(projectName)) {
            return modelAlias;
        }
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), projectName);
        NDataModel dataModel = modelManager.getDataModelDescByAlias(modelAlias);
        if (dataModel != null) {
            return dataModel.getAlias();
        }
        return modelAlias;
    }
}

