/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.Size;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.insensitive.ProjectInsensitiveRequest;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.request.Validation;
import org.springframework.validation.FieldError;

public class SQLRequest
implements Serializable,
ProjectInsensitiveRequest,
Validation {
    protected static final long serialVersionUID = 1L;
    private String sql;
    private String queryId;
    private String project;
    private String username = "";
    private String executeAs;
    private Integer offset = 0;
    private Integer limit = 0;
    private boolean acceptPartial = false;
    private Boolean forcedToPushDown;
    @JsonProperty(value="forced_to_index")
    private boolean forcedToIndex = false;
    private String stopId;
    private String format = "csv";
    private String encode = "utf-8";
    private String userAgent = "";
    @JsonProperty(value="spark_queue")
    private String sparkQueue = "";
    private boolean partialMatchIndex = false;
    @JsonProperty(value="file_name")
    private String fileName = "result";
    @JsonProperty(value="include_header")
    private boolean includeHeader;
    private boolean ifBigQuery = false;
    private Map<String, String> backdoorToggles;
    @Size(max=256)
    private @Size(max=256) String user_defined_tag;
    private String normalizedSql;
    protected volatile Object cacheKey = null;

    public Object getCacheKey() {
        if (this.cacheKey != null) {
            return this.cacheKey;
        }
        this.cacheKey = Lists.newArrayList((Object[])new Object[]{this.normalizedSql, this.project, this.offset, this.limit, this.acceptPartial, this.backdoorToggles, this.username});
        return this.cacheKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SQLRequest that = (SQLRequest)o;
        if (this.acceptPartial != that.acceptPartial) {
            return false;
        }
        if (!Objects.equals(this.sql, that.sql)) {
            return false;
        }
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        if (!Objects.equals(this.offset, that.offset)) {
            return false;
        }
        if (!Objects.equals(this.limit, that.limit)) {
            return false;
        }
        if (!Objects.equals(this.user_defined_tag, that.user_defined_tag)) {
            return false;
        }
        return Objects.equals(this.backdoorToggles, that.backdoorToggles);
    }

    public int hashCode() {
        int result = this.sql != null ? this.sql.hashCode() : 0;
        result = 31 * result + (this.project != null ? this.project.hashCode() : 0);
        result = 31 * result + (this.offset != null ? this.offset.hashCode() : 0);
        result = 31 * result + (this.limit != null ? this.limit.hashCode() : 0);
        result = 31 * result + (this.acceptPartial ? 1 : 0);
        result = 31 * result + (this.backdoorToggles != null ? this.backdoorToggles.hashCode() : 0);
        result = 31 * result + (this.user_defined_tag != null ? this.user_defined_tag.hashCode() : 0);
        return result;
    }

    @Override
    public String getErrorMessage(List<FieldError> errors) {
        Message message = MsgPicker.getMsg();
        if (!CollectionUtils.isEmpty(errors) && errors.get(0).getField().equalsIgnoreCase("user_defined_tag")) {
            return message.getInvalidUserTag();
        }
        return "";
    }

    public boolean isForcedToPushDown() {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)this.project);
        return this.forcedToPushDown != null ? this.forcedToPushDown.booleanValue() : projectConfig.isForcedToPushDown();
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getExecuteAs() {
        return this.executeAs;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public boolean isAcceptPartial() {
        return this.acceptPartial;
    }

    @Generated
    public Boolean getForcedToPushDown() {
        return this.forcedToPushDown;
    }

    @Generated
    public boolean isForcedToIndex() {
        return this.forcedToIndex;
    }

    @Generated
    public String getStopId() {
        return this.stopId;
    }

    @Generated
    public String getFormat() {
        return this.format;
    }

    @Generated
    public String getEncode() {
        return this.encode;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public String getSparkQueue() {
        return this.sparkQueue;
    }

    @Generated
    public boolean isPartialMatchIndex() {
        return this.partialMatchIndex;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public boolean isIncludeHeader() {
        return this.includeHeader;
    }

    @Generated
    public boolean isIfBigQuery() {
        return this.ifBigQuery;
    }

    @Generated
    public Map<String, String> getBackdoorToggles() {
        return this.backdoorToggles;
    }

    @Generated
    public String getUser_defined_tag() {
        return this.user_defined_tag;
    }

    @Generated
    public String getNormalizedSql() {
        return this.normalizedSql;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setExecuteAs(String executeAs) {
        this.executeAs = executeAs;
    }

    @Generated
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public void setAcceptPartial(boolean acceptPartial) {
        this.acceptPartial = acceptPartial;
    }

    @Generated
    public void setForcedToPushDown(Boolean forcedToPushDown) {
        this.forcedToPushDown = forcedToPushDown;
    }

    @Generated
    public void setForcedToIndex(boolean forcedToIndex) {
        this.forcedToIndex = forcedToIndex;
    }

    @Generated
    public void setStopId(String stopId) {
        this.stopId = stopId;
    }

    @Generated
    public void setFormat(String format) {
        this.format = format;
    }

    @Generated
    public void setEncode(String encode) {
        this.encode = encode;
    }

    @Generated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Generated
    public void setSparkQueue(String sparkQueue) {
        this.sparkQueue = sparkQueue;
    }

    @Generated
    public void setPartialMatchIndex(boolean partialMatchIndex) {
        this.partialMatchIndex = partialMatchIndex;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setIncludeHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
    }

    @Generated
    public void setIfBigQuery(boolean ifBigQuery) {
        this.ifBigQuery = ifBigQuery;
    }

    @Generated
    public void setBackdoorToggles(Map<String, String> backdoorToggles) {
        this.backdoorToggles = backdoorToggles;
    }

    @Generated
    public void setUser_defined_tag(String user_defined_tag) {
        this.user_defined_tag = user_defined_tag;
    }

    @Generated
    public void setNormalizedSql(String normalizedSql) {
        this.normalizedSql = normalizedSql;
    }

    @Generated
    public void setCacheKey(Object cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Generated
    public SQLRequest() {
    }
}

