/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.session;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.rest.util.HttpUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.session.SessionInformationExpiredEvent;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.stereotype.Component;

@Component
public class KylinSessionInformationExpiredStrategy
implements SessionInformationExpiredStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinSessionInformationExpiredStrategy.class);

    public void onExpiredSessionDetected(SessionInformationExpiredEvent event) throws IOException {
        HttpServletRequest request = event.getRequest();
        HttpServletResponse response = event.getResponse();
        HttpUtil.setErrorResponse(request, response, 401, (Exception)new KylinException((ErrorCodeProducer)ErrorCodeServer.USER_UNAUTHORIZED, new Object[0]));
        if (log.isDebugEnabled()) {
            log.debug("Detail http request for authentication:\n" + HttpUtil.formatRequest(request));
        }
    }
}

