/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class ExplicitTableAliasCalculator
implements TableAliasCalculator {
    private final Map<SqlTable, String> aliases;

    protected ExplicitTableAliasCalculator(Map<SqlTable, String> aliases) {
        this.aliases = Objects.requireNonNull(aliases);
    }

    @Override
    public Optional<String> aliasForColumn(SqlTable table) {
        return this.explicitAliasOrTableAlias(table);
    }

    @Override
    public Optional<String> aliasForTable(SqlTable table) {
        return this.explicitAliasOrTableAlias(table);
    }

    private Optional<String> explicitAliasOrTableAlias(SqlTable table) {
        String alias = this.aliases.get(table);
        if (alias == null) {
            return table.tableAlias();
        }
        return Optional.of(alias);
    }

    public static TableAliasCalculator of(SqlTable table, String alias) {
        HashMap<SqlTable, String> tableAliases = new HashMap<SqlTable, String>();
        tableAliases.put(table, alias);
        return ExplicitTableAliasCalculator.of(tableAliases);
    }

    public static TableAliasCalculator of(Map<SqlTable, String> aliases) {
        return new ExplicitTableAliasCalculator(aliases);
    }
}

