/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.config;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.job.condition.JobModeCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.security.util.InMemoryResource;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
@Conditional(value={JobModeCondition.class})
public class JobMybatisConfig
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobMybatisConfig.class);
    private static final String CREATE_JOB_INFO_TABLE = "create.job.info.table";
    private static final String CREATE_JOB_LOCK_TABLE = "create.job.lock.table";
    private static final String CREATE_JOB_INFO_INDEX_1 = "create.job.info.index1";
    private static final String CREATE_JOB_INFO_INDEX_2 = "create.job.info.index2";
    public static final String JOB_INFO_SUFFIX = "_job_info_v2";
    public static final String JOB_LOCK_SUFFIX = "_job_lock_v2";
    private DataSource dataSource;
    private String database;
    private String jobInfoTableName = "job_info";
    private String jobLockTableName = "job_lock";

    public String getDatabase() {
        return this.database;
    }

    public void afterPropertiesSet() throws Exception {
        this.setupJobTables();
    }

    public String getJobInfoTableName() {
        return this.jobInfoTableName;
    }

    public String getJobLockTableName() {
        return this.jobLockTableName;
    }

    public void setupJobTables() throws Exception {
        StorageURL url = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        if (null == this.dataSource) {
            Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
            this.dataSource = JdbcDataSource.getDataSource((Properties)props);
        }
        String keIdentified = url.getIdentifier();
        if ("file".equals(url.getScheme())) {
            log.info("metadata from file");
            keIdentified = "file";
            if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
                String uuid = RandomUtil.randomUUIDStr().replace("-", "_");
                keIdentified = "UT_" + uuid;
            }
        }
        this.jobInfoTableName = keIdentified + JOB_INFO_SUFFIX;
        this.jobLockTableName = keIdentified + JOB_LOCK_SUFFIX;
        this.database = Database.MYSQL.databaseId;
        Method[] declaredMethods = ReflectionUtils.getDeclaredMethods(this.dataSource.getClass());
        List getDriverClassNameMethodList = Arrays.stream(declaredMethods).filter(method -> "getDriverClassName".equals(method.getName())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(getDriverClassNameMethodList)) {
            log.warn("can not get method of [getDriverClassName] from datasource type = {}", this.dataSource.getClass());
        } else {
            Method methodOfgetDriverClassName = (Method)getDriverClassNameMethodList.get(0);
            String driverClassName = (String)ReflectionUtils.invokeMethod((Method)methodOfgetDriverClassName, (Object)this.dataSource);
            if (driverClassName.startsWith("com.mysql")) {
                log.info("driver class name = {}, is mysql", (Object)driverClassName);
            } else if (driverClassName.startsWith("org.postgresql")) {
                log.info("driver class name = {}, is postgresql", (Object)driverClassName);
                this.database = Database.POSTGRESQL.databaseId;
            } else if (driverClassName.equals("org.h2.Driver")) {
                log.info("driver class name = {}, is H2 ", (Object)driverClassName);
                this.database = Database.H2.databaseId;
            } else {
                String errorMsg = String.format(Locale.ROOT, "driver class name = %s, should add support", driverClassName);
                log.error(errorMsg);
                throw new KylinRuntimeException(errorMsg);
            }
        }
        Properties sqlProperties = JdbcUtil.getProperties((BasicDataSource)((BasicDataSource)this.dataSource));
        this.checkAndCreateTable(sqlProperties);
        this.checkAndCreateTableIndex(sqlProperties);
    }

    private void checkAndCreateTable(Properties sqlProperties) {
        try {
            if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)this.jobInfoTableName)) {
                String jobInfoTableSql = String.format(Locale.ROOT, sqlProperties.getProperty(CREATE_JOB_INFO_TABLE), this.jobInfoTableName);
                this.executeSql(jobInfoTableSql);
            }
            if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)this.jobLockTableName)) {
                String jobLockTableSql = String.format(Locale.ROOT, sqlProperties.getProperty(CREATE_JOB_LOCK_TABLE), this.jobLockTableName);
                this.executeSql(jobLockTableSql);
            }
        }
        catch (SQLException e) {
            throw new KylinRuntimeException((Throwable)e);
        }
    }

    private void checkAndCreateTableIndex(Properties sqlProperties) {
        try {
            String jobInfoIndex1 = this.jobInfoTableName + "_ix";
            if (!JdbcUtil.isIndexExists((Connection)this.dataSource.getConnection(), (String)this.jobInfoTableName, (String)jobInfoIndex1)) {
                String jobInfoIndex1Sql = String.format(Locale.ROOT, sqlProperties.getProperty(CREATE_JOB_INFO_INDEX_1), jobInfoIndex1, this.jobInfoTableName);
                this.executeSql(jobInfoIndex1Sql);
            }
            String jobInfoIndex2 = this.jobInfoTableName + "_project_model_id_ix";
            if (!JdbcUtil.isIndexExists((Connection)this.dataSource.getConnection(), (String)this.jobInfoTableName, (String)jobInfoIndex2)) {
                String jobInfoIndex2Sql = String.format(Locale.ROOT, sqlProperties.getProperty(CREATE_JOB_INFO_INDEX_2), jobInfoIndex2, this.jobInfoTableName);
                this.executeSql(jobInfoIndex2Sql);
            }
        }
        catch (Exception e) {
            log.warn("Check and create index for job info table failed.", (Throwable)e);
        }
    }

    private void executeSql(String sql) {
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.addScript((Resource)new InMemoryResource(sql));
        populator.setContinueOnError(false);
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    static enum Database {
        MYSQL("mysql"),
        POSTGRESQL("postgresql"),
        H2("h2");

        String databaseId;

        private Database(String databaseId) {
            this.databaseId = databaseId;
        }
    }
}

