/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.handler;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddIndexHandler
extends AbstractJobHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AddIndexHandler.class);

    @Override
    protected AbstractExecutable createJob(JobParam jobParam) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String modelId = jobParam.getModel();
        String project = jobParam.getProject();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(modelId);
        Segments readySegs = df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING});
        HashSet<String> targetSegments = new HashSet<String>(jobParam.getTargetSegments());
        Segments toDealSeg = new Segments();
        readySegs.stream().filter(segment -> targetSegments.contains(segment.getId() + "")).forEach(arg_0 -> toDealSeg.add(arg_0));
        readySegs = toDealSeg;
        if (CollectionUtils.isEmpty(jobParam.getProcessLayouts()) && CollectionUtils.isEmpty(jobParam.getDeleteLayouts())) {
            log.info("Event {} is no longer valid because no layout awaits process", (Object)jobParam);
            return null;
        }
        if (readySegs.isEmpty()) {
            throw new IllegalArgumentException("No segment is ready in this job.");
        }
        return JobFactory.createJob("CUBE_JOB_FACTORY", new AddIndexJobBuildParams(Sets.newLinkedHashSet((Iterable)readySegs), jobParam));
    }

    public static class AddIndexJobBuildParams
    extends JobFactory.JobBuildParams {
        private final boolean layoutsDeletableAfterBuild;

        public AddIndexJobBuildParams(Set<NDataSegment> readySegs, JobParam jobParam) {
            super(readySegs, jobParam.getProcessLayouts(), jobParam.getOwner(), jobParam.getJobTypeEnum(), jobParam.getJobId(), jobParam.getDeleteLayouts(), jobParam.getIgnoredSnapshotTables(), jobParam.getTargetPartitions(), jobParam.getTargetBuckets(), jobParam.getExtParams());
            this.layoutsDeletableAfterBuild = jobParam.isLayoutsDeletableAfterBuild();
        }

        @Generated
        public boolean isLayoutsDeletableAfterBuild() {
            return this.layoutsDeletableAfterBuild;
        }
    }
}

