/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.manager;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.handler.AbstractJobHandler;
import org.apache.kylin.job.handler.AddIndexHandler;
import org.apache.kylin.job.handler.AddSegmentHandler;
import org.apache.kylin.job.handler.IndexPlanOptimizeJobHandler;
import org.apache.kylin.job.handler.InternalTableJobHandler;
import org.apache.kylin.job.handler.LayoutDataOptimizeJobHandler;
import org.apache.kylin.job.handler.MergeSegmentHandler;
import org.apache.kylin.job.handler.RefreshSegmentHandler;
import org.apache.kylin.job.handler.SnapshotJobHandler;
import org.apache.kylin.job.handler.TableSamplingJobHandler;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private KylinConfig config;
    private String project;

    public JobManager(KylinConfig config, String project) {
        this.config = config;
        this.project = project;
    }

    static JobManager newInstance(KylinConfig conf, String project) {
        Preconditions.checkNotNull((Object)project);
        return new JobManager(conf, project);
    }

    public static JobManager getInstance(KylinConfig config, String project) {
        return (JobManager)config.getManager(project, JobManager.class);
    }

    public String addJob(JobParam jobParam, AbstractJobHandler handler) {
        try (SetLogCategory ignored = new SetLogCategory("build");){
            AbstractJobHandler localHandler;
            if (!(this.config.isJobNode() || this.config.isUTEnv() || this.config.isMetadataNode())) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_CREATE_ABANDON, new Object[0]);
            }
            Preconditions.checkNotNull((Object)this.project);
            JobManager.checkStorageQuota(this.project);
            jobParam.setProject(this.project);
            ExecutableUtil.computeParams(jobParam);
            AbstractJobHandler abstractJobHandler = localHandler = handler != null ? handler : this.createJobHandler(jobParam);
            if (localHandler == null) {
                String string = null;
                return string;
            }
            localHandler.handle(jobParam);
            String string = jobParam.getJobId();
            return string;
        }
    }

    public String addJob(JobParam jobParam) {
        return this.addJob(jobParam, null);
    }

    public String refreshSegmentJob(JobParam jobParam) {
        return this.refreshSegmentJob(jobParam, false);
    }

    public String refreshSegmentJob(JobParam jobParam, boolean refreshAllLayouts) {
        jobParam.getCondition().put("REFRESH_ALL_LAYOUTS", refreshAllLayouts);
        NDataModel model = NDataModelManager.getInstance((KylinConfig)this.config, (String)this.project).getDataModelDesc(jobParam.getModel());
        if (model.isMultiPartitionModel() && CollectionUtils.isNotEmpty(jobParam.getTargetPartitions())) {
            jobParam.setJobTypeEnum(JobTypeEnum.SUB_PARTITION_REFRESH);
        } else {
            jobParam.setJobTypeEnum(JobTypeEnum.INDEX_REFRESH);
        }
        return this.addJob(jobParam);
    }

    public String mergeSegmentJob(JobParam jobParam) {
        jobParam.setJobTypeEnum(JobTypeEnum.INDEX_MERGE);
        return this.addJob(jobParam);
    }

    public String addRelatedIndexJob(JobParam jobParam) {
        boolean noNeed;
        boolean bl = noNeed = jobParam.getTargetSegments() == null && SegmentUtil.getValidSegments(jobParam.getModel(), this.project).isEmpty() || jobParam.getTargetSegments() != null && jobParam.getTargetSegments().isEmpty();
        if (noNeed) {
            log.debug("No need to add index build job due to there is no valid segment in {}.", (Object)jobParam.getModel());
            return null;
        }
        jobParam.setJobTypeEnum(JobTypeEnum.INDEX_BUILD);
        return this.addJob(jobParam);
    }

    public String addIndexJob(JobParam jobParam) {
        Set<String> relatedSegments = SegmentUtil.getValidSegments(jobParam.getModel(), this.project).stream().map(RootPersistentEntity::getId).collect(Collectors.toSet());
        jobParam.withTargetSegments(relatedSegments);
        return this.addRelatedIndexJob(jobParam);
    }

    public String addSegmentJob(JobParam jobParam) {
        jobParam.setJobTypeEnum(JobTypeEnum.INC_BUILD);
        return this.addJob(jobParam);
    }

    public String buildPartitionJob(JobParam jobParam) {
        jobParam.setJobTypeEnum(JobTypeEnum.SUB_PARTITION_BUILD);
        return this.addJob(jobParam);
    }

    private AbstractJobHandler createJobHandler(JobParam jobParam) {
        AbstractJobHandler handler;
        switch (jobParam.getJobTypeEnum()) {
            case INC_BUILD: {
                handler = new AddSegmentHandler();
                break;
            }
            case INDEX_MERGE: {
                handler = new MergeSegmentHandler();
                break;
            }
            case INDEX_BUILD: 
            case SUB_PARTITION_BUILD: {
                handler = new AddIndexHandler();
                break;
            }
            case INDEX_REFRESH: 
            case SUB_PARTITION_REFRESH: {
                handler = new RefreshSegmentHandler();
                break;
            }
            case TABLE_SAMPLING: {
                handler = new TableSamplingJobHandler();
                break;
            }
            case SNAPSHOT_BUILD: 
            case SNAPSHOT_REFRESH: {
                handler = new SnapshotJobHandler();
                break;
            }
            case INDEX_PLAN_OPT: {
                handler = new IndexPlanOptimizeJobHandler();
                break;
            }
            case LAYOUT_DATA_OPTIMIZE: {
                handler = new LayoutDataOptimizeJobHandler();
                break;
            }
            case INTERNAL_TABLE_REFRESH: 
            case INTERNAL_TABLE_BUILD: 
            case INTERNAL_TABLE_DELETE_PARTITION: {
                handler = new InternalTableJobHandler();
                break;
            }
            default: {
                log.error("jobParam doesn't have matched job: {}", (Object)jobParam.getJobTypeEnum());
                return null;
            }
        }
        return handler;
    }

    public static void checkStorageQuota(String project) {
        JobContext jobContext = JobContextUtil.getJobContext(KylinConfig.getInstanceFromEnv());
        if (null != jobContext && jobContext.isProjectReachQuotaLimit(project)) {
            log.error("Add job failed due to no available storage quota in project {}", (Object)project);
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.JOB_STORAGE_QUOTA_LIMIT, new Object[0]);
        }
    }
}

