/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.scheduler;

import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.SystemInfoCollector;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.core.AbstractJobExecutable;
import org.apache.kylin.job.scheduler.NodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceAcquirer {
    private static final Logger logger = LoggerFactory.getLogger(ResourceAcquirer.class);
    private final KylinConfig kylinConfig;
    private final ConcurrentMap<String, NodeResource> registers;
    private static volatile Semaphore memorySemaphore = new Semaphore(Integer.MAX_VALUE);

    public ResourceAcquirer(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
        if (kylinConfig.getAutoSetConcurrentJob()) {
            double memoryRatio = kylinConfig.getMaxLocalConsumptionRatio();
            if (Integer.MAX_VALUE == memorySemaphore.availablePermits()) {
                memorySemaphore = new Semaphore((int)(memoryRatio * (double)SystemInfoCollector.getAvailableMemoryInfo().intValue()));
            }
            logger.info("Init memorySemaphore:{} MB, memoryRatio: {}", (Object)memorySemaphore.availablePermits(), (Object)memoryRatio);
        }
        this.registers = Maps.newConcurrentMap();
    }

    public boolean tryAcquire(AbstractJobExecutable jobExecutable) {
        if (this.kylinConfig.getDeployMode().equals("cluster")) {
            logger.debug("Submit job with 'cluster' mode, skip acquire driver resource.");
            return true;
        }
        NodeResource resource = new NodeResource(jobExecutable);
        boolean acquired = memorySemaphore.tryAcquire(resource.getMemory());
        if (acquired) {
            this.registers.put(jobExecutable.getJobId(), resource);
            logger.info("Acquire resource success {}, available: {}MB", (Object)resource, (Object)memorySemaphore.availablePermits());
            return true;
        }
        logger.warn("Acquire resource failed {}, available: {}MB", (Object)resource, (Object)memorySemaphore.availablePermits());
        return false;
    }

    public void release(AbstractJobExecutable jobExecutable) {
        if (this.kylinConfig.getDeployMode().equals("cluster")) {
            return;
        }
        String jobId = jobExecutable.getJobId();
        NodeResource resource = (NodeResource)this.registers.get(jobId);
        if (Objects.isNull(resource)) {
            logger.warn("Cannot find job's registered resource: {}", (Object)jobId);
            return;
        }
        memorySemaphore.release(resource.getMemory());
        this.registers.remove(jobExecutable.getJobId());
        logger.info("Release resource success {}, available: {}MB", (Object)resource, (Object)memorySemaphore.availablePermits());
    }

    public static double currentAvailableMem() {
        return 1.0 * (double)memorySemaphore.availablePermits();
    }

    public static int availablePermits() {
        return memorySemaphore.availablePermits();
    }

    public void start() {
    }

    public void destroy() {
    }
}

