/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.snapshot;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;

public final class SnapshotJobUtils {
    private SnapshotJobUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<TableDesc> getSnapshotTables(KylinConfig kylinConfig, String project) {
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)project);
        ExecutableManager execManager = ExecutableManager.getInstance(kylinConfig, project);
        List<AbstractExecutable> executables = execManager.getNotFinalExecutablesByType(Lists.newArrayList((Object[])new JobTypeEnum[]{JobTypeEnum.SNAPSHOT_BUILD, JobTypeEnum.SNAPSHOT_REFRESH}));
        return tableMetadataManager.listAllTables().stream().filter(tableDesc -> SnapshotJobUtils.hasLoadedSnapshot(tableDesc, executables)).distinct().collect(Collectors.toList());
    }

    private static boolean hasLoadedSnapshot(TableDesc tableDesc, List<AbstractExecutable> executables) {
        return tableDesc.isSnapshotHasBroken() || StringUtils.isNotEmpty((CharSequence)tableDesc.getLastSnapshotPath()) || SnapshotJobUtils.hasRunningJob(tableDesc, executables);
    }

    private static boolean hasRunningJob(TableDesc tableDesc, List<AbstractExecutable> executables) {
        return executables.stream().map(executable -> executable.getParam("table")).anyMatch(table -> StringUtils.equals((CharSequence)table, (CharSequence)tableDesc.getIdentity()));
    }
}

