/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.ArrayUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.engine.spark.builder.InternalTableLoader;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NBatchConstants;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartition;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.apache.kylin.rest.request.InternalTableRequest;
import org.apache.kylin.rest.response.InternalTableDescResponse;
import org.apache.kylin.rest.response.InternalTableLoadingJobResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.InternalTableLoadingService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.util.DataRangeUtils;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Option;

@Service(value="internalTableService")
public class InternalTableService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(InternalTableService.class);
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private InternalTableLoadingService internalTableLoadingService;
    @Autowired
    private TableService tableService;

    public void createInternalTable(String projectName, String table, String database, String[] partitionCols, String datePartitionFormat, Map<String, String> tblProperties, String storageType) throws Exception {
        String tableIdentity = database + "." + table;
        this.createInternalTable(projectName, tableIdentity, partitionCols, datePartitionFormat, tblProperties, storageType);
    }

    public void createInternalTable(String projectName, String tableIdentity, String[] partitionCols, String datePartitionFormat, Map<String, String> tblProperties, String storageType) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, projectName);
            InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, projectName);
            HashMap properties = Maps.newHashMap();
            properties.putAll(tblProperties);
            TableDesc originTable = tableMetadataManager.getTableDesc(tableIdentity);
            if (Objects.isNull(originTable)) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), tableIdentity);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, errorMsg);
            }
            if (originTable.isHasInternal()) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getSameInternalTableNameExist(), originTable.getName());
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
            }
            this.checkParameters(partitionCols, originTable, datePartitionFormat);
            InternalTableDesc internalTable = new InternalTableDesc(originTable);
            this.createInternalTablePath(internalTable.generateInternalTableLocation());
            if (partitionCols != null && partitionCols.length != 0) {
                InternalTablePartition tablePartition = new InternalTablePartition(partitionCols, datePartitionFormat);
                internalTable.setTablePartition(tablePartition);
            }
            internalTable.setTblProperties((Map)properties);
            internalTable.optimizeTblProperties();
            internalTable.setStorageType(storageType);
            internalTable.setLocation(internalTable.generateInternalTableLocation());
            this.createDeltaSchema(internalTable);
            tableMetadataManager.updateTableDesc(originTable.getIdentity(), copyForWrite -> copyForWrite.setHasInternal(true));
            internalTableManager.saveOrUpdateInternalTable(internalTable);
            return true;
        }, (String)projectName);
    }

    public void checkParameters(String[] partitionCols, TableDesc originTable, String datePartitionFormat) throws Exception {
        if (!Objects.isNull(partitionCols) && partitionCols.length > 0 || !StringUtils.isEmpty((CharSequence)datePartitionFormat)) {
            List partitionColList;
            if (Objects.isNull(partitionCols)) {
                partitionCols = new String[]{};
            }
            if (partitionCols.length != (partitionColList = Arrays.stream(partitionCols).map(col -> originTable.findColumnByName(col)).filter(col -> col != null).collect(Collectors.toList())).size() || partitionColList.size() == 0) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getPartitionColumnNotExist(), originTable.getIdentity());
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, errorMsg);
            }
            Optional<ColumnDesc> dateCol = partitionColList.stream().filter(col -> col.getTypeName().equals("date")).findFirst();
            if (StringUtils.isEmpty((CharSequence)datePartitionFormat) && dateCol.isPresent()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNullPartitionFormat(), new Object[0]));
            }
            if (!StringUtils.isEmpty((CharSequence)datePartitionFormat) && !dateCol.isPresent()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PARAMETER, MsgPicker.getMsg().getInternalTableNoDataCol());
            }
            this.checkIfFormatMatchCol(dateCol, originTable, datePartitionFormat);
        }
    }

    private void checkIfFormatMatchCol(Optional<ColumnDesc> dateCol, TableDesc originTable, String datePartitionFormat) throws Exception {
        if (dateCol.isPresent() && !StringUtils.isEmpty((CharSequence)datePartitionFormat)) {
            boolean isFormatMatchRealDataFormat = true;
            try {
                isFormatMatchRealDataFormat = this.tableService.getPartitionColumnFormat(originTable.getProject(), originTable.getIdentity(), dateCol.get().getName(), null).equals(datePartitionFormat);
            }
            catch (KylinException kylinException) {
                logger.warn("Cannot get the real data format, skip the date format check", (Throwable)kylinException);
            }
            if (!isFormatMatchRealDataFormat) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getIncorrectDateformat(), datePartitionFormat);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, errorMsg);
            }
        }
    }

    public void createDeltaSchema(InternalTableDesc internalTable) throws Exception {
        try {
            if (internalTable.getStorageType() == InternalTableDesc.StorageType.GLUTEN || internalTable.getStorageType() == InternalTableDesc.StorageType.DELTALAKE) {
                Option defaultSession = SparkSession.getDefaultSession();
                InternalTableLoader internalTableLoader = new InternalTableLoader();
                internalTableLoader.onlyLoadSchema(true);
                internalTableLoader.loadInternalTable((SparkSession)defaultSession.get(), internalTable, new String[]{"0", "0"}, null, KylinConfig.getInstanceFromEnv().getGlutenStoragePolicy(), false);
            }
        }
        catch (Exception e) {
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(internalTable.getLocation()));
            throw e;
        }
    }

    public void createInternalTable(String project, TableDesc originTable, String storageType) throws Exception {
        this.createInternalTable(project, originTable.getName(), originTable.getDatabase(), null, null, new HashMap<String, String>(), storageType);
    }

    public void updateInternalTable(String project, String table, String database, String[] partitionCols, String datePartitionFormat, Map<String, String> tblProperties, String storageType) {
        this.aclEvaluate.checkProjectWritePermission(project);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            String dbTblName = database + "." + table;
            NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
            InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
            TableDesc originTable = tableMetadataManager.getTableDesc(dbTblName);
            InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(dbTblName);
            if (Objects.isNull(internalTable)) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), dbTblName);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_NOT_EXIST, errorMsg);
            }
            if (internalTable.getRowCount() > 0L) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableEmpty(), dbTblName);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
            }
            this.checkParameters(partitionCols, originTable, datePartitionFormat);
            if (partitionCols != null && partitionCols.length != 0) {
                InternalTablePartition tablePartition = new InternalTablePartition(partitionCols, datePartitionFormat);
                internalTable.setTablePartition(tablePartition);
            } else {
                internalTable.setTablePartition(null);
            }
            internalTable.setTblProperties(tblProperties);
            internalTable.optimizeTblProperties();
            internalTable.setStorageType(storageType);
            this.suicideRunningInternalTableJob(project, dbTblName);
            this.deleteMetaAndDataInFileSystem(internalTable);
            this.createDeltaSchema(internalTable);
            internalTableManager.saveOrUpdateInternalTable(internalTable);
            return true;
        }, (String)project);
    }

    protected void createInternalTablePath(String path) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path location = new Path(path);
            fs.mkdirs(location);
        }
        catch (IOException e) {
            String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTablePath(), new Object[0]);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
        }
    }

    protected void deleteMetaAndDataInFileSystem(InternalTableDesc internalTable) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            Path location = new Path(internalTable.getLocation());
            if (fs.exists(location)) {
                HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)location);
                logger.info("Successfully deleted internal table on {}", (Object)internalTable.getLocation());
            } else {
                logger.warn("Internal table {}'s root path {} is not exists, skip delete", (Object)internalTable.getIdentity(), (Object)internalTable.getLocation());
            }
        }
        catch (IOException e) {
            logger.error("Failed to delete internal table on {}", (Object)internalTable.getLocation(), (Object)e);
        }
    }

    public void suicideRunningInternalTableJob(String project, String table) {
        try {
            ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).suicideRunningJobByJobType(project, table, (List)Lists.newArrayList((Object[])new String[]{JobTypeEnum.INTERNAL_TABLE_BUILD.name(), JobTypeEnum.INTERNAL_TABLE_REFRESH.name(), JobTypeEnum.INTERNAL_TABLE_DELETE_PARTITION.name()}));
        }
        catch (Exception e) {
            logger.warn("Failed to suicide running internal table job for table {}", (Object)table, (Object)e);
        }
    }

    public void dropInternalTable(String project, String tableIdentity) {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.suicideRunningInternalTableJob(project, tableIdentity);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
            InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
            InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(tableIdentity);
            if (Objects.isNull(internalTable)) {
                String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), tableIdentity);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.TABLE_NOT_EXIST, errorMsg);
            }
            tableMetadataManager.updateTableDesc(tableIdentity, copyForWrite -> copyForWrite.setHasInternal(false));
            internalTableManager.removeInternalTable(tableIdentity);
            this.deleteMetaAndDataInFileSystem(internalTable);
            return true;
        }, (String)project);
    }

    public void truncateInternalTable(String project, String tableIdentity) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
        InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(tableIdentity);
        if (Objects.isNull(internalTable)) {
            String errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), tableIdentity);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_NOT_EXIST, errorMsg);
        }
        this.suicideRunningInternalTableJob(project, tableIdentity);
        long start = System.currentTimeMillis();
        this.deleteMetaAndDataInFileSystem(internalTable);
        this.createDeltaSchema(internalTable);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        long storageSize = -1L;
        try {
            storageSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(internalTable.getLocation())).getLength();
        }
        catch (IOException e) {
            logger.warn("Fetch storage size for internal table {} from {} failed caused by:", new Object[]{internalTable.getIdentity(), internalTable.getLocation(), e});
        }
        long finalStorageSize = storageSize;
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            InternalTableManager img = (InternalTableManager)this.getManager(InternalTableManager.class, project);
            InternalTableDesc oldTable = img.getInternalTableDesc(tableIdentity);
            InternalTablePartition tablePartition = oldTable.getTablePartition();
            if (tablePartition != null) {
                tablePartition.setPartitionValues(new ArrayList());
                tablePartition.setPartitionDetails(new ArrayList());
            }
            oldTable.setJobRange((List)Lists.newArrayList());
            oldTable.setPartitionRange((List)Lists.newArrayList());
            oldTable.setStorageSize(finalStorageSize);
            oldTable.setRowCount(0L);
            img.saveOrUpdateInternalTable(oldTable);
            return true;
        }, (String)project);
        logger.info("Successfully truncate internal table {} in {} ms", (Object)tableIdentity, (Object)(System.currentTimeMillis() - start));
    }

    public void dropPartitionsOnDeltaTable(String project, String tableIdentity, String[] partitionValues, String yarnQueue) throws IOException {
        this.aclEvaluate.checkProjectWritePermission(project);
        this.internalTableLoadingService.dropPartitions(project, partitionValues, tableIdentity, yarnQueue);
    }

    public void reloadInternalTableSchema(String project, String tableIdentity) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
        InternalTableDesc internalTable = internalTableManager.getInternalTableDesc(tableIdentity);
        if (internalTable != null) {
            if (internalTable.getRowCount() != 0L) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_RELOAD_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getFailedReloadNoneEmptyInternalTable(), tableIdentity));
            }
            this.dropInternalTable(project, tableIdentity);
            this.createInternalTable(project, tableIdentity, internalTable.getPartitionColumns(), internalTable.getDatePartitionFormat(), internalTable.getTblProperties(), internalTable.getStorageType().toString());
        }
    }

    public InternalTableLoadingJobResponse loadIntoInternalTable(String project, String table, String database, boolean isIncremental, boolean isRefresh, String startDate, String endDate, String[] partitions, String yarnQueue) {
        this.aclEvaluate.checkProjectWritePermission(project);
        if (isIncremental) {
            DataRangeUtils.validateRange((String)startDate, (String)endDate);
        }
        if (!isIncremental && isRefresh) {
            isRefresh = false;
        }
        return this.internalTableLoadingService.loadIntoInternalTable(project, table, database, isIncremental, isRefresh, startDate, endDate, partitions, yarnQueue);
    }

    public List<InternalTableDescResponse> getTableList(String project, boolean isFuzzy, boolean needDetails, String databaseName, String tableName) {
        List tableList;
        InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
        if (StringUtils.isNotBlank((CharSequence)databaseName) || StringUtils.isNotBlank((CharSequence)tableName)) {
            tableList = internalTableManager.getInternalTableDescInfos(databaseName, tableName, isFuzzy);
            if (tableList.isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), tableName));
            }
        } else {
            tableList = internalTableManager.listAllTables();
        }
        return tableList.stream().map(table -> InternalTableDescResponse.convertToResponse(table, needDetails)).collect(Collectors.toList());
    }

    public List<InternalTablePartitionDetail> getTableDetail(String project, String databaseName, String tableName) {
        String tableIdentity;
        InternalTableManager internalTableManager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
        InternalTableDesc internalTableDesc = internalTableManager.getInternalTableDesc(tableIdentity = databaseName + "." + tableName);
        if (internalTableDesc == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), tableIdentity));
        }
        if (internalTableDesc.getTablePartition() == null) {
            return null;
        }
        return internalTableDesc.getTablePartition().getPartitionDetails();
    }

    public static void validate(InternalTableRequest request) {
        List<String> orderByColumns;
        String storageType = request.getStorageType();
        Message msg = MsgPicker.getMsg();
        if (storageType == null || storageType.isEmpty()) {
            request.setStorageType(InternalTableDesc.StorageType.GLUTEN.name());
            storageType = request.getStorageType();
        }
        if (!InternalTableDesc.StorageType.contains((String)storageType)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, String.format(Locale.ROOT, msg.getInternalTableStorageTypeFailed(), storageType));
        }
        if (!storageType.equalsIgnoreCase(InternalTableDesc.StorageType.GLUTEN.name())) {
            return;
        }
        Map tblProperties = request.getTblProperties();
        String primaryKey = null;
        String orderByKey = null;
        for (Map.Entry entry : tblProperties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!NBatchConstants.TblPropertyKey.contains((String)key)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, String.format(Locale.ROOT, msg.getInternalTableTblPropertiesFailed(), key));
            }
            if (key.equals("primaryKey")) {
                primaryKey = value;
            }
            if (!key.equals("orderByKey")) continue;
            orderByKey = value;
        }
        if (primaryKey == null) {
            return;
        }
        if (orderByKey == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, "When primaryKey is set, orderByKey must be set.");
        }
        List<String> primaryColumns = Arrays.asList(StringHelper.splitAndTrim(primaryKey, (String)","));
        if (!ArrayUtils.isPrefixSubset(primaryColumns, orderByColumns = Arrays.asList(StringHelper.splitAndTrim(orderByKey, (String)",")))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_INTERNAL_TABLE_PARAMETER, "primaryKey must be a prefix subset of orderByKey. Example: If orderByKey is 'a,b,c', primaryKey can be 'a', 'a,b' or 'a,b,c'");
        }
    }
}

