/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.query.util.EscapeTransformer;
import org.apache.kylin.rec.query.AbstractQueryRunner;
import org.apache.kylin.rec.query.mockup.MockupPushDownRunner;
import org.apache.kylin.rec.util.OptimizeTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalQueryRunner
extends AbstractQueryRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalQueryRunner.class);
    private final Set<String> dumpResources;
    private final Map<String, RootPersistentEntity> mockupResources;
    private static final String OPTIMIZE_TRANSFORMER = OptimizeTransformer.class.getName();
    private static final String ESCAPE_TRANSFORMER = EscapeTransformer.class.getName();

    LocalQueryRunner(KylinConfig srcKylinConfig, String projectName, String[] sqls, Set<String> dumpResources, Map<String, RootPersistentEntity> mockupResources) {
        super(projectName, sqls);
        this.kylinConfig = srcKylinConfig;
        this.dumpResources = dumpResources;
        this.mockupResources = mockupResources;
    }

    @Override
    public KylinConfig prepareConfig() throws IOException {
        File tmp = File.createTempFile("kylin_job_meta", "");
        FileUtils.forceDelete((File)tmp);
        Properties properties = this.kylinConfig.exportToProperties();
        properties.setProperty("kylin.metadata.url", tmp.getAbsolutePath());
        ResourceStore.dumpResources((KylinConfig)this.kylinConfig, (File)tmp, this.dumpResources, (Properties)properties);
        for (Map.Entry<String, RootPersistentEntity> mockupResource : this.mockupResources.entrySet()) {
            File dumpFile = new File(tmp, mockupResource.getKey() + ".json");
            File dumpParent = dumpFile.getParentFile();
            if (dumpParent.isFile()) {
                FileUtils.forceDelete((File)dumpParent);
            }
            FileUtils.forceMkdir((File)dumpParent);
            String dumpJson = JsonUtil.writeValueAsIndentString((Object)mockupResource.getValue());
            FileUtils.writeStringToFile((File)dumpFile, (String)dumpJson, (Charset)Charset.defaultCharset());
        }
        KylinConfig config = KylinConfig.createKylinConfig((Properties)properties);
        List transformers = Arrays.stream(this.kylinConfig.getQueryTransformers()).collect(Collectors.toList());
        int escapeIndex = transformers.indexOf(ESCAPE_TRANSFORMER);
        transformers.add(escapeIndex + 1, OPTIMIZE_TRANSFORMER);
        config.setProperty("kylin.query.pushdown.runner-class-name", MockupPushDownRunner.class.getName());
        config.setProperty("kylin.query.pushdown-enabled", "true");
        config.setProperty("kylin.query.transformers", StringUtils.join(transformers, (char)','));
        config.setProperty("kylin.query.security.acl-tcr-enabled", "false");
        config.setProperty("kylin.smart.conf.skip-corr-reduce-rule", "true");
        return config;
    }

    @Override
    public void cleanupConfig(KylinConfig config) throws IOException {
        File metaDir = new File(config.getMetadataUrl().getIdentifier());
        if (metaDir.exists() && metaDir.isDirectory()) {
            FileUtils.forceDelete((File)metaDir);
            log.debug("Deleted the meta dir: {}", (Object)metaDir);
        }
        if (MapUtils.isNotEmpty(this.mockupResources)) {
            this.mockupResources.clear();
        }
        if (CollectionUtils.isNotEmpty(this.dumpResources)) {
            this.dumpResources.clear();
        }
        config.clearManagers();
        config.clearManagersByProject(this.project);
        ResourceStore.clearCache((KylinConfig)config);
    }
}

