/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.favorite.AsyncAccelerationTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.rest.request.AutoIndexPlanRuleUpdateRequest;
import org.apache.kylin.rest.request.FavoriteRuleUpdateRequest;
import org.apache.kylin.rest.response.ProjectStatisticsResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.ProjectModelSupporter;
import org.apache.kylin.rest.service.ProjectSmartServiceSupporter;
import org.apache.kylin.rest.service.ProjectSmartSupporter;
import org.apache.kylin.rest.service.QueryHistoryAccelerateScheduler;
import org.apache.kylin.rest.service.TopRecsUpdateScheduler;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.service.util.AutoIndexPlanRuleUtil;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="projectSmartService")
public class ProjectSmartService
extends BasicService
implements ProjectSmartServiceSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectSmartService.class);
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private UserService userService;
    @Autowired
    private ProjectSmartSupporter projectSmartSupporter;
    @Autowired
    @Qualifier(value="topRecsUpdateScheduler")
    TopRecsUpdateScheduler topRecsUpdateScheduler;
    @Autowired
    private ProjectModelSupporter projectModelSupporter;

    private void updateSingleRule(String project, String ruleName, FavoriteRuleUpdateRequest request) {
        ArrayList conds = Lists.newArrayList();
        boolean isEnabled = false;
        switch (ruleName) {
            case "frequency": {
                isEnabled = request.isFreqEnable();
                conds.add(new FavoriteRule.Condition(null, request.getFreqValue()));
                break;
            }
            case "count": {
                isEnabled = request.isCountEnable();
                conds.add(new FavoriteRule.Condition(null, request.getCountValue()));
                break;
            }
            case "submitter": {
                isEnabled = request.isSubmitterEnable();
                if (!CollectionUtils.isNotEmpty((Collection)request.getUsers())) break;
                request.getUsers().forEach(user -> conds.add(new FavoriteRule.Condition(null, user)));
                break;
            }
            case "submitter_group": {
                isEnabled = request.isSubmitterEnable();
                if (!CollectionUtils.isNotEmpty((Collection)request.getUserGroups())) break;
                request.getUserGroups().forEach(userGroup -> conds.add(new FavoriteRule.Condition(null, userGroup)));
                break;
            }
            case "duration": {
                isEnabled = request.isDurationEnable();
                conds.add(new FavoriteRule.Condition(request.getMinDuration(), request.getMaxDuration()));
                break;
            }
            case "recommendations": {
                isEnabled = request.isRecommendationEnable();
                conds.add(new FavoriteRule.Condition(null, request.getRecommendationsValue()));
                break;
            }
            case "effective_days": {
                isEnabled = true;
                conds.add(new FavoriteRule.Condition(null, request.getEffectiveDays()));
                break;
            }
            case "update_frequency": {
                isEnabled = true;
                conds.add(new FavoriteRule.Condition(null, request.getUpdateFrequency()));
                break;
            }
            case "min_hit_count": {
                isEnabled = true;
                conds.add(new FavoriteRule.Condition(null, request.getMinHitCount()));
                break;
            }
            case "low_frequency_threshold": {
                isEnabled = true;
                conds.add(new FavoriteRule.Condition(null, request.getLowFrequencyThreshold()));
                break;
            }
            case "frequency_time_window": {
                isEnabled = true;
                conds.add(new FavoriteRule.Condition(null, request.getFrequencyTimeWindow()));
                break;
            }
        }
        FavoriteRuleManager.getInstance((String)project).updateRule((List)conds, isEnabled, ruleName);
        boolean updateFrequencyChange = this.isChangeFreqRule(project, ruleName, request);
        if (updateFrequencyChange) {
            this.topRecsUpdateScheduler.reScheduleProject(project);
        }
    }

    private boolean isChangeFreqRule(String project, String ruleName, FavoriteRuleUpdateRequest request) {
        if (!"update_frequency".equals(ruleName)) {
            return false;
        }
        String currentVal = FavoriteRuleManager.getInstance((String)project).getValue("update_frequency");
        return !currentVal.equals(request.getUpdateFrequency());
    }

    public void updateRegularRule(String project, FavoriteRuleUpdateRequest request) {
        this.aclEvaluate.checkProjectWritePermission(project);
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            FavoriteRule.FAVORITE_RULE_NAMES.forEach(ruleName -> {
                if (ruleName.equals("excluded_tables")) {
                    return;
                }
                this.updateSingleRule(project, (String)ruleName, request);
            });
            return null;
        });
        NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).listAllModels().forEach(model -> this.projectModelSupporter.onModelUpdate(project, model.getUuid()));
    }

    public ProjectStatisticsResponse getProjectStatistics(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        ProjectStatisticsResponse response = new ProjectStatisticsResponse();
        int[] datasourceStatistics = this.getDatasourceStatistics(project);
        response.setDatabaseSize(datasourceStatistics[0]);
        response.setTableSize(datasourceStatistics[1]);
        int[] recPatternCount = this.getRecPatternCount(project);
        response.setAdditionalRecPatternCount(recPatternCount[0]);
        response.setRemovalRecPatternCount(recPatternCount[1]);
        response.setRecPatternCount(recPatternCount[2]);
        response.setEffectiveRuleSize(this.getFavoriteRuleSize(project));
        int[] approvedRecsCount = this.getApprovedRecsCount(project);
        response.setApprovedAdditionalRecCount(approvedRecsCount[0]);
        response.setApprovedRemovalRecCount(approvedRecsCount[1]);
        response.setApprovedRecCount(approvedRecsCount[2]);
        Map<String, Set<Integer>> modelToRecMap = this.getModelToRecMap(project);
        response.setModelSize(modelToRecMap.size());
        if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(project).isSemiAutoMode()) {
            HashSet allRecSet = Sets.newHashSet();
            modelToRecMap.values().forEach(allRecSet::addAll);
            response.setAcceptableRecSize(allRecSet.size());
            response.setMaxRecShowSize(this.getRecommendationSizeToShow(project));
        } else {
            response.setAcceptableRecSize(-1);
            response.setMaxRecShowSize(-1);
        }
        AsyncAccelerationTask asyncAcceleration = (AsyncAccelerationTask)AsyncTaskManager.getInstance((String)project).get("async_acceleration_task");
        Map userRefreshTag = asyncAcceleration.getUserRefreshedTagMap();
        response.setRefreshed(userRefreshTag.getOrDefault(this.aclEvaluate.getCurrentUserName(), false).booleanValue());
        return response;
    }

    public Set<Integer> accelerateManually(String project) {
        AsyncTaskManager manager;
        Map<String, Set<Integer>> modelToRecMap;
        block3: {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
            this.aclEvaluate.checkProjectReadPermission(project);
            modelToRecMap = this.getModelToRecMap(project);
            QueryHistoryAccelerateScheduler scheduler = QueryHistoryAccelerateScheduler.getInstance();
            manager = AsyncTaskManager.getInstance((String)project);
            JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
                AsyncAccelerationTask accTask = this.getAsyncAccTask(project);
                AsyncAccelerationTask copied = (AsyncAccelerationTask)manager.copyForWrite((AbstractAsyncTask)accTask);
                copied.getUserRefreshedTagMap().put(this.aclEvaluate.getCurrentUserName(), false);
                manager.save((AbstractAsyncTask)copied);
                return null;
            });
            QueryHistoryAccelerateScheduler queryHistoryAccelerateScheduler = scheduler;
            queryHistoryAccelerateScheduler.getClass();
            QueryHistoryAccelerateScheduler.QueryHistoryAccelerateRunner accelerateRunner = new QueryHistoryAccelerateScheduler.QueryHistoryAccelerateRunner(queryHistoryAccelerateScheduler, true, project);
            try {
                scheduler.scheduleImmediately(accelerateRunner);
                if (this.projectSmartSupporter != null) {
                    this.projectSmartSupporter.onUpdateCost(project);
                }
            }
            catch (Throwable e) {
                log.error("Accelerate failed", e);
                if (!(e instanceof InterruptedException)) break block3;
                Thread.currentThread().interrupt();
            }
        }
        Map<String, Set<Integer>> deltaRecsMap = this.getDeltaRecs(modelToRecMap, project);
        HashSet deltaRecSet = Sets.newHashSet();
        deltaRecsMap.forEach((k, deltaRecs) -> deltaRecSet.addAll(deltaRecs));
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            AsyncAccelerationTask accTask = this.getAsyncAccTask(project);
            AsyncAccelerationTask copied = (AsyncAccelerationTask)manager.copyForWrite((AbstractAsyncTask)accTask);
            copied.setAlreadyRunning(false);
            copied.getUserRefreshedTagMap().put(this.aclEvaluate.getCurrentUserName(), !deltaRecSet.isEmpty());
            manager.save((AbstractAsyncTask)copied);
            return null;
        });
        return deltaRecSet;
    }

    public void accelerateImmediately(String project) {
        QueryHistoryAccelerateScheduler scheduler = QueryHistoryAccelerateScheduler.getInstance();
        log.info("Schedule QueryHistoryAccelerateRunner job, project [{}].", (Object)project);
        try {
            QueryHistoryAccelerateScheduler queryHistoryAccelerateScheduler = scheduler;
            queryHistoryAccelerateScheduler.getClass();
            scheduler.scheduleImmediately(new QueryHistoryAccelerateScheduler.QueryHistoryAccelerateRunner(queryHistoryAccelerateScheduler, false, project));
        }
        catch (Exception e) {
            log.error("Accelerate failed", (Throwable)e);
        }
    }

    private int getFavoriteRuleSize(String project) {
        if (!((NProjectManager)this.getManager(NProjectManager.class)).getProject(project).isSemiAutoMode()) {
            return -1;
        }
        return (int)FavoriteRuleManager.getInstance((String)project).listAll().stream().filter(FavoriteRule::isEnabled).count();
    }

    private int[] getRecPatternCount(String project) {
        if (!((NProjectManager)this.getManager(NProjectManager.class)).getProject(project).isSemiAutoMode()) {
            return new int[]{-1, -1, -1};
        }
        int[] array = new int[3];
        RawRecManager recManager = RawRecManager.getInstance((String)project);
        Map recPatternCountMap = recManager.getCandidatesByProject(project);
        array[0] = (Integer)recPatternCountMap.get(RawRecItem.RawRecType.ADDITIONAL_LAYOUT);
        array[1] = (Integer)recPatternCountMap.get(RawRecItem.RawRecType.REMOVAL_LAYOUT);
        array[2] = array[0] + array[1];
        return array;
    }

    private int[] getDatasourceStatistics(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        int[] arr = new int[2];
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        HashSet databaseSet = Sets.newHashSet();
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        List tables = tblMgr.listAllTables().stream().filter(table -> table.isAccessible(streamingEnabled)).map(table -> {
            databaseSet.add(table.getDatabase());
            return table;
        }).collect(Collectors.toList());
        arr[0] = databaseSet.size();
        arr[1] = tables.size();
        return arr;
    }

    private int[] getApprovedRecsCount(String project) {
        ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        if (!projectInstance.isSemiAutoMode()) {
            return new int[]{-1, -1, -1};
        }
        int[] allApprovedRecs = new int[3];
        NIndexPlanManager indexPlanManager = (NIndexPlanManager)this.getManager(NIndexPlanManager.class, project);
        for (IndexPlan indexPlan : indexPlanManager.listAllIndexPlans()) {
            if (indexPlan.isBroken()) continue;
            allApprovedRecs[0] = allApprovedRecs[0] + indexPlan.getApprovedAdditionalRecs();
            allApprovedRecs[1] = allApprovedRecs[1] + indexPlan.getApprovedRemovalRecs();
        }
        allApprovedRecs[2] = allApprovedRecs[0] + allApprovedRecs[1];
        return allApprovedRecs;
    }

    private int getRecommendationSizeToShow(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        return this.projectSmartSupporter != null ? this.projectSmartSupporter.onShowSize(project) : 0;
    }

    public AsyncAccelerationTask getAsyncAccTask(String project) {
        return (AsyncAccelerationTask)AsyncTaskManager.getInstance((String)project).get("async_acceleration_task");
    }

    public Map<String, Set<Integer>> getDeltaRecs(Map<String, Set<Integer>> modelToRecMap, String project) {
        Map<String, Set<Integer>> updatedModelToRecMap = this.getModelToRecMap(project);
        modelToRecMap.forEach((modelId, recSet) -> {
            if (updatedModelToRecMap.containsKey(modelId)) {
                ((Set)updatedModelToRecMap.get(modelId)).removeAll((Collection<?>)recSet);
            }
        });
        updatedModelToRecMap.entrySet().removeIf(pair -> ((Set)pair.getValue()).isEmpty());
        return updatedModelToRecMap;
    }

    public Map<String, Set<Integer>> getModelToRecMap(String project) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        this.aclEvaluate.checkProjectReadPermission(project);
        boolean streamingEnabled = this.getConfig().isStreamingEnabled();
        List<NDataModel> dataModels = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).listAllModels().stream().filter(model -> model.isBroken() || !model.fusionModelBatchPart()).filter(model -> model.isAccessible(streamingEnabled)).collect(Collectors.toList());
        HashMap map = Maps.newHashMap();
        dataModels.forEach(model -> {
            Set cfr_ignored_0 = map.putIfAbsent(model.getId(), Sets.newHashSet());
        });
        if (((NProjectManager)this.getManager(NProjectManager.class)).getProject(project).isSemiAutoMode()) {
            OptRecManagerV2 optRecManager = OptRecManagerV2.getInstance((String)project);
            for (NDataModel model2 : dataModels) {
                OptRecV2 optRecV2 = optRecManager.loadOptRecV2(model2.getUuid());
                ((Set)map.get(model2.getId())).addAll(optRecV2.getAdditionalLayoutRefs().keySet());
                ((Set)map.get(model2.getId())).addAll(optRecV2.getRemovalLayoutRefs().keySet());
            }
        }
        return map;
    }

    public Map<String, Object> getFavoriteRules(String project) {
        HashMap result = Maps.newHashMap();
        for (String ruleName : FavoriteRule.FAVORITE_RULE_NAMES) {
            this.getSingleRule(project, ruleName, result);
        }
        return result;
    }

    private void getSingleRule(String project, String ruleName, Map<String, Object> result) {
        FavoriteRule rule = this.getFavoriteRule(project, ruleName);
        List<FavoriteRule.Condition> conditions = rule.getConds().stream().filter(condition -> condition instanceof FavoriteRule.Condition).map(condition -> (FavoriteRule.Condition)condition).collect(Collectors.toList());
        String left = null;
        String right = null;
        if (conditions.size() == 1) {
            FavoriteRule.Condition condition2 = (FavoriteRule.Condition)conditions.get(0);
            left = condition2.getLeftThreshold();
            right = condition2.getRightThreshold();
        }
        switch (ruleName) {
            case "frequency": {
                result.put("freq_enable", rule.isEnabled());
                result.put("freq_value", this.parseFloat(right));
                break;
            }
            case "count": {
                result.put("count_enable", rule.isEnabled());
                result.put("count_value", this.parseFloat(right));
                break;
            }
            case "submitter": {
                result.put("submitter_enable", rule.isEnabled());
                result.put("users", this.getUsers(conditions));
                break;
            }
            case "submitter_group": {
                result.put("user_groups", this.getUserGroups(conditions));
                break;
            }
            case "duration": {
                result.put("duration_enable", rule.isEnabled());
                result.put("min_duration", this.parseLong(left));
                result.put("max_duration", this.parseLong(right));
                break;
            }
            case "recommendations": {
                result.put("recommendation_enable", rule.isEnabled());
                result.put("recommendations_value", this.parseLong(right));
                break;
            }
            case "min_hit_count": {
                result.put("min_hit_count", this.parseInt(right));
                break;
            }
            case "effective_days": {
                result.put("effective_days", this.parseInt(right));
                break;
            }
            case "update_frequency": {
                result.put("update_frequency", this.parseInt(right));
                break;
            }
            case "frequency_time_window": {
                result.put("frequency_time_window", right);
                break;
            }
            case "low_frequency_threshold": {
                result.put("low_frequency_threshold", this.parseInt(right));
                break;
            }
        }
    }

    private List<String> getUsers(List<FavoriteRule.Condition> conditionList) {
        ArrayList users = Lists.newArrayList();
        conditionList.forEach(cond -> {
            if ("ADMIN".equalsIgnoreCase(cond.getRightThreshold()) || this.userService.userExists(cond.getRightThreshold())) {
                users.add(cond.getRightThreshold());
            }
        });
        return users;
    }

    private List<String> getUserGroups(List<FavoriteRule.Condition> conditionList) {
        ArrayList userGroups = Lists.newArrayList();
        for (FavoriteRule.Condition cond : conditionList) {
            if (!"ROLE_ADMIN".equalsIgnoreCase(cond.getRightThreshold()) && !this.userGroupService.exists(cond.getRightThreshold())) continue;
            userGroups.add(cond.getRightThreshold());
        }
        return userGroups;
    }

    private Integer parseInt(String str) {
        return StringUtils.isEmpty((CharSequence)str) ? null : Integer.valueOf(Integer.parseInt(str));
    }

    private Float parseFloat(String str) {
        return StringUtils.isEmpty((CharSequence)str) ? null : Float.valueOf(Float.parseFloat(str));
    }

    private Long parseLong(String str) {
        return StringUtils.isEmpty((CharSequence)str) ? null : Long.valueOf(Long.parseLong(str));
    }

    private FavoriteRule getFavoriteRule(String project, String ruleName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)project));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)ruleName));
        return FavoriteRuleManager.getInstance((String)project).getOrDefaultByName(ruleName);
    }

    public Map<String, Object> getAutoIndexPlanRule(String project) {
        HashMap result = Maps.newHashMap();
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        manager.listAutoIndexPlanRules().forEach(rule -> result.put(rule.getName(), AutoIndexPlanRuleUtil.getRuleValue(rule)));
        if (!this.isEnableAutoSemi(project)) {
            result.put("index_planner_enable", false);
        }
        return result;
    }

    public boolean isEnableAutoSemi(String project) {
        ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        KylinConfigExt config = projectInstance.getConfig();
        return config.isSemiAutoMode();
    }

    public void updateAutoIndexPlanRule(String project, AutoIndexPlanRuleUpdateRequest request) {
        this.aclEvaluate.checkProjectWritePermission(project);
        FavoriteRuleManager manager = FavoriteRuleManager.getInstance((String)project);
        JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            FavoriteRule.AUTO_INDEX_PLAN_RULE_NAMES.stream().filter(ruleName -> !ruleName.equals("auto_index_plan_option")).forEach(ruleName -> {
                List<FavoriteRule.AbstractCondition> conds = AutoIndexPlanRuleUtil.getConditionsFromUpdateRequest(ruleName, request);
                manager.updateRule(conds, true, ruleName);
            });
            return null;
        });
    }
}

