/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.CrossRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class CrossRelNode
implements RelNode,
Serializable {
    private final RelNode left;
    private final RelNode right;
    private final CrossRel.JoinType joinType;
    private final ExpressionNode expression;
    private final AdvancedExtensionNode extensionNode;

    CrossRelNode(RelNode left, RelNode right, CrossRel.JoinType joinType, ExpressionNode expression, AdvancedExtensionNode extensionNode) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.expression = expression;
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        CrossRel.Builder crossRelBuilder = CrossRel.newBuilder();
        crossRelBuilder.setCommon(relCommonBuilder.build());
        crossRelBuilder.setType(this.joinType);
        if (this.left != null) {
            crossRelBuilder.setLeft(this.left.toProtobuf());
        }
        if (this.right != null) {
            crossRelBuilder.setRight(this.right.toProtobuf());
        }
        if (this.expression != null) {
            crossRelBuilder.setExpression(this.expression.toProtobuf());
        }
        if (this.extensionNode != null) {
            crossRelBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        return Rel.newBuilder().setCross(crossRelBuilder.build()).build();
    }
}

