/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc.store;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.Serializer;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.integration.store.AbstractMessageGroupStore;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupMetadata;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.MessageMetadata;
import org.springframework.integration.store.MessageStore;
import org.springframework.integration.store.SimpleMessageGroup;
import org.springframework.integration.support.converter.AllowListDeserializingConverter;
import org.springframework.integration.util.UUIDConverter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jdbc.support.lob.DefaultLobHandler;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JdbcMessageStore
extends AbstractMessageGroupStore
implements MessageStore,
BeanClassLoaderAware {
    public static final String DEFAULT_TABLE_PREFIX = "INT_";
    private final MessageMapper mapper = new MessageMapper();
    private final JdbcOperations jdbcTemplate;
    private final String vendorName;
    private final Map<Query, String> queryCache = new ConcurrentHashMap<Query, String>();
    private String region = "DEFAULT";
    private String tablePrefix = "INT_";
    private AllowListDeserializingConverter deserializer = new AllowListDeserializingConverter(JdbcMessageStore.class.getClassLoader());
    private boolean deserializerExplicitlySet;
    private SerializingConverter serializer;
    private LobHandler lobHandler = new DefaultLobHandler();

    public JdbcMessageStore(DataSource dataSource) {
        this((JdbcOperations)new JdbcTemplate(dataSource));
    }

    public JdbcMessageStore(JdbcOperations jdbcOperations) {
        Assert.notNull((Object)jdbcOperations, (String)"'dataSource' must not be null");
        this.jdbcTemplate = jdbcOperations;
        this.serializer = new SerializingConverter();
        try {
            this.vendorName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)((JdbcAccessor)jdbcOperations).getDataSource(), DatabaseMetaData::getDatabaseProductName);
        }
        catch (MetaDataAccessException ex) {
            throw new IllegalStateException("Cannot extract database vendor name", ex);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        if (!this.deserializerExplicitlySet) {
            this.deserializer = new AllowListDeserializingConverter(classLoader);
        }
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setRegion(String region) {
        Assert.hasText((String)region, (String)"Region must not be null or empty.");
        this.region = region;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setSerializer(Serializer<? super Message<?>> serializer) {
        this.serializer = new SerializingConverter(serializer);
    }

    public void setDeserializer(Deserializer<? extends Message<?>> deserializer) {
        this.deserializer = new AllowListDeserializingConverter(deserializer);
        this.deserializerExplicitlySet = true;
    }

    public void addAllowedPatterns(String ... patterns) {
        this.deserializer.addAllowedPatterns(patterns);
    }

    public Message<?> removeMessage(UUID id) {
        Message<?> message = this.getMessage(id);
        if (message == null) {
            return null;
        }
        int updated = this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE), new Object[]{this.getKey(id), this.region});
        if (updated != 0) {
            return message;
        }
        return null;
    }

    @ManagedAttribute
    public long getMessageCount() {
        return (Long)this.jdbcTemplate.queryForObject(this.getQuery(Query.GET_MESSAGE_COUNT), Long.class, new Object[]{this.region});
    }

    public Message<?> getMessage(UUID id) {
        List list = this.jdbcTemplate.query(this.getQuery(Query.GET_MESSAGE), (RowMapper)this.mapper, new Object[]{this.getKey(id), this.region});
        if (list.isEmpty()) {
            return null;
        }
        return (Message)list.get(0);
    }

    public MessageMetadata getMessageMetadata(UUID id) {
        List list = this.jdbcTemplate.query(this.getQuery(Query.GET_MESSAGE), (rs, rn) -> {
            MessageMetadata messageMetadata = new MessageMetadata(UUID.fromString(rs.getString("MESSAGE_ID")));
            messageMetadata.setTimestamp(rs.getTimestamp("CREATED_DATE").getTime());
            return messageMetadata;
        }, new Object[]{this.getKey(id), this.region});
        if (list.isEmpty()) {
            return null;
        }
        return (MessageMetadata)list.get(0);
    }

    public <T> Message<T> addMessage(Message<T> message) {
        UUID id = message.getHeaders().getId();
        Assert.notNull((Object)id, (String)"Cannot store messages without an ID header");
        String messageId = this.getKey(id);
        byte[] messageBytes = this.serializer.convert(message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Inserting message with id key=" + messageId));
        }
        try {
            this.jdbcTemplate.update(this.getQuery(Query.CREATE_MESSAGE), ps -> {
                ps.setString(1, messageId);
                ps.setString(2, this.region);
                ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                this.lobHandler.getLobCreator().setBlobAsBytes(ps, 4, messageBytes);
            });
        }
        catch (DuplicateKeyException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("The Message with id [" + id + "] already exists.\nIgnoring INSERT and SELECT existing..."));
            }
            return this.getMessage(id);
        }
        return message;
    }

    public void addMessagesToGroup(Object groupId, Message<?> ... messages) {
        String groupKey = this.getKey(groupId);
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupKey);
        boolean groupNotExist = groupMetadata == null;
        Timestamp createdDate = groupNotExist ? new Timestamp(System.currentTimeMillis()) : new Timestamp(groupMetadata.getTimestamp());
        for (Message<?> message : messages) {
            this.addMessage(message);
        }
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.CREATE_GROUP_TO_MESSAGE), Arrays.asList(messages), 100, (ps, messageToAdd) -> {
            String messageId = this.getKey(messageToAdd.getHeaders().getId());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Inserting message with id key=" + messageId + " and created date=" + createdDate));
            }
            ps.setString(1, groupKey);
            ps.setString(2, messageId);
            ps.setString(3, this.region);
        });
        if (groupNotExist) {
            try {
                this.doCreateMessageGroup(groupKey, createdDate);
            }
            catch (DuplicateKeyException e) {
                this.logger.warn((Object)"Lost race to create group; attempting update instead", (Throwable)e);
                this.updateMessageGroup(groupKey);
            }
        } else {
            this.updateMessageGroup(groupKey);
        }
    }

    @ManagedAttribute
    public int getMessageGroupCount() {
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_GROUPS), Integer.class, new Object[]{this.region});
    }

    @ManagedAttribute
    public int getMessageCountForAllMessageGroups() {
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_MESSAGES_IN_GROUPS), Integer.class, new Object[]{this.region});
    }

    @ManagedAttribute
    public int messageGroupSize(Object groupId) {
        String key = this.getKey(groupId);
        return (Integer)this.jdbcTemplate.queryForObject(this.getQuery(Query.COUNT_ALL_MESSAGES_IN_GROUP), Integer.class, new Object[]{key, this.region});
    }

    public MessageGroup getMessageGroup(Object groupId) {
        MessageGroupMetadata groupMetadata = this.getGroupMetadata(groupId);
        if (groupMetadata != null) {
            MessageGroup messageGroup = this.getMessageGroupFactory().create((MessageGroupStore)this, groupId, groupMetadata.getTimestamp(), groupMetadata.isComplete());
            messageGroup.setLastModified(groupMetadata.getLastModified());
            messageGroup.setLastReleasedMessageSequenceNumber(groupMetadata.getLastReleasedMessageSequenceNumber());
            messageGroup.setCondition(groupMetadata.getCondition());
            return messageGroup;
        }
        return new SimpleMessageGroup(groupId);
    }

    public MessageGroupMetadata getGroupMetadata(Object groupId) {
        String key = this.getKey(groupId);
        try {
            return (MessageGroupMetadata)this.jdbcTemplate.queryForObject(this.getQuery(Query.GET_GROUP_INFO), (rs, rowNum) -> {
                MessageGroupMetadata groupMetadata = new MessageGroupMetadata();
                if (rs.getInt("COMPLETE") > 0) {
                    groupMetadata.complete();
                }
                groupMetadata.setTimestamp(rs.getTimestamp("CREATED_DATE").getTime());
                groupMetadata.setLastModified(rs.getTimestamp("UPDATED_DATE").getTime());
                groupMetadata.setLastReleasedMessageSequenceNumber(rs.getInt("LAST_RELEASED_SEQUENCE"));
                groupMetadata.setCondition(rs.getString("CONDITION"));
                return groupMetadata;
            }, new Object[]{key, this.region});
        }
        catch (IncorrectResultSizeDataAccessException ex) {
            return null;
        }
    }

    public void removeMessagesFromGroup(Object groupId, Collection<Message<?>> messages) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        Assert.notNull(messages, (String)"'messages' must not be null");
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing messages from group with group key=" + groupKey));
        }
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.REMOVE_MESSAGE_FROM_GROUP), messages, this.getRemoveBatchSize(), (ps, messageToRemove) -> {
            ps.setString(1, groupKey);
            ps.setString(2, this.getKey(messageToRemove.getHeaders().getId()));
            ps.setString(3, this.region);
        });
        this.jdbcTemplate.batchUpdate(this.getQuery(Query.DELETE_MESSAGE), messages, this.getRemoveBatchSize(), (ps, messageToRemove) -> {
            ps.setString(1, this.getKey(messageToRemove.getHeaders().getId()));
            ps.setString(2, this.region);
        });
        this.updateMessageGroup(groupKey);
    }

    public void removeMessageGroup(Object groupId) {
        String groupKey = this.getKey(groupId);
        this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGES_FROM_GROUP), new Object[]{groupKey, this.region, this.region});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing relationships for the group with group key=" + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.REMOVE_GROUP_TO_MESSAGE_JOIN), new Object[]{groupKey, this.region});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleting messages with group key=" + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.DELETE_MESSAGE_GROUP), new Object[]{groupKey, this.region});
    }

    public void completeGroup(Object groupId) {
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Completing MessageGroup: " + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.COMPLETE_GROUP), new Object[]{new Timestamp(System.currentTimeMillis()), groupKey, this.region});
    }

    public void setGroupCondition(Object groupId, String condition) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        String groupKey = this.getKey(groupId);
        Timestamp updatedDate = new Timestamp(System.currentTimeMillis());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating message group with id key=" + groupKey + " and updated date=" + updatedDate));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_MESSAGE_GROUP), new Object[]{updatedDate, condition, groupKey, this.region});
    }

    public void setLastReleasedSequenceNumberForGroup(Object groupId, int sequenceNumber) {
        Assert.notNull((Object)groupId, (String)"'groupId' must not be null");
        String groupKey = this.getKey(groupId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating  the sequence number of the last released Message in the MessageGroup: " + groupKey));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_LAST_RELEASED_SEQUENCE), new Object[]{new Timestamp(System.currentTimeMillis()), sequenceNumber, groupKey, this.region});
    }

    public Message<?> pollMessageFromGroup(Object groupId) {
        String key = this.getKey(groupId);
        Message<?> polledMessage = this.doPollForMessage(key);
        if (polledMessage != null) {
            this.removeMessagesFromGroup(groupId, new Message[]{polledMessage});
        }
        return polledMessage;
    }

    public Message<?> getOneMessageFromGroup(Object groupId) {
        return this.doPollForMessage(this.getKey(groupId));
    }

    public Collection<Message<?>> getMessagesForGroup(Object groupId) {
        return this.jdbcTemplate.query(this.getQuery(Query.LIST_MESSAGES_BY_GROUP_KEY), (RowMapper)this.mapper, new Object[]{this.getKey(groupId), this.region, this.region});
    }

    public Stream<Message<?>> streamMessagesForGroup(Object groupId) {
        return this.jdbcTemplate.queryForStream(this.getQuery(Query.LIST_MESSAGES_BY_GROUP_KEY), (RowMapper)this.mapper, new Object[]{this.getKey(groupId), this.region, this.region});
    }

    public Iterator<MessageGroup> iterator() {
        final Iterator iterator = this.jdbcTemplate.query(this.getQuery(Query.LIST_GROUP_KEYS), (RowMapper)new SingleColumnRowMapper(), new Object[]{this.region}).iterator();
        return new Iterator<MessageGroup>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public MessageGroup next() {
                return JdbcMessageStore.this.getMessageGroup(iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove MessageGroup from this iterator.");
            }
        };
    }

    protected String getQuery(Query base) {
        return this.queryCache.computeIfAbsent(base, query -> {
            String parsedSql = StringUtils.replace((String)query.getSql(), (String)"%PREFIX%", (String)this.tablePrefix);
            if ((Query.GET_GROUP_INFO.equals((Object)base) || Query.UPDATE_MESSAGE_GROUP.equals((Object)base)) && this.vendorName.equals("MySQL")) {
                parsedSql = parsedSql.replaceFirst("\"(CONDITION)\"", "`$1`");
            }
            return parsedSql;
        });
    }

    protected JdbcOperations getJdbcOperations() {
        return this.jdbcTemplate;
    }

    protected Message<?> doPollForMessage(String groupIdKey) {
        List messages = this.jdbcTemplate.query(this.getQuery(Query.POLL_FROM_GROUP), (RowMapper)this.mapper, new Object[]{groupIdKey, this.region, groupIdKey, this.region});
        Assert.state((messages.size() < 2 ? 1 : 0) != 0, () -> "The query must return zero or 1 row; got " + messages.size() + " rows");
        if (messages.size() > 0) {
            return (Message)messages.get(0);
        }
        return null;
    }

    private void doCreateMessageGroup(String groupKey, Timestamp createdDate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating message group with id key=" + groupKey + " and created date=" + createdDate));
        }
        this.jdbcTemplate.update(this.getQuery(Query.CREATE_MESSAGE_GROUP), new Object[]{groupKey, this.region, createdDate, createdDate});
    }

    private void updateMessageGroup(String groupId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Updating MessageGroup: " + groupId));
        }
        this.jdbcTemplate.update(this.getQuery(Query.UPDATE_GROUP), new Object[]{new Timestamp(System.currentTimeMillis()), groupId, this.region});
    }

    private String getKey(Object input) {
        return input == null ? null : UUIDConverter.getUUID((Object)input).toString();
    }

    private class MessageMapper
    implements RowMapper<Message<?>> {
        private MessageMapper() {
        }

        public Message<?> mapRow(ResultSet rs, int rowNum) throws SQLException {
            byte[] messageBytes = JdbcMessageStore.this.lobHandler.getBlobAsBytes(rs, "MESSAGE_BYTES");
            if (messageBytes == null) {
                return null;
            }
            return (Message)JdbcMessageStore.this.deserializer.convert(messageBytes);
        }
    }

    private static enum Query {
        CREATE_MESSAGE_GROUP("INSERT into %PREFIX%MESSAGE_GROUP(GROUP_KEY, REGION, COMPLETE, LAST_RELEASED_SEQUENCE, CREATED_DATE, UPDATED_DATE) values (?, ?, 0, 0, ?, ?)"),
        UPDATE_MESSAGE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=?, \"CONDITION\"=? where GROUP_KEY=? and REGION=?"),
        REMOVE_MESSAGE_FROM_GROUP("DELETE from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY=? and MESSAGE_ID=? and REGION=?"),
        REMOVE_GROUP_TO_MESSAGE_JOIN("DELETE from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY=? and REGION=?"),
        COUNT_ALL_MESSAGES_IN_GROUPS("SELECT COUNT(MESSAGE_ID) from %PREFIX%GROUP_TO_MESSAGE where REGION=?"),
        COUNT_ALL_MESSAGES_IN_GROUP("SELECT COUNT(MESSAGE_ID) from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY=? and REGION=?"),
        LIST_MESSAGES_BY_GROUP_KEY("SELECT MESSAGE_ID, MESSAGE_BYTES, CREATED_DATE from %PREFIX%MESSAGE where MESSAGE_ID in (SELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY = ? and REGION = ?) and REGION = ? ORDER BY CREATED_DATE"),
        POLL_FROM_GROUP("SELECT %PREFIX%MESSAGE.MESSAGE_ID, %PREFIX%MESSAGE.MESSAGE_BYTES from %PREFIX%MESSAGE where %PREFIX%MESSAGE.MESSAGE_ID = (SELECT min(m.MESSAGE_ID) from %PREFIX%MESSAGE m join %PREFIX%GROUP_TO_MESSAGE on m.MESSAGE_ID = %PREFIX%GROUP_TO_MESSAGE.MESSAGE_ID where CREATED_DATE = (SELECT min(CREATED_DATE) from %PREFIX%MESSAGE, %PREFIX%GROUP_TO_MESSAGE where %PREFIX%MESSAGE.MESSAGE_ID = %PREFIX%GROUP_TO_MESSAGE.MESSAGE_ID and %PREFIX%GROUP_TO_MESSAGE.GROUP_KEY = ? and %PREFIX%MESSAGE.REGION = ?) and %PREFIX%GROUP_TO_MESSAGE.GROUP_KEY = ? and m.REGION = ?)"),
        GET_GROUP_INFO("SELECT COMPLETE, LAST_RELEASED_SEQUENCE, CREATED_DATE, UPDATED_DATE, \"CONDITION\" from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=?"),
        GET_MESSAGE("SELECT MESSAGE_ID, CREATED_DATE, MESSAGE_BYTES from %PREFIX%MESSAGE where MESSAGE_ID=? and REGION=?"),
        GET_MESSAGE_COUNT("SELECT COUNT(MESSAGE_ID) from %PREFIX%MESSAGE where REGION=?"),
        DELETE_MESSAGE("DELETE from %PREFIX%MESSAGE where MESSAGE_ID=? and REGION=?"),
        CREATE_MESSAGE("INSERT into %PREFIX%MESSAGE(MESSAGE_ID, REGION, CREATED_DATE, MESSAGE_BYTES) values (?, ?, ?, ?)"),
        COUNT_ALL_GROUPS("SELECT COUNT(GROUP_KEY) from %PREFIX%MESSAGE_GROUP where REGION=?"),
        COMPLETE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=?, COMPLETE=1 where GROUP_KEY=? and REGION=?"),
        UPDATE_LAST_RELEASED_SEQUENCE("UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=?, LAST_RELEASED_SEQUENCE=? where GROUP_KEY=? and REGION=?"),
        DELETE_MESSAGES_FROM_GROUP("DELETE from %PREFIX%MESSAGE where MESSAGE_ID in (SELECT MESSAGE_ID from %PREFIX%GROUP_TO_MESSAGE where GROUP_KEY = ? and REGION = ?) and REGION = ?"),
        DELETE_MESSAGE_GROUP("DELETE from %PREFIX%MESSAGE_GROUP where GROUP_KEY=? and REGION=?"),
        CREATE_GROUP_TO_MESSAGE("INSERT into %PREFIX%GROUP_TO_MESSAGE(GROUP_KEY, MESSAGE_ID, REGION) values (?, ?, ?)"),
        UPDATE_GROUP("UPDATE %PREFIX%MESSAGE_GROUP set UPDATED_DATE=? where GROUP_KEY=? and REGION=?"),
        LIST_GROUP_KEYS("SELECT distinct GROUP_KEY as CREATED from %PREFIX%MESSAGE_GROUP where REGION=?");

        private final String sql;

        private Query(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

