/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import org.apache.iceberg.transforms.Dates;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.TimeTransform;
import org.apache.iceberg.transforms.Timestamps;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.transforms.Years;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class Months<T>
extends TimeTransform<T> {
    private static final Months<?> INSTANCE = new Months();

    static <T> Months<T> get() {
        return INSTANCE;
    }

    @Override
    protected Transform<T, Integer> toEnum(Type type) {
        switch (type.typeId()) {
            case DATE: {
                return Dates.MONTH;
            }
            case TIMESTAMP: {
                return Timestamps.MONTH;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return Types.IntegerType.get();
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Timestamps) {
            return Timestamps.MONTH.satisfiesOrderOf(other);
        }
        if (other instanceof Dates) {
            return Dates.MONTH.satisfiesOrderOf(other);
        }
        return other instanceof Months || other instanceof Years;
    }

    @Override
    public String toHumanString(Type alwaysInt, Integer value) {
        return value != null ? TransformUtil.humanMonth(value) : "null";
    }

    public String toString() {
        return "month";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.MonthsTransformProxy.get();
    }
}

