/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FSProtos;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.protocolPB.PBHelper;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class FileStatus
implements Writable,
Comparable<Object>,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 332065512L;
    private Path path;
    private long length;
    private Boolean isdir;
    private short block_replication;
    private long blocksize;
    private long modification_time;
    private long access_time;
    private FsPermission permission;
    private String owner;
    private String group;
    private Path symlink;
    private Set<AttrFlags> attr;
    public static final Set<AttrFlags> NONE = Collections.emptySet();

    public static Set<AttrFlags> attributes(boolean acl, boolean crypt, boolean ec, boolean sn) {
        if (!(acl || crypt || ec || sn)) {
            return NONE;
        }
        EnumSet<AttrFlags> ret = EnumSet.noneOf(AttrFlags.class);
        if (acl) {
            ret.add(AttrFlags.HAS_ACL);
        }
        if (crypt) {
            ret.add(AttrFlags.HAS_CRYPT);
        }
        if (ec) {
            ret.add(AttrFlags.HAS_EC);
        }
        if (sn) {
            ret.add(AttrFlags.SNAPSHOT_ENABLED);
        }
        return ret;
    }

    public FileStatus() {
        this(0L, false, 0, 0L, 0L, 0L, null, null, null, null);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, Path path) {
        this(length, isdir, block_replication, blocksize, modification_time, 0L, null, null, null, path);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path path) {
        this(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, null, path);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path) {
        this(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, false, false, false);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, boolean hasAcl, boolean isEncrypted, boolean isErasureCoded) {
        this(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path, FileStatus.attributes(hasAcl, isEncrypted, isErasureCoded, false));
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, Set<AttrFlags> attr) {
        this.length = length;
        this.isdir = isdir;
        this.block_replication = (short)block_replication;
        this.blocksize = blocksize;
        this.modification_time = modification_time;
        this.access_time = access_time;
        this.permission = permission != null ? permission : (isdir ? FsPermission.getDirDefault() : (symlink != null ? FsPermission.getDefault() : FsPermission.getFileDefault()));
        this.owner = owner == null ? "" : owner;
        this.group = group == null ? "" : group;
        this.symlink = symlink;
        this.path = path;
        this.attr = attr;
        assert (isdir && symlink == null || !isdir);
    }

    public FileStatus(FileStatus other) throws IOException {
        this(other.getLen(), other.isDirectory(), other.getReplication(), other.getBlockSize(), other.getModificationTime(), other.getAccessTime(), other.getPermission(), other.getOwner(), other.getGroup(), other.isSymlink() ? other.getSymlink() : null, other.getPath());
    }

    public long getLen() {
        return this.length;
    }

    public boolean isFile() {
        return !this.isDirectory() && !this.isSymlink();
    }

    public boolean isDirectory() {
        return this.isdir;
    }

    @Deprecated
    public final boolean isDir() {
        return this.isDirectory();
    }

    public boolean isSymlink() {
        return this.symlink != null;
    }

    public long getBlockSize() {
        return this.blocksize;
    }

    public short getReplication() {
        return this.block_replication;
    }

    public long getModificationTime() {
        return this.modification_time;
    }

    public long getAccessTime() {
        return this.access_time;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public boolean hasAcl() {
        return this.attr.contains((Object)AttrFlags.HAS_ACL);
    }

    public boolean isEncrypted() {
        return this.attr.contains((Object)AttrFlags.HAS_CRYPT);
    }

    public boolean isErasureCoded() {
        return this.attr.contains((Object)AttrFlags.HAS_EC);
    }

    public boolean isSnapshotEnabled() {
        return this.attr.contains((Object)AttrFlags.SNAPSHOT_ENABLED);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path p) {
        this.path = p;
    }

    protected void setPermission(FsPermission permission) {
        this.permission = permission == null ? FsPermission.getFileDefault() : permission;
    }

    protected void setOwner(String owner) {
        this.owner = owner == null ? "" : owner;
    }

    protected void setGroup(String group) {
        this.group = group == null ? "" : group;
    }

    public Path getSymlink() throws IOException {
        if (!this.isSymlink()) {
            throw new IOException("Path " + this.path + " is not a symbolic link");
        }
        return this.symlink;
    }

    public void setSymlink(Path p) {
        this.symlink = p;
    }

    @Override
    public int compareTo(FileStatus o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public int compareTo(Object o) {
        FileStatus other = (FileStatus)o;
        return this.compareTo(other);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileStatus)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        FileStatus other = (FileStatus)o;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("{").append("path=" + this.path).append("; isDirectory=" + this.isdir);
        if (!this.isDirectory()) {
            sb.append("; length=" + this.length).append("; replication=" + this.block_replication).append("; blocksize=" + this.blocksize);
        }
        sb.append("; modification_time=" + this.modification_time).append("; access_time=" + this.access_time).append("; owner=" + this.owner).append("; group=" + this.group).append("; permission=" + this.permission).append("; isSymlink=" + this.isSymlink());
        if (this.isSymlink()) {
            try {
                sb.append("; symlink=" + this.getSymlink());
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
        }
        sb.append("; hasAcl=" + this.hasAcl()).append("; isEncrypted=" + this.isEncrypted()).append("; isErasureCoded=" + this.isErasureCoded()).append("}");
        return sb.toString();
    }

    @Override
    @Deprecated
    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        if (size < 0) {
            throw new IOException("Can't read FileStatusProto with negative size of " + size);
        }
        byte[] buf = new byte[size];
        in.readFully(buf);
        FSProtos.FileStatusProto proto = FSProtos.FileStatusProto.parseFrom(buf);
        FileStatus other = PBHelper.convert(proto);
        this.isdir = other.isDirectory();
        this.length = other.getLen();
        this.block_replication = other.getReplication();
        this.blocksize = other.getBlockSize();
        this.modification_time = other.getModificationTime();
        this.access_time = other.getAccessTime();
        this.setPermission(other.getPermission());
        this.setOwner(other.getOwner());
        this.setGroup(other.getGroup());
        this.setSymlink(other.isSymlink() ? other.getSymlink() : null);
        this.setPath(other.getPath());
        this.attr = FileStatus.attributes(other.hasAcl(), other.isEncrypted(), other.isErasureCoded(), other.isSnapshotEnabled());
        assert (!this.isDirectory() || !this.isSymlink()) : "A directory cannot be a symlink";
    }

    @Override
    @Deprecated
    public void write(DataOutput out) throws IOException {
        FSProtos.FileStatusProto proto = PBHelper.convert(this);
        int size = proto.getSerializedSize();
        out.writeInt(size);
        out.write(proto.toByteArray());
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (null == this.path) {
            throw new InvalidObjectException("No Path in deserialized FileStatus");
        }
        if (null == this.isdir) {
            throw new InvalidObjectException("No type in deserialized FileStatus");
        }
    }

    public static enum AttrFlags {
        HAS_ACL,
        HAS_CRYPT,
        HAS_EC,
        SNAPSHOT_ENABLED;

    }
}

