/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.netty.handler.codec.socks;

import java.util.List;
import org.apache.kyuubi.shade.io.netty.buffer.ByteBuf;
import org.apache.kyuubi.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.kyuubi.shade.io.netty.handler.codec.ReplayingDecoder;
import org.apache.kyuubi.shade.io.netty.handler.codec.socks.SocksAuthScheme;
import org.apache.kyuubi.shade.io.netty.handler.codec.socks.SocksCommonUtils;
import org.apache.kyuubi.shade.io.netty.handler.codec.socks.SocksInitResponse;
import org.apache.kyuubi.shade.io.netty.handler.codec.socks.SocksProtocolVersion;

public class SocksInitResponseDecoder
extends ReplayingDecoder<State> {
    public SocksInitResponseDecoder() {
        super(State.CHECK_PROTOCOL_VERSION);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) throws Exception {
        switch ((State)((Object)this.state())) {
            case CHECK_PROTOCOL_VERSION: {
                if (byteBuf.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    out.add(SocksCommonUtils.UNKNOWN_SOCKS_RESPONSE);
                    break;
                }
                this.checkpoint(State.READ_PREFERRED_AUTH_TYPE);
            }
            case READ_PREFERRED_AUTH_TYPE: {
                SocksAuthScheme authScheme = SocksAuthScheme.valueOf(byteBuf.readByte());
                out.add(new SocksInitResponse(authScheme));
                break;
            }
            default: {
                throw new Error("Unexpected response decoder type: " + this.state());
            }
        }
        ctx.pipeline().remove(this);
    }

    public static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_PREFERRED_AUTH_TYPE;

    }
}

