/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.luke.app.Observer;
import org.apache.lucene.luke.util.LoggerFactory;

public abstract class AbstractHandler<T extends Observer> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private List<T> observers = new ArrayList<T>();

    public void addObserver(T observer) {
        this.observers.add(observer);
        if (log.isLoggable(Level.FINE)) {
            log.fine(observer.getClass().getName() + " registered.");
        }
    }

    void notifyObservers() {
        for (Observer observer : this.observers) {
            this.notifyOne(observer);
        }
    }

    protected abstract void notifyOne(T var1);
}

