/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.knn.DemoEmbeddings;
import org.apache.lucene.demo.knn.KnnVectorDict;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.KnnFloatVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;

public class SearchFiles {
    private SearchFiles() {
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage:\tjava org.apache.lucene.demo.SearchFiles [-index dir] [-field f] [-repeat n] [-queries file] [-query string] [-raw] [-paging hitsPerPage] [-knn_vector knnHits]\n\nSee http://lucene.apache.org/core/9_0_0/demo/ for details.";
        if (args.length > 0 && ("-h".equals(args[0]) || "-help".equals(args[0]))) {
            System.out.println(usage);
            System.exit(0);
        }
        String index = "index";
        String field = "contents";
        String queries = null;
        int repeat = 0;
        boolean raw = false;
        int knnVectors = 0;
        String queryString = null;
        int hitsPerPage = 10;
        block20: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-index": {
                    index = args[++i];
                    continue block20;
                }
                case "-field": {
                    field = args[++i];
                    continue block20;
                }
                case "-queries": {
                    queries = args[++i];
                    continue block20;
                }
                case "-query": {
                    queryString = args[++i];
                    continue block20;
                }
                case "-repeat": {
                    repeat = Integer.parseInt(args[++i]);
                    continue block20;
                }
                case "-raw": {
                    raw = true;
                    continue block20;
                }
                case "-paging": {
                    hitsPerPage = Integer.parseInt(args[++i]);
                    if (hitsPerPage > 0) continue block20;
                    System.err.println("There must be at least 1 hit per page.");
                    System.exit(1);
                    continue block20;
                }
                case "-knn_vector": {
                    knnVectors = Integer.parseInt(args[++i]);
                    continue block20;
                }
                default: {
                    System.err.println("Unknown argument: " + args[i]);
                    System.exit(1);
                }
            }
        }
        DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)Paths.get(index, new String[0])));
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        StandardAnalyzer analyzer = new StandardAnalyzer();
        KnnVectorDict vectorDict = null;
        if (knnVectors > 0) {
            vectorDict = new KnnVectorDict(reader.directory(), "knn-dict");
        }
        BufferedReader in = queries != null ? Files.newBufferedReader(Paths.get(queries, new String[0]), StandardCharsets.UTF_8) : new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        QueryParser parser = new QueryParser(field, (Analyzer)analyzer);
        do {
            String line;
            if (queries == null && queryString == null) {
                System.out.println("Enter query: ");
            }
            String string = line = queryString != null ? queryString : in.readLine();
            if (line == null || line.length() == -1 || (line = line.trim()).length() == 0) break;
            Query query = parser.parse(line);
            if (knnVectors > 0) {
                query = SearchFiles.addSemanticQuery(query, vectorDict, knnVectors);
            }
            System.out.println("Searching for: " + query.toString(field));
            if (repeat > 0) {
                Date start = new Date();
                for (int i = 0; i < repeat; ++i) {
                    searcher.search(query, 100);
                }
                Date end = new Date();
                System.out.println("Time: " + (end.getTime() - start.getTime()) + "ms");
            }
            SearchFiles.doPagingSearch(in, searcher, query, hitsPerPage, raw, queries == null && queryString == null);
        } while (queryString == null);
        IOUtils.close((Closeable[])new Closeable[]{vectorDict, reader});
    }

    public static void doPagingSearch(BufferedReader in, IndexSearcher searcher, Query query, int hitsPerPage, boolean raw, boolean interactive) throws IOException {
        TopDocs results = searcher.search(query, 5 * hitsPerPage);
        ScoreDoc[] hits = results.scoreDocs;
        int numTotalHits = Math.toIntExact(results.totalHits.value());
        System.out.println(numTotalHits + " total matching documents");
        int start = 0;
        int end = Math.min(numTotalHits, hitsPerPage);
        while (true) {
            if (end > hits.length) {
                System.out.println("Only results 1 - " + hits.length + " of " + numTotalHits + " total matching documents collected.");
                System.out.println("Collect more (y/n) ?");
                String line = in.readLine();
                if (line == null || line.length() == 0 || line.charAt(0) == 'n') break;
                hits = searcher.search((Query)query, (int)numTotalHits).scoreDocs;
            }
            end = Math.min(hits.length, start + hitsPerPage);
            StoredFields storedFields = searcher.storedFields();
            for (int i = start; i < end; ++i) {
                if (raw) {
                    System.out.println("doc=" + hits[i].doc + " score=" + hits[i].score);
                    continue;
                }
                Document doc = storedFields.document(hits[i].doc);
                String path = doc.get("path");
                if (path != null) {
                    System.out.println(i + 1 + ". " + path);
                    String title = doc.get("title");
                    if (title == null) continue;
                    System.out.println("   Title: " + title);
                    continue;
                }
                System.out.println(i + 1 + ". No path for this document");
            }
            if (!interactive || end == 0) break;
            if (numTotalHits < end) continue;
            boolean quit = false;
            while (true) {
                System.out.print("Press ");
                if (start - hitsPerPage >= 0) {
                    System.out.print("(p)revious page, ");
                }
                if (start + hitsPerPage < numTotalHits) {
                    System.out.print("(n)ext page, ");
                }
                System.out.println("(q)uit or enter number to jump to a page.");
                String line = in.readLine();
                if (line == null || line.length() == 0 || line.charAt(0) == 'q') {
                    quit = true;
                    break;
                }
                if (line.charAt(0) == 'p') {
                    start = Math.max(0, start - hitsPerPage);
                    break;
                }
                if (line.charAt(0) == 'n') {
                    if (start + hitsPerPage >= numTotalHits) break;
                    start += hitsPerPage;
                    break;
                }
                int page = Integer.parseInt(line);
                if ((page - 1) * hitsPerPage < numTotalHits) {
                    start = (page - 1) * hitsPerPage;
                    break;
                }
                System.out.println("No such page");
            }
            if (quit) break;
            end = Math.min(numTotalHits, start + hitsPerPage);
        }
    }

    private static Query addSemanticQuery(Query query, KnnVectorDict vectorDict, int k) throws IOException {
        StringBuilder semanticQueryText = new StringBuilder();
        QueryFieldTermExtractor termExtractor = new QueryFieldTermExtractor("contents");
        query.visit((QueryVisitor)termExtractor);
        for (String term : termExtractor.terms) {
            semanticQueryText.append(term).append(' ');
        }
        if (semanticQueryText.length() > 0) {
            KnnFloatVectorQuery knnQuery = new KnnFloatVectorQuery("contents-vector", new DemoEmbeddings(vectorDict).computeEmbedding(semanticQueryText.toString()), k);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(query, BooleanClause.Occur.SHOULD);
            builder.add((Query)knnQuery, BooleanClause.Occur.SHOULD);
            return builder.build();
        }
        return query;
    }

    private static class QueryFieldTermExtractor
    extends QueryVisitor {
        private final String field;
        private final List<String> terms = new ArrayList<String>();

        QueryFieldTermExtractor(String field) {
            this.field = field;
        }

        public boolean acceptField(String field) {
            return field.equals(this.field);
        }

        public void consumeTerms(Query query, Term ... terms) {
            for (Term term : terms) {
                this.terms.add(term.text());
            }
        }

        public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
            if (occur == BooleanClause.Occur.MUST_NOT) {
                return QueryVisitor.EMPTY_VISITOR;
            }
            return this;
        }
    }
}

