/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.IOException;
import java.util.Optional;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsFormat;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorScorer;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsReader;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99FlatVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class Lucene104ScalarQuantizedVectorsFormat
extends FlatVectorsFormat {
    public static final String QUANTIZED_VECTOR_COMPONENT = "QVEC";
    public static final String NAME = "Lucene104ScalarQuantizedVectorsFormat";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;
    static final String META_CODEC_NAME = "Lucene104ScalarQuantizedVectorsFormatMeta";
    static final String VECTOR_DATA_CODEC_NAME = "Lucene104ScalarQuantizedVectorsFormatData";
    static final String META_EXTENSION = "vemq";
    static final String VECTOR_DATA_EXTENSION = "veq";
    static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;
    private static final FlatVectorsFormat rawVectorFormat = new Lucene99FlatVectorsFormat(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private static final Lucene104ScalarQuantizedVectorScorer scorer = new Lucene104ScalarQuantizedVectorScorer(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private final ScalarEncoding encoding;

    public Lucene104ScalarQuantizedVectorsFormat() {
        this(ScalarEncoding.UNSIGNED_BYTE);
    }

    public Lucene104ScalarQuantizedVectorsFormat(ScalarEncoding encoding) {
        super(NAME);
        this.encoding = encoding;
    }

    @Override
    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new Lucene104ScalarQuantizedVectorsWriter(state, this.encoding, rawVectorFormat.fieldsWriter(state), scorer);
    }

    @Override
    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new Lucene104ScalarQuantizedVectorsReader(state, rawVectorFormat.fieldsReader(state), scorer);
    }

    @Override
    public int getMaxDimensions(String fieldName) {
        return 1024;
    }

    public String toString() {
        return "Lucene104ScalarQuantizedVectorsFormat(name=Lucene104ScalarQuantizedVectorsFormat, encoding=" + String.valueOf((Object)this.encoding) + ", flatVectorScorer=" + String.valueOf(scorer) + ", rawVectorFormat=" + String.valueOf(rawVectorFormat) + ")";
    }

    public static sealed class ScalarEncoding
    extends Enum<ScalarEncoding> {
        public static final /* enum */ ScalarEncoding UNSIGNED_BYTE = new ScalarEncoding(0, 8, 8);
        public static final /* enum */ ScalarEncoding PACKED_NIBBLE = new ScalarEncoding(1, 4, 4);
        public static final /* enum */ ScalarEncoding SEVEN_BIT = new ScalarEncoding(2, 7, 8);
        public static final /* enum */ ScalarEncoding SINGLE_BIT_QUERY_NIBBLE = new ScalarEncoding(3, 1, 1, 4, 4);
        public static final /* enum */ ScalarEncoding DIBIT_QUERY_NIBBLE = new ScalarEncoding(4, 2, 2, 4, 4){

            @Override
            public int getDiscreteDimensions(int dimensions) {
                int queryDiscretized = (dimensions * 4 + 7) / 8 * 8 / 4;
                int docDiscretized = (dimensions + 7) / 8 * 8;
                int maxDiscretized = Math.max(queryDiscretized, docDiscretized);
                assert ((double)maxDiscretized % 2.0 == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
                assert ((double)maxDiscretized % 4.0 == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
                return maxDiscretized;
            }

            @Override
            public int getDocPackedLength(int dimensions) {
                int discretized = this.getDiscreteDimensions(dimensions);
                return 2 * ((discretized + 7) / 8);
            }
        };
        private final int wireNumber;
        private final byte bits;
        private final byte queryBits;
        private final int bitsPerDim;
        private final int queryBitsPerDim;
        private static final /* synthetic */ ScalarEncoding[] $VALUES;

        public static ScalarEncoding[] values() {
            return (ScalarEncoding[])$VALUES.clone();
        }

        public static ScalarEncoding valueOf(String name) {
            return Enum.valueOf(ScalarEncoding.class, name);
        }

        public static ScalarEncoding fromNumBits(int bits) {
            for (ScalarEncoding encoding : ScalarEncoding.values()) {
                if (encoding.bits != bits) continue;
                return encoding;
            }
            throw new IllegalArgumentException("No encoding for " + bits + " bits");
        }

        private ScalarEncoding(int wireNumber, byte bits, int bitsPerDim) {
            this.wireNumber = wireNumber;
            this.bits = bits;
            this.queryBits = bits;
            this.bitsPerDim = bitsPerDim;
            this.queryBitsPerDim = bitsPerDim;
        }

        private ScalarEncoding(int wireNumber, byte bits, int bitsPerDim, byte queryBits, int queryBitsPerDim) {
            this.wireNumber = wireNumber;
            this.bits = bits;
            this.queryBits = queryBits;
            this.bitsPerDim = bitsPerDim;
            this.queryBitsPerDim = queryBitsPerDim;
        }

        public boolean isAsymmetric() {
            return this.bits != this.queryBits;
        }

        int getWireNumber() {
            return this.wireNumber;
        }

        public byte getBits() {
            return this.bits;
        }

        public byte getQueryBits() {
            return this.queryBits;
        }

        public int getDiscreteDimensions(int dimensions) {
            if (this.queryBits == this.bits) {
                int totalBits = dimensions * this.bitsPerDim;
                return (totalBits + 7) / 8 * 8 / this.bitsPerDim;
            }
            int queryDiscretized = (dimensions * this.queryBitsPerDim + 7) / 8 * 8 / this.queryBitsPerDim;
            int docDiscretized = (dimensions * this.bitsPerDim + 7) / 8 * 8 / this.bitsPerDim;
            int maxDiscretized = Math.max(queryDiscretized, docDiscretized);
            assert ((double)maxDiscretized % (8.0 / (double)this.queryBitsPerDim) == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
            assert ((double)maxDiscretized % (8.0 / (double)this.bitsPerDim) == 0.0) : "bad discretized=" + maxDiscretized + " for dim=" + dimensions;
            return maxDiscretized;
        }

        public int getDocBitsPerDim() {
            return this.bitsPerDim;
        }

        public int getQueryBitsPerDim() {
            return this.queryBitsPerDim;
        }

        public int getDocPackedLength(int dimensions) {
            int discretized = this.getDiscreteDimensions(dimensions);
            int totalBits = discretized * this.bitsPerDim;
            return (totalBits + 7) / 8;
        }

        public int getQueryPackedLength(int dimensions) {
            int discretized = this.getDiscreteDimensions(dimensions);
            int totalBits = discretized * this.queryBitsPerDim;
            return (totalBits + 7) / 8;
        }

        public static Optional<ScalarEncoding> fromWireNumber(int wireNumber) {
            for (ScalarEncoding encoding : ScalarEncoding.values()) {
                if (encoding.wireNumber != wireNumber) continue;
                return Optional.of(encoding);
            }
            return Optional.empty();
        }

        private static /* synthetic */ ScalarEncoding[] $values() {
            return new ScalarEncoding[]{UNSIGNED_BYTE, PACKED_NIBBLE, SEVEN_BIT, SINGLE_BIT_QUERY_NIBBLE, DIBIT_QUERY_NIBBLE};
        }

        static {
            $VALUES = ScalarEncoding.$values();
        }
    }
}

