/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene104;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.lucene104.Lucene104ScalarQuantizedVectorsFormat;
import org.apache.lucene.codecs.lucene104.OffHeapScalarQuantizedVectorValues;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.codecs.lucene95.HasIndexSlice;
import org.apache.lucene.codecs.lucene95.OrdToDocDISIReaderConfiguration;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.quantization.OptimizedScalarQuantizer;

abstract class OffHeapScalarQuantizedFloatVectorValues
extends FloatVectorValues
implements HasIndexSlice {
    final int dimension;
    final int size;
    final VectorSimilarityFunction similarityFunction;
    final FlatVectorsScorer vectorsScorer;
    final IndexInput slice;
    final float[] vectorValue;
    final byte[] byteValue;
    final ByteBuffer byteBuffer;
    final byte[] unpackedByteVectorValue;
    final int byteSize;
    private int lastOrd = -1;
    final float[] correctiveValues;
    int quantizedComponentSum;
    final Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding;
    final float[] centroid;

    OffHeapScalarQuantizedFloatVectorValues(int dimension, int size, float[] centroid, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
        this.dimension = dimension;
        this.size = size;
        this.similarityFunction = similarityFunction;
        this.vectorsScorer = vectorsScorer;
        this.slice = slice;
        this.centroid = centroid;
        this.correctiveValues = new float[3];
        this.encoding = encoding;
        int docPackedLength = encoding.getDocPackedLength(dimension);
        this.byteSize = docPackedLength + 12 + 4;
        this.byteBuffer = ByteBuffer.allocate(docPackedLength);
        this.vectorValue = new float[dimension];
        this.byteValue = this.byteBuffer.array();
        this.unpackedByteVectorValue = new byte[dimension];
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float[] vectorValue(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return this.vectorValue;
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteValue.length);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = this.slice.readInt();
        switch (this.encoding) {
            case PACKED_NIBBLE: {
                OffHeapScalarQuantizedVectorValues.unpackNibbles(this.byteValue, this.unpackedByteVectorValue);
                break;
            }
            case SINGLE_BIT_QUERY_NIBBLE: {
                OptimizedScalarQuantizer.unpackBinary(this.byteValue, this.unpackedByteVectorValue);
                break;
            }
            case DIBIT_QUERY_NIBBLE: {
                OptimizedScalarQuantizer.untransposeDibit(this.byteValue, this.unpackedByteVectorValue);
                break;
            }
            case UNSIGNED_BYTE: 
            case SEVEN_BIT: {
                OptimizedScalarQuantizer.deQuantize(this.byteValue, this.vectorValue, this.encoding.getBits(), this.correctiveValues[0], this.correctiveValues[1], this.centroid);
                this.lastOrd = targetOrd;
                return this.vectorValue;
            }
        }
        OptimizedScalarQuantizer.deQuantize(this.unpackedByteVectorValue, this.vectorValue, this.encoding.getBits(), this.correctiveValues[0], this.correctiveValues[1], this.centroid);
        this.lastOrd = targetOrd;
        return this.vectorValue;
    }

    public OptimizedScalarQuantizer.QuantizationResult getCorrectiveTerms(int targetOrd) throws IOException {
        if (this.lastOrd == targetOrd) {
            return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
        }
        this.slice.seek((long)targetOrd * (long)this.byteSize + (long)this.byteValue.length);
        this.slice.readFloats(this.correctiveValues, 0, 3);
        this.quantizedComponentSum = this.slice.readInt();
        return new OptimizedScalarQuantizer.QuantizationResult(this.correctiveValues[0], this.correctiveValues[1], this.correctiveValues[2], this.quantizedComponentSum);
    }

    @Override
    public int getVectorByteLength() {
        return this.dimension;
    }

    @Override
    public IndexInput getSlice() {
        return this.slice;
    }

    static OffHeapScalarQuantizedFloatVectorValues load(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, float[] centroid, long quantizedVectorDataOffset, long quantizedVectorDataLength, IndexInput vectorData) throws IOException {
        if (configuration.isEmpty()) {
            return new EmptyOffHeapVectorValues(dimension, similarityFunction, vectorsScorer);
        }
        assert (centroid != null);
        IndexInput bytesSlice = vectorData.slice("scalar-quantized-float-vector-data", quantizedVectorDataOffset, quantizedVectorDataLength);
        if (configuration.isDense()) {
            return new DenseOffHeapVectorValues(dimension, size, centroid, encoding, similarityFunction, vectorsScorer, bytesSlice);
        }
        return new SparseOffHeapVectorValues(configuration, dimension, size, centroid, encoding, vectorData, similarityFunction, vectorsScorer, bytesSlice);
    }

    private static class EmptyOffHeapVectorValues
    extends OffHeapScalarQuantizedFloatVectorValues {
        EmptyOffHeapVectorValues(int dimension, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer) {
            super(dimension, 0, null, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding.UNSIGNED_BYTE, similarityFunction, vectorsScorer, null);
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }

        @Override
        public DenseOffHeapVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }

        @Override
        public VectorScorer scorer(float[] target) {
            return null;
        }
    }

    private static class DenseOffHeapVectorValues
    extends OffHeapScalarQuantizedFloatVectorValues {
        DenseOffHeapVectorValues(int dimension, int size, float[] centroid, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) {
            super(dimension, size, centroid, encoding, similarityFunction, vectorsScorer, slice);
        }

        @Override
        public DenseOffHeapVectorValues copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.centroid, this.encoding, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            DenseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerDense(scorer, iterator, matchingDocs);
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createDenseIterator();
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapScalarQuantizedFloatVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final OrdToDocDISIReaderConfiguration configuration;

        SparseOffHeapVectorValues(OrdToDocDISIReaderConfiguration configuration, int dimension, int size, float[] centroid, Lucene104ScalarQuantizedVectorsFormat.ScalarEncoding encoding, IndexInput dataIn, VectorSimilarityFunction similarityFunction, FlatVectorsScorer vectorsScorer, IndexInput slice) throws IOException {
            super(dimension, size, centroid, encoding, similarityFunction, vectorsScorer, slice);
            this.configuration = configuration;
            this.dataIn = dataIn;
            this.ordToDoc = configuration.getDirectMonotonicReader(dataIn);
            this.disi = configuration.getIndexedDISI(dataIn);
        }

        @Override
        public SparseOffHeapVectorValues copy() throws IOException {
            return new SparseOffHeapVectorValues(this.configuration, this.dimension, this.size, this.centroid, this.encoding, this.dataIn, this.similarityFunction, this.vectorsScorer, this.slice.clone());
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        public Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }

        @Override
        public KnnVectorValues.DocIndexIterator iterator() {
            return IndexedDISI.asDocIndexIterator(this.disi);
        }

        @Override
        public VectorScorer scorer(float[] target) throws IOException {
            SparseOffHeapVectorValues copy = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = copy.iterator();
            final RandomVectorScorer scorer = this.vectorsScorer.getRandomVectorScorer(this.similarityFunction, (KnnVectorValues)copy, target);
            return new VectorScorer(){

                @Override
                public float score() throws IOException {
                    return scorer.score(iterator.index());
                }

                @Override
                public DocIdSetIterator iterator() {
                    return iterator;
                }

                @Override
                public VectorScorer.Bulk bulk(DocIdSetIterator matchingDocs) {
                    return VectorScorer.Bulk.fromRandomScorerSparse(scorer, iterator, matchingDocs);
                }
            };
        }
    }
}

