/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.search;

public final class SimilarityConfig {
    private final boolean useClassicSimilarity;
    private final float k1;
    private final float b;
    private final boolean discountOverlaps;

    private SimilarityConfig(Builder builder) {
        this.useClassicSimilarity = builder.useClassicSimilarity;
        this.k1 = builder.k1;
        this.b = builder.b;
        this.discountOverlaps = builder.discountOverlaps;
    }

    public boolean isUseClassicSimilarity() {
        return this.useClassicSimilarity;
    }

    public float getK1() {
        return this.k1;
    }

    public float getB() {
        return this.b;
    }

    public boolean isDiscountOverlaps() {
        return this.discountOverlaps;
    }

    public String toString() {
        return "SimilarityConfig: [ use classic similarity=" + this.useClassicSimilarity + "; discount overlaps=" + this.discountOverlaps + "; k1=" + this.k1 + "; b=" + this.b + ";]";
    }

    public static class Builder {
        private boolean useClassicSimilarity = false;
        private float k1 = 1.2f;
        private float b = 0.75f;
        private boolean discountOverlaps = true;

        public Builder useClassicSimilarity(boolean val) {
            this.useClassicSimilarity = val;
            return this;
        }

        public Builder k1(float val) {
            this.k1 = val;
            return this;
        }

        public Builder b(float val) {
            this.b = val;
            return this;
        }

        public Builder discountOverlaps(boolean val) {
            this.discountOverlaps = val;
            return this;
        }

        public SimilarityConfig build() {
            return new SimilarityConfig(this);
        }
    }
}

