/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;

public class MultiValuedLongFieldSource
extends LongFieldSource {
    protected final SortedNumericSelector.Type selector;
    private final Long missingValue;

    public MultiValuedLongFieldSource(String field, SortedNumericSelector.Type selector) {
        this(field, selector, null);
    }

    public MultiValuedLongFieldSource(String field, SortedNumericSelector.Type selector, Long missingValue) {
        super(field);
        this.selector = selector;
        this.missingValue = missingValue;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedLongFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedLongFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.LONG, reverse, this.selector, (Object)this.missingValue);
    }

    @Override
    public String description() {
        return "long(" + this.field + "," + this.selector.name() + ")";
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric((LeafReader)readerContext.reader(), (String)this.field);
        return SortedNumericSelector.wrap((SortedNumericDocValues)sortedDv, (SortedNumericSelector.Type)this.selector, (SortField.Type)SortField.Type.LONG);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedLongFieldSource.class) {
            return false;
        }
        MultiValuedLongFieldSource other = (MultiValuedLongFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h = super.hashCode();
        return h += this.selector.hashCode();
    }
}

