/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene91;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.internal.hppc.IntObjectHashMap;
import org.apache.lucene.search.AcceptDocs;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.VectorScorer;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomVectorScorer;

public final class Lucene91HnswVectorsReader
extends KnnVectorsReader {
    private final IntObjectHashMap<FieldEntry> fields = new IntObjectHashMap();
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene91HnswVectorsReader(SegmentReadState state) throws IOException {
        int versionMeta = this.readMetadata(state);
        this.fieldInfos = state.fieldInfos;
        boolean success = false;
        try {
            this.vectorData = Lucene91HnswVectorsReader.openDataInput(state, versionMeta, "vec", "Lucene91HnswVectorsFormatData");
            this.vectorIndex = Lucene91HnswVectorsReader.openDataInput(state, versionMeta, "vex", "Lucene91HnswVectorsFormatIndex");
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this});
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)"vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader((DataInput)meta, (String)"Lucene91HnswVectorsFormatMeta", (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
                    }
                }
                CodecUtil.checkFooter((ChecksumIndexInput)meta, (Throwable)priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader((DataInput)in, (String)codecName, (int)0, (int)0, (byte[])state.segmentInfo.getId(), (String)state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, (DataInput)in);
                }
                CodecUtil.retrieveChecksum((IndexInput)in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, (DataInput)meta);
            }
            FieldEntry fieldEntry = this.readField((IndexInput)meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.number, (Object)fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction((DataInput)input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + String.valueOf(similarityFunction) + " != " + String.valueOf(info.getVectorSimilarityFunction()));
        }
        return FieldEntry.create((DataInput)input, info.getVectorSimilarityFunction());
    }

    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.vectorData);
        CodecUtil.checksumEntireFile((IndexInput)this.vectorIndex);
    }

    private FieldEntry getFieldEntry(String field) {
        FieldEntry fieldEntry;
        FieldInfo info = this.fieldInfos.fieldInfo(field);
        if (info == null || (fieldEntry = (FieldEntry)this.fields.get(info.number)) == null) {
            throw new IllegalArgumentException("field=\"" + field + "\" not found");
        }
        return fieldEntry;
    }

    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        return this.getOffHeapVectorValues(this.getFieldEntry(field));
    }

    public ByteVectorValues getByteVectorValues(String field) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void search(String field, float[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.getFieldEntry(field);
        if (fieldEntry.size() == 0) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = this.getOffHeapVectorValues(fieldEntry);
        RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (KnnVectorValues)vectorValues, target);
        HnswGraphSearcher.search((RandomVectorScorer)scorer, (KnnCollector)new OrdinalTranslatedKnnCollector(knnCollector, vectorValues::ordToDoc), (HnswGraph)this.getGraph(fieldEntry), (Bits)this.getAcceptOrds(acceptDocs.bits(), fieldEntry));
    }

    public void search(String field, byte[] target, KnnCollector knnCollector, AcceptDocs acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    private OffHeapFloatVectorValues getOffHeapVectorValues(FieldEntry fieldEntry) throws IOException {
        IndexInput bytesSlice = this.vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        return new OffHeapFloatVectorValues(fieldEntry.dimension, fieldEntry.size(), fieldEntry.ordToDoc, fieldEntry.similarityFunction, bytesSlice);
    }

    private Bits getAcceptOrds(final Bits acceptDocs, final FieldEntry fieldEntry) {
        if (fieldEntry.ordToDoc == null) {
            return acceptDocs;
        }
        if (acceptDocs == null) {
            return null;
        }
        return new Bits(){

            public boolean get(int index) {
                return acceptDocs.get(fieldEntry.ordToDoc(index));
            }

            public int length() {
                return fieldEntry.size;
            }
        };
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    public Map<String, Long> getOffHeapByteSize(FieldInfo fieldInfo) {
        FieldEntry entry = this.getFieldEntry(fieldInfo.name);
        Map.Entry<String, Long> raw = Map.entry("vec", entry.vectorDataLength);
        Map.Entry<String, Long> graph = Map.entry("vex", entry.vectorIndexLength);
        return Map.ofEntries(raw, graph);
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.vectorData, this.vectorIndex});
    }

    private record FieldEntry(VectorSimilarityFunction similarityFunction, long vectorDataOffset, long vectorDataLength, long vectorIndexOffset, long vectorIndexLength, int maxConn, int numLevels, int dimension, int size, int[] ordToDoc, IntUnaryOperator ordToDocOperator, int[][] nodesByLevel, long[] graphOffsetsByLevel) {
        static FieldEntry create(DataInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            int[] ordToDoc;
            long vectorDataOffset = input.readVLong();
            long vectorDataLength = input.readVLong();
            long vectorIndexOffset = input.readVLong();
            long vectorIndexLength = input.readVLong();
            int dimension = input.readInt();
            int size = input.readInt();
            byte denseSparseMarker = input.readByte();
            if (denseSparseMarker == -1) {
                ordToDoc = null;
            } else {
                assert (denseSparseMarker == 0);
                ordToDoc = new int[size];
                for (int i = 0; i < size; ++i) {
                    int doc;
                    ordToDoc[i] = doc = input.readInt();
                }
            }
            IntUnaryOperator ordToDocOperator = ordToDoc == null ? IntUnaryOperator.identity() : ord -> ordToDoc[ord];
            int maxConn = input.readInt();
            int numLevels = input.readInt();
            int[][] nodesByLevel = new int[numLevels][];
            for (int level = 0; level < numLevels; ++level) {
                int numNodesOnLevel = input.readInt();
                if (level == 0) {
                    assert (numNodesOnLevel == size);
                    nodesByLevel[0] = null;
                    continue;
                }
                nodesByLevel[level] = new int[numNodesOnLevel];
                for (int i = 0; i < numNodesOnLevel; ++i) {
                    nodesByLevel[level][i] = input.readInt();
                }
            }
            long[] graphOffsetsByLevel = new long[numLevels];
            long connectionsAndSizeBytes = Math.multiplyExact(Math.addExact(1L, (long)maxConn), 4);
            for (int level = 0; level < numLevels; ++level) {
                if (level == 0) {
                    graphOffsetsByLevel[level] = 0L;
                    continue;
                }
                int numNodesOnPrevLevel = level == 1 ? size : nodesByLevel[level - 1].length;
                graphOffsetsByLevel[level] = Math.addExact(graphOffsetsByLevel[level - 1], Math.multiplyExact(connectionsAndSizeBytes, numNodesOnPrevLevel));
            }
            return new FieldEntry(similarityFunction, vectorDataOffset, vectorDataLength, vectorIndexOffset, vectorIndexLength, maxConn, numLevels, dimension, size, ordToDoc, ordToDocOperator, nodesByLevel, graphOffsetsByLevel);
        }

        int ordToDoc(int ord) {
            return this.ordToDocOperator.applyAsInt(ord);
        }
    }

    static class OffHeapFloatVectorValues
    extends FloatVectorValues {
        private final int dimension;
        private final int size;
        private final int[] ordToDoc;
        private final IntUnaryOperator ordToDocOperator;
        private final IndexInput dataIn;
        private final int byteSize;
        private final float[] value;
        private final VectorSimilarityFunction similarityFunction;

        OffHeapFloatVectorValues(int dimension, int size, int[] ordToDoc, VectorSimilarityFunction similarityFunction, IndexInput dataIn) {
            this.dimension = dimension;
            this.size = size;
            this.ordToDoc = ordToDoc;
            this.ordToDocOperator = ordToDoc == null ? IntUnaryOperator.identity() : ord -> ordToDoc[ord];
            this.dataIn = dataIn;
            this.similarityFunction = similarityFunction;
            this.byteSize = 4 * dimension;
            this.value = new float[dimension];
        }

        public int dimension() {
            return this.dimension;
        }

        public int size() {
            return this.size;
        }

        public OffHeapFloatVectorValues copy() {
            return new OffHeapFloatVectorValues(this.dimension, this.size, this.ordToDoc, this.similarityFunction, this.dataIn.clone());
        }

        public float[] vectorValue(int targetOrd) throws IOException {
            this.dataIn.seek((long)targetOrd * (long)this.byteSize);
            this.dataIn.readFloats(this.value, 0, this.value.length);
            return this.value;
        }

        public int ordToDoc(int ord) {
            return this.ordToDocOperator.applyAsInt(ord);
        }

        public KnnVectorValues.DocIndexIterator iterator() {
            return this.createSparseIterator();
        }

        public VectorScorer scorer(final float[] target) {
            if (this.size == 0) {
                return null;
            }
            final OffHeapFloatVectorValues values = this.copy();
            final KnnVectorValues.DocIndexIterator iterator = values.iterator();
            return new VectorScorer(){

                public float score() throws IOException {
                    return values.similarityFunction.compare(values.vectorValue(iterator.index()), target);
                }

                public DocIdSetIterator iterator() {
                    return iterator;
                }
            };
        }
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final long[] graphOffsetsByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        final long bytesForConns;
        final int maxConn;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.dataIn = dataIn;
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            this.graphOffsetsByLevel = entry.graphOffsetsByLevel;
            this.bytesForConns = Math.multiplyExact(Math.addExact((long)entry.maxConn, 1L), 4);
            this.maxConn = entry.maxConn;
        }

        public int maxConn() {
            return this.maxConn;
        }

        public int neighborCount() {
            return this.arcCount;
        }

        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            long graphDataOffset = this.graphOffsetsByLevel[level] + (long)targetIndex * this.bytesForConns;
            this.dataIn.seek(graphDataOffset);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        public int size() {
            return this.size;
        }

        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc = this.dataIn.readInt();
            return this.arc;
        }

        public int numLevels() {
            return this.numLevels;
        }

        public int entryNode() {
            return this.entryNode;
        }

        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.DenseNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level]);
        }
    }
}

