/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=1, jvmArgsAppend={"-Xmx1g", "-Xms1g", "-XX:+AlwaysPreTouch"})
public class PolymorphismBenchmark {
    private IntList[] lists;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        this.lists = new IntList[100];
        Random r = new Random(0L);
        for (int i = 0; i < this.lists.length; ++i) {
            this.lists[i] = switch (r.nextInt(4)) {
                case 0 -> new List1();
                case 1 -> new List2();
                default -> new List3();
            };
        }
    }

    @Benchmark
    public long defaultImpl() {
        long sum = 0L;
        for (IntList list : this.lists) {
            sum += list.sum1();
        }
        return sum;
    }

    @Benchmark
    public long delegateToDefaultImpl() {
        long sum = 0L;
        for (IntList list : this.lists) {
            sum += list.sum2();
        }
        return sum;
    }

    @Benchmark
    public long specializedImpl() {
        long sum = 0L;
        for (IntList list : this.lists) {
            sum += list.sum3();
        }
        return sum;
    }

    public static abstract class IntList {
        public abstract int size();

        public abstract int get(int var1);

        public final long sum1() {
            long sum = 0L;
            for (int i = 0; i < this.size(); ++i) {
                sum += (long)this.get(i);
            }
            return sum;
        }

        public long sum2() {
            long sum = 0L;
            for (int i = 0; i < this.size(); ++i) {
                sum += (long)this.get(i);
            }
            return sum;
        }

        public abstract long sum3();
    }

    public static class List1
    extends IntList {
        @Override
        public int size() {
            return 128;
        }

        @Override
        public int get(int index) {
            return 1;
        }

        @Override
        public long sum2() {
            return super.sum2();
        }

        @Override
        public long sum3() {
            long sum = 0L;
            for (int i = 0; i < this.size(); ++i) {
                sum += (long)this.get(i);
            }
            return sum;
        }
    }

    public static class List2
    extends IntList {
        @Override
        public int size() {
            return 128;
        }

        @Override
        public int get(int index) {
            return 2;
        }

        @Override
        public long sum2() {
            return super.sum2();
        }

        @Override
        public long sum3() {
            long sum = 0L;
            for (int i = 0; i < this.size(); ++i) {
                sum += (long)this.get(i);
            }
            return sum;
        }
    }

    public static class List3
    extends IntList {
        @Override
        public int size() {
            return 128;
        }

        @Override
        public int get(int index) {
            return 3;
        }

        @Override
        public long sum2() {
            return super.sum2();
        }

        @Override
        public long sum3() {
            long sum = 0L;
            for (int i = 0; i < this.size(); ++i) {
                sum += (long)this.get(i);
            }
            return sum;
        }
    }
}

