/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final AdminRoutes adminRoutes;
    private final Admin admin;

    public AdminRequestHandler(AdminRoutes adminRoutes, Admin admin, ResponseRenderer responseRenderer) {
        super(responseRenderer);
        this.adminRoutes = adminRoutes;
        this.admin = admin;
    }

    @Override
    public ServeEvent handleRequest(Request request) {
        LocalNotifier.notifier().info("Received request to " + request.getUrl() + " with body " + request.getBodyAsString());
        String path = URI.create(AdminRequestHandler.withoutAdminRoot(request.getUrl())).getPath();
        try {
            AdminTask adminTask = this.adminRoutes.taskFor(request.getMethod(), path);
            AdminUriTemplate uriTemplate = this.adminRoutes.requestSpecForTask(adminTask.getClass()).getUriTemplate();
            PathParams pathParams = uriTemplate.parse(path);
            return ServeEvent.of(LoggedRequest.createFrom(request), adminTask.execute(this.admin, request, pathParams));
        }
        catch (NotFoundException e) {
            return ServeEvent.forUnmatchedRequest(LoggedRequest.createFrom(request));
        }
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

