/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;

public abstract class AbstractCallContextInterceptor
extends AbstractSoapInterceptor {
    public AbstractCallContextInterceptor() {
        super("pre-invoke");
    }

    protected Map<String, String> getCurrentCallContextMap(SoapMessage message) {
        Object callContextMapObject = message.getExchange().getInMessage().get((Object)"org.apache.chemistry.opencmis.callcontext");
        if (callContextMapObject instanceof Map) {
            return (Map)callContextMapObject;
        }
        return null;
    }

    protected void setCallContextMap(SoapMessage message, Map<String, String> callContextMap) {
        message.getExchange().getInMessage().put((Object)"org.apache.chemistry.opencmis.callcontext", callContextMap);
    }

    protected String getCurrentUser(SoapMessage message) {
        Map<String, String> callContextMap = this.getCurrentCallContextMap(message);
        if (callContextMap != null) {
            return callContextMap.get("username");
        }
        return null;
    }

    protected void addToCurrentCallContextMap(SoapMessage message, Map<String, String> callContextMapAdditions) {
        Map<String, String> callContextMap = this.getCurrentCallContextMap(message);
        if (callContextMap == null) {
            callContextMap = new HashMap<String, String>();
        }
        callContextMap.putAll(callContextMapAdditions);
        this.setCallContextMap(message, callContextMap);
    }

    protected void setUserAndPassword(SoapMessage message, String user, String password) {
        Map<String, String> callContextMap = this.getCurrentCallContextMap(message);
        if (callContextMap == null) {
            callContextMap = new HashMap<String, String>();
        }
        callContextMap.put("username", user);
        callContextMap.put("password", password);
        this.setCallContextMap(message, callContextMap);
    }

    protected void setUser(SoapMessage message, String user) {
        Map<String, String> callContextMap = this.getCurrentCallContextMap(message);
        if (callContextMap == null) {
            callContextMap = new HashMap<String, String>();
        }
        callContextMap.put("username", user);
        this.setCallContextMap(message, callContextMap);
    }
}

