/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters.composite;

import java.util.Properties;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    public boolean canConvert(Class type) {
        return Properties.class.isAssignableFrom(type);
    }

    public Object fromConfiguration(ConverterLookup converterLookup, PlexusConfiguration configuration, Class type, Class baseType, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object retValueInterpolated = this.fromExpression(configuration, expressionEvaluator, type);
        if (retValueInterpolated != null) {
            return retValueInterpolated;
        }
        String element = configuration.getName();
        Properties retValue = new Properties();
        PlexusConfiguration[] children = configuration.getChildren("property");
        if (children != null && children.length > 0) {
            for (int i = 0; i < children.length; ++i) {
                PlexusConfiguration child = children[i];
                this.addEntry(retValue, element, child);
            }
        }
        return retValue;
    }

    private void addEntry(Properties properties, String element, PlexusConfiguration property) throws ComponentConfigurationException {
        String name = property.getChild("name").getValue(null);
        if (name == null) {
            String msg = "Converter: java.util.Properties. Trying to convert the configuration element: '" + element + "', missing child element 'name'.";
            throw new ComponentConfigurationException(msg);
        }
        String value = property.getChild("value").getValue("");
        properties.put(name, value);
    }
}

