//*****************************************************************************
//
//! @file am_hal_ble_patch_b0.c
//!
//! @brief This is a binary patch for the BLE core.
//!
//! @addtogroup
//! @ingroup
//! @{
//
//*****************************************************************************

//*****************************************************************************
//
// Copyright (c) 2021, Ambiq Micro, Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from this
// software without specific prior written permission.
//
// Third party software included in this distribution is subject to the
// additional license terms as defined in the /docs/licenses directory.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
// This is part of revision release_sdk_3_0_0-742e5ac27c of the AmbiqSuite Development Package.
//
//*****************************************************************************

#include "am_mcu_apollo.h"


//*****************************************************************************
//
// BLE LL local supported feature flags.
//
//     Bit position | Link Layer Feature
//     0            | LE Encryption
//     1            | Connection Parameters Request Procedure
//     2            | Extended Reject Indication
//     3            | Slave-initiated Features Exchange
//     4            | LE Ping
//     5            | LE Data Packet Length Extension
//     6            | LL Privacy
//     7            | Extended Scanner Filter Policies
//
// Specified 4.6 Feature Support, Link Layer Specification, Core V4.2.
//
//*****************************************************************************
#ifndef AM_HAL_BLE_LOCAL_FEATURE
#define AM_HAL_BLE_LOCAL_FEATURE    0x21
#endif



//*****************************************************************************
//
// Patches included in this file.
//
//*****************************************************************************
am_hal_ble_patch_t am_ble_buffer_patch_b0;
am_hal_ble_patch_t am_ble_performance_patch_b0;
am_hal_ble_patch_t am_ble_nvds_patch_b0;

//*****************************************************************************
//
// Patch application order.
//
//*****************************************************************************
am_hal_ble_patch_t *am_hal_ble_default_patch_array_b0[] =
{
    // FTCODE patches (type 0xAA)

    // RAMCODE patches (type 0xBB)
    &am_ble_performance_patch_b0,

    // Standard patches (type 0xCC)
    &am_ble_buffer_patch_b0,

    // nvds param (type 0xDD)
    &am_ble_nvds_patch_b0,
};

#define AM_HAL_BLE_NUM_DEFAULT_PATCHES_B0                                        \
    (sizeof(am_hal_ble_default_patch_array_b0) /                                 \
     sizeof(am_hal_ble_default_patch_array_b0[0]))

am_hal_ble_patch_t **am_hal_ble_default_patches_b0 = am_hal_ble_default_patch_array_b0;
const uint32_t am_hal_ble_num_default_patches_b0 = AM_HAL_BLE_NUM_DEFAULT_PATCHES_B0;

//*****************************************************************************
//
// Patch Name:   RAMCODE PATCH v0.6    for Apollo3 B0

// Reduce duration from TX to TX
// Optimized 32K XO frequency calculation
// Optimized AGC Table
// Fixed Channelmap indication rejected issue
// Fixed 800M Spur
// Fixed feature issue
// Fixed disconnect issue  //long time large data transfer
// Date:        2019-10-25
//*****************************************************************************
//*****************************************************************************
// Fixed Sweyntooth security issues
// Fixed channel number less than 2 during channel map update
// Added protection for certain tx buffer list operation
// Disabled interrupt during AES operation
// Fixed interrupt nested disable/restore issues
// Date:        2020-04-27
//*****************************************************************************
//*****************************************************************************
// Improved instant past issue  0x28
// Improved disconnet response timout issue 0x22
// Date:        2020-08-23
//*****************************************************************************
//*****************************************************************************
// Fixed RD_REM_FEATURE issue when controller is busy
// Improved RD_RSSI
// Date:        2020-09-01
//*****************************************************************************
//*****************************************************************************
// Improved the hci send data(slave->host) process.
// Date:        2020-10-20
//*****************************************************************************
//*****************************************************************************
// Improved DHKey generation procedure.
// Improved connection parameter request procedure.
// Date:        2020-12-14
//*****************************************************************************
//*****************************************************************************
// Optimize process for LLCP packet with invalid length.
// Optimize process when receiving invalid parameter of LL_LEN_RSP.
// Date:        2021-01-07
//*****************************************************************************
//*****************************************************************************
// Fixed        No GATT response message during pairing issue
// Date:        2021-05-30
//*****************************************************************************
//*****************************************************************************
// Fixed        master mode connection issue
// Date:        2021-07-19
//*****************************************************************************
//*****************************************************************************
// Fixed        No response to LL_ENC_REQ issue
// Date:        2021-08-10
//*****************************************************************************

//*****************************************************************************
//   Optimize process when receiving invalid parameter of LL_LEN_REQ.
// Date:        2021-09-13
//*****************************************************************************

//*****************************************************************************
//   Fixed  RF sync error issue on some channels when doing DTM test
// Date:        2021-09-14
//*****************************************************************************

 am_hal_ble_buffer(0x12b4)am_ble_performance_patch_data_b0 =
{
    .bytes =
    {
        0x00,0x11,0xb0,0x12,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x01,0xc5,0x01,
        0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x01,0x01,0x85,0x36,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
        0x00,0x10,0x00,0x06,0x1f,0xb5,0x00,0x24,0x00,0x99,0x12,0x29,0x45,0xd0,0x0e,0xdc,
        0x2f,0xd2,0x08,0x00,0x78,0x44,0x00,0x79,0x00,0x18,0x87,0x44,0x2f,0x2c,0x2c,0x2c,
        0x2c,0x2c,0x2c,0x2c,0x34,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x2c,0x3b,0x2c,0x1c,0x29,
        0x42,0xd0,0x0c,0xdc,0x13,0x39,0x09,0x29,0x1b,0xd2,0x08,0x00,0x78,0x44,0x00,0x79,
        0x00,0x18,0x87,0x44,0x18,0x18,0x18,0x18,0x2d,0x18,0x30,0x33,0x18,0x00,0x6c,0x29,
        0x49,0xd0,0x08,0xdc,0x1d,0x29,0x35,0xd0,0x21,0x29,0x35,0xd0,0x5b,0x29,0x3c,0xd0,
        0x5e,0x29,0x06,0xd1,0x34,0xe0,0x79,0x29,0x4c,0xd0,0x7a,0x29,0x59,0xd0,0x7b,0x29,
        0x01,0xd0,0x00,0x24,0xe4,0x43,0x20,0x46,0x04,0xb0,0x10,0xbd,0x01,0x98,0xc0,0xb2,
        0x00,0xf0,0xfa,0xf8,0xf7,0xe7,0x06,0x9b,0x03,0x9a,0x02,0x99,0x01,0x98,0x01,0xf0,
        0x77,0xf8,0xf0,0xe7,0x00,0xf0,0x60,0xf8,0xed,0xe7,0x00,0xf0,0xc5,0xff,0xea,0xe7,
        0x00,0xf0,0x1e,0xfb,0xe7,0xe7,0x00,0xf0,0x75,0xfb,0xe4,0xe7,0x01,0x98,0xc0,0xb2,
        0x00,0xf0,0xb6,0xf9,0x04,0x46,0xde,0xe7,0x01,0x98,0xc0,0xb2,0x00,0xf0,0x78,0xff,
        0x04,0x46,0xd8,0xe7,0x00,0xf0,0x40,0xfa,0x00,0xf0,0x2c,0xff,0x04,0x46,0xd2,0xe7,
        0x01,0x98,0x00,0xf0,0x07,0xfe,0x04,0x46,0xcd,0xe7,0x02,0x98,0xc1,0xb2,0x01,0x98,
        0x00,0xf0,0x40,0xfe,0xc7,0xe7,0x03,0x98,0x00,0x28,0x01,0xd0,0x01,0x22,0x00,0xe0,
        0x00,0x22,0x02,0x98,0x06,0x9b,0x81,0xb2,0x01,0x98,0x80,0xb2,0x00,0xf0,0x02,0xfc,
        0x04,0x46,0xb8,0xe7,0x03,0x98,0x00,0x28,0x01,0xd0,0x01,0x22,0x00,0xe0,0x00,0x22,
        0x02,0x98,0x06,0x9b,0x81,0xb2,0x01,0x98,0x80,0xb2,0x00,0xf0,0x73,0xfc,0x04,0x46,
        0xa9,0xe7,0x03,0x98,0x00,0x28,0x01,0xd0,0x01,0x22,0x00,0xe0,0x00,0x22,0x02,0x98,
        0x06,0x9b,0x81,0xb2,0x01,0x98,0x80,0xb2,0x00,0xf0,0x02,0xfd,0x04,0x46,0x9a,0xe7,
        0x03,0xb4,0x01,0x48,0x01,0x90,0x01,0xbd,0x01,0x01,0x00,0x00,0x03,0xb4,0x01,0x48,
        0x01,0x90,0x01,0xbd,0x55,0x01,0x00,0x00,0xf0,0xb4,0x00,0x20,0x43,0x27,0x3f,0x06,
        0x79,0x68,0xff,0x24,0x01,0x34,0x21,0x43,0x79,0x60,0x79,0x68,0x22,0x03,0x11,0x43,
        0x79,0x60,0xa3,0x21,0xc9,0x05,0x0a,0x68,0x52,0x08,0x52,0x00,0x0a,0x60,0x34,0x49,
        0x09,0x69,0xcd,0xb2,0x33,0x49,0x09,0x78,0xc9,0x07,0xc9,0x0f,0x0a,0x05,0x0b,0x02,
        0x00,0x2d,0x06,0xd0,0x30,0x49,0x31,0x4e,0x09,0x88,0xb1,0x42,0x0d,0xd3,0x04,0x20,
        0x19,0xe0,0x78,0x68,0x01,0x21,0x09,0x05,0x88,0x43,0x10,0x43,0x78,0x60,0x78,0x68,
        0xa0,0x43,0x18,0x43,0x78,0x60,0xf0,0xbc,0x70,0x47,0x29,0x4e,0xb1,0x42,0x01,0xd3,
        0x03,0x20,0x08,0xe0,0x27,0x4e,0xb1,0x42,0x01,0xd3,0x02,0x20,0x03,0xe0,0x26,0x4e,
        0xb1,0x42,0x00,0xd3,0x01,0x20,0x25,0x4e,0x31,0x18,0x20,0x31,0x09,0x7e,0xa9,0x42,
        0x09,0xda,0x00,0x28,0x01,0xdd,0x40,0x1e,0x40,0xb2,0x31,0x18,0x09,0x7a,0x40,0x00,
        0x80,0x19,0x00,0x8b,0x0b,0xe0,0x04,0x28,0x04,0xda,0x31,0x5c,0xa9,0x42,0x01,0xdb,
        0x40,0x1c,0x40,0xb2,0x31,0x18,0x09,0x7a,0x40,0x00,0x80,0x19,0x00,0x8b,0x18,0x4d,
        0x29,0x62,0xa3,0x25,0xed,0x05,0x29,0x68,0x49,0x08,0x49,0x00,0x29,0x60,0x15,0x4e,
        0x31,0x6b,0xff,0x24,0x01,0x34,0x0c,0x43,0x34,0x63,0xa8,0x62,0xff,0x24,0x01,0x34,
        0xa1,0x43,0x31,0x63,0x08,0x49,0x08,0x80,0x78,0x68,0x21,0x03,0x88,0x43,0x10,0x43,
        0x78,0x60,0x78,0x68,0x09,0x13,0x88,0x43,0x18,0x43,0x78,0x60,0xf0,0xbc,0x70,0x47,
        0x80,0x00,0x80,0x45,0x3a,0x68,0x00,0x20,0x50,0x68,0x00,0x20,0xf6,0x3f,0x00,0x00,
        0xf6,0x38,0x00,0x00,0xf6,0x2d,0x00,0x00,0xf6,0x09,0x00,0x00,0x50,0x6e,0x00,0x20,
        0x80,0x04,0xc0,0x50,0x40,0x00,0x80,0x45,0xf0,0xb4,0x43,0x21,0x09,0x06,0x4a,0x68,
        0x01,0x20,0x80,0x04,0x02,0x43,0x4a,0x60,0xc4,0x23,0x87,0x22,0xd2,0x05,0x13,0x60,
        0x4d,0x4b,0x53,0x61,0x4a,0x68,0x82,0x43,0x4c,0x48,0x00,0x78,0xc0,0x07,0xc0,0x0f,
        0x83,0x04,0x1a,0x43,0x4a,0x60,0x8b,0x23,0x49,0x4a,0xdb,0x05,0x5a,0x63,0x49,0x4c,
        0x02,0x22,0xe2,0x60,0x05,0x22,0xca,0x60,0xda,0x63,0x01,0x22,0x22,0x61,0x62,0x62,
        0xa2,0x63,0x45,0x4c,0x22,0x60,0x45,0x4d,0x65,0x61,0xdc,0x6a,0x14,0x43,0xdc,0x62,
        0x4a,0x68,0x01,0x24,0x24,0x04,0x22,0x43,0x4a,0x60,0x4a,0x68,0xa5,0x10,0x2a,0x43,
        0x4a,0x60,0x40,0x4a,0x3e,0x4b,0x53,0x61,0x93,0x68,0x3f,0x26,0xb6,0x05,0x33,0x43,
        0x93,0x60,0x00,0x23,0xd3,0x60,0x3c,0x4b,0x93,0x61,0x3c,0x4b,0x1b,0x78,0x3c,0x2b,
        0x01,0xd1,0x06,0x23,0xd3,0x63,0x3a,0x4e,0x33,0x68,0x1e,0x27,0xbb,0x43,0x33,0x60,
        0x93,0x6a,0xfe,0x03,0xb3,0x43,0x01,0x26,0xb6,0x04,0x9b,0x19,0x93,0x62,0x35,0x4b,
        0xf0,0x22,0x5a,0x60,0x4a,0x68,0x03,0x04,0xa2,0x43,0x1a,0x43,0x4a,0x60,0x4a,0x68,
        0x83,0x03,0xaa,0x43,0x1a,0x43,0x4a,0x60,0x4a,0x68,0x74,0x11,0x22,0x43,0x4a,0x60,
        0x29,0x22,0x52,0x06,0x13,0x6a,0x1b,0x09,0x1b,0x01,0x08,0x33,0x13,0x62,0x2a,0x4b,
        0xd3,0x60,0x4a,0x68,0x43,0x03,0xa2,0x43,0x1a,0x43,0x4a,0x60,0x4a,0x68,0xe5,0x01,
        0x2a,0x43,0x4a,0x60,0x28,0x24,0xa3,0x23,0xdb,0x05,0x1c,0x60,0x23,0x4a,0x12,0x88,
        0x9a,0x62,0x23,0x4b,0x9a,0x62,0x4a,0x68,0x00,0x05,0xaa,0x43,0x02,0x43,0x4a,0x60,
        0x20,0x48,0xe6,0x23,0x03,0x70,0x04,0x72,0x1f,0x49,0x01,0x83,0x1f,0x49,0xe0,0x24,
        0x0c,0x76,0xd4,0x22,0x42,0x70,0x3c,0x22,0x42,0x72,0x1d,0x4a,0x42,0x83,0x4b,0x76,
        0xc8,0x22,0x82,0x70,0x46,0x25,0x85,0x72,0x1a,0x4d,0x85,0x83,0x8b,0x76,0xc2,0x70,
        0x50,0x22,0xc2,0x72,0x18,0x4a,0xc2,0x83,0xcc,0x76,0x5a,0x22,0x02,0x73,0x17,0x4a,
        0x02,0x84,0x0c,0x77,0xf0,0xbc,0x70,0x47,0xff,0x7f,0x00,0x00,0x3a,0x68,0x00,0x20,
        0x49,0x02,0x00,0x00,0x40,0x00,0x80,0x45,0x80,0x00,0x80,0x45,0x1e,0x02,0x00,0x00,
        0x03,0x00,0x3c,0x00,0x00,0x00,0x40,0x52,0x08,0x00,0x0f,0x00,0x41,0x68,0x00,0x20,
        0x00,0x00,0xc0,0x51,0x40,0x00,0x40,0x52,0xcc,0x34,0x63,0x02,0x50,0x68,0x00,0x20,
        0xc0,0x7e,0x00,0x20,0x50,0x6e,0x00,0x20,0xf6,0x07,0x00,0x00,0x70,0x6e,0x00,0x20,
        0xf6,0x09,0x00,0x00,0xf6,0x2d,0x00,0x00,0xf6,0x38,0x00,0x00,0xf6,0x3f,0x00,0x00,
        0xf8,0xb5,0x3f,0x48,0x00,0x68,0x00,0x28,0x78,0xd1,0x43,0x20,0x00,0x06,0x41,0x68,
        0x01,0x22,0xd2,0x03,0x11,0x43,0x41,0x60,0x3a,0x4f,0x3d,0x68,0x01,0x26,0x03,0x20,
        0x00,0x06,0x28,0x43,0x38,0x60,0x00,0x24,0x37,0x49,0x1e,0x20,0x88,0x47,0x36,0x49,
        0x01,0x20,0x88,0x47,0x78,0x68,0xc0,0x07,0xc0,0x0f,0x21,0x46,0x33,0x4a,0x64,0x1c,
        0x91,0x42,0x01,0xd8,0x00,0x28,0xf2,0xd0,0x2e,0x48,0x80,0x68,0x30,0x49,0x08,0x60,
        0x00,0x24,0x00,0x27,0x00,0x2e,0x11,0xd0,0x2e,0x4a,0x39,0x46,0x00,0x23,0x82,0x1a,
        0x99,0x41,0x14,0xda,0x64,0x1c,0x23,0x46,0x2a,0x4e,0x43,0x43,0x3a,0x46,0x00,0x21,
        0xf3,0x1a,0x91,0x41,0xc3,0x1a,0x8a,0x41,0xf4,0xdb,0x08,0xe0,0x26,0x49,0x88,0x42,
        0x05,0xd2,0x64,0x1c,0x22,0x46,0x42,0x43,0x8a,0x1a,0x82,0x42,0xf9,0xd8,0x23,0x4f,
        0x21,0x46,0x38,0x46,0xff,0xf7,0x44,0xfe,0x06,0x46,0x30,0x46,0x60,0x43,0x38,0x1a,
        0x00,0x03,0x21,0x46,0xff,0xf7,0x3c,0xfe,0x07,0x46,0x7d,0x20,0x19,0x21,0x00,0x02,
        0x89,0x01,0x84,0x42,0x05,0xd9,0x20,0x1a,0x00,0x04,0xff,0xf7,0x31,0xfe,0x01,0x46,
        0x04,0xe0,0x00,0x1b,0x00,0x04,0xff,0xf7,0x2b,0xfe,0x01,0x46,0x14,0x48,0x06,0x63,
        0x47,0x63,0x81,0x63,0x01,0x20,0x00,0x06,0x85,0x43,0x40,0x00,0x05,0x43,0x09,0x48,
        0x05,0x60,0x43,0x20,0x00,0x06,0x41,0x68,0x01,0x22,0xd2,0x03,0x91,0x43,0x0d,0x4a,
        0x12,0x78,0xd2,0x07,0x12,0x0c,0x11,0x43,0x41,0x60,0x20,0x46,0xf8,0xbd,0x00,0x00,
        0x60,0x68,0x00,0x20,0x00,0x00,0x40,0x44,0xe5,0x3e,0x00,0x00,0x10,0x27,0x00,0x00,
        0x64,0x68,0x00,0x20,0x00,0x20,0xbc,0xbe,0x00,0xd0,0x12,0x13,0x00,0x90,0xd0,0x03,
        0xc0,0x7e,0x00,0x20,0x3a,0x68,0x00,0x20,0x51,0x48,0x80,0x47,0x51,0x48,0x80,0x47,
        0x51,0x48,0x80,0x47,0x51,0x48,0x52,0x49,0x00,0x68,0x88,0x47,0x01,0x20,0xff,0xf7,
        0x5f,0xff,0x50,0x49,0x08,0x60,0x50,0x48,0x80,0x47,0x50,0x48,0x80,0x47,0x50,0x48,
        0x80,0x47,0x00,0x20,0xc0,0x26,0x4f,0x4c,0xff,0x27,0x01,0x46,0x40,0x1c,0x49,0xb2,
        0x00,0x29,0x10,0xda,0x0a,0x07,0x12,0x0f,0x08,0x3a,0x92,0x08,0x92,0x00,0x12,0x19,
        0xd5,0x69,0x89,0x07,0xc9,0x0e,0x3b,0x46,0x8b,0x40,0x9d,0x43,0x33,0x46,0x8b,0x40,
        0x1d,0x43,0xd5,0x61,0x0d,0xe0,0x8b,0x08,0x43,0x4a,0x9b,0x00,0x9a,0x18,0x13,0x68,
        0x89,0x07,0xc9,0x0e,0x3d,0x46,0x8d,0x40,0xab,0x43,0x35,0x46,0x8d,0x40,0x2b,0x43,
        0x13,0x60,0x1e,0x28,0xd9,0xd9,0x3d,0x49,0x08,0x68,0x00,0x0a,0x00,0x02,0x08,0x60,
        0x08,0x68,0xff,0x23,0x1b,0x02,0x98,0x43,0x08,0x60,0x0a,0x1d,0x10,0x68,0x00,0x02,
        0x00,0x0a,0x10,0x60,0x08,0x68,0x1d,0x02,0x01,0x26,0xa8,0x43,0xf6,0x05,0x30,0x43,
        0x08,0x60,0x08,0x1f,0x01,0x68,0x09,0x02,0x09,0x0a,0xc7,0x06,0x39,0x43,0x01,0x60,
        0x10,0x68,0x00,0x27,0x01,0x0a,0x09,0x02,0x80,0x20,0x01,0x43,0x11,0x60,0x10,0x68,
        0x71,0x12,0x98,0x43,0x08,0x43,0x10,0x60,0x10,0x68,0xa8,0x43,0x30,0x43,0x10,0x60,
        0x00,0x20,0x80,0xf3,0x10,0x88,0x26,0x4e,0x26,0x48,0x80,0x47,0x26,0x48,0x80,0x47,
        0x26,0x48,0x80,0x47,0x00,0x28,0xf7,0xd0,0x25,0x4d,0xa8,0x47,0x00,0x28,0xf3,0xdb,
        0xb0,0x47,0x00,0x28,0xf0,0xd1,0x23,0x48,0x80,0x47,0xa8,0x47,0x00,0x28,0xeb,0xdb,
        0xb0,0x47,0x00,0x28,0xe8,0xd1,0xef,0xf3,0x10,0x80,0xc5,0xb2,0x01,0x20,0x80,0xf3,
        0x10,0x88,0x1d,0x48,0x80,0x47,0x00,0x28,0x0e,0xd0,0x1c,0x48,0x01,0x68,0x00,0x29,
        0x05,0xd0,0x07,0x60,0x00,0xf0,0x34,0xf8,0x00,0xf0,0x8c,0xf8,0x04,0xe0,0x20,0x69,
        0xfb,0x21,0x08,0x40,0x20,0x61,0x30,0xbf,0x85,0xf3,0x10,0x88,0xcc,0xe7,0x00,0x00,
        0x6d,0x95,0x00,0x00,0x19,0x5f,0x01,0x00,0x6d,0x4f,0x01,0x00,0x20,0x68,0x00,0x20,
        0xa5,0x58,0x01,0x00,0x58,0x68,0x00,0x20,0x55,0x4f,0x01,0x00,0x65,0x50,0x01,0x00,
        0x49,0x4f,0x01,0x00,0x00,0xed,0x00,0xe0,0x00,0xe4,0x00,0xe0,0x0c,0xe4,0x00,0xe0,
        0x51,0x3a,0x00,0x00,0x79,0x5a,0x01,0x00,0x89,0x39,0x00,0x00,0x59,0x3f,0x00,0x00,
        0x1d,0x61,0x00,0x00,0x75,0x3a,0x00,0x00,0x8d,0x5a,0x01,0x00,0x70,0x68,0x00,0x20,
        0xf8,0xb5,0x00,0x24,0x24,0x48,0x80,0x47,0x43,0x25,0x2d,0x06,0x01,0x21,0x68,0x68,
        0x89,0x04,0x08,0x43,0x68,0x60,0x8b,0x26,0xf6,0x05,0x30,0x68,0x08,0x21,0x88,0x43,
        0x30,0x60,0x1e,0x48,0x80,0x47,0x06,0x20,0xe8,0x60,0x1d,0x4d,0x01,0x20,0xa8,0x47,
        0xa1,0x20,0xc0,0x05,0x01,0x6b,0x02,0x22,0x91,0x43,0x11,0x43,0x01,0x63,0x01,0x21,
        0x02,0x6b,0x8a,0x43,0x0a,0x43,0x02,0x63,0x01,0x6b,0x04,0x27,0xb9,0x43,0x39,0x43,
        0x01,0x63,0x14,0x48,0x41,0x68,0x89,0x00,0x0a,0xd5,0x01,0x20,0xa8,0x47,0x20,0x46,
        0x64,0x1c,0xe4,0xb2,0x19,0x28,0x03,0xd8,0x0e,0x48,0x40,0x68,0x80,0x00,0xf4,0xd4,
        0x0d,0x4c,0x0f,0x20,0x60,0x60,0x01,0x20,0xa8,0x47,0x07,0x20,0x60,0x60,0x04,0x20,
        0xa8,0x47,0x06,0x20,0x60,0x60,0x09,0x48,0x30,0x60,0x09,0x48,0x01,0x69,0x39,0x43,
        0x01,0x61,0x30,0xbf,0xf8,0xbd,0x00,0x00,0x75,0x3a,0x00,0x00,0x85,0xa3,0x00,0x00,
        0xe5,0x3e,0x00,0x00,0x80,0x00,0x80,0x45,0x40,0x00,0x80,0x45,0x26,0x03,0x00,0x00,
        0x00,0xed,0x00,0xe0,0x70,0xb5,0x48,0x4d,0x0f,0x20,0x68,0x60,0x8b,0x20,0xc0,0x05,
        0x01,0x68,0x46,0x4a,0x11,0x40,0x01,0x60,0x01,0x68,0x08,0x22,0x11,0x43,0x01,0x60,
        0x28,0x6a,0x04,0x21,0x08,0x43,0x28,0x62,0x41,0x48,0x80,0x47,0x05,0x20,0x43,0x24,
        0x24,0x06,0xe0,0x60,0x3f,0x4e,0x01,0x20,0xb0,0x47,0x3f,0x48,0x80,0x47,0x3f,0x48,
        0x80,0x47,0x3f,0x48,0x80,0x47,0x68,0x68,0x0d,0x28,0x03,0xd0,0x20,0x20,0xb0,0x47,
        0x0d,0x20,0x68,0x60,0x3b,0x48,0x80,0x47,0x60,0x68,0x01,0x23,0x1b,0x04,0x18,0x43,
        0x60,0x60,0x60,0x68,0x9a,0x10,0x10,0x43,0x60,0x60,0x38,0x48,0x36,0x49,0x41,0x61,
        0x81,0x68,0x3f,0x25,0xad,0x05,0x29,0x43,0x81,0x60,0x00,0x21,0xc1,0x60,0x34,0x49,
        0x81,0x61,0x34,0x49,0x09,0x78,0x3c,0x29,0x01,0xd1,0x06,0x21,0xc1,0x63,0x32,0x4d,
        0x29,0x68,0x1e,0x26,0xb1,0x43,0x29,0x60,0x81,0x6a,0xf5,0x03,0xa9,0x43,0x01,0x25,
        0xad,0x04,0x49,0x19,0x81,0x62,0x2d,0x49,0xf0,0x20,0x48,0x60,0x61,0x68,0x2c,0x48,
        0x99,0x43,0x00,0x78,0xc0,0x07,0xc0,0x0f,0x03,0x04,0x19,0x43,0x61,0x60,0x61,0x68,
        0x91,0x43,0x82,0x03,0x11,0x43,0x61,0x60,0x61,0x68,0x6a,0x11,0x11,0x43,0x61,0x60,
        0x29,0x21,0x24,0x4b,0x49,0x06,0xcb,0x60,0x0b,0x6a,0x1b,0x09,0x1b,0x01,0x08,0x33,
        0x0b,0x62,0x0b,0x68,0xd5,0x10,0x2b,0x43,0x0b,0x60,0x1f,0x4b,0x1b,0x78,0x5b,0x00,
        0x5b,0x1c,0x4b,0x61,0x61,0x68,0x91,0x43,0x42,0x03,0x11,0x43,0x61,0x60,0x62,0x68,
        0xa9,0x02,0x0a,0x43,0x62,0x60,0x28,0x23,0xa3,0x22,0xd2,0x05,0x13,0x60,0x17,0x4b,
        0x1b,0x88,0x93,0x62,0x62,0x68,0x00,0x05,0x8a,0x43,0x02,0x43,0x62,0x60,0x14,0x49,
        0x01,0x20,0x88,0x47,0x70,0xbd,0x00,0x00,0x40,0x00,0x80,0x45,0xfd,0xfd,0xff,0xff,
        0x75,0x3a,0x00,0x00,0xe5,0x3e,0x00,0x00,0x65,0x50,0x01,0x00,0x29,0x48,0x01,0x00,
        0xc5,0x64,0x01,0x00,0x69,0x48,0x01,0x00,0x03,0x00,0x3c,0x00,0x00,0x00,0x40,0x52,
        0x08,0x00,0x0f,0x00,0x41,0x68,0x00,0x20,0x00,0x00,0xc0,0x51,0x40,0x00,0x40,0x52,
        0x3a,0x68,0x00,0x20,0xcc,0x34,0x63,0x04,0x74,0x68,0x00,0x20,0x50,0x68,0x00,0x20,
        0xa1,0x59,0x01,0x00,0xff,0xb5,0x81,0xb0,0x0d,0x46,0x00,0x26,0x35,0x49,0x28,0x46,
        0x88,0x47,0x00,0x90,0x01,0x98,0x87,0x00,0x33,0x48,0xc4,0x59,0x20,0x46,0xa0,0x30,
        0x41,0x79,0x09,0x07,0x07,0xd5,0x00,0x79,0x07,0x28,0x04,0xd0,0x2f,0x4a,0x3d,0x21,
        0x01,0x98,0x90,0x47,0x52,0xe0,0x2e,0x49,0x01,0x98,0x88,0x47,0x04,0x28,0x4d,0xd1,
        0x68,0x46,0x01,0x78,0x02,0x20,0x88,0x43,0x08,0xd0,0x00,0x20,0x00,0x28,0x07,0xd0,
        0xa4,0x20,0x00,0x5d,0x07,0x28,0x03,0xd0,0x02,0x26,0x3f,0xe0,0x01,0x20,0xf5,0xe7,
        0x28,0x46,0x02,0x22,0x11,0x43,0x00,0x91,0x22,0x4e,0xb0,0x47,0x28,0x46,0x04,0x23,
        0x6a,0x46,0x11,0x78,0x19,0x43,0x00,0x91,0xb0,0x47,0x08,0x20,0xa4,0x21,0x08,0x55,
        0x04,0x98,0x80,0x1e,0x18,0x4e,0xf1,0x59,0x88,0x60,0xff,0x20,0x1a,0x4a,0x29,0x46,
        0x03,0x30,0x90,0x47,0xef,0xf3,0x10,0x80,0xc1,0xb2,0x01,0x20,0x80,0xf3,0x10,0x88,
        0xf0,0x59,0x0c,0x23,0xa0,0x30,0x42,0x79,0x1a,0x43,0x42,0x71,0x20,0x69,0x28,0x30,
        0x60,0x30,0x00,0x7e,0x81,0xf3,0x10,0x88,0x00,0x28,0x05,0xd0,0x40,0x34,0xa0,0x8b,
        0x04,0x21,0x08,0x43,0xa0,0x83,0x08,0xe0,0xff,0x20,0x07,0x30,0x0b,0x4c,0x00,0x23,
        0x2a,0x46,0x29,0x46,0xa0,0x47,0x0a,0x49,0x88,0x47,0x01,0x26,0x30,0x46,0x05,0xb0,
        0xf0,0xbd,0x00,0x00,0x0d,0x9f,0x00,0x00,0x64,0x69,0x00,0x20,0x25,0xc4,0x00,0x00,
        0x1d,0x0a,0x01,0x00,0x31,0x9f,0x00,0x00,0x89,0xa1,0x00,0x00,0xf5,0x9d,0x00,0x00,
        0x31,0x9e,0x00,0x00,0xff,0xb5,0x81,0xb0,0x1d,0x46,0x00,0x20,0x00,0x90,0x01,0x98,
        0x42,0x49,0x80,0x00,0x0e,0x58,0x01,0x23,0x34,0x46,0x40,0x34,0xe2,0x7c,0x1a,0x43,
        0xe2,0x74,0x08,0x58,0xa0,0x30,0x40,0x79,0x00,0x07,0x03,0xd5,0x3c,0x4a,0x3d,0x21,
        0x01,0x98,0x90,0x47,0x6a,0x88,0x1b,0x2a,0x0a,0xd3,0xeb,0x88,0x1b,0x2b,0x07,0xd3,
        0xa9,0x88,0xff,0x27,0x49,0x37,0xb9,0x42,0x02,0xd3,0x28,0x89,0xb8,0x42,0x05,0xd2,
        0x34,0x4b,0x29,0x78,0x20,0x22,0x01,0x98,0x98,0x47,0x5b,0xe0,0xa5,0x88,0x9d,0x42,
        0x00,0xd2,0x2b,0x46,0x9b,0xb2,0xa5,0x89,0x85,0x42,0x00,0xd2,0x28,0x46,0x80,0xb2,
        0x65,0x88,0x95,0x42,0x00,0xd2,0x2a,0x46,0x92,0xb2,0x65,0x89,0x8d,0x42,0x00,0xd2,
        0x29,0x46,0x89,0xb2,0x25,0x89,0x9d,0x42,0x08,0xd1,0x25,0x8a,0x85,0x42,0x05,0xd1,
        0xe5,0x88,0x95,0x42,0x02,0xd1,0xe5,0x89,0x8d,0x42,0x12,0xd0,0xef,0xf3,0x10,0x85,
        0xed,0xb2,0x01,0x27,0x87,0xf3,0x10,0x88,0x23,0x81,0x20,0x82,0xe2,0x80,0xe1,0x81,
        0x1d,0x4b,0x30,0x69,0x98,0x47,0x85,0xf3,0x10,0x88,0xe0,0x7c,0xfd,0x21,0x08,0x40,
        0xe0,0x74,0x1a,0x49,0x01,0x98,0x88,0x47,0xe0,0x7c,0x40,0x08,0x40,0x00,0xe0,0x74,
        0x17,0x49,0x40,0x22,0x09,0x7f,0x11,0x40,0x00,0xd0,0x01,0x21,0x00,0x29,0x19,0xd0,
        0x80,0x07,0x17,0xd4,0x0c,0x23,0x14,0x4d,0x3e,0x22,0x12,0x48,0x01,0x99,0xa8,0x47,
        0x07,0x21,0x01,0x70,0x01,0x99,0x41,0x80,0x21,0x89,0x01,0x81,0x21,0x8a,0x41,0x81,
        0xe1,0x88,0x81,0x80,0xe1,0x89,0xc1,0x80,0x0c,0x49,0x88,0x47,0xe0,0x7c,0x02,0x21,
        0x08,0x43,0xe0,0x74,0x00,0x98,0x05,0xb0,0xf0,0xbd,0x00,0x00,0x64,0x69,0x00,0x20,
        0x25,0xc4,0x00,0x00,0x3d,0xbb,0x00,0x00,0x95,0x26,0x01,0x00,0xe5,0xb7,0x00,0x00,
        0xb8,0x68,0x00,0x20,0x04,0x08,0x00,0x00,0xf5,0x9d,0x00,0x00,0xb5,0x8f,0x00,0x00,
        0xff,0xb5,0x85,0xb0,0x0c,0x46,0x1d,0x46,0x00,0x20,0x04,0x90,0x59,0x49,0x20,0x46,
        0x88,0x47,0x03,0x90,0x05,0x98,0x81,0x00,0x57,0x48,0x46,0x58,0xa5,0x20,0x80,0x5d,
        0x00,0x07,0x04,0xd5,0x55,0x4a,0x3d,0x21,0x05,0x98,0x90,0x47,0x9f,0xe0,0xff,0x20,
        0x53,0x4a,0x21,0x46,0x03,0x30,0x90,0x47,0x68,0x46,0x02,0x7b,0x01,0x20,0x90,0x43,
        0x08,0xd0,0x00,0x20,0x00,0x28,0x7d,0xd0,0x30,0x46,0xa0,0x30,0xc1,0x78,0x04,0x29,
        0x02,0xd0,0x87,0xe0,0x01,0x20,0xf5,0xe7,0x69,0x88,0x1b,0x29,0x72,0xd3,0xe9,0x88,
        0x1b,0x29,0x7f,0xd3,0xab,0x88,0xff,0x21,0x49,0x31,0x8b,0x42,0x7a,0xd3,0x2b,0x89,
        0x8b,0x42,0x77,0xd3,0x00,0x21,0xc1,0x70,0x51,0x08,0x49,0x00,0x03,0x91,0x41,0x4a,
        0x20,0x46,0x90,0x47,0x34,0x46,0x40,0x34,0xa0,0x88,0xe9,0x88,0x88,0x42,0x00,0xd3,
        0x08,0x46,0x80,0xb2,0x02,0x90,0xa0,0x89,0x29,0x89,0x88,0x42,0x00,0xd3,0x08,0x46,
        0x80,0xb2,0x01,0x90,0x60,0x88,0x69,0x88,0x88,0x42,0x00,0xd3,0x08,0x46,0x87,0xb2,
        0x60,0x89,0xa9,0x88,0x88,0x42,0x00,0xd3,0x08,0x46,0x85,0xb2,0x32,0x4b,0x30,0x69,
        0x29,0x46,0x01,0x9a,0x98,0x47,0x21,0x89,0x02,0x98,0x81,0x42,0x09,0xd1,0x21,0x8a,
        0x01,0x98,0x81,0x42,0x05,0xd1,0xe0,0x88,0xb8,0x42,0x02,0xd1,0xe0,0x89,0xa8,0x42,
        0x1a,0xd0,0x67,0x80,0x65,0x81,0xef,0xf3,0x10,0x80,0xc0,0xb2,0x00,0x90,0x01,0x20,
        0x80,0xf3,0x10,0x88,0x02,0x98,0x20,0x81,0x01,0x98,0x20,0x82,0xe7,0x80,0xe5,0x81,
        0x22,0x4b,0x3a,0x46,0x29,0x46,0x30,0x69,0x98,0x47,0x00,0x98,0x80,0xf3,0x10,0x88,
        0xe0,0x7c,0xfd,0x21,0x08,0x40,0xe0,0x74,0x1d,0x48,0x40,0x21,0x00,0x7f,0x08,0x40,
        0x00,0xd0,0x01,0x20,0x00,0x28,0x22,0xd0,0xe0,0x7c,0x80,0x07,0x1f,0xd4,0x0c,0x23,
        0x19,0x4d,0x3e,0x22,0x17,0x48,0x05,0x99,0xa8,0x47,0x07,0x21,0x01,0x70,0x05,0x99,
        0x41,0x80,0x00,0xe0,0x0e,0xe0,0x21,0x89,0x01,0x81,0x21,0x8a,0x41,0x81,0xe1,0x88,
        0x81,0x80,0xe1,0x89,0xc1,0x80,0x11,0x49,0x88,0x47,0xe0,0x7c,0x02,0x21,0x08,0x43,
        0xe0,0x74,0x04,0xe0,0x0e,0x4b,0x29,0x78,0x20,0x22,0x05,0x98,0x98,0x47,0x04,0x98,
        0x09,0xb0,0xf0,0xbd,0x0d,0x9f,0x00,0x00,0x64,0x69,0x00,0x20,0x25,0xc4,0x00,0x00,
        0x89,0xa1,0x00,0x00,0x31,0x9f,0x00,0x00,0x71,0x25,0x01,0x00,0x95,0x26,0x01,0x00,
        0xb8,0x68,0x00,0x20,0x04,0x08,0x00,0x00,0xf5,0x9d,0x00,0x00,0xb5,0x8f,0x00,0x00,
        0x3d,0xbb,0x00,0x00,0x70,0xb5,0x05,0x46,0x00,0x21,0x1a,0x4a,0x10,0x20,0x90,0x47,
        0x04,0x46,0x00,0x20,0x00,0x2c,0x29,0xd0,0x28,0x88,0x17,0x49,0x80,0x00,0x08,0x58,
        0x00,0x69,0x28,0x30,0x08,0x30,0xa9,0x68,0xe1,0x60,0x29,0x88,0xe1,0x80,0xa9,0x88,
        0x21,0x81,0xa9,0x78,0xa1,0x72,0x2f,0x21,0xa1,0x80,0x01,0x21,0x81,0xf3,0x10,0x88,
        0x0e,0x4a,0x21,0x46,0x90,0x47,0x00,0x20,0x80,0xf3,0x10,0x88,0x01,0x20,0xe1,0x88,
        0x5a,0x22,0x51,0x43,0x0a,0x4a,0x89,0x18,0x4a,0x8a,0x12,0x0b,0x02,0x2a,0x05,0xd3,
        0x4a,0x8a,0x12,0x05,0x12,0x0d,0x03,0x03,0x1a,0x43,0x4a,0x82,0x00,0x28,0x00,0xd0,
        0x01,0x20,0x70,0xbd,0x75,0x9c,0x00,0x00,0x64,0x69,0x00,0x20,0xa7,0x3c,0x00,0x00,
        0x80,0x40,0x80,0x50,0xf3,0xb5,0x85,0xb0,0x65,0x4a,0x04,0x92,0x16,0x78,0x4a,0x1e,
        0xd2,0xb2,0x06,0x92,0x00,0x29,0x72,0xd0,0x01,0x46,0x40,0x31,0x03,0x91,0x61,0x49,
        0x05,0x46,0x80,0x35,0x02,0x91,0xa8,0x79,0xc0,0x06,0x69,0xd4,0x01,0x21,0x5e,0x4a,
        0x10,0x20,0x90,0x47,0x04,0x46,0x0c,0x20,0x5c,0x4f,0x70,0x43,0xc0,0x19,0x01,0x8e,
        0x26,0x71,0x03,0x9a,0x92,0x8f,0xe2,0x80,0xc2,0x8d,0x22,0x81,0x23,0x46,0x0b,0x33,
        0x9c,0x46,0x5b,0x1c,0x22,0x46,0x9e,0x46,0x40,0x8e,0xc3,0x0b,0x53,0x73,0x82,0x04,
        0x92,0x0e,0x63,0x46,0x1a,0x70,0x73,0x46,0x18,0x70,0x00,0x20,0x60,0x71,0xa8,0x79,
        0xc2,0x07,0x05,0xd0,0x22,0x7a,0x52,0x06,0x02,0xd4,0x40,0x08,0x40,0x00,0xa8,0x71,
        0xe0,0x88,0x04,0x28,0x6f,0xd0,0x08,0x0a,0xa0,0x72,0xa8,0x79,0x82,0x07,0x0f,0xd5,
        0x22,0x7a,0xd2,0x07,0x0c,0xd1,0xfd,0x22,0x10,0x40,0xa8,0x71,0xe0,0x88,0xff,0x23,
        0x82,0x00,0x43,0x48,0x80,0x58,0x40,0x30,0x82,0x8b,0x01,0x33,0x1a,0x43,0x82,0x83,
        0x22,0x89,0xff,0x20,0x40,0x30,0x02,0x40,0x45,0xd1,0xa0,0x7a,0x00,0x28,0x42,0xd0,
        0x89,0x07,0x89,0x0f,0x01,0x91,0xe1,0x88,0x39,0x4a,0x8b,0x00,0xd2,0x58,0xa0,0x32,
        0x52,0x79,0x92,0x07,0x01,0xd5,0x00,0x1f,0xa0,0x72,0x01,0x98,0x01,0x28,0x1f,0xd0,
        0x02,0x28,0x1d,0xd0,0x03,0x28,0x0c,0xd0,0x20,0x79,0x0c,0x21,0x48,0x43,0xc0,0x19,
        0x81,0x8d,0x49,0x04,0x49,0x0c,0x81,0x85,0x01,0x20,0x60,0x71,0x33,0xe0,0x4a,0xe0,
        0x36,0xe0,0x2c,0x4a,0xa1,0x7a,0x20,0x46,0x90,0x47,0x20,0x79,0x0c,0x21,0x48,0x43,
        0xc0,0x19,0x81,0x8d,0x49,0x04,0x49,0x0c,0x81,0x85,0x01,0x20,0x60,0x71,0x22,0xe0,
        0x08,0x02,0x40,0x1c,0x81,0xb2,0x08,0x23,0x23,0x4f,0x0a,0x46,0x58,0x01,0xb8,0x47,
        0xe1,0x88,0x01,0x80,0xa1,0x7a,0x81,0x80,0x01,0x99,0x81,0x70,0x21,0x79,0x81,0x71,
        0x1e,0x49,0x88,0x47,0x0f,0xe0,0x00,0x2a,0x03,0xd0,0xa8,0x79,0x01,0x21,0x08,0x43,
        0xa8,0x71,0x20,0x79,0x0c,0x21,0x48,0x43,0xc0,0x19,0x81,0x8d,0x49,0x04,0x49,0x0c,
        0x81,0x85,0x01,0x20,0x60,0x71,0x16,0x4a,0x21,0x46,0x02,0x98,0x90,0x47,0x08,0xe0,
        0x0c,0x20,0x31,0x46,0x41,0x43,0x0d,0x48,0x08,0x18,0x81,0x8d,0x49,0x04,0x49,0x0c,
        0x81,0x85,0x76,0x1c,0x76,0x07,0x76,0x0f,0x06,0x98,0x41,0x1e,0xc9,0xb2,0x06,0x91,
        0x00,0x28,0x00,0xd0,0x47,0xe7,0x04,0x98,0x06,0x70,0x07,0xb0,0xf0,0xbd,0x00,0x00,
        0x5c,0x6c,0x00,0x20,0xb0,0x69,0x00,0x20,0x75,0x9c,0x00,0x00,0x80,0x44,0x80,0x50,
        0x64,0x69,0x00,0x20,0xad,0x14,0x01,0x00,0xf5,0x9d,0x00,0x00,0x31,0x9e,0x00,0x00,
        0xa7,0x3c,0x00,0x00,0x10,0xb5,0x19,0x48,0x80,0x7a,0xc0,0x07,0x01,0xd0,0x00,0x20,
        0x10,0xbd,0x17,0x48,0x80,0x47,0x05,0x20,0x00,0x07,0xc0,0x69,0x15,0x49,0x00,0x05,
        0x04,0xd0,0x08,0x78,0x01,0x28,0x15,0xd0,0x02,0x28,0x13,0xd0,0x08,0x78,0x00,0x28,
        0x08,0xd0,0x01,0x28,0x06,0xd0,0x02,0x28,0x04,0xd0,0x0f,0x48,0x80,0x47,0x0f,0x49,
        0x32,0x20,0x88,0x47,0x0e,0x48,0x41,0x68,0x0d,0x29,0x08,0xd0,0x40,0x68,0x0e,0x28,
        0x05,0xd0,0x06,0xe0,0x0b,0x49,0x04,0x20,0x88,0x47,0x01,0x20,0x10,0xbd,0x0a,0x48,
        0x80,0x47,0x0a,0x49,0x04,0x20,0x88,0x47,0x00,0x20,0x10,0xbd,0x0c,0x6e,0x00,0x20,
        0x51,0x9a,0x00,0x00,0x18,0x10,0x00,0x20,0x69,0x61,0x01,0x00,0xe5,0x3e,0x00,0x00,
        0x40,0x00,0x80,0x45,0xa1,0x59,0x01,0x00,0xd3,0x60,0x01,0x00,0x59,0x59,0x01,0x00,
        0x41,0xb2,0x15,0x48,0x00,0x88,0x15,0x4a,0x90,0x42,0x01,0xd1,0x41,0x20,0x1e,0xe0,
        0x13,0x4a,0x90,0x42,0x01,0xd1,0x3c,0x20,0x19,0xe0,0x12,0x4a,0x90,0x42,0x01,0xd1,
        0x37,0x20,0x14,0xe0,0x10,0x4a,0x90,0x42,0x01,0xd1,0x32,0x20,0x0f,0xe0,0x0f,0x4a,
        0x90,0x42,0x01,0xd1,0x2d,0x20,0x0a,0xe0,0x0d,0x4a,0x90,0x42,0x01,0xd1,0x37,0x20,
        0x05,0xe0,0x0c,0x4a,0x90,0x42,0x01,0xd1,0x2f,0x20,0x00,0xe0,0x28,0x20,0x40,0x42,
        0x40,0x18,0x40,0xb2,0x70,0x47,0x00,0x00,0x50,0x68,0x00,0x20,0xf6,0x3f,0x00,0x00,
        0xf6,0x38,0x00,0x00,0xf6,0x2d,0x00,0x00,0xf6,0x09,0x00,0x00,0xf6,0x07,0x00,0x00,
        0xf6,0x20,0x00,0x00,0x96,0x20,0x00,0x00,0x70,0xb5,0x42,0x48,0x41,0x68,0x0d,0x29,
        0x06,0xd0,0x0d,0x21,0x41,0x60,0x40,0x49,0x01,0x20,0x88,0x47,0x3f,0x48,0x80,0x47,
        0x43,0x24,0x24,0x06,0x60,0x68,0x01,0x22,0x52,0x03,0x10,0x43,0x60,0x60,0x29,0x20,
        0x3b,0x49,0x40,0x06,0xc1,0x60,0x01,0x6a,0x09,0x09,0x09,0x01,0x08,0x31,0x01,0x62,
        0x01,0x68,0xd3,0x10,0x19,0x43,0x01,0x60,0x36,0x49,0x09,0x78,0x49,0x00,0x49,0x1c,
        0x41,0x61,0x61,0x68,0x34,0x4e,0x91,0x43,0x30,0x78,0xc0,0x07,0xc0,0x0f,0x42,0x03,
        0x11,0x43,0x61,0x60,0x31,0x49,0x09,0x78,0x3c,0x29,0x0b,0xd1,0x62,0x68,0x99,0x01,
        0x0a,0x43,0x62,0x60,0x2e,0x4b,0x06,0x22,0xda,0x63,0x62,0x68,0x8a,0x43,0x01,0x04,
        0x0a,0x43,0x62,0x60,0x61,0x68,0x01,0x22,0x12,0x05,0x11,0x43,0x61,0x60,0x28,0x25,
        0xa3,0x21,0xc9,0x05,0x0d,0x60,0x27,0x4b,0x1b,0x88,0x8b,0x62,0x61,0x68,0x00,0x05,
        0x91,0x43,0x01,0x43,0x61,0x60,0xff,0xf7,0x41,0xf8,0x80,0x02,0x80,0x0a,0x29,0x07,
        0x01,0x43,0x21,0x48,0x81,0x62,0x60,0x68,0xff,0x21,0x01,0x31,0x08,0x43,0x60,0x60,
        0x1e,0x48,0x1f,0x4a,0x00,0x78,0xc3,0x07,0xdb,0x0f,0x53,0x61,0xc0,0x06,0xc0,0x0f,
        0x90,0x61,0x1c,0x48,0x1c,0x4a,0x00,0x88,0x90,0x42,0x01,0xd0,0x1b,0x4a,0x50,0x62,
        0x1b,0x48,0x02,0x78,0x1b,0x48,0x00,0x2a,0x01,0xd0,0x01,0x22,0x82,0x60,0x1a,0x4a,
        0x12,0x78,0x00,0x2a,0x05,0xd0,0x45,0x62,0x18,0x4b,0x26,0x22,0x1a,0x61,0x02,0x22,
        0xc2,0x62,0x60,0x68,0x88,0x43,0x31,0x78,0xc9,0x07,0xc9,0x0d,0x08,0x43,0x60,0x60,
        0x70,0xbd,0x00,0x00,0x40,0x00,0x80,0x45,0xe5,0x3e,0x00,0x00,0xd3,0x60,0x01,0x00,
        0xcc,0x34,0x63,0x04,0x74,0x68,0x00,0x20,0x3a,0x68,0x00,0x20,0x41,0x68,0x00,0x20,
        0x00,0x00,0x40,0x52,0x50,0x68,0x00,0x20,0x00,0x01,0x80,0x50,0x35,0x68,0x00,0x20,
        0x40,0x04,0xc0,0x50,0x52,0x68,0x00,0x20,0xff,0x0f,0x00,0x00,0x80,0x04,0xc0,0x50,
        0x39,0x68,0x00,0x20,0x00,0x04,0xc0,0x50,0x36,0x68,0x00,0x20,0xc0,0x04,0xc0,0x50,
        0xff,0xb5,0xff,0xb0,0x82,0xb0,0x05,0x46,0x0c,0x46,0x00,0x27,0x2d,0x49,0x02,0x20,
        0x88,0x47,0x2d,0x48,0x80,0x47,0x2d,0x48,0x80,0x47,0x2d,0x48,0x80,0x47,0x2d,0x48,
        0x2d,0x4b,0x00,0x78,0x2d,0x4e,0x00,0x28,0x02,0xd0,0x01,0x28,0x08,0xd0,0x1e,0xe0,
        0x64,0x1e,0xa7,0xb2,0x28,0x78,0xb0,0x61,0x39,0x46,0x68,0x1c,0x98,0x47,0x16,0xe0,
        0x69,0x46,0x0c,0x70,0x20,0x0a,0x48,0x70,0x00,0x22,0x68,0x46,0x00,0x2c,0x06,0xd9,
        0xa9,0x5c,0x87,0x18,0xb9,0x70,0x52,0x1c,0x92,0xb2,0xa2,0x42,0xf8,0xd3,0x64,0x1c,
        0xa7,0xb2,0x69,0x46,0x09,0x78,0xb1,0x61,0x39,0x46,0x40,0x1c,0x98,0x47,0x78,0x07,
        0x40,0x0f,0xf1,0x68,0x09,0x07,0x09,0x0f,0x81,0x42,0xfa,0xd3,0x18,0x49,0x0a,0x20,
        0x88,0x47,0x18,0x48,0x80,0x47,0x18,0x48,0x81,0x68,0x89,0x07,0xfc,0xd5,0x70,0x68,
        0x80,0x07,0xfc,0xd5,0x08,0x20,0x70,0x60,0x00,0x20,0xb0,0x61,0x13,0x48,0x80,0x47,
        0x13,0x48,0x80,0x47,0x83,0x9a,0x00,0x21,0x84,0x98,0x90,0x47,0x11,0x48,0x00,0x78,
        0x00,0x28,0x03,0xd1,0x12,0x4a,0x10,0x49,0x10,0x48,0x90,0x47,0x7f,0xb0,0x06,0xb0,
        0xf0,0xbd,0x00,0x00,0xa1,0x59,0x01,0x00,0xbd,0x60,0x01,0x00,0xe9,0x5f,0x00,0x00,
        0xad,0x2d,0x00,0x00,0x3e,0x68,0x00,0x20,0x09,0x43,0x00,0x00,0x00,0x00,0xc0,0x52,
        0xe5,0x3e,0x00,0x00,0x09,0x62,0x01,0x00,0xc0,0x02,0x00,0x50,0x9d,0x2d,0x00,0x00,
        0xf5,0x61,0x01,0x00,0x01,0x10,0x00,0x20,0xff,0x03,0x00,0x00,0x18,0x10,0x00,0x20,
        0x85,0x42,0x00,0x00
    }
};

am_hal_ble_patch_t am_ble_performance_patch_b0 =
{
    .ui32Type = 0xBB,
    .ui32Length = 0x12b4,
    .ui32CRC = 0x36f5,
    .pui32Data = am_ble_performance_patch_data_b0.words,
};


//*****************************************************************************



//*****************************************************************************
//
// Patch Name:  Function PATCH v0.4    for Apollo3 B0
//
// Reduce duration from TX to TX
// Optimized 32K XO frequency calculation
// Optimized AGC Table
// Fixed Channelmap indication rejected issue
// Fixed 800M Spur
// Fixed feature issue
// Fixed disconnect issue  //long time large data transfer
// Date:        2019-10-25
//*****************************************************************************
//*****************************************************************************
// Fixed Sweyntooth security issues
// Fixed channel number less than 2 during channel map update
// Added protection for certain tx buffer list operation
// Disabled interrupt during AES operation
// Fixed interrupt nested disable/restore issues
// Date:        2020-04-27
//*****************************************************************************
//*****************************************************************************
// Improved instant past issue  0x28
// Improved disconnet response timout issue 0x22
// Date:        2020-08-23
//*****************************************************************************
//*****************************************************************************
// Fixed RD_REM_FEATURE issue when controller is busy
// Improved RD_RSSI
// Date:        2020-09-01
//*****************************************************************************

//*****************************************************************************
// Fixed can't enter sleep when no RF task (stop advertising)
// Date:        2020-12-03
//*****************************************************************************

//*****************************************************************************
// Improved DHKey generation procedure.
// Improved connection parameter request procedure.
// Date:        2020-12-14
//*****************************************************************************

//*****************************************************************************
// Optimize process for LLCP packet with invalid length.
// Optimize process when receiving invalid parameter of LL_LEN_RSP.
// Date:        2021-01-07
//*****************************************************************************
//*****************************************************************************
// Fixed        No GATT response message during pairing issue
// Date:        2021-05-30
//*****************************************************************************

//*****************************************************************************
// Fixed        master mode connection issue
// Date:        2021-07-19
//*****************************************************************************
//*****************************************************************************
// Fixed        No response to LL_ENC_REQ issue
// Date:        2021-08-10
//*****************************************************************************

//*****************************************************************************
//   Optimize process when receiving invalid parameter of LL_LEN_REQ.
// Date:        2021-09-13
//*****************************************************************************

const  am_hal_ble_buffer(0x0720)am_ble_buffer_patch_data_b0 =
{
    .bytes =
    {
        0x00,0x22,0x20,0x07,0xff,0x3f,0x00,0x00,0x84,0xf5,0x07,0x00,0x73,0xfd,0x07,0x00,
        0x75,0x05,0x08,0x00,0x17,0x0b,0x08,0x00,0xa9,0x15,0x08,0x00,0x18,0x1b,0x08,0x00,
        0x2d,0x23,0x08,0x00,0xc5,0x2c,0x08,0x00,0xf4,0x32,0x08,0x00,0xff,0x39,0x08,0x00,
        0x64,0x43,0x08,0x00,0xf9,0x49,0x08,0x00,0xee,0x51,0x08,0x00,0x54,0x5c,0x08,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x21,0x20,0xec,0xf7,
        0xf9,0xfc,0x00,0x28,0x0a,0xd0,0x00,0x20,0x00,0x90,0x03,0x46,0x02,0x46,0x01,0x46,
        0x24,0x68,0x21,0x20,0x35,0x34,0xa0,0x47,0x00,0xbf,0x38,0xbd,0xef,0xf7,0xfb,0xfe,
        0x0f,0x49,0x00,0x28,0x02,0xd0,0x08,0x78,0x01,0x28,0x12,0xd0,0x08,0x78,0x02,0x28,
        0x0f,0xd0,0x00,0x28,0x06,0xd0,0x01,0x28,0x04,0xd0,0x00,0xf0,0x0c,0x6e,0x00,0x20,
        0x00,0x00,0x00,0x04,0x1c,0x6e,0x00,0x20,0x00,0x49,0x08,0x47,0x01,0x43,0x00,0x20,
        0x23,0x4e,0xca,0x7c,0x75,0x68,0xc9,0x6a,0x00,0x2a,0x1d,0xd0,0x7d,0x22,0x12,0x02,
        0x91,0x42,0x02,0xd3,0x8a,0x1a,0x01,0x20,0x00,0xe0,0x52,0x1a,0x00,0x28,0x05,0xd0,
        0x20,0x46,0x50,0x43,0xea,0xf7,0x02,0xfa,0x20,0x1a,0x04,0xe0,0xea,0xf7,0xde,0xf9,
        0x00,0x19,0x01,0x02,0xc2,0x00,0x69,0x18,0x12,0x18,0x89,0x18,0x4a,0x0a,0x53,0x02,
        0xc9,0x1a,0x71,0x60,0x1e,0x21,0x48,0x43,0x80,0x18,0x70,0xbd,0x2c,0x68,0x00,0x20,
        0x0c,0x6e,0x00,0x20,0x00,0x49,0x08,0x47,0x31,0x43,0x00,0x20,0xc1,0x7c,0xc0,0x6a,
        0x00,0x29,0x15,0xd0,0x7d,0x21,0x09,0x02,0x88,0x42,0x02,0xd3,0x02,0xd5,0x04,0x20,
        0x60,0x70,0x34,0xe0,0x28,0x69,0x06,0xf0,0xb5,0xf8,0x00,0x28,0x02,0xd0,0x02,0x20,
        0x60,0x70,0x2c,0xe0,0x03,0x98,0x04,0xf0,0x1f,0xfa,0x04,0x28,0x07,0xd1,0x68,0x46,
        0x01,0x79,0x02,0x20,0x88,0x43,0x05,0xd0,0x00,0x20,0x00,0x28,0x04,0xd0,0x00,0xbf,
        0x00,0x20,0x1c,0xe0,0x01,0x20,0xf8,0xe7,0xf0,0x88,0x00,0x90,
                                AM_HAL_BLE_LOCAL_FEATURE, //0x21,
                                0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,
        0xff,0x03,0x00,0x00,0xff,0x00,0x3c,0x1f,0x00,0x00,0x00,0x00,0x01,0x20,0x00,0x00,
        0x8d,0x84,0x00,0x00,0x02,0x20,0x00,0x00,0xcd,0x7d,0x00,0x00,0x03,0x20,0x00,0x00,
        0xd1,0x7e,0x00,0x00,0x05,0x20,0x00,0x00,0xfd,0x84,0x00,0x00,0x28,0x69,0x28,0x30,
        0x40,0x30,0x01,0x8d,0x00,0x98,0x40,0x1a,0x2a,0x49,0x80,0xb2,0x00,0xbf,0x00,0xbf,
        0x28,0x46,0x05,0x22,0x71,0x1c,0x63,0x30,0xf3,0xf7,0xac,0xfd,0x28,0x69,0x00,0x99,
        0x01,0xf0,0xdf,0xfb,0x01,0x20,0x60,0x70,0x01,0xe0,0x03,0x20,0x60,0x70,0x00,0x2f,
        0x39,0xd1,0x60,0x78,0x06,0x28,0x36,0xd2,0x01,0x00,0x79,0x44,0x00,0xbf,0x00,0xbf,
        0x31,0x89,0x56,0x22,0x51,0x53,0x31,0x46,0x01,0xf0,0x3e,0xfe,0x01,0x20,0x60,0x70,
        0x01,0xe0,0x03,0x20,0x60,0x70,0x00,0x2f,0x67,0xd1,0x60,0x78,0x06,0x28,0x64,0xd2,
        0x01,0x00,0x79,0x44,0x09,0x79,0x49,0x18,0x8f,0x44,0x5f,0x18,0x0c,0x02,0x07,0x12,
        0x28,0x21,0x05,0x98,0xff,0xf7,0x54,0xfc,0x57,0xe0,0x3d,0x21,0x78,0x68,0x00,0x20,
        0xac,0x6d,0x00,0x20,0x40,0x00,0x80,0x50,0x17,0x20,0x00,0x00,0x01,0x08,0x00,0x00,
        0x7e,0x40,0x80,0x50,0xd8,0x68,0x00,0x20,0x00,0x49,0x08,0x47,0x91,0x43,0x00,0x20,
        0x11,0x43,0xc3,0x78,0x82,0x78,0x1b,0x02,0x1a,0x43,0x12,0x04,0x0a,0x43,0x1a,0x4c,
        0x62,0x60,0x42,0x79,0x01,0x79,0x12,0x02,0x11,0x43,0xc3,0x79,0x13,0x2e,0x1b,0xd0,
        0xa1,0x21,0x0e,0x55,0x02,0x22,0x69,0x46,0x0a,0x72,0x4e,0x72,0x0f,0x21,0x08,0x43,
        0x01,0x90,0x01,0x46,0x38,0x46,0xfe,0xf7,0x09,0xf9,0x69,0x46,0x0a,0x7a,0xe8,0xb2,
        0x02,0xa9,0xff,0xf7,0x55,0xff,0x40,0x34,0xff,0x20,0xa2,0x8a,0x39,0x46,0x03,0x30,
        0x00,0xbf,0x00,0xbf,0x03,0xb0,0xf0,0xbd,0x16,0x22,0xa1,0x21,0x20,0x88,0x80,0x00,
        0x38,0x58,0x40,0x30,0x00,0x7f,0xc0,0x07,0x05,0xd0,0x00,0x25,0x2f,0xe0,0x20,0x88,
        0x08,0xf0,0x22,0xfd,0x2b,0xe0,0x68,0x46,0x01,0x7a,0x01,0x20,0x88,0x43,0x03,0xd0,
        0x00,0x20,0x00,0x28,0x08,0xd1,0x01,0xe0,0x01,0x20,0xfa,0xe7,0x04,0x20,0x88,0x43,
        0x04,0xd0,0x00,0x20,0x00,0x28,0x03,0xd0,0x3a,0x25,0x18,0xe0,0x11,0x43,0x81,0x83,
        0x0f,0x21,0x30,0x46,0xfc,0xf7,0x12,0xfb,0x28,0x46,0x03,0xf0,0x85,0xf8,0x04,0x28,
        0x03,0xd1,0x61,0x78,0x28,0x46,0xfe,0xf7,0x83,0xfd,0x00,0x20,0x70,0xbd,0x00,0x00,
        0x64,0x69,0x00,0x20,0x30,0xb4,0x02,0x4c,0xa4,0x46,0x30,0xbc,0x60,0x47,0x00,0x00,
        0x39,0x44,0x00,0x20,0xe9,0xfa,0x01,0x46,0x00,0x90,0x03,0x98,0x20,0x88,0x68,0x80,
        0x28,0x46,0x01,0xf0,0xb5,0xf8,0x00,0x20,0xf8,0xbd,0x00,0x00,0x15,0x20,0x00,0x00,
        0x01,0x08,0x00,0x00,0x64,0x69,0x00,0x20,0xf0,0xb5,0x83,0xb0,0x18,0x46,0x00,0x24,
        0x18,0x4d,0xe9,0x7a,0x00,0x29,0x00,0xd0,0x00,0x24,0x21,0x46,0x0a,0xf0,0x42,0xfe,
        0x00,0x2c,0x24,0xd1,0x01,0x26,0x01,0x96,0x13,0x4c,0x02,0xaa,0xf9,0xfd,0x04,0x46,
        0x03,0xe0,0x30,0x46,0x0b,0xf0,0x5c,0xfe,0x04,0x46,0x21,0x46,0x38,0x46,0x0a,0xf0,
        0xa3,0xff,0x00,0x20,0xf8,0xbd,0x00,0x00,0x2e,0x20,0x00,0x00,0xd9,0xdf,0xff,0xff,
        0xf8,0x68,0x00,0x20,0x10,0xb5,0x82,0xb0,0x0a,0x46,0x1c,0x46,0x00,0x21,0x0d,0x48,
        0xc3,0x7a,0x00,0x2b,0x00,0xd0,0x00,0xbf,0x00,0x21,0x0c,0xd1,0xee,0xf7,0x3a,0xfe,
        0xa0,0x78,0x16,0x28,0x02,0xd3,0x19,0x20,0x20,0x70,0x13,0xe0,0x0c,0x21,0x0c,0x4a,
        0x48,0x43,0x11,0x5c,0xb1,0x42,0x02,0xd0,0x19,0x20,0x20,0x70,0x0a,0xe0,0x00,0x21,
        0x21,0x70,0x6d,0x1c,0x80,0x18,0x76,0x1e,0xad,0xb2,0x83,0x68,0xf1,0xb2,0xa2,0x1c,
        0x28,0x46,0x98,0x47,0x20,0x46,0x70,0xbd,0x80,0x44,0x80,0x50,0x08,0x4a,0x11,0x6b,
        0x52,0x6b,0x08,0x4b,0x98,0x42,0x01,0xd9,0x00,0x20,0x70,0x47,0x41,0x43,0x42,0x43,
        0x89,0x09,0x90,0x0c,0x08,0x18,0x04,0x49,0x88,0x42,0xf6,0xd9,0x00,0x20,0x70,0x47,
        0xc0,0x7e,0x00,0x20,0x80,0x84,0x1e,0x00,0x00,0x87,0x93,0x03,0x10,0xb4,0x13,0x49,
        0x89,0x6b,0x13,0x4a,0x90,0x42,0x02,0xd9,0x10,0xbc,0x00,0x20,0x70,0x47,0x11,0x4a,
        0x7d,0x24,0x13,0x68,0x14,0x22,0x24,0x02,0x42,0x43,0xa3,0x42,0x03,0xd9,0x41,0x43,
        0x08,0x0c,0x10,0x18,0x02,0xe0,0x41,0x43,0x08,0x0c,0x10,0x1a,0x0a,0x49,0x88,0x42,
        0x02,0xd9,0x00,0x20,0x10,0xbc,0x70,0x47,0x00,0x28,0x00,0xd0,0x40,0x1e,0xa3,0x42,
        0xf8,0xd2,0x00,0x28,0xf6,0xd0,0x10,0xbc,0x40,0x1e,0x70,0x47,0xc0,0x7e,0x00,0x20,
        0xa0,0x86,0x01,0x00,0x58,0x68,0x00,0x20,0x80,0x84,0x1e,0x00,0xf0,0xb4,0xef,0xf3,
        0x10,0x81,0xcc,0xb2,0x01,0x21,0x81,0xf3,0x10,0x88,0x42,0x78,0x01,0x78,0x12,0x02,
        0x11,0x43,0xc3,0x78,0x82,0x78,0x1b,0x02,0x1a,0x43,0x12,0x04,0x0a,0x43,0x1d,0x4d,
        0x6a,0x60,0x42,0x79,0x01,0x79,0x12,0x02,0x11,0x43,0xc3,0x79,0x82,0x79,0x1b,0x02,
        0x1a,0x43,0x12,0x04,0x0a,0x43,0xaa,0x60,0x42,0x7a,0x01,0x7a,0x12,0x02,0x11,0x43,
        0xc3,0x7a,0x82,0x7a,0x1b,0x02,0x1a,0x43,0x12,0x04,0x0a,0x43,0xea,0x60,0x42,0x7b,
        0x01,0x7b,0x12,0x02,0x11,0x43,0xc3,0x7b,0x82,0x7b,0x1b,0x02,0x1a,0x43,0x12,0x04,
        0x0a,0x43,0x2a,0x61,0x10,0x30,0x10,0x23,0x0b,0x4a,0x00,0x21,0x46,0x5c,0x56,0x54,
        0x49,0x1c,0x89,0xb2,0x99,0x42,0xf9,0xd3,0x6e,0x20,0x68,0x61,0x01,0x20,0x28,0x60,
        0x06,0x48,0x01,0x21,0x01,0x74,0x84,0xf3,0x10,0x88,0xf0,0xbc,0x04,0x49,0x10,0x20,
        0x08,0x47,0x00,0x00,0xc0,0x00,0x80,0x50,0x6e,0x40,0x80,0x50,0xd8,0x68,0x00,0x20,
        0xa1,0x59,0x01,0x00,0xff,0xb5,0x85,0xb0,0x0e,0x46,0x1f,0x46,0x00,0x20,0x02,0x90,
        0x74,0x49,0x30,0x46,0x88,0x47,0x01,0x46,0x01,0x90,0x05,0x98,0x72,0x4a,0x80,0x00,
        0x04,0x90,0x14,0x58,0x25,0x46,0xa0,0x35,0x6b,0x79,0x18,0x07,0x07,0xd5,0xe8,0x78,
        0x0d,0x28,0x04,0xd0,0x6d,0x4a,0x3d,0x21,0x05,0x98,0x90,0x47,0xce,0xe0,0x01,0x20,
        0x88,0x43,0x0d,0xd0,0x00,0x20,0x00,0x28,0x74,0xd0,0xe8,0x78,0x68,0x4a,0x03,0x92,
        0x05,0x28,0x70,0xd0,0x06,0xdc,0x01,0x28,0x1b,0xd0,0x04,0x28,0x6a,0xd1,0x74,0xe0,
        0x01,0x20,0xf0,0xe7,0x07,0x28,0x2d,0xd0,0x0d,0x28,0x63,0xd1,0xd8,0x06,0x61,0xd4,
        0x00,0x24,0x6c,0x71,0x1a,0x22,0x5f,0x4b,0x00,0x21,0x05,0x98,0x98,0x47,0x68,0x46,
        0x01,0x79,0x49,0x08,0x49,0x00,0x01,0x91,0x5b,0x4a,0x30,0x46,0x90,0x47,0xec,0x70,
        0xa4,0xe0,0x78,0x78,0x0e,0x28,0x4d,0xd1,0xff,0x20,0x58,0x4a,0x31,0x46,0x03,0x30,
        0x90,0x47,0x22,0x46,0x69,0x32,0x56,0x4b,0x1a,0x20,0x05,0x99,0x98,0x47,0x68,0x46,
        0x01,0x79,0x49,0x08,0x49,0x00,0x01,0x91,0x4f,0x4a,0x30,0x46,0x90,0x47,0x00,0x20,
        0xe8,0x70,0x8b,0xe0,0x78,0x78,0x0f,0x28,0x34,0xd1,0xff,0x20,0x4b,0x4a,0x31,0x46,
        0x03,0x30,0x90,0x47,0x20,0x46,0x60,0x30,0x41,0x7a,0xfd,0x22,0x11,0x40,0x41,0x72,
        0x48,0x49,0x05,0x98,0x88,0x47,0x03,0x28,0x26,0xd0,0x20,0x46,0x40,0x30,0x01,0x46,
        0x80,0x8b,0x42,0x06,0x10,0xd5,0x40,0x22,0x90,0x43,0x88,0x83,0x03,0x98,0x04,0x21,
        0x00,0x7f,0x08,0x40,0x00,0xd0,0x01,0x20,0x00,0x28,0x05,0xd0,0x22,0x69,0x28,0x32,
        0x3d,0x4b,0x1a,0x20,0x05,0x99,0x98,0x47,0x3c,0x4a,0x00,0x21,0x05,0x98,0x90,0x47,
        0x68,0x46,0x01,0x79,0x49,0x08,0x49,0x00,0x01,0x91,0x33,0x4a,0x30,0x46,0x90,0x47,
        0x00,0x20,0xe8,0x70,0x52,0xe0,0x41,0xe0,0x2b,0x49,0x04,0x98,0x08,0x58,0x00,0x68,
        0x02,0x21,0x01,0x70,0x32,0x49,0x88,0x47,0x48,0xe0,0x78,0x78,0x14,0x28,0x45,0xd1,
        0xff,0x20,0x2a,0x4a,0x31,0x46,0x03,0x30,0x90,0x47,0x01,0x20,0x40,0x34,0xa0,0x74,
        0x03,0x98,0x40,0x21,0x00,0x7f,0x08,0x40,0x00,0xd0,0x01,0x20,0x00,0x28,0x1a,0xd0,
        0xe0,0x7c,0x80,0x07,0x17,0xd4,0x0c,0x23,0x27,0x4f,0x3e,0x22,0x25,0x48,0x05,0x99,
        0xb8,0x47,0x07,0x21,0x01,0x70,0x05,0x99,0x41,0x80,0x21,0x89,0x01,0x81,0x21,0x8a,
        0x41,0x81,0xe1,0x88,0x81,0x80,0xe1,0x89,0xc1,0x80,0x20,0x49,0x88,0x47,0xe0,0x7c,
        0x02,0x21,0x08,0x43,0xe0,0x74,0x68,0x46,0x01,0x79,0x49,0x08,0x49,0x00,0x01,0x91,
        0x11,0x4a,0x30,0x46,0x90,0x47,0x00,0x20,0xe8,0x70,0x0f,0xe0,0x78,0x78,0x12,0x28,
        0x0c,0xd1,0x49,0x08,0x49,0x00,0x01,0x91,0x0b,0x4a,0x30,0x46,0x90,0x47,0x00,0x20,
        0xe8,0x70,0xff,0x20,0x09,0x4a,0x31,0x46,0x03,0x30,0x90,0x47,0x02,0x98,0x09,0xb0,
        0xf0,0xbd,0x00,0x00,0x0d,0x9f,0x00,0x00,0x64,0x69,0x00,0x20,0x25,0xc4,0x00,0x00,
        0xb8,0x68,0x00,0x20,0x05,0xa8,0x00,0x00,0x31,0x9f,0x00,0x00,0x89,0xa1,0x00,0x00,
        0x1d,0xb0,0x00,0x00,0x1d,0x0a,0x01,0x00,0x09,0xab,0x00,0x00,0x05,0xc4,0x00,0x00,
        0x31,0x9e,0x00,0x00,0x04,0x08,0x00,0x00,0xf5,0x9d,0x00,0x00,0xb5,0x8f,0x00,0x00
    }
};

am_hal_ble_patch_t am_ble_buffer_patch_b0 =
{
    .ui32Type = 0xCC,
    .ui32Length = 0x0720,
    .ui32CRC = 0xefad,
    .pui32Data = am_ble_buffer_patch_data_b0.words,
};


//*****************************************************************************
//
// Patch Name:  Function PATCH v0.4    for Apollo3 B0
// Reduce duration from TX to TX
// Optimized 32K XO frequency calculation
// Optimized AGC Table
// Fixed Channelmap indication rejected issue
// Fixed 800M Spur
// Fixed feature issue
// Date:        2019-05-15
//*****************************************************************************
//*****************************************************************************
// Added one parameter for changing channel reassess duration
// Date:        2020-09-12
//*****************************************************************************


am_hal_ble_buffer(0x00c7) am_ble_buffer_nvds_data_b0 =
{
    .bytes =
    {
        0x4e,0x56,0x44,0x53, //NVDS_MAGIC_NUMBER
        0x01,0x06,0x06,0xef,0xbb,0x23,0x88,0x77,0x66, //bluetooth address
        0x02,0x06,0x0a,0x4e,0x5a,0x38,0x38,0x30,0x31,0x56,0x31,0x41,0x00, //device name
        0x03,0x06,0x01,0x00, //system clock frequency, 00=32MHz  01=24MHz  others=16MHz
        0x07,0x06,0x02,0x00,0x00, //32K clock drift, 0x01f4 = 500 ppm
        0x0c,0x06,0x02,0x96,0x00, //sleep clock accuracy in ppm, default 0x0096 = 150 ppm
        0x08,0x06,0x01,0x00, //01 for BQB qualification, 00 for normal usage
        0x09,0x06,0x01,0x02, //clock source selection, 00 = internal RC32KHz, 02= use Apollo3 MCU 32.768KHz
        0x0a,0x06,0x04,0x00,0x00,0x00,0x00, //0x00000000 = auto detect and low frequency clock calibration
        0x0b,0x06,0x01,0x96, //rx_ifs  0x96 = 150us
        0x23,0x06,0x01,0x95, //tx_ifs  0x95 = 149us
        0x0d,0x06,0x02,0xe8,0x3, //duration allowed for XO32M stabilization from external wakeup
        0x0e,0x06,0x02,0xe8,0x3, //duration allowed for XO32M stabilization from internal wakeup signal
        0x0f,0x06,0x02,0x2c,0x01, //duration allowed for radio to leave low power mode
        0x10,0x06,0x04,0x00,0xc2,0x01,0x00, //set UART_BAUDRATE
        0x11,0x06,0x01,0x01, //sleep algorithm enabled
        // 0x11,0x06,0x01,0x00, //sleep algorithm disabled
        0x12,0x06,0x01,0x01, //external wake-up support
        0x13,0x06,0x02,0x90,0x02, //duration of sleep and wake-up algorithm
        0x14,0x06,0x02,0xAC,0x09, // Ambiq's Company Identifier
        0x15,0x06,0x01,0x09, //BLE major version, support BLE 5.0
        0x16,0x06,0x01,0x03, //BLE minor version
        0x17,0x06,0x01,0x29, //BLE SW version build
        0x18,0x06,0x02,0xdc,0x05, //advertising interval (undirect)
        0x19,0x06,0x02,0xe2,0x04, //advertising interval (direct)
        0x20,0x06,0x01,0x01, //agc switch on
        0x21,0x06,0x01,0x02, //EA programming latency,set '2' with master mode
        0x22,0x06,0x01,0x00, //EA asap latency
        0x24,0x06,0x04,0x5C,0x09,0x6A,0x09, //radio TRX timing
        0x25,0x06,0x01,0x11, //modem polarity setting
        0x26,0x06,0x01,0x00, //modem sync setting
        0x27,0x06,0x01,0x02, //BLE reset delay
        0x2d,0x06,0x01,0x00, //2 byte mode switch, 01 to enable
        0x28,0x06,0x02,0xf6,0x2d, //initial agc gain setting
        0x29,0x06,0x01,0x0f, //initial Tx output power, 0x0f is +4dBm
        0x35,0x06,0x01,0x08, //maximum Tx ouput power setting
        0x37,0x06,0x01,0x00, //RC32K calibration control, 0xAA to enable
        0x05,0x06,0x02,0x34,0x00, //no use
        0x04,0x06,0x01,0x20, //internal dvdd voltage level control if using 0.9V from MCU side
        0x2e,0x06,0x01,0x00, //instant indication,set "0" to disbale instant reject
        0x40,0x06,0x02,0x10,0x27, //set channel reassess time duration  0x2710 means set to 10s
        0x00,0x00,0x00,0x00     //dummy
    }
};

am_hal_ble_patch_t am_ble_nvds_patch_b0 =
{
    .ui32Type = 0xDD,
    .ui32Length = 0x00c7,
    .ui32CRC = 0x112b,
    .pui32Data = am_ble_buffer_nvds_data_b0.words,
};

//*****************************************************************************
//
// End Doxygen group.
//! @}
//
//*****************************************************************************
