/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.userdetails;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public class LdapAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 343193700821611354L;
    private final String dn;
    private final String role;
    private final Map<String, List<String>> attributes;

    public LdapAuthority(String role, String dn) {
        this(role, dn, null);
    }

    public LdapAuthority(String role, String dn, Map<String, List<String>> attributes) {
        Assert.notNull((Object)role, (String)"role can not be null");
        Assert.notNull((Object)dn, (String)"dn can not be null");
        this.role = role;
        this.dn = dn;
        this.attributes = attributes;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public String getDn() {
        return this.dn;
    }

    public List<String> getAttributeValues(String name) {
        List<String> result = null;
        if (this.attributes != null) {
            result = this.attributes.get(name);
        }
        return result != null ? result : Collections.emptyList();
    }

    public String getFirstAttributeValue(String name) {
        List<String> result = this.getAttributeValues(name);
        return !result.isEmpty() ? result.get(0) : null;
    }

    public String getAuthority() {
        return this.role;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LdapAuthority)) {
            return false;
        }
        LdapAuthority other = (LdapAuthority)obj;
        if (!this.dn.equals(other.getDn())) {
            return false;
        }
        return this.role.equals(other.getAuthority());
    }

    public int hashCode() {
        int result = this.dn.hashCode();
        result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "LdapAuthority{dn='" + this.dn + "', role='" + this.role + "'}";
    }
}

