/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.writer;

import org.apache.commons.lang3.Validate;

public class TableColumn {
    private final String name;
    private final int minLength;
    private final int maxLength;
    private final boolean abbreviate;

    public TableColumn(String name, int minLength, int maxLength) {
        this(name, minLength, maxLength, false);
    }

    public TableColumn(String name, int minLength, int maxLength, boolean abbreviate) {
        this.name = name;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.abbreviate = abbreviate;
        Validate.notBlank((CharSequence)this.name);
        Validate.isTrue((this.minLength > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.maxLength > 0 ? 1 : 0) != 0);
        Validate.isTrue((this.maxLength >= this.minLength ? 1 : 0) != 0);
    }

    public String getName() {
        return this.name;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public boolean isAbbreviated() {
        return this.abbreviate;
    }
}

