/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;
import org.apache.nifi.attribute.expression.language.exception.AttributeExpressionLanguageException;

public class HashEvaluator
extends StringEvaluator {
    private static final String SUPPORTED_ALGORITHMS = String.join((CharSequence)", ", Security.getAlgorithms("MessageDigest"));
    private final Evaluator<String> algorithm;
    private final Evaluator<String> subject;

    public HashEvaluator(Evaluator<String> subject, Evaluator<String> algorithm) {
        this.subject = subject;
        this.algorithm = algorithm;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext context) {
        String subjectValue = this.subject.evaluate(context).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String algorithmValue = this.algorithm.evaluate(context).getValue();
        MessageDigest digest = this.getDigest(algorithmValue);
        String encoded = new DigestUtils(digest).digestAsHex(subjectValue);
        return new StringQueryResult(encoded);
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }

    private MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AttributeExpressionLanguageException("Invalid hash algorithm: " + algorithm + " not in set [" + SUPPORTED_ALGORITHMS + "]", e);
        }
    }
}

