/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.ott;

import java.time.Duration;
import org.springframework.util.Assert;

public class GenerateOneTimeTokenRequest {
    private static final Duration DEFAULT_EXPIRES_IN = Duration.ofMinutes(5L);
    private final String username;
    private final Duration expiresIn;

    public GenerateOneTimeTokenRequest(String username) {
        this(username, DEFAULT_EXPIRES_IN);
    }

    public GenerateOneTimeTokenRequest(String username, Duration expiresIn) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notNull((Object)expiresIn, (String)"expiresIn cannot be null");
        this.username = username;
        this.expiresIn = expiresIn;
    }

    public String getUsername() {
        return this.username;
    }

    public Duration getExpiresIn() {
        return this.expiresIn;
    }
}

